from typing import Dict, List, Optional, Union

import terrascript.core as core


@core.resource(type="aws_ec2_transit_gateway", namespace="aws_transit_gateway")
class Ec2TransitGateway(core.Resource):

    amazon_side_asn: Optional[Union[int, core.IntOut]] = core.attr(int, default=None)

    arn: Union[str, core.StringOut] = core.attr(str, computed=True)

    association_default_route_table_id: Union[str, core.StringOut] = core.attr(str, computed=True)

    auto_accept_shared_attachments: Optional[Union[str, core.StringOut]] = core.attr(
        str, default=None
    )

    default_route_table_association: Optional[Union[str, core.StringOut]] = core.attr(
        str, default=None
    )

    default_route_table_propagation: Optional[Union[str, core.StringOut]] = core.attr(
        str, default=None
    )

    description: Optional[Union[str, core.StringOut]] = core.attr(str, default=None)

    dns_support: Optional[Union[str, core.StringOut]] = core.attr(str, default=None)

    id: Union[str, core.StringOut] = core.attr(str, computed=True)

    multicast_support: Optional[Union[str, core.StringOut]] = core.attr(str, default=None)

    owner_id: Union[str, core.StringOut] = core.attr(str, computed=True)

    propagation_default_route_table_id: Union[str, core.StringOut] = core.attr(str, computed=True)

    tags: Optional[Union[Dict[str, str], core.MapOut[core.StringOut]]] = core.attr(
        str, default=None, kind=core.Kind.map
    )

    tags_all: Optional[Union[Dict[str, str], core.MapOut[core.StringOut]]] = core.attr(
        str, default=None, computed=True, kind=core.Kind.map
    )

    transit_gateway_cidr_blocks: Optional[
        Union[List[str], core.ArrayOut[core.StringOut]]
    ] = core.attr(str, default=None, kind=core.Kind.array)

    vpn_ecmp_support: Optional[Union[str, core.StringOut]] = core.attr(str, default=None)

    def __init__(
        self,
        resource_name: str,
        *,
        amazon_side_asn: Optional[Union[int, core.IntOut]] = None,
        auto_accept_shared_attachments: Optional[Union[str, core.StringOut]] = None,
        default_route_table_association: Optional[Union[str, core.StringOut]] = None,
        default_route_table_propagation: Optional[Union[str, core.StringOut]] = None,
        description: Optional[Union[str, core.StringOut]] = None,
        dns_support: Optional[Union[str, core.StringOut]] = None,
        multicast_support: Optional[Union[str, core.StringOut]] = None,
        tags: Optional[Union[Dict[str, str], core.MapOut[core.StringOut]]] = None,
        tags_all: Optional[Union[Dict[str, str], core.MapOut[core.StringOut]]] = None,
        transit_gateway_cidr_blocks: Optional[
            Union[List[str], core.ArrayOut[core.StringOut]]
        ] = None,
        vpn_ecmp_support: Optional[Union[str, core.StringOut]] = None,
        depends_on: Optional[Union[List[str], core.ArrayOut[core.StringOut]]] = None,
        provider: Optional[Union[str, core.StringOut]] = None,
        lifecycle: Optional[core.Lifecycle] = None,
    ):
        super().__init__(
            name=resource_name,
            args=Ec2TransitGateway.Args(
                amazon_side_asn=amazon_side_asn,
                auto_accept_shared_attachments=auto_accept_shared_attachments,
                default_route_table_association=default_route_table_association,
                default_route_table_propagation=default_route_table_propagation,
                description=description,
                dns_support=dns_support,
                multicast_support=multicast_support,
                tags=tags,
                tags_all=tags_all,
                transit_gateway_cidr_blocks=transit_gateway_cidr_blocks,
                vpn_ecmp_support=vpn_ecmp_support,
                depends_on=depends_on,
                provider=provider,
                lifecycle=lifecycle,
            ),
        )

    @core.schema_args
    class Args(core.Resource.Args):
        amazon_side_asn: Optional[Union[int, core.IntOut]] = core.arg(default=None)

        auto_accept_shared_attachments: Optional[Union[str, core.StringOut]] = core.arg(
            default=None
        )

        default_route_table_association: Optional[Union[str, core.StringOut]] = core.arg(
            default=None
        )

        default_route_table_propagation: Optional[Union[str, core.StringOut]] = core.arg(
            default=None
        )

        description: Optional[Union[str, core.StringOut]] = core.arg(default=None)

        dns_support: Optional[Union[str, core.StringOut]] = core.arg(default=None)

        multicast_support: Optional[Union[str, core.StringOut]] = core.arg(default=None)

        tags: Optional[Union[Dict[str, str], core.MapOut[core.StringOut]]] = core.arg(default=None)

        tags_all: Optional[Union[Dict[str, str], core.MapOut[core.StringOut]]] = core.arg(
            default=None
        )

        transit_gateway_cidr_blocks: Optional[
            Union[List[str], core.ArrayOut[core.StringOut]]
        ] = core.arg(default=None)

        vpn_ecmp_support: Optional[Union[str, core.StringOut]] = core.arg(default=None)
