from typing import Dict, List, Optional, Union

import terrascript.core as core


@core.resource(type="aws_transcribe_vocabulary_filter", namespace="aws_transcribe")
class VocabularyFilter(core.Resource):

    arn: Union[str, core.StringOut] = core.attr(str, computed=True)

    download_uri: Union[str, core.StringOut] = core.attr(str, computed=True)

    id: Union[str, core.StringOut] = core.attr(str, computed=True)

    language_code: Union[str, core.StringOut] = core.attr(str)

    tags: Optional[Union[Dict[str, str], core.MapOut[core.StringOut]]] = core.attr(
        str, default=None, kind=core.Kind.map
    )

    tags_all: Optional[Union[Dict[str, str], core.MapOut[core.StringOut]]] = core.attr(
        str, default=None, computed=True, kind=core.Kind.map
    )

    vocabulary_filter_file_uri: Optional[Union[str, core.StringOut]] = core.attr(str, default=None)

    vocabulary_filter_name: Union[str, core.StringOut] = core.attr(str)

    words: Optional[Union[List[str], core.ArrayOut[core.StringOut]]] = core.attr(
        str, default=None, kind=core.Kind.array
    )

    def __init__(
        self,
        resource_name: str,
        *,
        language_code: Union[str, core.StringOut],
        vocabulary_filter_name: Union[str, core.StringOut],
        tags: Optional[Union[Dict[str, str], core.MapOut[core.StringOut]]] = None,
        tags_all: Optional[Union[Dict[str, str], core.MapOut[core.StringOut]]] = None,
        vocabulary_filter_file_uri: Optional[Union[str, core.StringOut]] = None,
        words: Optional[Union[List[str], core.ArrayOut[core.StringOut]]] = None,
        depends_on: Optional[Union[List[str], core.ArrayOut[core.StringOut]]] = None,
        provider: Optional[Union[str, core.StringOut]] = None,
        lifecycle: Optional[core.Lifecycle] = None,
    ):
        super().__init__(
            name=resource_name,
            args=VocabularyFilter.Args(
                language_code=language_code,
                vocabulary_filter_name=vocabulary_filter_name,
                tags=tags,
                tags_all=tags_all,
                vocabulary_filter_file_uri=vocabulary_filter_file_uri,
                words=words,
                depends_on=depends_on,
                provider=provider,
                lifecycle=lifecycle,
            ),
        )

    @core.schema_args
    class Args(core.Resource.Args):
        language_code: Union[str, core.StringOut] = core.arg()

        tags: Optional[Union[Dict[str, str], core.MapOut[core.StringOut]]] = core.arg(default=None)

        tags_all: Optional[Union[Dict[str, str], core.MapOut[core.StringOut]]] = core.arg(
            default=None
        )

        vocabulary_filter_file_uri: Optional[Union[str, core.StringOut]] = core.arg(default=None)

        vocabulary_filter_name: Union[str, core.StringOut] = core.arg()

        words: Optional[Union[List[str], core.ArrayOut[core.StringOut]]] = core.arg(default=None)
