from typing import List, Optional, Union

import terrascript.core as core


@core.resource(type="aws_shield_protection_health_check_association", namespace="aws_shield")
class ProtectionHealthCheckAssociation(core.Resource):

    health_check_arn: Union[str, core.StringOut] = core.attr(str)

    id: Union[str, core.StringOut] = core.attr(str, computed=True)

    shield_protection_id: Union[str, core.StringOut] = core.attr(str)

    def __init__(
        self,
        resource_name: str,
        *,
        health_check_arn: Union[str, core.StringOut],
        shield_protection_id: Union[str, core.StringOut],
        depends_on: Optional[Union[List[str], core.ArrayOut[core.StringOut]]] = None,
        provider: Optional[Union[str, core.StringOut]] = None,
        lifecycle: Optional[core.Lifecycle] = None,
    ):
        super().__init__(
            name=resource_name,
            args=ProtectionHealthCheckAssociation.Args(
                health_check_arn=health_check_arn,
                shield_protection_id=shield_protection_id,
                depends_on=depends_on,
                provider=provider,
                lifecycle=lifecycle,
            ),
        )

    @core.schema_args
    class Args(core.Resource.Args):
        health_check_arn: Union[str, core.StringOut] = core.arg()

        shield_protection_id: Union[str, core.StringOut] = core.arg()
