from typing import Dict, List, Optional, Union

import terrascript.core as core


@core.schema
class Limits(core.Schema):

    daily: Optional[Union[int, core.IntOut]] = core.attr(int, default=None)

    maximum_duration: Optional[Union[int, core.IntOut]] = core.attr(int, default=None)

    messages_per_second: Optional[Union[int, core.IntOut]] = core.attr(int, default=None)

    total: Optional[Union[int, core.IntOut]] = core.attr(int, default=None)

    def __init__(
        self,
        *,
        daily: Optional[Union[int, core.IntOut]] = None,
        maximum_duration: Optional[Union[int, core.IntOut]] = None,
        messages_per_second: Optional[Union[int, core.IntOut]] = None,
        total: Optional[Union[int, core.IntOut]] = None,
    ):
        super().__init__(
            args=Limits.Args(
                daily=daily,
                maximum_duration=maximum_duration,
                messages_per_second=messages_per_second,
                total=total,
            ),
        )

    @core.schema_args
    class Args(core.SchemaArgs):
        daily: Optional[Union[int, core.IntOut]] = core.arg(default=None)

        maximum_duration: Optional[Union[int, core.IntOut]] = core.arg(default=None)

        messages_per_second: Optional[Union[int, core.IntOut]] = core.arg(default=None)

        total: Optional[Union[int, core.IntOut]] = core.arg(default=None)


@core.schema
class CampaignHook(core.Schema):

    lambda_function_name: Optional[Union[str, core.StringOut]] = core.attr(str, default=None)

    mode: Optional[Union[str, core.StringOut]] = core.attr(str, default=None)

    web_url: Optional[Union[str, core.StringOut]] = core.attr(str, default=None)

    def __init__(
        self,
        *,
        lambda_function_name: Optional[Union[str, core.StringOut]] = None,
        mode: Optional[Union[str, core.StringOut]] = None,
        web_url: Optional[Union[str, core.StringOut]] = None,
    ):
        super().__init__(
            args=CampaignHook.Args(
                lambda_function_name=lambda_function_name,
                mode=mode,
                web_url=web_url,
            ),
        )

    @core.schema_args
    class Args(core.SchemaArgs):
        lambda_function_name: Optional[Union[str, core.StringOut]] = core.arg(default=None)

        mode: Optional[Union[str, core.StringOut]] = core.arg(default=None)

        web_url: Optional[Union[str, core.StringOut]] = core.arg(default=None)


@core.schema
class QuietTime(core.Schema):

    end: Optional[Union[str, core.StringOut]] = core.attr(str, default=None)

    start: Optional[Union[str, core.StringOut]] = core.attr(str, default=None)

    def __init__(
        self,
        *,
        end: Optional[Union[str, core.StringOut]] = None,
        start: Optional[Union[str, core.StringOut]] = None,
    ):
        super().__init__(
            args=QuietTime.Args(
                end=end,
                start=start,
            ),
        )

    @core.schema_args
    class Args(core.SchemaArgs):
        end: Optional[Union[str, core.StringOut]] = core.arg(default=None)

        start: Optional[Union[str, core.StringOut]] = core.arg(default=None)


@core.resource(type="aws_pinpoint_app", namespace="aws_pinpoint")
class App(core.Resource):
    """
    The Application ID of the Pinpoint App.
    """

    application_id: Union[str, core.StringOut] = core.attr(str, computed=True)

    """
    Amazon Resource Name (ARN) of the PinPoint Application
    """
    arn: Union[str, core.StringOut] = core.attr(str, computed=True)

    """
    (Optional) Specifies settings for invoking an AWS Lambda function that customizes a segment for a ca
    mpaign
    """
    campaign_hook: Optional[CampaignHook] = core.attr(CampaignHook, default=None)

    id: Union[str, core.StringOut] = core.attr(str, computed=True)

    """
    (Optional) The default campaign limits for the app. These limits apply to each campaign for the app,
    unless the campaign overrides the default with limits of its own
    """
    limits: Optional[Limits] = core.attr(Limits, default=None)

    """
    (Optional) The application name. By default generated by Terraform
    """
    name: Optional[Union[str, core.StringOut]] = core.attr(str, default=None, computed=True)

    """
    (Optional) The name of the Pinpoint application. Conflicts with `name`
    """
    name_prefix: Optional[Union[str, core.StringOut]] = core.attr(str, default=None)

    """
    (Optional) The default quiet time for the app. Each campaign for this app sends no messages during t
    his time unless the campaign overrides the default with a quiet time of its own
    """
    quiet_time: Optional[QuietTime] = core.attr(QuietTime, default=None)

    """
    (Optional) Key-value map of resource tags. If configured with a provider [`default_tags` configurati
    on block](https://registry.terraform.io/providers/hashicorp/aws/latest/docs#default_tags-configurati
    on-block) present, tags with matching keys will overwrite those defined at the provider-level.
    """
    tags: Optional[Union[Dict[str, str], core.MapOut[core.StringOut]]] = core.attr(
        str, default=None, kind=core.Kind.map
    )

    """
    A map of tags assigned to the resource, including those inherited from the provider [`default_tags`
    configuration block](https://registry.terraform.io/providers/hashicorp/aws/latest/docs#default_tags-
    configuration-block).
    """
    tags_all: Optional[Union[Dict[str, str], core.MapOut[core.StringOut]]] = core.attr(
        str, default=None, computed=True, kind=core.Kind.map
    )

    def __init__(
        self,
        resource_name: str,
        *,
        campaign_hook: Optional[CampaignHook] = None,
        limits: Optional[Limits] = None,
        name: Optional[Union[str, core.StringOut]] = None,
        name_prefix: Optional[Union[str, core.StringOut]] = None,
        quiet_time: Optional[QuietTime] = None,
        tags: Optional[Union[Dict[str, str], core.MapOut[core.StringOut]]] = None,
        tags_all: Optional[Union[Dict[str, str], core.MapOut[core.StringOut]]] = None,
        depends_on: Optional[Union[List[str], core.ArrayOut[core.StringOut]]] = None,
        provider: Optional[Union[str, core.StringOut]] = None,
        lifecycle: Optional[core.Lifecycle] = None,
    ):
        super().__init__(
            name=resource_name,
            args=App.Args(
                campaign_hook=campaign_hook,
                limits=limits,
                name=name,
                name_prefix=name_prefix,
                quiet_time=quiet_time,
                tags=tags,
                tags_all=tags_all,
                depends_on=depends_on,
                provider=provider,
                lifecycle=lifecycle,
            ),
        )

    @core.schema_args
    class Args(core.Resource.Args):
        campaign_hook: Optional[CampaignHook] = core.arg(default=None)

        limits: Optional[Limits] = core.arg(default=None)

        name: Optional[Union[str, core.StringOut]] = core.arg(default=None)

        name_prefix: Optional[Union[str, core.StringOut]] = core.arg(default=None)

        quiet_time: Optional[QuietTime] = core.arg(default=None)

        tags: Optional[Union[Dict[str, str], core.MapOut[core.StringOut]]] = core.arg(default=None)

        tags_all: Optional[Union[Dict[str, str], core.MapOut[core.StringOut]]] = core.arg(
            default=None
        )
