from typing import List, Optional, Union

import terrascript.core as core


@core.schema
class ParameterValue(core.Schema):

    id: Union[str, core.StringOut] = core.attr(str, computed=True)

    string_value: Union[str, core.StringOut] = core.attr(str, computed=True)

    def __init__(
        self,
        *,
        id: Union[str, core.StringOut],
        string_value: Union[str, core.StringOut],
    ):
        super().__init__(
            args=ParameterValue.Args(
                id=id,
                string_value=string_value,
            ),
        )

    @core.schema_args
    class Args(core.SchemaArgs):
        id: Union[str, core.StringOut] = core.arg()

        string_value: Union[str, core.StringOut] = core.arg()


@core.schema
class Field(core.Schema):

    key: Union[str, core.StringOut] = core.attr(str, computed=True)

    ref_value: Union[str, core.StringOut] = core.attr(str, computed=True)

    string_value: Union[str, core.StringOut] = core.attr(str, computed=True)

    def __init__(
        self,
        *,
        key: Union[str, core.StringOut],
        ref_value: Union[str, core.StringOut],
        string_value: Union[str, core.StringOut],
    ):
        super().__init__(
            args=Field.Args(
                key=key,
                ref_value=ref_value,
                string_value=string_value,
            ),
        )

    @core.schema_args
    class Args(core.SchemaArgs):
        key: Union[str, core.StringOut] = core.arg()

        ref_value: Union[str, core.StringOut] = core.arg()

        string_value: Union[str, core.StringOut] = core.arg()


@core.schema
class PipelineObject(core.Schema):

    field: Optional[Union[List[Field], core.ArrayOut[Field]]] = core.attr(
        Field, default=None, kind=core.Kind.array
    )

    id: Union[str, core.StringOut] = core.attr(str, computed=True)

    name: Union[str, core.StringOut] = core.attr(str, computed=True)

    def __init__(
        self,
        *,
        id: Union[str, core.StringOut],
        name: Union[str, core.StringOut],
        field: Optional[Union[List[Field], core.ArrayOut[Field]]] = None,
    ):
        super().__init__(
            args=PipelineObject.Args(
                id=id,
                name=name,
                field=field,
            ),
        )

    @core.schema_args
    class Args(core.SchemaArgs):
        field: Optional[Union[List[Field], core.ArrayOut[Field]]] = core.arg(default=None)

        id: Union[str, core.StringOut] = core.arg()

        name: Union[str, core.StringOut] = core.arg()


@core.schema
class Attribute(core.Schema):

    key: Union[str, core.StringOut] = core.attr(str, computed=True)

    string_value: Union[str, core.StringOut] = core.attr(str, computed=True)

    def __init__(
        self,
        *,
        key: Union[str, core.StringOut],
        string_value: Union[str, core.StringOut],
    ):
        super().__init__(
            args=Attribute.Args(
                key=key,
                string_value=string_value,
            ),
        )

    @core.schema_args
    class Args(core.SchemaArgs):
        key: Union[str, core.StringOut] = core.arg()

        string_value: Union[str, core.StringOut] = core.arg()


@core.schema
class ParameterObject(core.Schema):

    attribute: Union[List[Attribute], core.ArrayOut[Attribute]] = core.attr(
        Attribute, computed=True, kind=core.Kind.array
    )

    id: Union[str, core.StringOut] = core.attr(str, computed=True)

    def __init__(
        self,
        *,
        attribute: Union[List[Attribute], core.ArrayOut[Attribute]],
        id: Union[str, core.StringOut],
    ):
        super().__init__(
            args=ParameterObject.Args(
                attribute=attribute,
                id=id,
            ),
        )

    @core.schema_args
    class Args(core.SchemaArgs):
        attribute: Union[List[Attribute], core.ArrayOut[Attribute]] = core.arg()

        id: Union[str, core.StringOut] = core.arg()


@core.data(type="aws_datapipeline_pipeline_definition", namespace="aws_datapipeline")
class DsPipelineDefinition(core.Data):

    id: Union[str, core.StringOut] = core.attr(str, computed=True)

    parameter_object: Union[List[ParameterObject], core.ArrayOut[ParameterObject]] = core.attr(
        ParameterObject, computed=True, kind=core.Kind.array
    )

    parameter_value: Optional[
        Union[List[ParameterValue], core.ArrayOut[ParameterValue]]
    ] = core.attr(ParameterValue, default=None, kind=core.Kind.array)

    pipeline_id: Union[str, core.StringOut] = core.attr(str)

    pipeline_object: Union[List[PipelineObject], core.ArrayOut[PipelineObject]] = core.attr(
        PipelineObject, computed=True, kind=core.Kind.array
    )

    def __init__(
        self,
        data_name: str,
        *,
        pipeline_id: Union[str, core.StringOut],
        parameter_value: Optional[
            Union[List[ParameterValue], core.ArrayOut[ParameterValue]]
        ] = None,
    ):
        super().__init__(
            name=data_name,
            args=DsPipelineDefinition.Args(
                pipeline_id=pipeline_id,
                parameter_value=parameter_value,
            ),
        )

    @core.schema_args
    class Args(core.SchemaArgs):
        parameter_value: Optional[
            Union[List[ParameterValue], core.ArrayOut[ParameterValue]]
        ] = core.arg(default=None)

        pipeline_id: Union[str, core.StringOut] = core.arg()
