from typing import Dict, List, Optional, Union

import terrascript.core as core


@core.resource(type="aws_api_gateway_method_response", namespace="aws_api_gateway")
class MethodResponse(core.Resource):

    http_method: Union[str, core.StringOut] = core.attr(str)

    id: Union[str, core.StringOut] = core.attr(str, computed=True)

    resource_id: Union[str, core.StringOut] = core.attr(str)

    response_models: Optional[Union[Dict[str, str], core.MapOut[core.StringOut]]] = core.attr(
        str, default=None, kind=core.Kind.map
    )

    response_parameters: Optional[Union[Dict[str, bool], core.MapOut[core.BoolOut]]] = core.attr(
        bool, default=None, kind=core.Kind.map
    )

    rest_api_id: Union[str, core.StringOut] = core.attr(str)

    status_code: Union[str, core.StringOut] = core.attr(str)

    def __init__(
        self,
        resource_name: str,
        *,
        http_method: Union[str, core.StringOut],
        resource_id: Union[str, core.StringOut],
        rest_api_id: Union[str, core.StringOut],
        status_code: Union[str, core.StringOut],
        response_models: Optional[Union[Dict[str, str], core.MapOut[core.StringOut]]] = None,
        response_parameters: Optional[Union[Dict[str, bool], core.MapOut[core.BoolOut]]] = None,
        depends_on: Optional[Union[List[str], core.ArrayOut[core.StringOut]]] = None,
        provider: Optional[Union[str, core.StringOut]] = None,
        lifecycle: Optional[core.Lifecycle] = None,
    ):
        super().__init__(
            name=resource_name,
            args=MethodResponse.Args(
                http_method=http_method,
                resource_id=resource_id,
                rest_api_id=rest_api_id,
                status_code=status_code,
                response_models=response_models,
                response_parameters=response_parameters,
                depends_on=depends_on,
                provider=provider,
                lifecycle=lifecycle,
            ),
        )

    @core.schema_args
    class Args(core.Resource.Args):
        http_method: Union[str, core.StringOut] = core.arg()

        resource_id: Union[str, core.StringOut] = core.arg()

        response_models: Optional[Union[Dict[str, str], core.MapOut[core.StringOut]]] = core.arg(
            default=None
        )

        response_parameters: Optional[Union[Dict[str, bool], core.MapOut[core.BoolOut]]] = core.arg(
            default=None
        )

        rest_api_id: Union[str, core.StringOut] = core.arg()

        status_code: Union[str, core.StringOut] = core.arg()
