# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['uniswap']

package_data = \
{'': ['*'],
 'uniswap': ['assets/*', 'assets/uniswap-v1/*', 'assets/uniswap-v2/*']}

install_requires = \
['web3>=5.12.0,<6.0.0']

setup_kwargs = {
    'name': 'uniswap-python',
    'version': '0.4.2',
    'description': 'An unofficial Python wrapper for the Uniswap exchange',
    'long_description': '<p align="center">\n  <img width="350" height="200" src="https://user-images.githubusercontent.com/9441295/54372021-b7a99280-4637-11e9-864d-7c515a79d4fa.png">\n</p>\n\n# uniswap-python\n\n[![GitHub Actions](https://github.com/ErikBjare/uniswap-python/workflows/test/badge.svg)](https://github.com/ErikBjare/uniswap-python/actions)\n[![Downloads](https://pepy.tech/badge/uniswap-python)](https://pepy.tech/project/uniswap-python)\n[![License](http://img.shields.io/badge/license-MIT-blue.svg)](https://raw.githubusercontent.com/shanefontaine/uniswap-python/master/LICENSE)\n[![Typechecking: Mypy](http://www.mypy-lang.org/static/mypy_badge.svg)](http://mypy-lang.org/)\n[![Code style: black](https://img.shields.io/badge/code%20style-black-000000.svg)](https://github.com/ambv/black)\n\nThe unofficial Python client for the [Uniswap](https://uniswap.io/).\n\n_The authors are in no way affiliated with or funded by Uniswap, uniswap.io, or any subsidiaries or affiliates of any of the previously mentioned entities._\n\n### This package supports Uniswap V2 as of version 0.4.0.\n\n## Functionality\n*  A simple to use Python wrapper for all available contract functions and variables\n*  Simple parsing of data returned from the Uniswap contract\n\n## Under Development\n*  Run tests on a private chain rather than Rinkeby\n*  Better error handling\n\n## Getting Started\nThis README is documentation on the syntax of the python client presented in this repository. See function docstrings for full syntax details.\nThis API attempts to present a clean interface to Uniswap, but in order to use it to its full potential, you must familiarize yourself with the official Uniswap documentation.\n\n*  https://docs.uniswap.io/\n\nYou may manually install the project or use pip:\n\n```python\npip install uniswap-python\n\n# or\n\npip install git+git://github.com/shanefontaine/uniswap-python.git\n```\n\n### Environment Variables\nThe program expects an environment variables to be set in order to run the program. You can use an Infura node, since the transactions are being signed locally and broadcast as a raw transaction. The environment variable is:\n\n```\nPROVIDER  # HTTP Provider for web3\n```\n\n### Public Client\nOnly some endpoints in the API are available to everyone. The public endpoints can be reached using PublicClient\n\n```python\nfrom uniswap import uniswap\nuniswap_wrapper = uniswap.UniswapWrapper()\neth = "0x0000000000000000000000000000000000000000"\nbat = "0x0D8775F648430679A709E98d2b0Cb6250d2887EF"\ndai = "0x89d24A6b4CcB1B6fAA2625fE562bDD9a23260359"\n```\n\n#### Market Methods\n*  [get_fee_maker](https://docs.uniswap.io/)\n```python\nuniswap_wrapper.get_fee_maker()\n```\n\n*  [get_fee_taker](https://docs.uniswap.io/)\n```python\nuniswap_wrapper.get_fee_taker()\n```\n\n*  [get_eth_token_input_price](https://github.com/Uniswap/contracts-vyper/blob/master/contracts/uniswap_exchange.vy#L416)\n```python\n# Get the public price for ETH to Token trades with an exact input.\nuniswap_wrapper.get_eth_token_input_price(bat, 1*10**18)\nuniswap_wrapper.get_eth_token_input_price(dai, 5*10**18)\n```\n\n*  [get_token_eth_input_price](https://github.com/Uniswap/contracts-vyper/blob/master/contracts/uniswap_exchange.vy#L437)\n```python\n# Get the public price for token to ETH trades with an exact input.\nuniswap_wrapper.get_token_eth_input_price(bat, 1*10**18)\nuniswap_wrapper.get_token_eth_input_price(dai, 5*10**18)\n```\n\n*  [get_eth_token_output_price](https://github.com/Uniswap/contracts-vyper/blob/master/contracts/uniswap_exchange.vy#L426)\n```python\n# Get the public price for ETH to Token trades with an exact output\nuniswap_wrapper.get_eth_token_output_price(bat, 1*10**18)\nuniswap_wrapper.get_eth_token_output_price(dai, 5*10**18)\n```\n\n*  [get_token_eth_output_price](https://github.com/Uniswap/contracts-vyper/blob/master/contracts/uniswap_exchange.vy#L448)\n```python\n# Get the public price for token to ETH trades with an exact output.\nuniswap_wrapper.get_token_eth_output_price(bat, 1*10**18)\nuniswap_wrapper.get_token_eth_output_price(dai, 5*10**18)\n```\n\n#### ERC20 Pool Methods\n*  [get_eth_balance](https://docs.uniswap.io/smart-contract-integration/vyper)\n```python\n# Get the balance of ETH in an exchange contract.\nuniswap_wrapper.get_eth_balance(bat)\n```\n\n*  [get_token_balance](https://github.com/Uniswap/contracts-vyper/blob/master/contracts/uniswap_exchange.vy#L469)\n```python\n# Get the balance of a token in an exchange contract.\nuniswap_wrapper.get_token_balance(bat)\n```\n\n*  [get_exchange_rate](https://github.com/Uniswap/uniswap-frontend/blob/master/src/pages/Pool/AddLiquidity.js#L351)\n```python\n# Get the balance of a token in an exchange contract.\nuniswap_wrapper.get_exchange_rate(bat)\n```\n\n#### Liquidity Methods\n\n*  [add_liquidity](https://github.com/Uniswap/contracts-vyper/blob/master/contracts/uniswap_exchange.vy#L48)\n```python\n# Add liquidity to the pool.\nuniswap_wrapper.add_liquidity(bat, 1*10**18)\n```\n\n*  [remove_liquidity](https://github.com/Uniswap/contracts-vyper/blob/master/contracts/uniswap_exchange.vy#L83)\n```python\n# Remove liquidity from the pool.\nuniswap_wrapper.remove_liquidity(bat, 1*10**18)\n```\n\n#### Trading\n*  make_trade\n  *  eth_to_token_input\n    *  [ethToTokenSwapInput](https://github.com/Uniswap/contracts-vyper/blob/master/contracts/uniswap_exchange.vy#L127)\n    *  [ethToTokenTransferInput](https://github.com/Uniswap/contracts-vyper/blob/master/contracts/uniswap_exchange.vy#L162)\n  *  token_to_eth_input\n    *  [tokenToEthSwapInput](https://github.com/Uniswap/contracts-vyper/blob/master/contracts/uniswap_exchange.vy#L202)\n    *  [tokenToEthTransferInput](https://github.com/Uniswap/contracts-vyper/blob/master/contracts/uniswap_exchange.vy#L232)\n  *  token_to_token_input\n    *  [tokenToTokenSwapInput](https://github.com/Uniswap/contracts-vyper/blob/master/contracts/uniswap_exchange.vy#L271)\n    *  [tokenToTokenTransferInput](https://github.com/Uniswap/contracts-vyper/blob/master/contracts/uniswap_exchange.vy#L307)\n```python\n# Make a trade based on the input parameters\nuniswap_wrapper.make_trade(eth, bat, 1*10**18) # calls _eth_to_token_input\nuniswap_wrapper.make_trade(bat, eth, 1*10**18) # calls _token_to_eth_input\nuniswap_wrapper.make_trade(bat, dai, 1*10**18) # calls _token_to_token_input\nuniswap_wrapper.make_trade(eth, bat, 1*10**18, "0x123...") # calls _eth_to_token_input\n```\n\n*  make_trade_output\n  *  eth_to_token_swap_output\n    *  [ethToTokenSwapOutput](https://github.com/Uniswap/contracts-vyper/blob/master/contracts/uniswap_exchange.vy#L167)\n    *  [ethToTokenTransferOutput](https://github.com/Uniswap/contracts-vyper/blob/master/contracts/uniswap_exchange.vy#L197)\n  *  token_to_eth_swap_output\n    *  [tokenToEthSwapOutput](https://github.com/Uniswap/contracts-vyper/blob/master/contracts/uniswap_exchange.vy#L237)\n    *  [tokenToEthTransferOutput](https://github.com/Uniswap/contracts-vyper/blob/master/contracts/uniswap_exchange.vy#L266)\n  *  token_to_token_swap_output\n    *  [tokenTotokenSwapOutput](https://github.com/Uniswap/contracts-vyper/blob/master/contracts/uniswap_exchange.vy#L312)\n    *  [tokenTotokenTransferOutput](https://github.com/Uniswap/contracts-vyper/blob/master/contracts/uniswap_exchange.vy#L349))\n```python\n# Make a trade where the output qty is known based on the input parameters\nuniswap_wrapper.make_trade_output(eth, bat, 1*10**18) # calls _eth_to_token_swap_output\nuniswap_wrapper.make_trade_output(bat, eth, 1*10**18) # calls _token_to_eth_swap_output\nuniswap_wrapper.make_trade_output(bat, dai, 1*10**18, "0x123...") # calls _token_to_token_swap_output\n```\n\n## Testing\nUnit tests are under development using the pytest framework. Contributions are welcome!\n\nTest are run on a fork of the main net using ganache-cli. You need to install it with `npm install -g ganache-cli` before running tests.\n\nTo run the full test suite, in the project directory run:\n\n```\nmake test\n```\n\n## Ownership Disclosure\n\n*  I own some BAT and DAI tokens that are seen in the examples above. These tokens are used only for example purposes and are not meant to be an endorsement. I am not affiliated with BAT, Brave, Basic Attention Token, Brave Browser, DAI, Maker, MakerDAO, or any subsidiaries.\n\n## Changelog\n\n_0.4.2_\n\n* Add note about Uniswap V2 support\n\n_0.4.1_\n\n* Update changelog for PyPi and clean up\n\n_0.4.0_\n\n_A huge thank you [Erik Bj\xc3\xa4reholt](https://github.com/ErikBjare) for adding Uniswap V2 support, as well as all changes in this version!_\n\n* Added support for Uniswap v2\n* Handle arbitrary tokens (by address) using the factory contract\n* Switched from setup.py to pyproject.toml/poetry\n* Switched from Travis to GitHub Actions\n* For CI to work in your repo, you need to set the secret MAINNET_PROVIDER. I use Infura.\n* Running tests on a local fork of mainnet using ganache-cli (started as a fixture)\n* Fixed tests for make_trade and make_trade_output\n* Added type annotations to the entire codebase and check them with mypy in CI\n* Formatted entire codebase with black\n* Moved stuff around such that the basic import becomes from uniswap import Uniswap (instead of from uniswap.uniswap import UniswapWrapper)\n* Fixed misc bugs\n\n_0.3.3_\n*  Provide token inputs as addresses instead of names\n\n_0.3.2_\n*  Add ability to transfer tokens after a trade\n*  Add tests for this new functionality\n\n_0.3.1_\n*  Add tests for all types of trades\n\n_0.3.0_\n*  Add ability to make all types of trades\n*  Add example to README\n\n_0.2.1_\n*  Add liquidity tests\n\n_0.2.0_\n*  Add liquidity and ERC20 pool methods\n\n_0.1.1_\n*  Major README update\n\n_0.1.0_\n*  Add market endpoints\n*  Add tests for market endpoints\n',
    'author': 'Shane Fontaine',
    'author_email': 'shane6fontaine@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/shanefontaine/uniswap-python',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
