<p align="center">
  <img src="https://cdn.imgbin.com/10/3/23/imgbin-breast-cancer-senology-mammography-diego-JcEW147fdbivCyrvC5vykSPj3.jpg" width="200">
</p>

# MammoPy
A Comprehensive Deep Learning Library for Mammogram Assessment

[![PyPI version](https://badge.fury.io/py/mammopy.svg)](https://badge.fury.io/py/mammopy)
![GitHub](https://img.shields.io/github/license/mammopy/mammopy)
# Useful Links
**[[Documentation]](https://github.com/uefcancer/mammopy/)**
| **[[Paper]]()** 
| **[[Notebook examples]]()** 
| **[[Web applications]]()** 
# Introduction
**Welcome to ``MammoPy`` Repository!** `MammoPy` is a python-based library designed to facilitate the creation of mammogram image analysis pipelines . The library includes plug-and-play modules to perform:

- Standard mammogram image pre-processing (e.g., *normalization*, *bounding box cropping*, and *DICOM to jpeg conversion*)

- Mammogram assessment pipelines (e.g., *breast area segmentation*, *dense tissue segmentation*, and *percentage density estimation*)

- Modeling deep learning architectures for various downstream tasks  (e.g., *micro-calcification* and *mass detection*)

- Feature attribution-based interpretability techniques (e.g., *GradCAM*, *GradCAM++*, and *LRP*)

- Visualization 

All the functionalities are grouped under a user-friendly API. 

If you encounter any issue or have questions regarding the library, feel free to [open a GitHub issue](https://github.com/uefcancer/mammopy/issues). We'll do our best to address it. 