"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.handler = void 0;
const cognito_verifier_1 = require("./aws-jwt-verify-ripout/cognito-verifier");
async function handler(event) {
    var _a, _b, _c, _d, _e, _f, _g;
    console.debug(`event: ${JSON.stringify(event)}`);
    const request = event.Records[0].cf.request;
    // Example request including the token.
    // "request": {
    //     "headers": {
    //         "cookie": [
    //             {
    //                 "key": "Cookie",
    //                 "value": "token=ey123"
    //             }
    //         ],
    //     },
    // }
    // Consider using Postman for testing like with cookies. See more in the Readme.
    const token = ((_c = (_b = (_a = request.headers.cookie) === null || _a === void 0 ? void 0 : _a.filter(cookie => cookie.key === 'Cookie' && cookie.value.startsWith('token'))) === null || _b === void 0 ? void 0 : _b[0]) === null || _c === void 0 ? void 0 : _c.value.substring(6)) || 'notValid';
    if (token) {
        console.debug('got token in cookie');
        const userPoolId = ((_e = (_d = request.origin) === null || _d === void 0 ? void 0 : _d.s3) === null || _e === void 0 ? void 0 : _e.customHeaders['x-env-userpoolid'][0].value) || '';
        const clientId = ((_g = (_f = request.origin) === null || _f === void 0 ? void 0 : _f.s3) === null || _g === void 0 ? void 0 : _g.customHeaders['x-env-clientid'][0].value) || '';
        console.debug(`userPoolId: ${userPoolId}`);
        console.debug(`clientId: ${clientId}`);
        const verifier = cognito_verifier_1.CognitoJwtVerifier.create({
            userPoolId,
            tokenUse: 'access',
            clientId,
        });
        try {
            const payload = await verifier.verify(token);
            console.debug('Token is valid. Payload:', payload);
            return request;
        }
        catch {
            console.error(`Unauthorized JWT ${token === 'notValid' ? 'missing token' : ''}`);
            const response = {
                status: '401',
                statusDescription: `Unauthorized JWT ${token === 'notValid' ? 'missing token' : ''}`,
                headers: {
                    location: [
                        {
                            key: 'Location',
                            value: 'www.mianio.com/401',
                        },
                    ],
                },
            };
            return response;
        }
        // return { status: 200, body: `hab token ${token}` };
    }
    else {
        console.debug('got no token in cookie :(');
    }
    const unauthorizedResponse = {
        status: '403',
        statusDescription: 'Forbidden',
        headers: {
            location: [
                {
                    key: 'Location',
                    value: 'www.mianio.com/403',
                },
            ],
        },
    };
    return unauthorizedResponse;
}
exports.handler = handler;
//# sourceMappingURL=data:application/json;base64,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