# -*- coding: utf-8 -*-


null = ""
true = "true"
false = "false"

test_data_notification = {"notifications": [{"threatInfo": {"incidentId": "Z7NG6", "score": 7,
                                               "summary": "A known virus (Sality: Keylogger, Password or Data stealer, Backdoor) was detected running.",
                                               "indicators": [{"indicatorName": "PACKED_CALL",
                                                               "applicationName": "ShippingInvoice.pdf.exe",
                                                               "sha256Hash": "cfe0ae57f314a9f747a7cec605907cdaf1984b3cdea74ee8d5893d00ae0886cc"},
                                                              {"indicatorName": "TARGET_MALWARE_APP",
                                                               "applicationName": "explorer.exe",
                                                               "sha256Hash": "1e675cb7df214172f7eb0497f7275556038a0d09c6e5a3e6862c5e26885ef455"},
                                                              {"indicatorName": "HAS_PACKED_CODE",
                                                               "applicationName": "ShippingInvoice.pdf.exe",
                                                               "sha256Hash": "cfe0ae57f314a9f747a7cec605907cdaf1984b3cdea74ee8d5893d00ae0886cc"},
                                                              {"indicatorName": "KNOWN_DOWNLOADER",
                                                               "applicationName": "ShippingInvoice.pdf.exe",
                                                               "sha256Hash": "cfe0ae57f314a9f747a7cec605907cdaf1984b3cdea74ee8d5893d00ae0886cc"},
                                                              {"indicatorName": "ENUMERATE_PROCESSES",
                                                               "applicationName": "ShippingInvoice.pdf.exe",
                                                               "sha256Hash": "cfe0ae57f314a9f747a7cec605907cdaf1984b3cdea74ee8d5893d00ae0886cc"},
                                                              {"indicatorName": "SET_SYSTEM_SECURITY",
                                                               "applicationName": "ShippingInvoice.pdf.exe",
                                                               "sha256Hash": "cfe0ae57f314a9f747a7cec605907cdaf1984b3cdea74ee8d5893d00ae0886cc"},
                                                              {"indicatorName": "MODIFY_MEMORY_PROTECTION",
                                                               "applicationName": "ShippingInvoice.pdf.exe",
                                                               "sha256Hash": "cfe0ae57f314a9f747a7cec605907cdaf1984b3cdea74ee8d5893d00ae0886cc"},
                                                              {"indicatorName": "KNOWN_PASSWORD_STEALER",
                                                               "applicationName": "ShippingInvoice.pdf.exe",
                                                               "sha256Hash": "cfe0ae57f314a9f747a7cec605907cdaf1984b3cdea74ee8d5893d00ae0886cc"},
                                                              {"indicatorName": "RUN_MALWARE_APP",
                                                               "applicationName": "explorer.exe",
                                                               "sha256Hash": "1e675cb7df214172f7eb0497f7275556038a0d09c6e5a3e6862c5e26885ef455"},
                                                              {"indicatorName": "MODIFY_PROCESS",
                                                               "applicationName": "ShippingInvoice.pdf.exe",
                                                               "sha256Hash": "cfe0ae57f314a9f747a7cec605907cdaf1984b3cdea74ee8d5893d00ae0886cc"},
                                                              {"indicatorName": "MALWARE_APP",
                                                               "applicationName": "ShippingInvoice.pdf.exe",
                                                               "sha256Hash": "cfe0ae57f314a9f747a7cec605907cdaf1984b3cdea74ee8d5893d00ae0886cc"}],
                                               "time": 1460703240678},
                                "url": "https://testserver.company.net/ui#investigate/events/device/2004118/incident/Z7NG6",
                                "eventTime": 1460703240678, "eventId": "f279d0e6035211e6be8701df2c083974",
                                "eventDescription": "[syslog alert] [Cb Defense has detected a threat against your company.] [https://testserver.company.net/ui#device/2004118/incident/Z7NG6] [A known virus (Sality: Keylogger, Password or Data stealer, Backdoor) was detected running.] [Incident id: Z7NG6] [Threat score: 7] [Group: default] [Email: FirstName.LastName@company.net.demo] [Name: Demo_CaretoPC] [Type and OS: WINDOWS XP x86 SP: 0]\n",
                                "deviceInfo": {"email": "COMPANY\\FirstName.LastName", "groupName": "default",
                                               "internalIpAddress": null, "externalIpAddress": null,
                                               "deviceType": "WINDOWS", "deviceVersion": "XP x86 SP: 0",
                                               "targetPriorityType": "MEDIUM", "deviceId": 2004118,
                                               "deviceName": "COMPANY\\Demo_CaretoPC", "deviceHostName": null,
                                               "targetPriorityCode": 0}, "ruleName": "syslog alert",
                                "type": "THREAT"}, {"threatInfo": {"incidentId": "YL5RZ", "score": 7,
                                                                   "summary": "A known virus (Sality: Keylogger, Password or Data stealer, Backdoor) was detected running.",
                                                                   "indicators": [
                                                                       {"indicatorName": "PACKED_CALL",
                                                                        "applicationName": "ShippingInvoice.pdf.exe",
                                                                        "sha256Hash": "cfe0ae57f314a9f747a7cec605907cdaf1984b3cdea74ee8d5893d00ae0886cc"},
                                                                       {"indicatorName": "MODIFY_PROCESS",
                                                                        "applicationName": "ShippingInvoice.pdf.exe",
                                                                        "sha256Hash": "cfe0ae57f314a9f747a7cec605907cdaf1984b3cdea74ee8d5893d00ae0886cc"},
                                                                       {"indicatorName": "ENUMERATE_PROCESSES",
                                                                        "applicationName": "ShippingInvoice.pdf.exe",
                                                                        "sha256Hash": "cfe0ae57f314a9f747a7cec605907cdaf1984b3cdea74ee8d5893d00ae0886cc"},
                                                                       {"indicatorName": "MALWARE_APP",
                                                                        "applicationName": "ShippingInvoice.pdf.exe",
                                                                        "sha256Hash": "cfe0ae57f314a9f747a7cec605907cdaf1984b3cdea74ee8d5893d00ae0886cc"},
                                                                       {"indicatorName": "SET_SYSTEM_SECURITY",
                                                                        "applicationName": "ShippingInvoice.pdf.exe",
                                                                        "sha256Hash": "cfe0ae57f314a9f747a7cec605907cdaf1984b3cdea74ee8d5893d00ae0886cc"},
                                                                       {"indicatorName": "KNOWN_DOWNLOADER",
                                                                        "applicationName": "ShippingInvoice.pdf.exe",
                                                                        "sha256Hash": "cfe0ae57f314a9f747a7cec605907cdaf1984b3cdea74ee8d5893d00ae0886cc"},
                                                                       {"indicatorName": "HAS_PACKED_CODE",
                                                                        "applicationName": "ShippingInvoice.pdf.exe",
                                                                        "sha256Hash": "cfe0ae57f314a9f747a7cec605907cdaf1984b3cdea74ee8d5893d00ae0886cc"},
                                                                       {
                                                                           "indicatorName": "KNOWN_PASSWORD_STEALER",
                                                                           "applicationName": "ShippingInvoice.pdf.exe",
                                                                           "sha256Hash": "cfe0ae57f314a9f747a7cec605907cdaf1984b3cdea74ee8d5893d00ae0886cc"},
                                                                       {
                                                                           "indicatorName": "MODIFY_MEMORY_PROTECTION",
                                                                           "applicationName": "ShippingInvoice.pdf.exe",
                                                                           "sha256Hash": "cfe0ae57f314a9f747a7cec605907cdaf1984b3cdea74ee8d5893d00ae0886cc"}],
                                                                   "time": 1460703240678},
                                                    "url": "https://testserver.company.net/ui#investigate/events/device/2004118/incident/YL5RZ",
                                                    "eventTime": 1460703240678,
                                                    "eventId": "f44087c9035211e6aab2b97cae4f83f3",
                                                    "eventDescription": "[syslog alert] [Cb Defense has detected a threat against your company.] [https://testserver.company.net/ui#device/2004118/incident/YL5RZ] [A known virus (Sality: Keylogger, Password or Data stealer, Backdoor) was detected running.] [Incident id: YL5RZ] [Threat score: 7] [Group: default] [Email: FirstName.LastName@company.net.demo] [Name: Demo_CaretoPC] [Type and OS: WINDOWS XP x86 SP: 0]\n",
                                                    "deviceInfo": {
                                                        "email": "COMPANY\\FirstName.LastName@company.net.demo",
                                                        "groupName": "default", "internalIpAddress": null,
                                                        "externalIpAddress": null, "deviceType": "WINDOWS",
                                                        "deviceVersion": "XP x86 SP: 0",
                                                        "targetPriorityType": "MEDIUM", "deviceId": 2004118,
                                                        "deviceName": "COMPANY\\Demo_CaretoPC",
                                                        "deviceHostName": null, "targetPriorityCode": 0},
                                                    "ruleName": "syslog alert", "type": "THREAT"}, {
                                   "threatInfo": {"incidentId": "IDWID", "score": 7,
                                                  "summary": "A known virus (iWorm) is actively attempting a network connection.",
                                                  "indicators": [{"indicatorName": "ATTEMPTED_CLIENT",
                                                                  "applicationName": "Mac.BackDoor.iWorm_sample_2",
                                                                  "sha256Hash": "0b374d3dfd2fcae65d191dd1810cd8cc0b497c48b509f260654b0f3fe4cc9f8f"},
                                                                 {"indicatorName": "ACTIVE_CLIENT",
                                                                  "applicationName": "Mac.BackDoor.iWorm_sample_2",
                                                                  "sha256Hash": "0b374d3dfd2fcae65d191dd1810cd8cc0b497c48b509f260654b0f3fe4cc9f8f"},
                                                                 {"indicatorName": "KNOWN_MALWARE_ON_NETWORK",
                                                                  "applicationName": "Mac.BackDoor.iWorm_sample_2",
                                                                  "sha256Hash": "0b374d3dfd2fcae65d191dd1810cd8cc0b497c48b509f260654b0f3fe4cc9f8f"},
                                                                 {"indicatorName": "RUN_SYSTEM_APP",
                                                                  "applicationName": "Mac.BackDoor.iWorm_sample_2",
                                                                  "sha256Hash": "0b374d3dfd2fcae65d191dd1810cd8cc0b497c48b509f260654b0f3fe4cc9f8f"},
                                                                 {"indicatorName": "MALWARE_APP",
                                                                  "applicationName": "Mac.BackDoor.iWorm_sample_2",
                                                                  "sha256Hash": "0b374d3dfd2fcae65d191dd1810cd8cc0b497c48b509f260654b0f3fe4cc9f8f"},
                                                                 {"indicatorName": "BEACON",
                                                                  "applicationName": "Mac.BackDoor.iWorm_sample_2",
                                                                  "sha256Hash": "0b374d3dfd2fcae65d191dd1810cd8cc0b497c48b509f260654b0f3fe4cc9f8f"},
                                                                 {"indicatorName": "INTERNATIONAL_SITE",
                                                                  "applicationName": "Mac.BackDoor.iWorm_sample_2",
                                                                  "sha256Hash": "0b374d3dfd2fcae65d191dd1810cd8cc0b497c48b509f260654b0f3fe4cc9f8f"},
                                                                 {"indicatorName": "RUN_ANOTHER_APP",
                                                                  "applicationName": "Mac.BackDoor.iWorm_sample_2",
                                                                  "sha256Hash": "0b374d3dfd2fcae65d191dd1810cd8cc0b497c48b509f260654b0f3fe4cc9f8f"},
                                                                 {"indicatorName": "NETWORK_ACCESS",
                                                                  "applicationName": "Mac.BackDoor.iWorm_sample_2",
                                                                  "sha256Hash": "0b374d3dfd2fcae65d191dd1810cd8cc0b497c48b509f260654b0f3fe4cc9f8f"}],
                                                  "time": 1460751097691},
                                   "url": "https://testserver.company.net/ui#investigate/events/device/2004121/incident/IDWID",
                                   "eventTime": 1460751097691, "eventId": "f66bcb98035211e6be8701df2c083974",
                                   "eventDescription": "[syslog alert] [Cb Defense has detected a threat against your company.] [https://testserver.company.net/ui#device/2004121/incident/IDWID] [A known virus (iWorm) is actively attempting a network connection.] [Incident id: IDWID] [Threat score: 7] [Group: default] [Email: iworm_test@company.net.demo] [Name: iworm_test] [Type and OS: MAC MAC OS X 10.9.0]\n",
                                   "deviceInfo": {"email": "COMPANY\\iworm_test", "groupName": "default",
                                                  "internalIpAddress": null, "externalIpAddress": null,
                                                  "deviceType": "MAC", "deviceVersion": "MAC OS X 10.9.0",
                                                  "targetPriorityType": "MEDIUM", "deviceId": 2004121,
                                                  "deviceName": "COMPANY\\iworm_test", "deviceHostName": null,
                                                  "targetPriorityCode": 0}, "ruleName": "syslog alert",
                                   "type": "THREAT"}, {"threatInfo": {"incidentId": "UHMZ3", "score": 7,
                                                                      "summary": "A known virus (iWorm) is actively attempting a network connection.",
                                                                      "indicators": [
                                                                          {"indicatorName": "MALWARE_APP",
                                                                           "applicationName": "Mac.BackDoor.iWorm_sample_2",
                                                                           "sha256Hash": "0b374d3dfd2fcae65d191dd1810cd8cc0b497c48b509f260654b0f3fe4cc9f8f"},
                                                                          {"indicatorName": "INTERNATIONAL_SITE",
                                                                           "applicationName": "Mac.BackDoor.iWorm_sample_2",
                                                                           "sha256Hash": "0b374d3dfd2fcae65d191dd1810cd8cc0b497c48b509f260654b0f3fe4cc9f8f"},
                                                                          {"indicatorName": "NETWORK_ACCESS",
                                                                           "applicationName": "Mac.BackDoor.iWorm_sample_2",
                                                                           "sha256Hash": "0b374d3dfd2fcae65d191dd1810cd8cc0b497c48b509f260654b0f3fe4cc9f8f"},
                                                                          {
                                                                              "indicatorName": "KNOWN_MALWARE_ON_NETWORK",
                                                                              "applicationName": "Mac.BackDoor.iWorm_sample_2",
                                                                              "sha256Hash": "0b374d3dfd2fcae65d191dd1810cd8cc0b497c48b509f260654b0f3fe4cc9f8f"},
                                                                          {"indicatorName": "BEACON",
                                                                           "applicationName": "Mac.BackDoor.iWorm_sample_2",
                                                                           "sha256Hash": "0b374d3dfd2fcae65d191dd1810cd8cc0b497c48b509f260654b0f3fe4cc9f8f"},
                                                                          {"indicatorName": "ATTEMPTED_CLIENT",
                                                                           "applicationName": "Mac.BackDoor.iWorm_sample_2",
                                                                           "sha256Hash": "0b374d3dfd2fcae65d191dd1810cd8cc0b497c48b509f260654b0f3fe4cc9f8f"},
                                                                          {"indicatorName": "RUN_MALWARE_APP",
                                                                           "applicationName": "bash",
                                                                           "sha256Hash": "737867f9e519c2eae2b064c33dc0608b283ebd6045fcf8b19736651ec34c0e37"},
                                                                          {"indicatorName": "RUN_SYSTEM_APP",
                                                                           "applicationName": "Mac.BackDoor.iWorm_sample_2",
                                                                           "sha256Hash": "0b374d3dfd2fcae65d191dd1810cd8cc0b497c48b509f260654b0f3fe4cc9f8f"},
                                                                          {"indicatorName": "ACTIVE_CLIENT",
                                                                           "applicationName": "Mac.BackDoor.iWorm_sample_2",
                                                                           "sha256Hash": "0b374d3dfd2fcae65d191dd1810cd8cc0b497c48b509f260654b0f3fe4cc9f8f"},
                                                                          {"indicatorName": "TARGET_MALWARE_APP",
                                                                           "applicationName": "bash",
                                                                           "sha256Hash": "737867f9e519c2eae2b064c33dc0608b283ebd6045fcf8b19736651ec34c0e37"},
                                                                          {"indicatorName": "RUN_ANOTHER_APP",
                                                                           "applicationName": "Mac.BackDoor.iWorm_sample_2",
                                                                           "sha256Hash": "0b374d3dfd2fcae65d191dd1810cd8cc0b497c48b509f260654b0f3fe4cc9f8f"}],
                                                                      "time": 1460751097691},
                                                       "url": "https://testserver.company.net/ui#investigate/events/device/2004121/incident/UHMZ3",
                                                       "eventTime": 1460751097691,
                                                       "eventId": "f7e85a1c035211e6aab2b97cae4f83f3",
                                                       "eventDescription": "[syslog alert] [Cb Defense has detected a threat against your company.] [https://testserver.company.net/ui#device/2004121/incident/UHMZ3] [A known virus (iWorm) is actively attempting a network connection.] [Incident id: UHMZ3] [Threat score: 7] [Group: default] [Email: iworm_test@company.net.demo] [Name: iworm_test] [Type and OS: MAC MAC OS X 10.9.0]\n",
                                                       "deviceInfo": {"email": "COMPANY\\iworm_test",
                                                                      "groupName": "default",
                                                                      "internalIpAddress": null,
                                                                      "externalIpAddress": null,
                                                                      "deviceType": "MAC",
                                                                      "deviceVersion": "MAC OS X 10.9.0",
                                                                      "targetPriorityType": "MEDIUM",
                                                                      "deviceId": 2004121,
                                                                      "deviceName": "COMPANY\\iworm_test",
                                                                      "deviceHostName": null,
                                                                      "targetPriorityCode": 0},
                                                       "ruleName": "syslog alert", "type": "THREAT"}, {
                                   "threatInfo": {"incidentId": "DKI00", "score": 3,
                                                  "summary": "An unknown, suspect or compromised application, has exhibited dangerous virus-like behavior.",
                                                  "indicators": [{"indicatorName": "ENUMERATE_PROCESSES",
                                                                  "applicationName": "osxinj",
                                                                  "sha256Hash": "8cae6527b19ddc3395f09b537c727bbfaa5a0fe010ae42229d3d1b4470f2434b"},
                                                                 {"indicatorName": "INJECT_CODE",
                                                                  "applicationName": "osxinj",
                                                                  "sha256Hash": "8cae6527b19ddc3395f09b537c727bbfaa5a0fe010ae42229d3d1b4470f2434b"},
                                                                 {"indicatorName": "SUSPICIOUS_BEHAVIOR",
                                                                  "applicationName": "osxinj",
                                                                  "sha256Hash": "8cae6527b19ddc3395f09b537c727bbfaa5a0fe010ae42229d3d1b4470f2434b"}],
                                                  "time": 1460752031552},
                                   "url": "https://testserver.company.net/ui#investigate/events/device/2004120/incident/DKI00",
                                   "eventTime": 1460752031552, "eventId": "fb1752ee035211e6aab2b97cae4f83f3",
                                   "eventDescription": "[syslog alert] [Cb Defense has detected a threat against your company.] [https://testserver.company.net/ui#device/2004120/incident/DKI00] [An unknown, suspect or compromised application, has exhibited dangerous virus-like behavior.] [Incident id: DKI00] [Threat score: 3] [Group: default] [Email: osxInjection@company.net.demo] [Name: Demo_Mac_Injection] [Type and OS: MAC MAC OS X 10.9.0]\n",
                                   "deviceInfo": {"email": "osxInjection@company.net.demo",
                                                  "groupName": "default", "internalIpAddress": null,
                                                  "externalIpAddress": null, "deviceType": "MAC",
                                                  "deviceVersion": "MAC OS X 10.9.0",
                                                  "targetPriorityType": "MEDIUM", "deviceId": 2004120,
                                                  "deviceName": "Demo_Mac_Injection", "deviceHostName": null,
                                                  "targetPriorityCode": 0}, "ruleName": "syslog alert",
                                   "type": "THREAT"}, {"threatInfo": {"incidentId": "140XP", "score": 7,
                                                                      "summary": "A known virus (Thoper: Keylogger, Password or Data stealer, Backdoor) was detected running.",
                                                                      "indicators": [{
                                                                          "indicatorName": "MODIFY_MEMORY_PROTECTION",
                                                                          "applicationName": "win3dx.DLL",
                                                                          "sha256Hash": "ba6db998cda7cdaa7eea235e26776d1bed99c73f4c9789ed70c98053a8d18559"},
                                                                          {
                                                                              "indicatorName": "MALWARE_APP",
                                                                              "applicationName": "win3dx.DLL",
                                                                              "sha256Hash": "ba6db998cda7cdaa7eea235e26776d1bed99c73f4c9789ed70c98053a8d18559"},
                                                                          {
                                                                              "indicatorName": "KNOWN_BACKDOOR",
                                                                              "applicationName": "win3dx.DLL",
                                                                              "sha256Hash": "ba6db998cda7cdaa7eea235e26776d1bed99c73f4c9789ed70c98053a8d18559"},
                                                                          {
                                                                              "indicatorName": "KNOWN_PASSWORD_STEALER",
                                                                              "applicationName": "win3dx.DLL",
                                                                              "sha256Hash": "ba6db998cda7cdaa7eea235e26776d1bed99c73f4c9789ed70c98053a8d18559"},
                                                                          {
                                                                              "indicatorName": "KNOWN_KEYLOGGER",
                                                                              "applicationName": "win3dx.DLL",
                                                                              "sha256Hash": "ba6db998cda7cdaa7eea235e26776d1bed99c73f4c9789ed70c98053a8d18559"},
                                                                          {
                                                                              "indicatorName": "MODIFY_SERVICE",
                                                                              "applicationName": "win3dx.DLL",
                                                                              "sha256Hash": "ba6db998cda7cdaa7eea235e26776d1bed99c73f4c9789ed70c98053a8d18559"}],
                                                                      "time": 1460752197249},
                                                       "url": "https://testserver.company.net/ui#investigate/events/device/2004116/incident/140XP",
                                                       "eventTime": 1460752197249,
                                                       "eventId": "f73005f9035211e6be8701df2c083974",
                                                       "eventDescription": "[syslog alert] [Cb Defense has detected a threat against your company.] [https://testserver.company.net/ui#device/2004116/incident/140XP] [A known virus (Thoper: Keylogger, Password or Data stealer, Backdoor) was detected running.] [Incident id: 140XP] [Threat score: 7] [Group: default] [Email: rat01@company.net.demo] [Name: Demo_RAT_01] [Type and OS: WINDOWS XP x86 SP: 0]\n",
                                                       "deviceInfo": {"email": "COMPANY\\rat01@company.net.demo",
                                                                      "groupName": "default",
                                                                      "internalIpAddress": null,
                                                                      "externalIpAddress": null,
                                                                      "deviceType": "WINDOWS",
                                                                      "deviceVersion": "XP x86 SP: 0",
                                                                      "targetPriorityType": "MEDIUM",
                                                                      "deviceId": 2004116,
                                                                      "deviceName": "COMPANY\\Demo_RAT_01",
                                                                      "deviceHostName": null,
                                                                      "targetPriorityCode": 0},
                                                       "ruleName": "syslog alert", "type": "THREAT"}, {
                                   "threatInfo": {"incidentId": "VPJZJ", "score": 7,
                                                  "summary": "A known virus (Keylogger, Password or Data stealer, Backdoor) was detected running.",
                                                  "indicators": [{"indicatorName": "MODIFY_SERVICE",
                                                                  "applicationName": "win3dx.DLL",
                                                                  "sha256Hash": "ba6db998cda7cdaa7eea235e26776d1bed99c73f4c9789ed70c98053a8d18559"},
                                                                 {"indicatorName": "KNOWN_KEYLOGGER",
                                                                  "applicationName": "win3dx.DLL",
                                                                  "sha256Hash": "ba6db998cda7cdaa7eea235e26776d1bed99c73f4c9789ed70c98053a8d18559"},
                                                                 {"indicatorName": "KNOWN_PASSWORD_STEALER",
                                                                  "applicationName": "win3dx.DLL",
                                                                  "sha256Hash": "ba6db998cda7cdaa7eea235e26776d1bed99c73f4c9789ed70c98053a8d18559"},
                                                                 {"indicatorName": "CODE_DROP",
                                                                  "applicationName": "explorer.exe",
                                                                  "sha256Hash": "1e675cb7df214172f7eb0497f7275556038a0d09c6e5a3e6862c5e26885ef455"},
                                                                 {"indicatorName": "MALWARE_APP",
                                                                  "applicationName": "win3dx.DLL",
                                                                  "sha256Hash": "ba6db998cda7cdaa7eea235e26776d1bed99c73f4c9789ed70c98053a8d18559"},
                                                                 {"indicatorName": "MALWARE_DROP",
                                                                  "applicationName": "explorer.exe",
                                                                  "sha256Hash": "1e675cb7df214172f7eb0497f7275556038a0d09c6e5a3e6862c5e26885ef455"},
                                                                 {"indicatorName": "TARGET_MALWARE_APP",
                                                                  "applicationName": "explorer.exe",
                                                                  "sha256Hash": "1e675cb7df214172f7eb0497f7275556038a0d09c6e5a3e6862c5e26885ef455"},
                                                                 {"indicatorName": "MODIFY_MEMORY_PROTECTION",
                                                                  "applicationName": "win3dx.DLL",
                                                                  "sha256Hash": "ba6db998cda7cdaa7eea235e26776d1bed99c73f4c9789ed70c98053a8d18559"},
                                                                 {"indicatorName": "KNOWN_BACKDOOR",
                                                                  "applicationName": "win3dx.DLL",
                                                                  "sha256Hash": "ba6db998cda7cdaa7eea235e26776d1bed99c73f4c9789ed70c98053a8d18559"},
                                                                 {"indicatorName": "RUN_MALWARE_APP",
                                                                  "applicationName": "svchost.exe",
                                                                  "sha256Hash": "2910ebc692d833d949bfd56059e8106d324a276d5f165f874f3fb1b6c613cdd5"}],
                                                  "time": 1460752198380},
                                   "url": "https://testserver.company.net/ui#investigate/events/device/2004116/incident/VPJZJ",
                                   "eventTime": 1460752198380, "eventId": "f72cf95a035211e6aab2b97cae4f83f3",
                                   "eventDescription": "[syslog alert] [Cb Defense has detected a threat against your company.] [https://testserver.company.net/ui#device/2004116/incident/VPJZJ] [A known virus (Keylogger, Password or Data stealer, Backdoor) was detected running.] [Incident id: VPJZJ] [Threat score: 7] [Group: default] [Email: rat01@company.net.demo] [Name: Demo_RAT_01] [Type and OS: WINDOWS XP x86 SP: 0]\n",
                                   "deviceInfo": {"email": "COMPANY\\rat01@company.net.demo",
                                                  "groupName": "default", "internalIpAddress": null,
                                                  "externalIpAddress": null, "deviceType": "WINDOWS",
                                                  "deviceVersion": "XP x86 SP: 0",
                                                  "targetPriorityType": "MEDIUM", "deviceId": 2004116,
                                                  "deviceName": "COMPANY\\Demo_RAT_01", "deviceHostName": null,
                                                  "targetPriorityCode": 0}, "ruleName": "syslog alert",
                                   "type": "THREAT"}, {"threatInfo": {"incidentId": "6OJFC", "score": 3,
                                                                      "summary": "A known virus (FakeRean) was detected running.",
                                                                      "indicators": [
                                                                          {"indicatorName": "KNOWN_ROGUE",
                                                                           "applicationName": "svc.exe",
                                                                           "sha256Hash": "a37dd4f85117539ce4401c02c2bea403d7a724bedaccb5969980c8cf39b2a01a"},
                                                                          {
                                                                              "indicatorName": "MODIFY_MEMORY_PROTECTION",
                                                                              "applicationName": "svc.exe",
                                                                              "sha256Hash": "a37dd4f85117539ce4401c02c2bea403d7a724bedaccb5969980c8cf39b2a01a"},
                                                                          {"indicatorName": "MODIFY_OWN_PROCESS",
                                                                           "applicationName": "svc.exe",
                                                                           "sha256Hash": "a37dd4f85117539ce4401c02c2bea403d7a724bedaccb5969980c8cf39b2a01a"},
                                                                          {"indicatorName": "MALWARE_APP",
                                                                           "applicationName": "svc.exe",
                                                                           "sha256Hash": "a37dd4f85117539ce4401c02c2bea403d7a724bedaccb5969980c8cf39b2a01a"},
                                                                          {"indicatorName": "PACKED_CALL",
                                                                           "applicationName": "svc.exe",
                                                                           "sha256Hash": "a37dd4f85117539ce4401c02c2bea403d7a724bedaccb5969980c8cf39b2a01a"},
                                                                          {"indicatorName": "HAS_PACKED_CODE",
                                                                           "applicationName": "svc.exe",
                                                                           "sha256Hash": "a37dd4f85117539ce4401c02c2bea403d7a724bedaccb5969980c8cf39b2a01a"}],
                                                                      "time": 1460752321085},
                                                       "url": "https://testserver.company.net/ui#investigate/events/device/2004122/incident/6OJFC",
                                                       "eventTime": 1460752321085,
                                                       "eventId": "f73313db035211e6aab2b97cae4f83f3",
                                                       "eventDescription": "[syslog alert] [Cb Defense has detected a threat against your company.] [https://testserver.company.net/ui#device/2004122/incident/6OJFC] [A known virus (FakeRean) was detected running.] [Incident id: 6OJFC] [Threat score: 3] [Group: default] [Email: fakeav_driveby@company.net.demo] [Name: fakeav_driveby] [Type and OS: WINDOWS Windows 7 x86 SP: 0]\n",
                                                       "deviceInfo": {
                                                           "email": "COMPANY\\fakeav_driveby@company.net.demo",
                                                           "groupName": "default", "internalIpAddress": null,
                                                           "externalIpAddress": null, "deviceType": "WINDOWS",
                                                           "deviceVersion": "Windows 7 x86 SP: 0",
                                                           "targetPriorityType": "MEDIUM", "deviceId": 2004122,
                                                           "deviceName": "COMPANY\\fakeav_driveby",
                                                           "deviceHostName": null, "targetPriorityCode": 0},
                                                       "ruleName": "syslog alert", "type": "THREAT"}, {
                                   "threatInfo": {"incidentId": "DRE26", "score": 4,
                                                  "summary": "An application has created an executable which is a known virus or on the Company Black List.",
                                                  "indicators": [{"indicatorName": "HAS_SCRIPT_DLL",
                                                                  "applicationName": "iexplore.exe",
                                                                  "sha256Hash": "422d380855c449e81a30fcf840b44cb8b6291549b05768b23954616b4772fc45"},
                                                                 {"indicatorName": "MODIFY_OWN_PROCESS",
                                                                  "applicationName": "svc.exe",
                                                                  "sha256Hash": "a37dd4f85117539ce4401c02c2bea403d7a724bedaccb5969980c8cf39b2a01a"},
                                                                 {"indicatorName": "HAS_PACKED_CODE",
                                                                  "applicationName": "iexplore.exe",
                                                                  "sha256Hash": "422d380855c449e81a30fcf840b44cb8b6291549b05768b23954616b4772fc45"},
                                                                 {"indicatorName": "CODE_DROP",
                                                                  "applicationName": "iexplore.exe",
                                                                  "sha256Hash": "422d380855c449e81a30fcf840b44cb8b6291549b05768b23954616b4772fc45"},
                                                                 {"indicatorName": "RUN_MALWARE_APP",
                                                                  "applicationName": "iexplore.exe",
                                                                  "sha256Hash": "422d380855c449e81a30fcf840b44cb8b6291549b05768b23954616b4772fc45"},
                                                                 {"indicatorName": "RUN_ANOTHER_APP",
                                                                  "applicationName": "iexplore.exe",
                                                                  "sha256Hash": "422d380855c449e81a30fcf840b44cb8b6291549b05768b23954616b4772fc45"},
                                                                 {"indicatorName": "PACKED_CALL",
                                                                  "applicationName": "svc.exe",
                                                                  "sha256Hash": "a37dd4f85117539ce4401c02c2bea403d7a724bedaccb5969980c8cf39b2a01a"},
                                                                 {"indicatorName": "MALWARE_APP",
                                                                  "applicationName": "svc.exe",
                                                                  "sha256Hash": "a37dd4f85117539ce4401c02c2bea403d7a724bedaccb5969980c8cf39b2a01a"},
                                                                 {"indicatorName": "MODIFY_MEMORY_PROTECTION",
                                                                  "applicationName": "svc.exe",
                                                                  "sha256Hash": "a37dd4f85117539ce4401c02c2bea403d7a724bedaccb5969980c8cf39b2a01a"},
                                                                 {"indicatorName": "NEW_SCRIPT_DLL",
                                                                  "applicationName": "iexplore.exe",
                                                                  "sha256Hash": "422d380855c449e81a30fcf840b44cb8b6291549b05768b23954616b4772fc45"},
                                                                 {"indicatorName": "TARGET_MALWARE_APP",
                                                                  "applicationName": "iexplore.exe",
                                                                  "sha256Hash": "422d380855c449e81a30fcf840b44cb8b6291549b05768b23954616b4772fc45"},
                                                                 {"indicatorName": "KNOWN_ROGUE",
                                                                  "applicationName": "svc.exe",
                                                                  "sha256Hash": "a37dd4f85117539ce4401c02c2bea403d7a724bedaccb5969980c8cf39b2a01a"},
                                                                 {"indicatorName": "HAS_PACKED_CODE",
                                                                  "applicationName": "svc.exe",
                                                                  "sha256Hash": "a37dd4f85117539ce4401c02c2bea403d7a724bedaccb5969980c8cf39b2a01a"},
                                                                 {"indicatorName": "MALWARE_DROP",
                                                                  "applicationName": "iexplore.exe",
                                                                  "sha256Hash": "422d380855c449e81a30fcf840b44cb8b6291549b05768b23954616b4772fc45"}],
                                                  "time": 1460752321085},
                                   "url": "https://testserver.company.net/ui#investigate/events/device/2004122/incident/DRE26",
                                   "eventTime": 1460752321085, "eventId": "fadb33aa035211e6be8701df2c083974",
                                   "eventDescription": "[syslog alert] [Cb Defense has detected a threat against your company.] [https://testserver.company.net/ui#device/2004122/incident/DRE26] [An application has created an executable which is a known virus or on the Company Black List.] [Incident id: DRE26] [Threat score: 4] [Group: default] [Email: fakeav_driveby@company.net.demo] [Name: fakeav_driveby] [Type and OS: WINDOWS Windows 7 x86 SP: 0]\n",
                                   "deviceInfo": {"email": "COMPANY\\fakeav_driveby@company.net.demo",
                                                  "groupName": "default", "internalIpAddress": null,
                                                  "externalIpAddress": null, "deviceType": "WINDOWS",
                                                  "deviceVersion": "Windows 7 x86 SP: 0",
                                                  "targetPriorityType": "MEDIUM", "deviceId": 2004122,
                                                  "deviceName": "COMPANY\\fakeav_driveby",
                                                  "deviceHostName": null, "targetPriorityCode": 0},
                                   "ruleName": "syslog alert", "type": "THREAT"}, {
                                   "threatInfo": {"incidentId": "8OI0O", "score": 8,
                                                  "summary": "A known virus (Appetite: Keylogger, Password or Data stealer, Backdoor, Rootkit, Ransomware or Worm) attempted a network connection.",
                                                  "indicators": [{"indicatorName": "ATTEMPTED_CLIENT",
                                                                  "applicationName": "caretoosxdropper",
                                                                  "sha256Hash": "0710be16ba8a36712c3cac21776c8846e29897300271f09ba0a41983e370e1a0"},
                                                                 {"indicatorName": "BEACON",
                                                                  "applicationName": "caretoosxdropper",
                                                                  "sha256Hash": "0710be16ba8a36712c3cac21776c8846e29897300271f09ba0a41983e370e1a0"},
                                                                 {"indicatorName": "MALWARE_DROP",
                                                                  "applicationName": "xpcproxy",
                                                                  "sha256Hash": "ab0d18bd9d4a32e3b5cdc7e2231760833c0e6c2a315b479109df5bceae28b221"},
                                                                 {"indicatorName": "KNOWN_MALWARE_ON_NETWORK",
                                                                  "applicationName": "caretoosxdropper",
                                                                  "sha256Hash": "0710be16ba8a36712c3cac21776c8846e29897300271f09ba0a41983e370e1a0"},
                                                                 {"indicatorName": "MALWARE_APP",
                                                                  "applicationName": "caretoosxdropper",
                                                                  "sha256Hash": "0710be16ba8a36712c3cac21776c8846e29897300271f09ba0a41983e370e1a0"},
                                                                 {"indicatorName": "TARGET_MALWARE_APP",
                                                                  "applicationName": "xpcproxy",
                                                                  "sha256Hash": "ab0d18bd9d4a32e3b5cdc7e2231760833c0e6c2a315b479109df5bceae28b221"},
                                                                 {"indicatorName": "CODE_DROP",
                                                                  "applicationName": "xpcproxy",
                                                                  "sha256Hash": "ab0d18bd9d4a32e3b5cdc7e2231760833c0e6c2a315b479109df5bceae28b221"},
                                                                 {"indicatorName": "KNOWN_BACKDOOR",
                                                                  "applicationName": "caretoosxdropper",
                                                                  "sha256Hash": "0710be16ba8a36712c3cac21776c8846e29897300271f09ba0a41983e370e1a0"},
                                                                 {"indicatorName": "RUN_MALWARE_APP",
                                                                  "applicationName": "bash",
                                                                  "sha256Hash": "737867f9e519c2eae2b064c33dc0608b283ebd6045fcf8b19736651ec34c0e37"}],
                                                  "time": 1460752389112},
                                   "url": "https://testserver.company.net/ui#investigate/events/device/2004117/incident/8OI0O",
                                   "eventTime": 1460752389112, "eventId": "fadd7d9b035211e6be8701df2c083974",
                                   "eventDescription": "[syslog alert] [Cb Defense has detected a threat against your company.] [https://testserver.company.net/ui#device/2004117/incident/8OI0O] [A known virus (Appetite: Keylogger, Password or Data stealer, Backdoor, Rootkit, Ransomware or Worm) attempted a network connection.] [Incident id: 8OI0O] [Threat score: 8] [Group: default] [Email: caretoOsx@company.net.demo] [Name: Demo_CaretoMac] [Type and OS: MAC MAC OS X 10.9.0]\n",
                                   "deviceInfo": {"email": "COMPANY\\caretoOsx@company.net.demo",
                                                  "groupName": "default", "internalIpAddress": null,
                                                  "externalIpAddress": null, "deviceType": "MAC",
                                                  "deviceVersion": "MAC OS X 10.9.0",
                                                  "targetPriorityType": "MEDIUM", "deviceId": 2004117,
                                                  "deviceName": "COMPANY\\Demo_CaretoMac",
                                                  "deviceHostName": null, "targetPriorityCode": 0},
                                   "ruleName": "syslog alert", "type": "THREAT"}, {
                                   "threatInfo": {"incidentId": "3WTHN", "score": 8,
                                                  "summary": "A known virus (Appetite: Keylogger, Password or Data stealer, Backdoor, Rootkit, Ransomware or Worm) attempted a network connection.",
                                                  "indicators": [{"indicatorName": "BEACON",
                                                                  "applicationName": "caretoosxdropper",
                                                                  "sha256Hash": "0710be16ba8a36712c3cac21776c8846e29897300271f09ba0a41983e370e1a0"},
                                                                 {"indicatorName": "KNOWN_MALWARE_ON_NETWORK",
                                                                  "applicationName": "caretoosxdropper",
                                                                  "sha256Hash": "0710be16ba8a36712c3cac21776c8846e29897300271f09ba0a41983e370e1a0"},
                                                                 {"indicatorName": "MALWARE_APP",
                                                                  "applicationName": "caretoosxdropper",
                                                                  "sha256Hash": "0710be16ba8a36712c3cac21776c8846e29897300271f09ba0a41983e370e1a0"},
                                                                 {"indicatorName": "KNOWN_BACKDOOR",
                                                                  "applicationName": "caretoosxdropper",
                                                                  "sha256Hash": "0710be16ba8a36712c3cac21776c8846e29897300271f09ba0a41983e370e1a0"},
                                                                 {"indicatorName": "ATTEMPTED_CLIENT",
                                                                  "applicationName": "caretoosxdropper",
                                                                  "sha256Hash": "0710be16ba8a36712c3cac21776c8846e29897300271f09ba0a41983e370e1a0"}],
                                                  "time": 1460752389112},
                                   "url": "https://testserver.company.net/ui#investigate/events/device/2004117/incident/3WTHN",
                                   "eventTime": 1460752389112, "eventId": "faf9dfdd035211e6aab2b97cae4f83f3",
                                   "eventDescription": "[syslog alert] [Cb Defense has detected a threat against your company.] [https://testserver.company.net/ui#device/2004117/incident/3WTHN] [A known virus (Appetite: Keylogger, Password or Data stealer, Backdoor, Rootkit, Ransomware or Worm) attempted a network connection.] [Incident id: 3WTHN] [Threat score: 8] [Group: default] [Email: caretoOsx@company.net.demo] [Name: Demo_CaretoMac] [Type and OS: MAC MAC OS X 10.9.0]\n",
                                   "deviceInfo": {"email": "COMPANY\\caretoOsx@company.net.demo",
                                                  "groupName": "default", "internalIpAddress": null,
                                                  "externalIpAddress": null, "deviceType": "MAC",
                                                  "deviceVersion": "MAC OS X 10.9.0",
                                                  "targetPriorityType": "MEDIUM", "deviceId": 2004117,
                                                  "deviceName": "COMPANY\\Demo_CaretoMac",
                                                  "deviceHostName": null, "targetPriorityCode": 0},
                                   "ruleName": "syslog alert", "type": "THREAT"}, {
                                   "threatInfo": {"incidentId": "81RTK", "score": 2,
                                                  "summary": "Multiple commands were executed via a script.",
                                                  "indicators": [{"indicatorName": "RUN_ANOTHER_APP",
                                                                  "applicationName": "Payload.class",
                                                                  "sha256Hash": "6750c319c5d1ba2d2937ef602c2e5c03df6fb60449566e5efb0331310a655c4e"},
                                                                 {"indicatorName": "SCRIPT_COMMAND",
                                                                  "applicationName": "Payload.class",
                                                                  "sha256Hash": "6750c319c5d1ba2d2937ef602c2e5c03df6fb60449566e5efb0331310a655c4e"},
                                                                 {"indicatorName": "SCRIPT_COMMAND",
                                                                  "applicationName": "Payload.class",
                                                                  "sha256Hash": "f84adcc7dc36e494dc89fd1c81c30233c91d0cb875c6cf5171dea19ab55cb72f"},
                                                                 {"indicatorName": "RUN_ANOTHER_APP",
                                                                  "applicationName": "Payload.class",
                                                                  "sha256Hash": "9afae0b82960d6fce7544efba1cb0509522dc29ba76539b63c30b5afce86388f"},
                                                                 {"indicatorName": "RUN_ANOTHER_APP",
                                                                  "applicationName": "Payload.class",
                                                                  "sha256Hash": "f84adcc7dc36e494dc89fd1c81c30233c91d0cb875c6cf5171dea19ab55cb72f"}],
                                                  "time": 1460752391454},
                                   "url": "https://testserver.company.net/ui#investigate/events/device/2004119/incident/81RTK",
                                   "eventTime": 1460752391454, "eventId": "f6357957035211e6be8701df2c083974",
                                   "eventDescription": "[syslog alert] [Cb Defense has detected a threat against your company.] [https://testserver.company.net/ui#device/2004119/incident/81RTK] [Multiple commands were executed via a script.] [Incident id: 81RTK] [Threat score: 2] [Group: default] [Email: macReverseShell@company.net.demo] [Name: Demo_Mac_Shell] [Type and OS: MAC MAC OS X 10.9.0]\n",
                                   "deviceInfo": {"email": "COMPANY\\macReverseShell@company.net.demo",
                                                  "groupName": "default", "internalIpAddress": null,
                                                  "externalIpAddress": null, "deviceType": "MAC",
                                                  "deviceVersion": "MAC OS X 10.9.0",
                                                  "targetPriorityType": "MEDIUM", "deviceId": 2004119,
                                                  "deviceName": "COMPANY\\Demo_Mac_Shell",
                                                  "deviceHostName": null, "targetPriorityCode": 0},
                                   "ruleName": "syslog alert", "type": "THREAT"},
                               {
                                   "threatInfo": {"incidentId": "ZZ123", "score": 2,
                                                  "summary": u"Test of various issues with ümlauts and Unicode characters ø.",
                                                  "indicators": [{"indicatorName": "RUN_ANOTHER_APP",
                                                                  "applicationName": "Payload.class",
                                                                  "sha256Hash": "6750c319c5d1ba2d2937ef602c2e5c03df6fb60449566e5efb0331310a655c4e"},
                                                                 {"indicatorName": "SCRIPT_COMMAND",
                                                                  "applicationName": "Payload.class",
                                                                  "sha256Hash": "6750c319c5d1ba2d2937ef602c2e5c03df6fb60449566e5efb0331310a655c4e"},
                                                                 {"indicatorName": "SCRIPT_COMMAND",
                                                                  "applicationName": "Payload.class",
                                                                  "sha256Hash": "f84adcc7dc36e494dc89fd1c81c30233c91d0cb875c6cf5171dea19ab55cb72f"},
                                                                 {"indicatorName": "RUN_ANOTHER_APP",
                                                                  "applicationName": "éxplorer.exe",
                                                                  "sha256Hash": "9afae0b82960d6fce7544efba1cb0509522dc29ba76539b63c30b5afce86388f"},
                                                                 {"indicatorName": "RUN_ANOTHER_APP",
                                                                  "applicationName": "Payload.class",
                                                                  "sha256Hash": "f84adcc7dc36e494dc89fd1c81c30233c91d0cb875c6cf5171dea19ab55cb72f"}],
                                                  "time": 1460752391454},
                                   "url": "https://testserver.company.net/ui#investigate/events/device/2004119/incident/81RTK",
                                   "eventTime": 1460752391454, "eventId": "f6357957035211e6be8701df2c083974",
                                   "eventDescription": "[syslog alert] [Cb Defense has detected a threat against your company.] [https://testserver.company.net/ui#device/2004119/incident/81RTK] [Multiple commands were executed via a script.] [Incident id: 81RTK] [Threat score: 2] [Group: default] [Email: macReverseShell@company.net.demo] [Name: Demo_Mac_Shell] [Type and OS: MAC MAC OS X 10.9.0]\n",
                                   "deviceInfo": {"email": u"COMPANY\\schloßuser",
                                                  "groupName": "default", "internalIpAddress": null,
                                                  "externalIpAddress": null, "deviceType": "MAC",
                                                  "deviceVersion": "MAC OS X 10.9.0",
                                                  "targetPriorityType": "MEDIUM", "deviceId": 2004119,
                                                  "deviceName": u"COMPANY\\Demo_Time",
                                                  "deviceHostName": null, "targetPriorityCode": 0},
                                   "ruleName": "syslog alert", "type": "THREAT"}
                               ], "success": true,
             "message": "Success"}


cef_output_notification = """test CEF:0|CarbonBlack|CbDefense_Syslog_Connector|2.0|Active_Threat|A known virus (Sality: Keylogger, Password or Data stealer, Backdoor) was detected running.|7|rt="Apr 15 2016 06:54:00" sntdom=COMPANY dvchost=Demo_CaretoPC duser=FirstName.LastName dvc= cs3Label="Link" cs3="https://testserver.company.net/ui#investigate/events/device/2004118/incident/Z7NG6" cs4Label="Threat_ID" cs4="Z7NG6" act=Alert
test CEF:0|CarbonBlack|CbDefense_Syslog_Connector|2.0|Active_Threat|A known virus (Sality: Keylogger, Password or Data stealer, Backdoor) was detected running.|7|rt="Apr 15 2016 06:54:00" sntdom=COMPANY dvchost=Demo_CaretoPC duser=FirstName.LastName@company.net.demo dvc= cs3Label="Link" cs3="https://testserver.company.net/ui#investigate/events/device/2004118/incident/YL5RZ" cs4Label="Threat_ID" cs4="YL5RZ" act=Alert
test CEF:0|CarbonBlack|CbDefense_Syslog_Connector|2.0|Active_Threat|A known virus (iWorm) is actively attempting a network connection.|7|rt="Apr 15 2016 20:11:37" sntdom=COMPANY dvchost=iworm_test duser=iworm_test dvc= cs3Label="Link" cs3="https://testserver.company.net/ui#investigate/events/device/2004121/incident/IDWID" cs4Label="Threat_ID" cs4="IDWID" act=Alert
test CEF:0|CarbonBlack|CbDefense_Syslog_Connector|2.0|Active_Threat|A known virus (iWorm) is actively attempting a network connection.|7|rt="Apr 15 2016 20:11:37" sntdom=COMPANY dvchost=iworm_test duser=iworm_test dvc= cs3Label="Link" cs3="https://testserver.company.net/ui#investigate/events/device/2004121/incident/UHMZ3" cs4Label="Threat_ID" cs4="UHMZ3" act=Alert
test CEF:0|CarbonBlack|CbDefense_Syslog_Connector|2.0|Active_Threat|An unknown, suspect or compromised application, has exhibited dangerous virus-like behavior.|3|rt="Apr 15 2016 20:27:11" dvchost=Demo_Mac_Injection duser=osxInjection@company.net.demo dvc= cs3Label="Link" cs3="https://testserver.company.net/ui#investigate/events/device/2004120/incident/DKI00" cs4Label="Threat_ID" cs4="DKI00" act=Alert
test CEF:0|CarbonBlack|CbDefense_Syslog_Connector|2.0|Active_Threat|A known virus (Thoper: Keylogger, Password or Data stealer, Backdoor) was detected running.|7|rt="Apr 15 2016 20:29:57" sntdom=COMPANY dvchost=Demo_RAT_01 duser=rat01@company.net.demo dvc= cs3Label="Link" cs3="https://testserver.company.net/ui#investigate/events/device/2004116/incident/140XP" cs4Label="Threat_ID" cs4="140XP" act=Alert
test CEF:0|CarbonBlack|CbDefense_Syslog_Connector|2.0|Active_Threat|A known virus (Keylogger, Password or Data stealer, Backdoor) was detected running.|7|rt="Apr 15 2016 20:29:58" sntdom=COMPANY dvchost=Demo_RAT_01 duser=rat01@company.net.demo dvc= cs3Label="Link" cs3="https://testserver.company.net/ui#investigate/events/device/2004116/incident/VPJZJ" cs4Label="Threat_ID" cs4="VPJZJ" act=Alert
test CEF:0|CarbonBlack|CbDefense_Syslog_Connector|2.0|Active_Threat|A known virus (FakeRean) was detected running.|3|rt="Apr 15 2016 20:32:01" sntdom=COMPANY dvchost=fakeav_driveby duser=fakeav_driveby@company.net.demo dvc= cs3Label="Link" cs3="https://testserver.company.net/ui#investigate/events/device/2004122/incident/6OJFC" cs4Label="Threat_ID" cs4="6OJFC" act=Alert
test CEF:0|CarbonBlack|CbDefense_Syslog_Connector|2.0|Active_Threat|An application has created an executable which is a known virus or on the Company Black List.|4|rt="Apr 15 2016 20:32:01" sntdom=COMPANY dvchost=fakeav_driveby duser=fakeav_driveby@company.net.demo dvc= cs3Label="Link" cs3="https://testserver.company.net/ui#investigate/events/device/2004122/incident/DRE26" cs4Label="Threat_ID" cs4="DRE26" act=Alert
test CEF:0|CarbonBlack|CbDefense_Syslog_Connector|2.0|Active_Threat|A known virus (Appetite: Keylogger, Password or Data stealer, Backdoor, Rootkit, Ransomware or Worm) attempted a network connection.|8|rt="Apr 15 2016 20:33:09" sntdom=COMPANY dvchost=Demo_CaretoMac duser=caretoOsx@company.net.demo dvc= cs3Label="Link" cs3="https://testserver.company.net/ui#investigate/events/device/2004117/incident/8OI0O" cs4Label="Threat_ID" cs4="8OI0O" act=Alert
test CEF:0|CarbonBlack|CbDefense_Syslog_Connector|2.0|Active_Threat|A known virus (Appetite: Keylogger, Password or Data stealer, Backdoor, Rootkit, Ransomware or Worm) attempted a network connection.|8|rt="Apr 15 2016 20:33:09" sntdom=COMPANY dvchost=Demo_CaretoMac duser=caretoOsx@company.net.demo dvc= cs3Label="Link" cs3="https://testserver.company.net/ui#investigate/events/device/2004117/incident/3WTHN" cs4Label="Threat_ID" cs4="3WTHN" act=Alert
test CEF:0|CarbonBlack|CbDefense_Syslog_Connector|2.0|Active_Threat|Multiple commands were executed via a script.|2|rt="Apr 15 2016 20:33:11" sntdom=COMPANY dvchost=Demo_Mac_Shell duser=macReverseShell@company.net.demo dvc= cs3Label="Link" cs3="https://testserver.company.net/ui#investigate/events/device/2004119/incident/81RTK" cs4Label="Threat_ID" cs4="81RTK" act=Alert
test CEF:0|CarbonBlack|CbDefense_Syslog_Connector|2.0|Active_Threat|Test of various issues with ümlauts and Unicode characters ø.|2|rt="Apr 15 2016 20:33:11" sntdom=COMPANY dvchost=Demo_Time duser=schloßuser dvc= cs3Label="Link" cs3="https://testserver.company.net/ui#investigate/events/device/2004119/incident/81RTK" cs4Label="Threat_ID" cs4="ZZ123" act=Alert"""

leef_output_notification=['LEEF:2.0|CarbonBlack|CbDefense|0.1|THREAT|x09|identHostName=COMPANY\\Demo_CaretoPC\tdeviceName=COMPANY\\Demo_CaretoPC\tsev=7\tdeviceHostName=\texternalIpAddress=\tdeviceId=2004118\truleName=syslog alert\tidentSrc=\tcat=THREAT\teventId=f279d0e6035211e6be8701df2c083974\tsrc=\tresource=COMPANY\\Demo_CaretoPC\ttargetPriorityCode=0\turl=https://testserver.company.net/ui#investigate/events/device/2004118/incident/Z7NG6\tinternalIpAddress=\tdst=\tsummary=A known virus (Sality: Keylogger, Password or Data stealer, Backdoor) was detected running.\tgroupName=default\tdeviceType=WINDOWS\tdevTime=Apr-15-2016 06:54:00 GMT\ttargetPriorityType=MEDIUM\tsignature=Active_Threat\tdevTimeFormat=MMM dd yyyy HH:mm:ss z\tincidentId=Z7NG6\ttype=THREAT\temail=COMPANY\\FirstName.LastName\tdeviceVersion=XP x86 SP: 0', 'LEEF:2.0|CarbonBlack|CbDefense|0.1|PACKED_CALL|x09|identHostName=COMPANY\\Demo_CaretoPC\tdeviceName=COMPANY\\Demo_CaretoPC\tsev=7\tdeviceHostName=\texternalIpAddress=\tdeviceId=2004118\truleName=syslog alert\tidentSrc=\tcat=THREAT\teventId=f279d0e6035211e6be8701df2c083974\tsrc=\tresource=COMPANY\\Demo_CaretoPC\ttargetPriorityCode=0\turl=https://testserver.company.net/ui#investigate/events/device/2004118/incident/Z7NG6\tinternalIpAddress=\tdst=\tsummary=A known virus (Sality: Keylogger, Password or Data stealer, Backdoor) was detected running.\tgroupName=default\tdeviceType=WINDOWS\tdevTime=Apr-15-2016 06:54:00 GMT\ttargetPriorityType=MEDIUM\tsignature=Active_Threat\tdevTimeFormat=MMM dd yyyy HH:mm:ss z\tincidentId=Z7NG6\ttype=THREAT\temail=COMPANY\\FirstName.LastName\tdeviceVersion=XP x86 SP: 0\tapplicationName=ShippingInvoice.pdf.exe\tindicatorName=PACKED_CALL\tsha256Hash=cfe0ae57f314a9f747a7cec605907cdaf1984b3cdea74ee8d5893d00ae0886cc', 'LEEF:2.0|CarbonBlack|CbDefense|0.1|TARGET_MALWARE_APP|x09|identHostName=COMPANY\\Demo_CaretoPC\tdeviceName=COMPANY\\Demo_CaretoPC\tsev=7\tdeviceHostName=\texternalIpAddress=\tdeviceId=2004118\truleName=syslog alert\tidentSrc=\tcat=THREAT\teventId=f279d0e6035211e6be8701df2c083974\tsrc=\tresource=COMPANY\\Demo_CaretoPC\ttargetPriorityCode=0\turl=https://testserver.company.net/ui#investigate/events/device/2004118/incident/Z7NG6\tinternalIpAddress=\tdst=\tsummary=A known virus (Sality: Keylogger, Password or Data stealer, Backdoor) was detected running.\tgroupName=default\tdeviceType=WINDOWS\tdevTime=Apr-15-2016 06:54:00 GMT\ttargetPriorityType=MEDIUM\tsignature=Active_Threat\tdevTimeFormat=MMM dd yyyy HH:mm:ss z\tincidentId=Z7NG6\ttype=THREAT\temail=COMPANY\\FirstName.LastName\tdeviceVersion=XP x86 SP: 0\tapplicationName=explorer.exe\tindicatorName=TARGET_MALWARE_APP\tsha256Hash=1e675cb7df214172f7eb0497f7275556038a0d09c6e5a3e6862c5e26885ef455', 'LEEF:2.0|CarbonBlack|CbDefense|0.1|HAS_PACKED_CODE|x09|identHostName=COMPANY\\Demo_CaretoPC\tdeviceName=COMPANY\\Demo_CaretoPC\tsev=7\tdeviceHostName=\texternalIpAddress=\tdeviceId=2004118\truleName=syslog alert\tidentSrc=\tcat=THREAT\teventId=f279d0e6035211e6be8701df2c083974\tsrc=\tresource=COMPANY\\Demo_CaretoPC\ttargetPriorityCode=0\turl=https://testserver.company.net/ui#investigate/events/device/2004118/incident/Z7NG6\tinternalIpAddress=\tdst=\tsummary=A known virus (Sality: Keylogger, Password or Data stealer, Backdoor) was detected running.\tgroupName=default\tdeviceType=WINDOWS\tdevTime=Apr-15-2016 06:54:00 GMT\ttargetPriorityType=MEDIUM\tsignature=Active_Threat\tdevTimeFormat=MMM dd yyyy HH:mm:ss z\tincidentId=Z7NG6\ttype=THREAT\temail=COMPANY\\FirstName.LastName\tdeviceVersion=XP x86 SP: 0\tapplicationName=ShippingInvoice.pdf.exe\tindicatorName=HAS_PACKED_CODE\tsha256Hash=cfe0ae57f314a9f747a7cec605907cdaf1984b3cdea74ee8d5893d00ae0886cc', 'LEEF:2.0|CarbonBlack|CbDefense|0.1|KNOWN_DOWNLOADER|x09|identHostName=COMPANY\\Demo_CaretoPC\tdeviceName=COMPANY\\Demo_CaretoPC\tsev=7\tdeviceHostName=\texternalIpAddress=\tdeviceId=2004118\truleName=syslog alert\tidentSrc=\tcat=THREAT\teventId=f279d0e6035211e6be8701df2c083974\tsrc=\tresource=COMPANY\\Demo_CaretoPC\ttargetPriorityCode=0\turl=https://testserver.company.net/ui#investigate/events/device/2004118/incident/Z7NG6\tinternalIpAddress=\tdst=\tsummary=A known virus (Sality: Keylogger, Password or Data stealer, Backdoor) was detected running.\tgroupName=default\tdeviceType=WINDOWS\tdevTime=Apr-15-2016 06:54:00 GMT\ttargetPriorityType=MEDIUM\tsignature=Active_Threat\tdevTimeFormat=MMM dd yyyy HH:mm:ss z\tincidentId=Z7NG6\ttype=THREAT\temail=COMPANY\\FirstName.LastName\tdeviceVersion=XP x86 SP: 0\tapplicationName=ShippingInvoice.pdf.exe\tindicatorName=KNOWN_DOWNLOADER\tsha256Hash=cfe0ae57f314a9f747a7cec605907cdaf1984b3cdea74ee8d5893d00ae0886cc', 'LEEF:2.0|CarbonBlack|CbDefense|0.1|ENUMERATE_PROCESSES|x09|identHostName=COMPANY\\Demo_CaretoPC\tdeviceName=COMPANY\\Demo_CaretoPC\tsev=7\tdeviceHostName=\texternalIpAddress=\tdeviceId=2004118\truleName=syslog alert\tidentSrc=\tcat=THREAT\teventId=f279d0e6035211e6be8701df2c083974\tsrc=\tresource=COMPANY\\Demo_CaretoPC\ttargetPriorityCode=0\turl=https://testserver.company.net/ui#investigate/events/device/2004118/incident/Z7NG6\tinternalIpAddress=\tdst=\tsummary=A known virus (Sality: Keylogger, Password or Data stealer, Backdoor) was detected running.\tgroupName=default\tdeviceType=WINDOWS\tdevTime=Apr-15-2016 06:54:00 GMT\ttargetPriorityType=MEDIUM\tsignature=Active_Threat\tdevTimeFormat=MMM dd yyyy HH:mm:ss z\tincidentId=Z7NG6\ttype=THREAT\temail=COMPANY\\FirstName.LastName\tdeviceVersion=XP x86 SP: 0\tapplicationName=ShippingInvoice.pdf.exe\tindicatorName=ENUMERATE_PROCESSES\tsha256Hash=cfe0ae57f314a9f747a7cec605907cdaf1984b3cdea74ee8d5893d00ae0886cc', 'LEEF:2.0|CarbonBlack|CbDefense|0.1|SET_SYSTEM_SECURITY|x09|identHostName=COMPANY\\Demo_CaretoPC\tdeviceName=COMPANY\\Demo_CaretoPC\tsev=7\tdeviceHostName=\texternalIpAddress=\tdeviceId=2004118\truleName=syslog alert\tidentSrc=\tcat=THREAT\teventId=f279d0e6035211e6be8701df2c083974\tsrc=\tresource=COMPANY\\Demo_CaretoPC\ttargetPriorityCode=0\turl=https://testserver.company.net/ui#investigate/events/device/2004118/incident/Z7NG6\tinternalIpAddress=\tdst=\tsummary=A known virus (Sality: Keylogger, Password or Data stealer, Backdoor) was detected running.\tgroupName=default\tdeviceType=WINDOWS\tdevTime=Apr-15-2016 06:54:00 GMT\ttargetPriorityType=MEDIUM\tsignature=Active_Threat\tdevTimeFormat=MMM dd yyyy HH:mm:ss z\tincidentId=Z7NG6\ttype=THREAT\temail=COMPANY\\FirstName.LastName\tdeviceVersion=XP x86 SP: 0\tapplicationName=ShippingInvoice.pdf.exe\tindicatorName=SET_SYSTEM_SECURITY\tsha256Hash=cfe0ae57f314a9f747a7cec605907cdaf1984b3cdea74ee8d5893d00ae0886cc', 'LEEF:2.0|CarbonBlack|CbDefense|0.1|MODIFY_MEMORY_PROTECTION|x09|identHostName=COMPANY\\Demo_CaretoPC\tdeviceName=COMPANY\\Demo_CaretoPC\tsev=7\tdeviceHostName=\texternalIpAddress=\tdeviceId=2004118\truleName=syslog alert\tidentSrc=\tcat=THREAT\teventId=f279d0e6035211e6be8701df2c083974\tsrc=\tresource=COMPANY\\Demo_CaretoPC\ttargetPriorityCode=0\turl=https://testserver.company.net/ui#investigate/events/device/2004118/incident/Z7NG6\tinternalIpAddress=\tdst=\tsummary=A known virus (Sality: Keylogger, Password or Data stealer, Backdoor) was detected running.\tgroupName=default\tdeviceType=WINDOWS\tdevTime=Apr-15-2016 06:54:00 GMT\ttargetPriorityType=MEDIUM\tsignature=Active_Threat\tdevTimeFormat=MMM dd yyyy HH:mm:ss z\tincidentId=Z7NG6\ttype=THREAT\temail=COMPANY\\FirstName.LastName\tdeviceVersion=XP x86 SP: 0\tapplicationName=ShippingInvoice.pdf.exe\tindicatorName=MODIFY_MEMORY_PROTECTION\tsha256Hash=cfe0ae57f314a9f747a7cec605907cdaf1984b3cdea74ee8d5893d00ae0886cc', 'LEEF:2.0|CarbonBlack|CbDefense|0.1|KNOWN_PASSWORD_STEALER|x09|identHostName=COMPANY\\Demo_CaretoPC\tdeviceName=COMPANY\\Demo_CaretoPC\tsev=7\tdeviceHostName=\texternalIpAddress=\tdeviceId=2004118\truleName=syslog alert\tidentSrc=\tcat=THREAT\teventId=f279d0e6035211e6be8701df2c083974\tsrc=\tresource=COMPANY\\Demo_CaretoPC\ttargetPriorityCode=0\turl=https://testserver.company.net/ui#investigate/events/device/2004118/incident/Z7NG6\tinternalIpAddress=\tdst=\tsummary=A known virus (Sality: Keylogger, Password or Data stealer, Backdoor) was detected running.\tgroupName=default\tdeviceType=WINDOWS\tdevTime=Apr-15-2016 06:54:00 GMT\ttargetPriorityType=MEDIUM\tsignature=Active_Threat\tdevTimeFormat=MMM dd yyyy HH:mm:ss z\tincidentId=Z7NG6\ttype=THREAT\temail=COMPANY\\FirstName.LastName\tdeviceVersion=XP x86 SP: 0\tapplicationName=ShippingInvoice.pdf.exe\tindicatorName=KNOWN_PASSWORD_STEALER\tsha256Hash=cfe0ae57f314a9f747a7cec605907cdaf1984b3cdea74ee8d5893d00ae0886cc', 'LEEF:2.0|CarbonBlack|CbDefense|0.1|RUN_MALWARE_APP|x09|identHostName=COMPANY\\Demo_CaretoPC\tdeviceName=COMPANY\\Demo_CaretoPC\tsev=7\tdeviceHostName=\texternalIpAddress=\tdeviceId=2004118\truleName=syslog alert\tidentSrc=\tcat=THREAT\teventId=f279d0e6035211e6be8701df2c083974\tsrc=\tresource=COMPANY\\Demo_CaretoPC\ttargetPriorityCode=0\turl=https://testserver.company.net/ui#investigate/events/device/2004118/incident/Z7NG6\tinternalIpAddress=\tdst=\tsummary=A known virus (Sality: Keylogger, Password or Data stealer, Backdoor) was detected running.\tgroupName=default\tdeviceType=WINDOWS\tdevTime=Apr-15-2016 06:54:00 GMT\ttargetPriorityType=MEDIUM\tsignature=Active_Threat\tdevTimeFormat=MMM dd yyyy HH:mm:ss z\tincidentId=Z7NG6\ttype=THREAT\temail=COMPANY\\FirstName.LastName\tdeviceVersion=XP x86 SP: 0\tapplicationName=explorer.exe\tindicatorName=RUN_MALWARE_APP\tsha256Hash=1e675cb7df214172f7eb0497f7275556038a0d09c6e5a3e6862c5e26885ef455', 'LEEF:2.0|CarbonBlack|CbDefense|0.1|MODIFY_PROCESS|x09|identHostName=COMPANY\\Demo_CaretoPC\tdeviceName=COMPANY\\Demo_CaretoPC\tsev=7\tdeviceHostName=\texternalIpAddress=\tdeviceId=2004118\truleName=syslog alert\tidentSrc=\tcat=THREAT\teventId=f279d0e6035211e6be8701df2c083974\tsrc=\tresource=COMPANY\\Demo_CaretoPC\ttargetPriorityCode=0\turl=https://testserver.company.net/ui#investigate/events/device/2004118/incident/Z7NG6\tinternalIpAddress=\tdst=\tsummary=A known virus (Sality: Keylogger, Password or Data stealer, Backdoor) was detected running.\tgroupName=default\tdeviceType=WINDOWS\tdevTime=Apr-15-2016 06:54:00 GMT\ttargetPriorityType=MEDIUM\tsignature=Active_Threat\tdevTimeFormat=MMM dd yyyy HH:mm:ss z\tincidentId=Z7NG6\ttype=THREAT\temail=COMPANY\\FirstName.LastName\tdeviceVersion=XP x86 SP: 0\tapplicationName=ShippingInvoice.pdf.exe\tindicatorName=MODIFY_PROCESS\tsha256Hash=cfe0ae57f314a9f747a7cec605907cdaf1984b3cdea74ee8d5893d00ae0886cc', 'LEEF:2.0|CarbonBlack|CbDefense|0.1|MALWARE_APP|x09|identHostName=COMPANY\\Demo_CaretoPC\tdeviceName=COMPANY\\Demo_CaretoPC\tsev=7\tdeviceHostName=\texternalIpAddress=\tdeviceId=2004118\truleName=syslog alert\tidentSrc=\tcat=THREAT\teventId=f279d0e6035211e6be8701df2c083974\tsrc=\tresource=COMPANY\\Demo_CaretoPC\ttargetPriorityCode=0\turl=https://testserver.company.net/ui#investigate/events/device/2004118/incident/Z7NG6\tinternalIpAddress=\tdst=\tsummary=A known virus (Sality: Keylogger, Password or Data stealer, Backdoor) was detected running.\tgroupName=default\tdeviceType=WINDOWS\tdevTime=Apr-15-2016 06:54:00 GMT\ttargetPriorityType=MEDIUM\tsignature=Active_Threat\tdevTimeFormat=MMM dd yyyy HH:mm:ss z\tincidentId=Z7NG6\ttype=THREAT\temail=COMPANY\\FirstName.LastName\tdeviceVersion=XP x86 SP: 0\tapplicationName=ShippingInvoice.pdf.exe\tindicatorName=MALWARE_APP\tsha256Hash=cfe0ae57f314a9f747a7cec605907cdaf1984b3cdea74ee8d5893d00ae0886cc', 'LEEF:2.0|CarbonBlack|CbDefense|0.1|THREAT|x09|identHostName=COMPANY\\Demo_CaretoPC\tdeviceName=COMPANY\\Demo_CaretoPC\tsev=7\tdeviceHostName=\texternalIpAddress=\tdeviceId=2004118\truleName=syslog alert\tidentSrc=\tcat=THREAT\teventId=f44087c9035211e6aab2b97cae4f83f3\tsrc=\tresource=COMPANY\\Demo_CaretoPC\ttargetPriorityCode=0\turl=https://testserver.company.net/ui#investigate/events/device/2004118/incident/YL5RZ\tinternalIpAddress=\tdst=\tsummary=A known virus (Sality: Keylogger, Password or Data stealer, Backdoor) was detected running.\tgroupName=default\tdeviceType=WINDOWS\tdevTime=Apr-15-2016 06:54:00 GMT\ttargetPriorityType=MEDIUM\tsignature=Active_Threat\tdevTimeFormat=MMM dd yyyy HH:mm:ss z\tincidentId=YL5RZ\ttype=THREAT\temail=COMPANY\\FirstName.LastName@company.net.demo\tdeviceVersion=XP x86 SP: 0', 'LEEF:2.0|CarbonBlack|CbDefense|0.1|PACKED_CALL|x09|identHostName=COMPANY\\Demo_CaretoPC\tdeviceName=COMPANY\\Demo_CaretoPC\tsev=7\tdeviceHostName=\texternalIpAddress=\tdeviceId=2004118\truleName=syslog alert\tidentSrc=\tcat=THREAT\teventId=f44087c9035211e6aab2b97cae4f83f3\tsrc=\tresource=COMPANY\\Demo_CaretoPC\ttargetPriorityCode=0\turl=https://testserver.company.net/ui#investigate/events/device/2004118/incident/YL5RZ\tinternalIpAddress=\tdst=\tsummary=A known virus (Sality: Keylogger, Password or Data stealer, Backdoor) was detected running.\tgroupName=default\tdeviceType=WINDOWS\tdevTime=Apr-15-2016 06:54:00 GMT\ttargetPriorityType=MEDIUM\tsignature=Active_Threat\tdevTimeFormat=MMM dd yyyy HH:mm:ss z\tincidentId=YL5RZ\ttype=THREAT\temail=COMPANY\\FirstName.LastName@company.net.demo\tdeviceVersion=XP x86 SP: 0\tapplicationName=ShippingInvoice.pdf.exe\tindicatorName=PACKED_CALL\tsha256Hash=cfe0ae57f314a9f747a7cec605907cdaf1984b3cdea74ee8d5893d00ae0886cc', 'LEEF:2.0|CarbonBlack|CbDefense|0.1|MODIFY_PROCESS|x09|identHostName=COMPANY\\Demo_CaretoPC\tdeviceName=COMPANY\\Demo_CaretoPC\tsev=7\tdeviceHostName=\texternalIpAddress=\tdeviceId=2004118\truleName=syslog alert\tidentSrc=\tcat=THREAT\teventId=f44087c9035211e6aab2b97cae4f83f3\tsrc=\tresource=COMPANY\\Demo_CaretoPC\ttargetPriorityCode=0\turl=https://testserver.company.net/ui#investigate/events/device/2004118/incident/YL5RZ\tinternalIpAddress=\tdst=\tsummary=A known virus (Sality: Keylogger, Password or Data stealer, Backdoor) was detected running.\tgroupName=default\tdeviceType=WINDOWS\tdevTime=Apr-15-2016 06:54:00 GMT\ttargetPriorityType=MEDIUM\tsignature=Active_Threat\tdevTimeFormat=MMM dd yyyy HH:mm:ss z\tincidentId=YL5RZ\ttype=THREAT\temail=COMPANY\\FirstName.LastName@company.net.demo\tdeviceVersion=XP x86 SP: 0\tapplicationName=ShippingInvoice.pdf.exe\tindicatorName=MODIFY_PROCESS\tsha256Hash=cfe0ae57f314a9f747a7cec605907cdaf1984b3cdea74ee8d5893d00ae0886cc', 'LEEF:2.0|CarbonBlack|CbDefense|0.1|ENUMERATE_PROCESSES|x09|identHostName=COMPANY\\Demo_CaretoPC\tdeviceName=COMPANY\\Demo_CaretoPC\tsev=7\tdeviceHostName=\texternalIpAddress=\tdeviceId=2004118\truleName=syslog alert\tidentSrc=\tcat=THREAT\teventId=f44087c9035211e6aab2b97cae4f83f3\tsrc=\tresource=COMPANY\\Demo_CaretoPC\ttargetPriorityCode=0\turl=https://testserver.company.net/ui#investigate/events/device/2004118/incident/YL5RZ\tinternalIpAddress=\tdst=\tsummary=A known virus (Sality: Keylogger, Password or Data stealer, Backdoor) was detected running.\tgroupName=default\tdeviceType=WINDOWS\tdevTime=Apr-15-2016 06:54:00 GMT\ttargetPriorityType=MEDIUM\tsignature=Active_Threat\tdevTimeFormat=MMM dd yyyy HH:mm:ss z\tincidentId=YL5RZ\ttype=THREAT\temail=COMPANY\\FirstName.LastName@company.net.demo\tdeviceVersion=XP x86 SP: 0\tapplicationName=ShippingInvoice.pdf.exe\tindicatorName=ENUMERATE_PROCESSES\tsha256Hash=cfe0ae57f314a9f747a7cec605907cdaf1984b3cdea74ee8d5893d00ae0886cc', 'LEEF:2.0|CarbonBlack|CbDefense|0.1|MALWARE_APP|x09|identHostName=COMPANY\\Demo_CaretoPC\tdeviceName=COMPANY\\Demo_CaretoPC\tsev=7\tdeviceHostName=\texternalIpAddress=\tdeviceId=2004118\truleName=syslog alert\tidentSrc=\tcat=THREAT\teventId=f44087c9035211e6aab2b97cae4f83f3\tsrc=\tresource=COMPANY\\Demo_CaretoPC\ttargetPriorityCode=0\turl=https://testserver.company.net/ui#investigate/events/device/2004118/incident/YL5RZ\tinternalIpAddress=\tdst=\tsummary=A known virus (Sality: Keylogger, Password or Data stealer, Backdoor) was detected running.\tgroupName=default\tdeviceType=WINDOWS\tdevTime=Apr-15-2016 06:54:00 GMT\ttargetPriorityType=MEDIUM\tsignature=Active_Threat\tdevTimeFormat=MMM dd yyyy HH:mm:ss z\tincidentId=YL5RZ\ttype=THREAT\temail=COMPANY\\FirstName.LastName@company.net.demo\tdeviceVersion=XP x86 SP: 0\tapplicationName=ShippingInvoice.pdf.exe\tindicatorName=MALWARE_APP\tsha256Hash=cfe0ae57f314a9f747a7cec605907cdaf1984b3cdea74ee8d5893d00ae0886cc', 'LEEF:2.0|CarbonBlack|CbDefense|0.1|SET_SYSTEM_SECURITY|x09|identHostName=COMPANY\\Demo_CaretoPC\tdeviceName=COMPANY\\Demo_CaretoPC\tsev=7\tdeviceHostName=\texternalIpAddress=\tdeviceId=2004118\truleName=syslog alert\tidentSrc=\tcat=THREAT\teventId=f44087c9035211e6aab2b97cae4f83f3\tsrc=\tresource=COMPANY\\Demo_CaretoPC\ttargetPriorityCode=0\turl=https://testserver.company.net/ui#investigate/events/device/2004118/incident/YL5RZ\tinternalIpAddress=\tdst=\tsummary=A known virus (Sality: Keylogger, Password or Data stealer, Backdoor) was detected running.\tgroupName=default\tdeviceType=WINDOWS\tdevTime=Apr-15-2016 06:54:00 GMT\ttargetPriorityType=MEDIUM\tsignature=Active_Threat\tdevTimeFormat=MMM dd yyyy HH:mm:ss z\tincidentId=YL5RZ\ttype=THREAT\temail=COMPANY\\FirstName.LastName@company.net.demo\tdeviceVersion=XP x86 SP: 0\tapplicationName=ShippingInvoice.pdf.exe\tindicatorName=SET_SYSTEM_SECURITY\tsha256Hash=cfe0ae57f314a9f747a7cec605907cdaf1984b3cdea74ee8d5893d00ae0886cc', 'LEEF:2.0|CarbonBlack|CbDefense|0.1|KNOWN_DOWNLOADER|x09|identHostName=COMPANY\\Demo_CaretoPC\tdeviceName=COMPANY\\Demo_CaretoPC\tsev=7\tdeviceHostName=\texternalIpAddress=\tdeviceId=2004118\truleName=syslog alert\tidentSrc=\tcat=THREAT\teventId=f44087c9035211e6aab2b97cae4f83f3\tsrc=\tresource=COMPANY\\Demo_CaretoPC\ttargetPriorityCode=0\turl=https://testserver.company.net/ui#investigate/events/device/2004118/incident/YL5RZ\tinternalIpAddress=\tdst=\tsummary=A known virus (Sality: Keylogger, Password or Data stealer, Backdoor) was detected running.\tgroupName=default\tdeviceType=WINDOWS\tdevTime=Apr-15-2016 06:54:00 GMT\ttargetPriorityType=MEDIUM\tsignature=Active_Threat\tdevTimeFormat=MMM dd yyyy HH:mm:ss z\tincidentId=YL5RZ\ttype=THREAT\temail=COMPANY\\FirstName.LastName@company.net.demo\tdeviceVersion=XP x86 SP: 0\tapplicationName=ShippingInvoice.pdf.exe\tindicatorName=KNOWN_DOWNLOADER\tsha256Hash=cfe0ae57f314a9f747a7cec605907cdaf1984b3cdea74ee8d5893d00ae0886cc', 'LEEF:2.0|CarbonBlack|CbDefense|0.1|HAS_PACKED_CODE|x09|identHostName=COMPANY\\Demo_CaretoPC\tdeviceName=COMPANY\\Demo_CaretoPC\tsev=7\tdeviceHostName=\texternalIpAddress=\tdeviceId=2004118\truleName=syslog alert\tidentSrc=\tcat=THREAT\teventId=f44087c9035211e6aab2b97cae4f83f3\tsrc=\tresource=COMPANY\\Demo_CaretoPC\ttargetPriorityCode=0\turl=https://testserver.company.net/ui#investigate/events/device/2004118/incident/YL5RZ\tinternalIpAddress=\tdst=\tsummary=A known virus (Sality: Keylogger, Password or Data stealer, Backdoor) was detected running.\tgroupName=default\tdeviceType=WINDOWS\tdevTime=Apr-15-2016 06:54:00 GMT\ttargetPriorityType=MEDIUM\tsignature=Active_Threat\tdevTimeFormat=MMM dd yyyy HH:mm:ss z\tincidentId=YL5RZ\ttype=THREAT\temail=COMPANY\\FirstName.LastName@company.net.demo\tdeviceVersion=XP x86 SP: 0\tapplicationName=ShippingInvoice.pdf.exe\tindicatorName=HAS_PACKED_CODE\tsha256Hash=cfe0ae57f314a9f747a7cec605907cdaf1984b3cdea74ee8d5893d00ae0886cc', 'LEEF:2.0|CarbonBlack|CbDefense|0.1|KNOWN_PASSWORD_STEALER|x09|identHostName=COMPANY\\Demo_CaretoPC\tdeviceName=COMPANY\\Demo_CaretoPC\tsev=7\tdeviceHostName=\texternalIpAddress=\tdeviceId=2004118\truleName=syslog alert\tidentSrc=\tcat=THREAT\teventId=f44087c9035211e6aab2b97cae4f83f3\tsrc=\tresource=COMPANY\\Demo_CaretoPC\ttargetPriorityCode=0\turl=https://testserver.company.net/ui#investigate/events/device/2004118/incident/YL5RZ\tinternalIpAddress=\tdst=\tsummary=A known virus (Sality: Keylogger, Password or Data stealer, Backdoor) was detected running.\tgroupName=default\tdeviceType=WINDOWS\tdevTime=Apr-15-2016 06:54:00 GMT\ttargetPriorityType=MEDIUM\tsignature=Active_Threat\tdevTimeFormat=MMM dd yyyy HH:mm:ss z\tincidentId=YL5RZ\ttype=THREAT\temail=COMPANY\\FirstName.LastName@company.net.demo\tdeviceVersion=XP x86 SP: 0\tapplicationName=ShippingInvoice.pdf.exe\tindicatorName=KNOWN_PASSWORD_STEALER\tsha256Hash=cfe0ae57f314a9f747a7cec605907cdaf1984b3cdea74ee8d5893d00ae0886cc', 'LEEF:2.0|CarbonBlack|CbDefense|0.1|MODIFY_MEMORY_PROTECTION|x09|identHostName=COMPANY\\Demo_CaretoPC\tdeviceName=COMPANY\\Demo_CaretoPC\tsev=7\tdeviceHostName=\texternalIpAddress=\tdeviceId=2004118\truleName=syslog alert\tidentSrc=\tcat=THREAT\teventId=f44087c9035211e6aab2b97cae4f83f3\tsrc=\tresource=COMPANY\\Demo_CaretoPC\ttargetPriorityCode=0\turl=https://testserver.company.net/ui#investigate/events/device/2004118/incident/YL5RZ\tinternalIpAddress=\tdst=\tsummary=A known virus (Sality: Keylogger, Password or Data stealer, Backdoor) was detected running.\tgroupName=default\tdeviceType=WINDOWS\tdevTime=Apr-15-2016 06:54:00 GMT\ttargetPriorityType=MEDIUM\tsignature=Active_Threat\tdevTimeFormat=MMM dd yyyy HH:mm:ss z\tincidentId=YL5RZ\ttype=THREAT\temail=COMPANY\\FirstName.LastName@company.net.demo\tdeviceVersion=XP x86 SP: 0\tapplicationName=ShippingInvoice.pdf.exe\tindicatorName=MODIFY_MEMORY_PROTECTION\tsha256Hash=cfe0ae57f314a9f747a7cec605907cdaf1984b3cdea74ee8d5893d00ae0886cc', 'LEEF:2.0|CarbonBlack|CbDefense|0.1|THREAT|x09|identHostName=COMPANY\\iworm_test\tdeviceName=COMPANY\\iworm_test\tsev=7\tdeviceHostName=\texternalIpAddress=\tdeviceId=2004121\truleName=syslog alert\tidentSrc=\tcat=THREAT\teventId=f66bcb98035211e6be8701df2c083974\tsrc=\tresource=COMPANY\\iworm_test\ttargetPriorityCode=0\turl=https://testserver.company.net/ui#investigate/events/device/2004121/incident/IDWID\tinternalIpAddress=\tdst=\tsummary=A known virus (iWorm) is actively attempting a network connection.\tgroupName=default\tdeviceType=MAC\tdevTime=Apr-15-2016 20:11:37 GMT\ttargetPriorityType=MEDIUM\tsignature=Active_Threat\tdevTimeFormat=MMM dd yyyy HH:mm:ss z\tincidentId=IDWID\ttype=THREAT\temail=COMPANY\\iworm_test\tdeviceVersion=MAC OS X 10.9.0', 'LEEF:2.0|CarbonBlack|CbDefense|0.1|ATTEMPTED_CLIENT|x09|identHostName=COMPANY\\iworm_test\tdeviceName=COMPANY\\iworm_test\tsev=7\tdeviceHostName=\texternalIpAddress=\tdeviceId=2004121\truleName=syslog alert\tidentSrc=\tcat=THREAT\teventId=f66bcb98035211e6be8701df2c083974\tsrc=\tresource=COMPANY\\iworm_test\ttargetPriorityCode=0\turl=https://testserver.company.net/ui#investigate/events/device/2004121/incident/IDWID\tinternalIpAddress=\tdst=\tsummary=A known virus (iWorm) is actively attempting a network connection.\tgroupName=default\tdeviceType=MAC\tdevTime=Apr-15-2016 20:11:37 GMT\ttargetPriorityType=MEDIUM\tsignature=Active_Threat\tdevTimeFormat=MMM dd yyyy HH:mm:ss z\tincidentId=IDWID\ttype=THREAT\temail=COMPANY\\iworm_test\tdeviceVersion=MAC OS X 10.9.0\tapplicationName=Mac.BackDoor.iWorm_sample_2\tindicatorName=ATTEMPTED_CLIENT\tsha256Hash=0b374d3dfd2fcae65d191dd1810cd8cc0b497c48b509f260654b0f3fe4cc9f8f', 'LEEF:2.0|CarbonBlack|CbDefense|0.1|ACTIVE_CLIENT|x09|identHostName=COMPANY\\iworm_test\tdeviceName=COMPANY\\iworm_test\tsev=7\tdeviceHostName=\texternalIpAddress=\tdeviceId=2004121\truleName=syslog alert\tidentSrc=\tcat=THREAT\teventId=f66bcb98035211e6be8701df2c083974\tsrc=\tresource=COMPANY\\iworm_test\ttargetPriorityCode=0\turl=https://testserver.company.net/ui#investigate/events/device/2004121/incident/IDWID\tinternalIpAddress=\tdst=\tsummary=A known virus (iWorm) is actively attempting a network connection.\tgroupName=default\tdeviceType=MAC\tdevTime=Apr-15-2016 20:11:37 GMT\ttargetPriorityType=MEDIUM\tsignature=Active_Threat\tdevTimeFormat=MMM dd yyyy HH:mm:ss z\tincidentId=IDWID\ttype=THREAT\temail=COMPANY\\iworm_test\tdeviceVersion=MAC OS X 10.9.0\tapplicationName=Mac.BackDoor.iWorm_sample_2\tindicatorName=ACTIVE_CLIENT\tsha256Hash=0b374d3dfd2fcae65d191dd1810cd8cc0b497c48b509f260654b0f3fe4cc9f8f', 'LEEF:2.0|CarbonBlack|CbDefense|0.1|KNOWN_MALWARE_ON_NETWORK|x09|identHostName=COMPANY\\iworm_test\tdeviceName=COMPANY\\iworm_test\tsev=7\tdeviceHostName=\texternalIpAddress=\tdeviceId=2004121\truleName=syslog alert\tidentSrc=\tcat=THREAT\teventId=f66bcb98035211e6be8701df2c083974\tsrc=\tresource=COMPANY\\iworm_test\ttargetPriorityCode=0\turl=https://testserver.company.net/ui#investigate/events/device/2004121/incident/IDWID\tinternalIpAddress=\tdst=\tsummary=A known virus (iWorm) is actively attempting a network connection.\tgroupName=default\tdeviceType=MAC\tdevTime=Apr-15-2016 20:11:37 GMT\ttargetPriorityType=MEDIUM\tsignature=Active_Threat\tdevTimeFormat=MMM dd yyyy HH:mm:ss z\tincidentId=IDWID\ttype=THREAT\temail=COMPANY\\iworm_test\tdeviceVersion=MAC OS X 10.9.0\tapplicationName=Mac.BackDoor.iWorm_sample_2\tindicatorName=KNOWN_MALWARE_ON_NETWORK\tsha256Hash=0b374d3dfd2fcae65d191dd1810cd8cc0b497c48b509f260654b0f3fe4cc9f8f', 'LEEF:2.0|CarbonBlack|CbDefense|0.1|RUN_SYSTEM_APP|x09|identHostName=COMPANY\\iworm_test\tdeviceName=COMPANY\\iworm_test\tsev=7\tdeviceHostName=\texternalIpAddress=\tdeviceId=2004121\truleName=syslog alert\tidentSrc=\tcat=THREAT\teventId=f66bcb98035211e6be8701df2c083974\tsrc=\tresource=COMPANY\\iworm_test\ttargetPriorityCode=0\turl=https://testserver.company.net/ui#investigate/events/device/2004121/incident/IDWID\tinternalIpAddress=\tdst=\tsummary=A known virus (iWorm) is actively attempting a network connection.\tgroupName=default\tdeviceType=MAC\tdevTime=Apr-15-2016 20:11:37 GMT\ttargetPriorityType=MEDIUM\tsignature=Active_Threat\tdevTimeFormat=MMM dd yyyy HH:mm:ss z\tincidentId=IDWID\ttype=THREAT\temail=COMPANY\\iworm_test\tdeviceVersion=MAC OS X 10.9.0\tapplicationName=Mac.BackDoor.iWorm_sample_2\tindicatorName=RUN_SYSTEM_APP\tsha256Hash=0b374d3dfd2fcae65d191dd1810cd8cc0b497c48b509f260654b0f3fe4cc9f8f', 'LEEF:2.0|CarbonBlack|CbDefense|0.1|MALWARE_APP|x09|identHostName=COMPANY\\iworm_test\tdeviceName=COMPANY\\iworm_test\tsev=7\tdeviceHostName=\texternalIpAddress=\tdeviceId=2004121\truleName=syslog alert\tidentSrc=\tcat=THREAT\teventId=f66bcb98035211e6be8701df2c083974\tsrc=\tresource=COMPANY\\iworm_test\ttargetPriorityCode=0\turl=https://testserver.company.net/ui#investigate/events/device/2004121/incident/IDWID\tinternalIpAddress=\tdst=\tsummary=A known virus (iWorm) is actively attempting a network connection.\tgroupName=default\tdeviceType=MAC\tdevTime=Apr-15-2016 20:11:37 GMT\ttargetPriorityType=MEDIUM\tsignature=Active_Threat\tdevTimeFormat=MMM dd yyyy HH:mm:ss z\tincidentId=IDWID\ttype=THREAT\temail=COMPANY\\iworm_test\tdeviceVersion=MAC OS X 10.9.0\tapplicationName=Mac.BackDoor.iWorm_sample_2\tindicatorName=MALWARE_APP\tsha256Hash=0b374d3dfd2fcae65d191dd1810cd8cc0b497c48b509f260654b0f3fe4cc9f8f', 'LEEF:2.0|CarbonBlack|CbDefense|0.1|BEACON|x09|identHostName=COMPANY\\iworm_test\tdeviceName=COMPANY\\iworm_test\tsev=7\tdeviceHostName=\texternalIpAddress=\tdeviceId=2004121\truleName=syslog alert\tidentSrc=\tcat=THREAT\teventId=f66bcb98035211e6be8701df2c083974\tsrc=\tresource=COMPANY\\iworm_test\ttargetPriorityCode=0\turl=https://testserver.company.net/ui#investigate/events/device/2004121/incident/IDWID\tinternalIpAddress=\tdst=\tsummary=A known virus (iWorm) is actively attempting a network connection.\tgroupName=default\tdeviceType=MAC\tdevTime=Apr-15-2016 20:11:37 GMT\ttargetPriorityType=MEDIUM\tsignature=Active_Threat\tdevTimeFormat=MMM dd yyyy HH:mm:ss z\tincidentId=IDWID\ttype=THREAT\temail=COMPANY\\iworm_test\tdeviceVersion=MAC OS X 10.9.0\tapplicationName=Mac.BackDoor.iWorm_sample_2\tindicatorName=BEACON\tsha256Hash=0b374d3dfd2fcae65d191dd1810cd8cc0b497c48b509f260654b0f3fe4cc9f8f', 'LEEF:2.0|CarbonBlack|CbDefense|0.1|INTERNATIONAL_SITE|x09|identHostName=COMPANY\\iworm_test\tdeviceName=COMPANY\\iworm_test\tsev=7\tdeviceHostName=\texternalIpAddress=\tdeviceId=2004121\truleName=syslog alert\tidentSrc=\tcat=THREAT\teventId=f66bcb98035211e6be8701df2c083974\tsrc=\tresource=COMPANY\\iworm_test\ttargetPriorityCode=0\turl=https://testserver.company.net/ui#investigate/events/device/2004121/incident/IDWID\tinternalIpAddress=\tdst=\tsummary=A known virus (iWorm) is actively attempting a network connection.\tgroupName=default\tdeviceType=MAC\tdevTime=Apr-15-2016 20:11:37 GMT\ttargetPriorityType=MEDIUM\tsignature=Active_Threat\tdevTimeFormat=MMM dd yyyy HH:mm:ss z\tincidentId=IDWID\ttype=THREAT\temail=COMPANY\\iworm_test\tdeviceVersion=MAC OS X 10.9.0\tapplicationName=Mac.BackDoor.iWorm_sample_2\tindicatorName=INTERNATIONAL_SITE\tsha256Hash=0b374d3dfd2fcae65d191dd1810cd8cc0b497c48b509f260654b0f3fe4cc9f8f', 'LEEF:2.0|CarbonBlack|CbDefense|0.1|RUN_ANOTHER_APP|x09|identHostName=COMPANY\\iworm_test\tdeviceName=COMPANY\\iworm_test\tsev=7\tdeviceHostName=\texternalIpAddress=\tdeviceId=2004121\truleName=syslog alert\tidentSrc=\tcat=THREAT\teventId=f66bcb98035211e6be8701df2c083974\tsrc=\tresource=COMPANY\\iworm_test\ttargetPriorityCode=0\turl=https://testserver.company.net/ui#investigate/events/device/2004121/incident/IDWID\tinternalIpAddress=\tdst=\tsummary=A known virus (iWorm) is actively attempting a network connection.\tgroupName=default\tdeviceType=MAC\tdevTime=Apr-15-2016 20:11:37 GMT\ttargetPriorityType=MEDIUM\tsignature=Active_Threat\tdevTimeFormat=MMM dd yyyy HH:mm:ss z\tincidentId=IDWID\ttype=THREAT\temail=COMPANY\\iworm_test\tdeviceVersion=MAC OS X 10.9.0\tapplicationName=Mac.BackDoor.iWorm_sample_2\tindicatorName=RUN_ANOTHER_APP\tsha256Hash=0b374d3dfd2fcae65d191dd1810cd8cc0b497c48b509f260654b0f3fe4cc9f8f', 'LEEF:2.0|CarbonBlack|CbDefense|0.1|NETWORK_ACCESS|x09|identHostName=COMPANY\\iworm_test\tdeviceName=COMPANY\\iworm_test\tsev=7\tdeviceHostName=\texternalIpAddress=\tdeviceId=2004121\truleName=syslog alert\tidentSrc=\tcat=THREAT\teventId=f66bcb98035211e6be8701df2c083974\tsrc=\tresource=COMPANY\\iworm_test\ttargetPriorityCode=0\turl=https://testserver.company.net/ui#investigate/events/device/2004121/incident/IDWID\tinternalIpAddress=\tdst=\tsummary=A known virus (iWorm) is actively attempting a network connection.\tgroupName=default\tdeviceType=MAC\tdevTime=Apr-15-2016 20:11:37 GMT\ttargetPriorityType=MEDIUM\tsignature=Active_Threat\tdevTimeFormat=MMM dd yyyy HH:mm:ss z\tincidentId=IDWID\ttype=THREAT\temail=COMPANY\\iworm_test\tdeviceVersion=MAC OS X 10.9.0\tapplicationName=Mac.BackDoor.iWorm_sample_2\tindicatorName=NETWORK_ACCESS\tsha256Hash=0b374d3dfd2fcae65d191dd1810cd8cc0b497c48b509f260654b0f3fe4cc9f8f', 'LEEF:2.0|CarbonBlack|CbDefense|0.1|THREAT|x09|identHostName=COMPANY\\iworm_test\tdeviceName=COMPANY\\iworm_test\tsev=7\tdeviceHostName=\texternalIpAddress=\tdeviceId=2004121\truleName=syslog alert\tidentSrc=\tcat=THREAT\teventId=f7e85a1c035211e6aab2b97cae4f83f3\tsrc=\tresource=COMPANY\\iworm_test\ttargetPriorityCode=0\turl=https://testserver.company.net/ui#investigate/events/device/2004121/incident/UHMZ3\tinternalIpAddress=\tdst=\tsummary=A known virus (iWorm) is actively attempting a network connection.\tgroupName=default\tdeviceType=MAC\tdevTime=Apr-15-2016 20:11:37 GMT\ttargetPriorityType=MEDIUM\tsignature=Active_Threat\tdevTimeFormat=MMM dd yyyy HH:mm:ss z\tincidentId=UHMZ3\ttype=THREAT\temail=COMPANY\\iworm_test\tdeviceVersion=MAC OS X 10.9.0', 'LEEF:2.0|CarbonBlack|CbDefense|0.1|MALWARE_APP|x09|identHostName=COMPANY\\iworm_test\tdeviceName=COMPANY\\iworm_test\tsev=7\tdeviceHostName=\texternalIpAddress=\tdeviceId=2004121\truleName=syslog alert\tidentSrc=\tcat=THREAT\teventId=f7e85a1c035211e6aab2b97cae4f83f3\tsrc=\tresource=COMPANY\\iworm_test\ttargetPriorityCode=0\turl=https://testserver.company.net/ui#investigate/events/device/2004121/incident/UHMZ3\tinternalIpAddress=\tdst=\tsummary=A known virus (iWorm) is actively attempting a network connection.\tgroupName=default\tdeviceType=MAC\tdevTime=Apr-15-2016 20:11:37 GMT\ttargetPriorityType=MEDIUM\tsignature=Active_Threat\tdevTimeFormat=MMM dd yyyy HH:mm:ss z\tincidentId=UHMZ3\ttype=THREAT\temail=COMPANY\\iworm_test\tdeviceVersion=MAC OS X 10.9.0\tapplicationName=Mac.BackDoor.iWorm_sample_2\tindicatorName=MALWARE_APP\tsha256Hash=0b374d3dfd2fcae65d191dd1810cd8cc0b497c48b509f260654b0f3fe4cc9f8f', 'LEEF:2.0|CarbonBlack|CbDefense|0.1|INTERNATIONAL_SITE|x09|identHostName=COMPANY\\iworm_test\tdeviceName=COMPANY\\iworm_test\tsev=7\tdeviceHostName=\texternalIpAddress=\tdeviceId=2004121\truleName=syslog alert\tidentSrc=\tcat=THREAT\teventId=f7e85a1c035211e6aab2b97cae4f83f3\tsrc=\tresource=COMPANY\\iworm_test\ttargetPriorityCode=0\turl=https://testserver.company.net/ui#investigate/events/device/2004121/incident/UHMZ3\tinternalIpAddress=\tdst=\tsummary=A known virus (iWorm) is actively attempting a network connection.\tgroupName=default\tdeviceType=MAC\tdevTime=Apr-15-2016 20:11:37 GMT\ttargetPriorityType=MEDIUM\tsignature=Active_Threat\tdevTimeFormat=MMM dd yyyy HH:mm:ss z\tincidentId=UHMZ3\ttype=THREAT\temail=COMPANY\\iworm_test\tdeviceVersion=MAC OS X 10.9.0\tapplicationName=Mac.BackDoor.iWorm_sample_2\tindicatorName=INTERNATIONAL_SITE\tsha256Hash=0b374d3dfd2fcae65d191dd1810cd8cc0b497c48b509f260654b0f3fe4cc9f8f', 'LEEF:2.0|CarbonBlack|CbDefense|0.1|NETWORK_ACCESS|x09|identHostName=COMPANY\\iworm_test\tdeviceName=COMPANY\\iworm_test\tsev=7\tdeviceHostName=\texternalIpAddress=\tdeviceId=2004121\truleName=syslog alert\tidentSrc=\tcat=THREAT\teventId=f7e85a1c035211e6aab2b97cae4f83f3\tsrc=\tresource=COMPANY\\iworm_test\ttargetPriorityCode=0\turl=https://testserver.company.net/ui#investigate/events/device/2004121/incident/UHMZ3\tinternalIpAddress=\tdst=\tsummary=A known virus (iWorm) is actively attempting a network connection.\tgroupName=default\tdeviceType=MAC\tdevTime=Apr-15-2016 20:11:37 GMT\ttargetPriorityType=MEDIUM\tsignature=Active_Threat\tdevTimeFormat=MMM dd yyyy HH:mm:ss z\tincidentId=UHMZ3\ttype=THREAT\temail=COMPANY\\iworm_test\tdeviceVersion=MAC OS X 10.9.0\tapplicationName=Mac.BackDoor.iWorm_sample_2\tindicatorName=NETWORK_ACCESS\tsha256Hash=0b374d3dfd2fcae65d191dd1810cd8cc0b497c48b509f260654b0f3fe4cc9f8f', 'LEEF:2.0|CarbonBlack|CbDefense|0.1|KNOWN_MALWARE_ON_NETWORK|x09|identHostName=COMPANY\\iworm_test\tdeviceName=COMPANY\\iworm_test\tsev=7\tdeviceHostName=\texternalIpAddress=\tdeviceId=2004121\truleName=syslog alert\tidentSrc=\tcat=THREAT\teventId=f7e85a1c035211e6aab2b97cae4f83f3\tsrc=\tresource=COMPANY\\iworm_test\ttargetPriorityCode=0\turl=https://testserver.company.net/ui#investigate/events/device/2004121/incident/UHMZ3\tinternalIpAddress=\tdst=\tsummary=A known virus (iWorm) is actively attempting a network connection.\tgroupName=default\tdeviceType=MAC\tdevTime=Apr-15-2016 20:11:37 GMT\ttargetPriorityType=MEDIUM\tsignature=Active_Threat\tdevTimeFormat=MMM dd yyyy HH:mm:ss z\tincidentId=UHMZ3\ttype=THREAT\temail=COMPANY\\iworm_test\tdeviceVersion=MAC OS X 10.9.0\tapplicationName=Mac.BackDoor.iWorm_sample_2\tindicatorName=KNOWN_MALWARE_ON_NETWORK\tsha256Hash=0b374d3dfd2fcae65d191dd1810cd8cc0b497c48b509f260654b0f3fe4cc9f8f', 'LEEF:2.0|CarbonBlack|CbDefense|0.1|BEACON|x09|identHostName=COMPANY\\iworm_test\tdeviceName=COMPANY\\iworm_test\tsev=7\tdeviceHostName=\texternalIpAddress=\tdeviceId=2004121\truleName=syslog alert\tidentSrc=\tcat=THREAT\teventId=f7e85a1c035211e6aab2b97cae4f83f3\tsrc=\tresource=COMPANY\\iworm_test\ttargetPriorityCode=0\turl=https://testserver.company.net/ui#investigate/events/device/2004121/incident/UHMZ3\tinternalIpAddress=\tdst=\tsummary=A known virus (iWorm) is actively attempting a network connection.\tgroupName=default\tdeviceType=MAC\tdevTime=Apr-15-2016 20:11:37 GMT\ttargetPriorityType=MEDIUM\tsignature=Active_Threat\tdevTimeFormat=MMM dd yyyy HH:mm:ss z\tincidentId=UHMZ3\ttype=THREAT\temail=COMPANY\\iworm_test\tdeviceVersion=MAC OS X 10.9.0\tapplicationName=Mac.BackDoor.iWorm_sample_2\tindicatorName=BEACON\tsha256Hash=0b374d3dfd2fcae65d191dd1810cd8cc0b497c48b509f260654b0f3fe4cc9f8f', 'LEEF:2.0|CarbonBlack|CbDefense|0.1|ATTEMPTED_CLIENT|x09|identHostName=COMPANY\\iworm_test\tdeviceName=COMPANY\\iworm_test\tsev=7\tdeviceHostName=\texternalIpAddress=\tdeviceId=2004121\truleName=syslog alert\tidentSrc=\tcat=THREAT\teventId=f7e85a1c035211e6aab2b97cae4f83f3\tsrc=\tresource=COMPANY\\iworm_test\ttargetPriorityCode=0\turl=https://testserver.company.net/ui#investigate/events/device/2004121/incident/UHMZ3\tinternalIpAddress=\tdst=\tsummary=A known virus (iWorm) is actively attempting a network connection.\tgroupName=default\tdeviceType=MAC\tdevTime=Apr-15-2016 20:11:37 GMT\ttargetPriorityType=MEDIUM\tsignature=Active_Threat\tdevTimeFormat=MMM dd yyyy HH:mm:ss z\tincidentId=UHMZ3\ttype=THREAT\temail=COMPANY\\iworm_test\tdeviceVersion=MAC OS X 10.9.0\tapplicationName=Mac.BackDoor.iWorm_sample_2\tindicatorName=ATTEMPTED_CLIENT\tsha256Hash=0b374d3dfd2fcae65d191dd1810cd8cc0b497c48b509f260654b0f3fe4cc9f8f', 'LEEF:2.0|CarbonBlack|CbDefense|0.1|RUN_MALWARE_APP|x09|identHostName=COMPANY\\iworm_test\tdeviceName=COMPANY\\iworm_test\tsev=7\tdeviceHostName=\texternalIpAddress=\tdeviceId=2004121\truleName=syslog alert\tidentSrc=\tcat=THREAT\teventId=f7e85a1c035211e6aab2b97cae4f83f3\tsrc=\tresource=COMPANY\\iworm_test\ttargetPriorityCode=0\turl=https://testserver.company.net/ui#investigate/events/device/2004121/incident/UHMZ3\tinternalIpAddress=\tdst=\tsummary=A known virus (iWorm) is actively attempting a network connection.\tgroupName=default\tdeviceType=MAC\tdevTime=Apr-15-2016 20:11:37 GMT\ttargetPriorityType=MEDIUM\tsignature=Active_Threat\tdevTimeFormat=MMM dd yyyy HH:mm:ss z\tincidentId=UHMZ3\ttype=THREAT\temail=COMPANY\\iworm_test\tdeviceVersion=MAC OS X 10.9.0\tapplicationName=bash\tindicatorName=RUN_MALWARE_APP\tsha256Hash=737867f9e519c2eae2b064c33dc0608b283ebd6045fcf8b19736651ec34c0e37', 'LEEF:2.0|CarbonBlack|CbDefense|0.1|RUN_SYSTEM_APP|x09|identHostName=COMPANY\\iworm_test\tdeviceName=COMPANY\\iworm_test\tsev=7\tdeviceHostName=\texternalIpAddress=\tdeviceId=2004121\truleName=syslog alert\tidentSrc=\tcat=THREAT\teventId=f7e85a1c035211e6aab2b97cae4f83f3\tsrc=\tresource=COMPANY\\iworm_test\ttargetPriorityCode=0\turl=https://testserver.company.net/ui#investigate/events/device/2004121/incident/UHMZ3\tinternalIpAddress=\tdst=\tsummary=A known virus (iWorm) is actively attempting a network connection.\tgroupName=default\tdeviceType=MAC\tdevTime=Apr-15-2016 20:11:37 GMT\ttargetPriorityType=MEDIUM\tsignature=Active_Threat\tdevTimeFormat=MMM dd yyyy HH:mm:ss z\tincidentId=UHMZ3\ttype=THREAT\temail=COMPANY\\iworm_test\tdeviceVersion=MAC OS X 10.9.0\tapplicationName=Mac.BackDoor.iWorm_sample_2\tindicatorName=RUN_SYSTEM_APP\tsha256Hash=0b374d3dfd2fcae65d191dd1810cd8cc0b497c48b509f260654b0f3fe4cc9f8f', 'LEEF:2.0|CarbonBlack|CbDefense|0.1|ACTIVE_CLIENT|x09|identHostName=COMPANY\\iworm_test\tdeviceName=COMPANY\\iworm_test\tsev=7\tdeviceHostName=\texternalIpAddress=\tdeviceId=2004121\truleName=syslog alert\tidentSrc=\tcat=THREAT\teventId=f7e85a1c035211e6aab2b97cae4f83f3\tsrc=\tresource=COMPANY\\iworm_test\ttargetPriorityCode=0\turl=https://testserver.company.net/ui#investigate/events/device/2004121/incident/UHMZ3\tinternalIpAddress=\tdst=\tsummary=A known virus (iWorm) is actively attempting a network connection.\tgroupName=default\tdeviceType=MAC\tdevTime=Apr-15-2016 20:11:37 GMT\ttargetPriorityType=MEDIUM\tsignature=Active_Threat\tdevTimeFormat=MMM dd yyyy HH:mm:ss z\tincidentId=UHMZ3\ttype=THREAT\temail=COMPANY\\iworm_test\tdeviceVersion=MAC OS X 10.9.0\tapplicationName=Mac.BackDoor.iWorm_sample_2\tindicatorName=ACTIVE_CLIENT\tsha256Hash=0b374d3dfd2fcae65d191dd1810cd8cc0b497c48b509f260654b0f3fe4cc9f8f', 'LEEF:2.0|CarbonBlack|CbDefense|0.1|TARGET_MALWARE_APP|x09|identHostName=COMPANY\\iworm_test\tdeviceName=COMPANY\\iworm_test\tsev=7\tdeviceHostName=\texternalIpAddress=\tdeviceId=2004121\truleName=syslog alert\tidentSrc=\tcat=THREAT\teventId=f7e85a1c035211e6aab2b97cae4f83f3\tsrc=\tresource=COMPANY\\iworm_test\ttargetPriorityCode=0\turl=https://testserver.company.net/ui#investigate/events/device/2004121/incident/UHMZ3\tinternalIpAddress=\tdst=\tsummary=A known virus (iWorm) is actively attempting a network connection.\tgroupName=default\tdeviceType=MAC\tdevTime=Apr-15-2016 20:11:37 GMT\ttargetPriorityType=MEDIUM\tsignature=Active_Threat\tdevTimeFormat=MMM dd yyyy HH:mm:ss z\tincidentId=UHMZ3\ttype=THREAT\temail=COMPANY\\iworm_test\tdeviceVersion=MAC OS X 10.9.0\tapplicationName=bash\tindicatorName=TARGET_MALWARE_APP\tsha256Hash=737867f9e519c2eae2b064c33dc0608b283ebd6045fcf8b19736651ec34c0e37', 'LEEF:2.0|CarbonBlack|CbDefense|0.1|RUN_ANOTHER_APP|x09|identHostName=COMPANY\\iworm_test\tdeviceName=COMPANY\\iworm_test\tsev=7\tdeviceHostName=\texternalIpAddress=\tdeviceId=2004121\truleName=syslog alert\tidentSrc=\tcat=THREAT\teventId=f7e85a1c035211e6aab2b97cae4f83f3\tsrc=\tresource=COMPANY\\iworm_test\ttargetPriorityCode=0\turl=https://testserver.company.net/ui#investigate/events/device/2004121/incident/UHMZ3\tinternalIpAddress=\tdst=\tsummary=A known virus (iWorm) is actively attempting a network connection.\tgroupName=default\tdeviceType=MAC\tdevTime=Apr-15-2016 20:11:37 GMT\ttargetPriorityType=MEDIUM\tsignature=Active_Threat\tdevTimeFormat=MMM dd yyyy HH:mm:ss z\tincidentId=UHMZ3\ttype=THREAT\temail=COMPANY\\iworm_test\tdeviceVersion=MAC OS X 10.9.0\tapplicationName=Mac.BackDoor.iWorm_sample_2\tindicatorName=RUN_ANOTHER_APP\tsha256Hash=0b374d3dfd2fcae65d191dd1810cd8cc0b497c48b509f260654b0f3fe4cc9f8f', 'LEEF:2.0|CarbonBlack|CbDefense|0.1|THREAT|x09|identHostName=Demo_Mac_Injection\tdeviceName=Demo_Mac_Injection\tsev=3\tdeviceHostName=\texternalIpAddress=\tdeviceId=2004120\truleName=syslog alert\tidentSrc=\tcat=THREAT\teventId=fb1752ee035211e6aab2b97cae4f83f3\tsrc=\tresource=Demo_Mac_Injection\ttargetPriorityCode=0\turl=https://testserver.company.net/ui#investigate/events/device/2004120/incident/DKI00\tinternalIpAddress=\tdst=\tsummary=An unknown, suspect or compromised application, has exhibited dangerous virus-like behavior.\tgroupName=default\tdeviceType=MAC\tdevTime=Apr-15-2016 20:27:11 GMT\ttargetPriorityType=MEDIUM\tsignature=Active_Threat\tdevTimeFormat=MMM dd yyyy HH:mm:ss z\tincidentId=DKI00\ttype=THREAT\temail=osxInjection@company.net.demo\tdeviceVersion=MAC OS X 10.9.0', 'LEEF:2.0|CarbonBlack|CbDefense|0.1|ENUMERATE_PROCESSES|x09|identHostName=Demo_Mac_Injection\tdeviceName=Demo_Mac_Injection\tsev=3\tdeviceHostName=\texternalIpAddress=\tdeviceId=2004120\truleName=syslog alert\tidentSrc=\tcat=THREAT\teventId=fb1752ee035211e6aab2b97cae4f83f3\tsrc=\tresource=Demo_Mac_Injection\ttargetPriorityCode=0\turl=https://testserver.company.net/ui#investigate/events/device/2004120/incident/DKI00\tinternalIpAddress=\tdst=\tsummary=An unknown, suspect or compromised application, has exhibited dangerous virus-like behavior.\tgroupName=default\tdeviceType=MAC\tdevTime=Apr-15-2016 20:27:11 GMT\ttargetPriorityType=MEDIUM\tsignature=Active_Threat\tdevTimeFormat=MMM dd yyyy HH:mm:ss z\tincidentId=DKI00\ttype=THREAT\temail=osxInjection@company.net.demo\tdeviceVersion=MAC OS X 10.9.0\tapplicationName=osxinj\tindicatorName=ENUMERATE_PROCESSES\tsha256Hash=8cae6527b19ddc3395f09b537c727bbfaa5a0fe010ae42229d3d1b4470f2434b', 'LEEF:2.0|CarbonBlack|CbDefense|0.1|INJECT_CODE|x09|identHostName=Demo_Mac_Injection\tdeviceName=Demo_Mac_Injection\tsev=3\tdeviceHostName=\texternalIpAddress=\tdeviceId=2004120\truleName=syslog alert\tidentSrc=\tcat=THREAT\teventId=fb1752ee035211e6aab2b97cae4f83f3\tsrc=\tresource=Demo_Mac_Injection\ttargetPriorityCode=0\turl=https://testserver.company.net/ui#investigate/events/device/2004120/incident/DKI00\tinternalIpAddress=\tdst=\tsummary=An unknown, suspect or compromised application, has exhibited dangerous virus-like behavior.\tgroupName=default\tdeviceType=MAC\tdevTime=Apr-15-2016 20:27:11 GMT\ttargetPriorityType=MEDIUM\tsignature=Active_Threat\tdevTimeFormat=MMM dd yyyy HH:mm:ss z\tincidentId=DKI00\ttype=THREAT\temail=osxInjection@company.net.demo\tdeviceVersion=MAC OS X 10.9.0\tapplicationName=osxinj\tindicatorName=INJECT_CODE\tsha256Hash=8cae6527b19ddc3395f09b537c727bbfaa5a0fe010ae42229d3d1b4470f2434b', 'LEEF:2.0|CarbonBlack|CbDefense|0.1|SUSPICIOUS_BEHAVIOR|x09|identHostName=Demo_Mac_Injection\tdeviceName=Demo_Mac_Injection\tsev=3\tdeviceHostName=\texternalIpAddress=\tdeviceId=2004120\truleName=syslog alert\tidentSrc=\tcat=THREAT\teventId=fb1752ee035211e6aab2b97cae4f83f3\tsrc=\tresource=Demo_Mac_Injection\ttargetPriorityCode=0\turl=https://testserver.company.net/ui#investigate/events/device/2004120/incident/DKI00\tinternalIpAddress=\tdst=\tsummary=An unknown, suspect or compromised application, has exhibited dangerous virus-like behavior.\tgroupName=default\tdeviceType=MAC\tdevTime=Apr-15-2016 20:27:11 GMT\ttargetPriorityType=MEDIUM\tsignature=Active_Threat\tdevTimeFormat=MMM dd yyyy HH:mm:ss z\tincidentId=DKI00\ttype=THREAT\temail=osxInjection@company.net.demo\tdeviceVersion=MAC OS X 10.9.0\tapplicationName=osxinj\tindicatorName=SUSPICIOUS_BEHAVIOR\tsha256Hash=8cae6527b19ddc3395f09b537c727bbfaa5a0fe010ae42229d3d1b4470f2434b', 'LEEF:2.0|CarbonBlack|CbDefense|0.1|THREAT|x09|identHostName=COMPANY\\Demo_RAT_01\tdeviceName=COMPANY\\Demo_RAT_01\tsev=7\tdeviceHostName=\texternalIpAddress=\tdeviceId=2004116\truleName=syslog alert\tidentSrc=\tcat=THREAT\teventId=f73005f9035211e6be8701df2c083974\tsrc=\tresource=COMPANY\\Demo_RAT_01\ttargetPriorityCode=0\turl=https://testserver.company.net/ui#investigate/events/device/2004116/incident/140XP\tinternalIpAddress=\tdst=\tsummary=A known virus (Thoper: Keylogger, Password or Data stealer, Backdoor) was detected running.\tgroupName=default\tdeviceType=WINDOWS\tdevTime=Apr-15-2016 20:29:57 GMT\ttargetPriorityType=MEDIUM\tsignature=Active_Threat\tdevTimeFormat=MMM dd yyyy HH:mm:ss z\tincidentId=140XP\ttype=THREAT\temail=COMPANY\\rat01@company.net.demo\tdeviceVersion=XP x86 SP: 0', 'LEEF:2.0|CarbonBlack|CbDefense|0.1|MODIFY_MEMORY_PROTECTION|x09|identHostName=COMPANY\\Demo_RAT_01\tdeviceName=COMPANY\\Demo_RAT_01\tsev=7\tdeviceHostName=\texternalIpAddress=\tdeviceId=2004116\truleName=syslog alert\tidentSrc=\tcat=THREAT\teventId=f73005f9035211e6be8701df2c083974\tsrc=\tresource=COMPANY\\Demo_RAT_01\ttargetPriorityCode=0\turl=https://testserver.company.net/ui#investigate/events/device/2004116/incident/140XP\tinternalIpAddress=\tdst=\tsummary=A known virus (Thoper: Keylogger, Password or Data stealer, Backdoor) was detected running.\tgroupName=default\tdeviceType=WINDOWS\tdevTime=Apr-15-2016 20:29:57 GMT\ttargetPriorityType=MEDIUM\tsignature=Active_Threat\tdevTimeFormat=MMM dd yyyy HH:mm:ss z\tincidentId=140XP\ttype=THREAT\temail=COMPANY\\rat01@company.net.demo\tdeviceVersion=XP x86 SP: 0\tapplicationName=win3dx.DLL\tindicatorName=MODIFY_MEMORY_PROTECTION\tsha256Hash=ba6db998cda7cdaa7eea235e26776d1bed99c73f4c9789ed70c98053a8d18559', 'LEEF:2.0|CarbonBlack|CbDefense|0.1|MALWARE_APP|x09|identHostName=COMPANY\\Demo_RAT_01\tdeviceName=COMPANY\\Demo_RAT_01\tsev=7\tdeviceHostName=\texternalIpAddress=\tdeviceId=2004116\truleName=syslog alert\tidentSrc=\tcat=THREAT\teventId=f73005f9035211e6be8701df2c083974\tsrc=\tresource=COMPANY\\Demo_RAT_01\ttargetPriorityCode=0\turl=https://testserver.company.net/ui#investigate/events/device/2004116/incident/140XP\tinternalIpAddress=\tdst=\tsummary=A known virus (Thoper: Keylogger, Password or Data stealer, Backdoor) was detected running.\tgroupName=default\tdeviceType=WINDOWS\tdevTime=Apr-15-2016 20:29:57 GMT\ttargetPriorityType=MEDIUM\tsignature=Active_Threat\tdevTimeFormat=MMM dd yyyy HH:mm:ss z\tincidentId=140XP\ttype=THREAT\temail=COMPANY\\rat01@company.net.demo\tdeviceVersion=XP x86 SP: 0\tapplicationName=win3dx.DLL\tindicatorName=MALWARE_APP\tsha256Hash=ba6db998cda7cdaa7eea235e26776d1bed99c73f4c9789ed70c98053a8d18559', 'LEEF:2.0|CarbonBlack|CbDefense|0.1|KNOWN_BACKDOOR|x09|identHostName=COMPANY\\Demo_RAT_01\tdeviceName=COMPANY\\Demo_RAT_01\tsev=7\tdeviceHostName=\texternalIpAddress=\tdeviceId=2004116\truleName=syslog alert\tidentSrc=\tcat=THREAT\teventId=f73005f9035211e6be8701df2c083974\tsrc=\tresource=COMPANY\\Demo_RAT_01\ttargetPriorityCode=0\turl=https://testserver.company.net/ui#investigate/events/device/2004116/incident/140XP\tinternalIpAddress=\tdst=\tsummary=A known virus (Thoper: Keylogger, Password or Data stealer, Backdoor) was detected running.\tgroupName=default\tdeviceType=WINDOWS\tdevTime=Apr-15-2016 20:29:57 GMT\ttargetPriorityType=MEDIUM\tsignature=Active_Threat\tdevTimeFormat=MMM dd yyyy HH:mm:ss z\tincidentId=140XP\ttype=THREAT\temail=COMPANY\\rat01@company.net.demo\tdeviceVersion=XP x86 SP: 0\tapplicationName=win3dx.DLL\tindicatorName=KNOWN_BACKDOOR\tsha256Hash=ba6db998cda7cdaa7eea235e26776d1bed99c73f4c9789ed70c98053a8d18559', 'LEEF:2.0|CarbonBlack|CbDefense|0.1|KNOWN_PASSWORD_STEALER|x09|identHostName=COMPANY\\Demo_RAT_01\tdeviceName=COMPANY\\Demo_RAT_01\tsev=7\tdeviceHostName=\texternalIpAddress=\tdeviceId=2004116\truleName=syslog alert\tidentSrc=\tcat=THREAT\teventId=f73005f9035211e6be8701df2c083974\tsrc=\tresource=COMPANY\\Demo_RAT_01\ttargetPriorityCode=0\turl=https://testserver.company.net/ui#investigate/events/device/2004116/incident/140XP\tinternalIpAddress=\tdst=\tsummary=A known virus (Thoper: Keylogger, Password or Data stealer, Backdoor) was detected running.\tgroupName=default\tdeviceType=WINDOWS\tdevTime=Apr-15-2016 20:29:57 GMT\ttargetPriorityType=MEDIUM\tsignature=Active_Threat\tdevTimeFormat=MMM dd yyyy HH:mm:ss z\tincidentId=140XP\ttype=THREAT\temail=COMPANY\\rat01@company.net.demo\tdeviceVersion=XP x86 SP: 0\tapplicationName=win3dx.DLL\tindicatorName=KNOWN_PASSWORD_STEALER\tsha256Hash=ba6db998cda7cdaa7eea235e26776d1bed99c73f4c9789ed70c98053a8d18559', 'LEEF:2.0|CarbonBlack|CbDefense|0.1|KNOWN_KEYLOGGER|x09|identHostName=COMPANY\\Demo_RAT_01\tdeviceName=COMPANY\\Demo_RAT_01\tsev=7\tdeviceHostName=\texternalIpAddress=\tdeviceId=2004116\truleName=syslog alert\tidentSrc=\tcat=THREAT\teventId=f73005f9035211e6be8701df2c083974\tsrc=\tresource=COMPANY\\Demo_RAT_01\ttargetPriorityCode=0\turl=https://testserver.company.net/ui#investigate/events/device/2004116/incident/140XP\tinternalIpAddress=\tdst=\tsummary=A known virus (Thoper: Keylogger, Password or Data stealer, Backdoor) was detected running.\tgroupName=default\tdeviceType=WINDOWS\tdevTime=Apr-15-2016 20:29:57 GMT\ttargetPriorityType=MEDIUM\tsignature=Active_Threat\tdevTimeFormat=MMM dd yyyy HH:mm:ss z\tincidentId=140XP\ttype=THREAT\temail=COMPANY\\rat01@company.net.demo\tdeviceVersion=XP x86 SP: 0\tapplicationName=win3dx.DLL\tindicatorName=KNOWN_KEYLOGGER\tsha256Hash=ba6db998cda7cdaa7eea235e26776d1bed99c73f4c9789ed70c98053a8d18559', 'LEEF:2.0|CarbonBlack|CbDefense|0.1|MODIFY_SERVICE|x09|identHostName=COMPANY\\Demo_RAT_01\tdeviceName=COMPANY\\Demo_RAT_01\tsev=7\tdeviceHostName=\texternalIpAddress=\tdeviceId=2004116\truleName=syslog alert\tidentSrc=\tcat=THREAT\teventId=f73005f9035211e6be8701df2c083974\tsrc=\tresource=COMPANY\\Demo_RAT_01\ttargetPriorityCode=0\turl=https://testserver.company.net/ui#investigate/events/device/2004116/incident/140XP\tinternalIpAddress=\tdst=\tsummary=A known virus (Thoper: Keylogger, Password or Data stealer, Backdoor) was detected running.\tgroupName=default\tdeviceType=WINDOWS\tdevTime=Apr-15-2016 20:29:57 GMT\ttargetPriorityType=MEDIUM\tsignature=Active_Threat\tdevTimeFormat=MMM dd yyyy HH:mm:ss z\tincidentId=140XP\ttype=THREAT\temail=COMPANY\\rat01@company.net.demo\tdeviceVersion=XP x86 SP: 0\tapplicationName=win3dx.DLL\tindicatorName=MODIFY_SERVICE\tsha256Hash=ba6db998cda7cdaa7eea235e26776d1bed99c73f4c9789ed70c98053a8d18559', 'LEEF:2.0|CarbonBlack|CbDefense|0.1|THREAT|x09|identHostName=COMPANY\\Demo_RAT_01\tdeviceName=COMPANY\\Demo_RAT_01\tsev=7\tdeviceHostName=\texternalIpAddress=\tdeviceId=2004116\truleName=syslog alert\tidentSrc=\tcat=THREAT\teventId=f72cf95a035211e6aab2b97cae4f83f3\tsrc=\tresource=COMPANY\\Demo_RAT_01\ttargetPriorityCode=0\turl=https://testserver.company.net/ui#investigate/events/device/2004116/incident/VPJZJ\tinternalIpAddress=\tdst=\tsummary=A known virus (Keylogger, Password or Data stealer, Backdoor) was detected running.\tgroupName=default\tdeviceType=WINDOWS\tdevTime=Apr-15-2016 20:29:58 GMT\ttargetPriorityType=MEDIUM\tsignature=Active_Threat\tdevTimeFormat=MMM dd yyyy HH:mm:ss z\tincidentId=VPJZJ\ttype=THREAT\temail=COMPANY\\rat01@company.net.demo\tdeviceVersion=XP x86 SP: 0', 'LEEF:2.0|CarbonBlack|CbDefense|0.1|MODIFY_SERVICE|x09|identHostName=COMPANY\\Demo_RAT_01\tdeviceName=COMPANY\\Demo_RAT_01\tsev=7\tdeviceHostName=\texternalIpAddress=\tdeviceId=2004116\truleName=syslog alert\tidentSrc=\tcat=THREAT\teventId=f72cf95a035211e6aab2b97cae4f83f3\tsrc=\tresource=COMPANY\\Demo_RAT_01\ttargetPriorityCode=0\turl=https://testserver.company.net/ui#investigate/events/device/2004116/incident/VPJZJ\tinternalIpAddress=\tdst=\tsummary=A known virus (Keylogger, Password or Data stealer, Backdoor) was detected running.\tgroupName=default\tdeviceType=WINDOWS\tdevTime=Apr-15-2016 20:29:58 GMT\ttargetPriorityType=MEDIUM\tsignature=Active_Threat\tdevTimeFormat=MMM dd yyyy HH:mm:ss z\tincidentId=VPJZJ\ttype=THREAT\temail=COMPANY\\rat01@company.net.demo\tdeviceVersion=XP x86 SP: 0\tapplicationName=win3dx.DLL\tindicatorName=MODIFY_SERVICE\tsha256Hash=ba6db998cda7cdaa7eea235e26776d1bed99c73f4c9789ed70c98053a8d18559', 'LEEF:2.0|CarbonBlack|CbDefense|0.1|KNOWN_KEYLOGGER|x09|identHostName=COMPANY\\Demo_RAT_01\tdeviceName=COMPANY\\Demo_RAT_01\tsev=7\tdeviceHostName=\texternalIpAddress=\tdeviceId=2004116\truleName=syslog alert\tidentSrc=\tcat=THREAT\teventId=f72cf95a035211e6aab2b97cae4f83f3\tsrc=\tresource=COMPANY\\Demo_RAT_01\ttargetPriorityCode=0\turl=https://testserver.company.net/ui#investigate/events/device/2004116/incident/VPJZJ\tinternalIpAddress=\tdst=\tsummary=A known virus (Keylogger, Password or Data stealer, Backdoor) was detected running.\tgroupName=default\tdeviceType=WINDOWS\tdevTime=Apr-15-2016 20:29:58 GMT\ttargetPriorityType=MEDIUM\tsignature=Active_Threat\tdevTimeFormat=MMM dd yyyy HH:mm:ss z\tincidentId=VPJZJ\ttype=THREAT\temail=COMPANY\\rat01@company.net.demo\tdeviceVersion=XP x86 SP: 0\tapplicationName=win3dx.DLL\tindicatorName=KNOWN_KEYLOGGER\tsha256Hash=ba6db998cda7cdaa7eea235e26776d1bed99c73f4c9789ed70c98053a8d18559', 'LEEF:2.0|CarbonBlack|CbDefense|0.1|KNOWN_PASSWORD_STEALER|x09|identHostName=COMPANY\\Demo_RAT_01\tdeviceName=COMPANY\\Demo_RAT_01\tsev=7\tdeviceHostName=\texternalIpAddress=\tdeviceId=2004116\truleName=syslog alert\tidentSrc=\tcat=THREAT\teventId=f72cf95a035211e6aab2b97cae4f83f3\tsrc=\tresource=COMPANY\\Demo_RAT_01\ttargetPriorityCode=0\turl=https://testserver.company.net/ui#investigate/events/device/2004116/incident/VPJZJ\tinternalIpAddress=\tdst=\tsummary=A known virus (Keylogger, Password or Data stealer, Backdoor) was detected running.\tgroupName=default\tdeviceType=WINDOWS\tdevTime=Apr-15-2016 20:29:58 GMT\ttargetPriorityType=MEDIUM\tsignature=Active_Threat\tdevTimeFormat=MMM dd yyyy HH:mm:ss z\tincidentId=VPJZJ\ttype=THREAT\temail=COMPANY\\rat01@company.net.demo\tdeviceVersion=XP x86 SP: 0\tapplicationName=win3dx.DLL\tindicatorName=KNOWN_PASSWORD_STEALER\tsha256Hash=ba6db998cda7cdaa7eea235e26776d1bed99c73f4c9789ed70c98053a8d18559', 'LEEF:2.0|CarbonBlack|CbDefense|0.1|CODE_DROP|x09|identHostName=COMPANY\\Demo_RAT_01\tdeviceName=COMPANY\\Demo_RAT_01\tsev=7\tdeviceHostName=\texternalIpAddress=\tdeviceId=2004116\truleName=syslog alert\tidentSrc=\tcat=THREAT\teventId=f72cf95a035211e6aab2b97cae4f83f3\tsrc=\tresource=COMPANY\\Demo_RAT_01\ttargetPriorityCode=0\turl=https://testserver.company.net/ui#investigate/events/device/2004116/incident/VPJZJ\tinternalIpAddress=\tdst=\tsummary=A known virus (Keylogger, Password or Data stealer, Backdoor) was detected running.\tgroupName=default\tdeviceType=WINDOWS\tdevTime=Apr-15-2016 20:29:58 GMT\ttargetPriorityType=MEDIUM\tsignature=Active_Threat\tdevTimeFormat=MMM dd yyyy HH:mm:ss z\tincidentId=VPJZJ\ttype=THREAT\temail=COMPANY\\rat01@company.net.demo\tdeviceVersion=XP x86 SP: 0\tapplicationName=explorer.exe\tindicatorName=CODE_DROP\tsha256Hash=1e675cb7df214172f7eb0497f7275556038a0d09c6e5a3e6862c5e26885ef455', 'LEEF:2.0|CarbonBlack|CbDefense|0.1|MALWARE_APP|x09|identHostName=COMPANY\\Demo_RAT_01\tdeviceName=COMPANY\\Demo_RAT_01\tsev=7\tdeviceHostName=\texternalIpAddress=\tdeviceId=2004116\truleName=syslog alert\tidentSrc=\tcat=THREAT\teventId=f72cf95a035211e6aab2b97cae4f83f3\tsrc=\tresource=COMPANY\\Demo_RAT_01\ttargetPriorityCode=0\turl=https://testserver.company.net/ui#investigate/events/device/2004116/incident/VPJZJ\tinternalIpAddress=\tdst=\tsummary=A known virus (Keylogger, Password or Data stealer, Backdoor) was detected running.\tgroupName=default\tdeviceType=WINDOWS\tdevTime=Apr-15-2016 20:29:58 GMT\ttargetPriorityType=MEDIUM\tsignature=Active_Threat\tdevTimeFormat=MMM dd yyyy HH:mm:ss z\tincidentId=VPJZJ\ttype=THREAT\temail=COMPANY\\rat01@company.net.demo\tdeviceVersion=XP x86 SP: 0\tapplicationName=win3dx.DLL\tindicatorName=MALWARE_APP\tsha256Hash=ba6db998cda7cdaa7eea235e26776d1bed99c73f4c9789ed70c98053a8d18559', 'LEEF:2.0|CarbonBlack|CbDefense|0.1|MALWARE_DROP|x09|identHostName=COMPANY\\Demo_RAT_01\tdeviceName=COMPANY\\Demo_RAT_01\tsev=7\tdeviceHostName=\texternalIpAddress=\tdeviceId=2004116\truleName=syslog alert\tidentSrc=\tcat=THREAT\teventId=f72cf95a035211e6aab2b97cae4f83f3\tsrc=\tresource=COMPANY\\Demo_RAT_01\ttargetPriorityCode=0\turl=https://testserver.company.net/ui#investigate/events/device/2004116/incident/VPJZJ\tinternalIpAddress=\tdst=\tsummary=A known virus (Keylogger, Password or Data stealer, Backdoor) was detected running.\tgroupName=default\tdeviceType=WINDOWS\tdevTime=Apr-15-2016 20:29:58 GMT\ttargetPriorityType=MEDIUM\tsignature=Active_Threat\tdevTimeFormat=MMM dd yyyy HH:mm:ss z\tincidentId=VPJZJ\ttype=THREAT\temail=COMPANY\\rat01@company.net.demo\tdeviceVersion=XP x86 SP: 0\tapplicationName=explorer.exe\tindicatorName=MALWARE_DROP\tsha256Hash=1e675cb7df214172f7eb0497f7275556038a0d09c6e5a3e6862c5e26885ef455', 'LEEF:2.0|CarbonBlack|CbDefense|0.1|TARGET_MALWARE_APP|x09|identHostName=COMPANY\\Demo_RAT_01\tdeviceName=COMPANY\\Demo_RAT_01\tsev=7\tdeviceHostName=\texternalIpAddress=\tdeviceId=2004116\truleName=syslog alert\tidentSrc=\tcat=THREAT\teventId=f72cf95a035211e6aab2b97cae4f83f3\tsrc=\tresource=COMPANY\\Demo_RAT_01\ttargetPriorityCode=0\turl=https://testserver.company.net/ui#investigate/events/device/2004116/incident/VPJZJ\tinternalIpAddress=\tdst=\tsummary=A known virus (Keylogger, Password or Data stealer, Backdoor) was detected running.\tgroupName=default\tdeviceType=WINDOWS\tdevTime=Apr-15-2016 20:29:58 GMT\ttargetPriorityType=MEDIUM\tsignature=Active_Threat\tdevTimeFormat=MMM dd yyyy HH:mm:ss z\tincidentId=VPJZJ\ttype=THREAT\temail=COMPANY\\rat01@company.net.demo\tdeviceVersion=XP x86 SP: 0\tapplicationName=explorer.exe\tindicatorName=TARGET_MALWARE_APP\tsha256Hash=1e675cb7df214172f7eb0497f7275556038a0d09c6e5a3e6862c5e26885ef455', 'LEEF:2.0|CarbonBlack|CbDefense|0.1|MODIFY_MEMORY_PROTECTION|x09|identHostName=COMPANY\\Demo_RAT_01\tdeviceName=COMPANY\\Demo_RAT_01\tsev=7\tdeviceHostName=\texternalIpAddress=\tdeviceId=2004116\truleName=syslog alert\tidentSrc=\tcat=THREAT\teventId=f72cf95a035211e6aab2b97cae4f83f3\tsrc=\tresource=COMPANY\\Demo_RAT_01\ttargetPriorityCode=0\turl=https://testserver.company.net/ui#investigate/events/device/2004116/incident/VPJZJ\tinternalIpAddress=\tdst=\tsummary=A known virus (Keylogger, Password or Data stealer, Backdoor) was detected running.\tgroupName=default\tdeviceType=WINDOWS\tdevTime=Apr-15-2016 20:29:58 GMT\ttargetPriorityType=MEDIUM\tsignature=Active_Threat\tdevTimeFormat=MMM dd yyyy HH:mm:ss z\tincidentId=VPJZJ\ttype=THREAT\temail=COMPANY\\rat01@company.net.demo\tdeviceVersion=XP x86 SP: 0\tapplicationName=win3dx.DLL\tindicatorName=MODIFY_MEMORY_PROTECTION\tsha256Hash=ba6db998cda7cdaa7eea235e26776d1bed99c73f4c9789ed70c98053a8d18559', 'LEEF:2.0|CarbonBlack|CbDefense|0.1|KNOWN_BACKDOOR|x09|identHostName=COMPANY\\Demo_RAT_01\tdeviceName=COMPANY\\Demo_RAT_01\tsev=7\tdeviceHostName=\texternalIpAddress=\tdeviceId=2004116\truleName=syslog alert\tidentSrc=\tcat=THREAT\teventId=f72cf95a035211e6aab2b97cae4f83f3\tsrc=\tresource=COMPANY\\Demo_RAT_01\ttargetPriorityCode=0\turl=https://testserver.company.net/ui#investigate/events/device/2004116/incident/VPJZJ\tinternalIpAddress=\tdst=\tsummary=A known virus (Keylogger, Password or Data stealer, Backdoor) was detected running.\tgroupName=default\tdeviceType=WINDOWS\tdevTime=Apr-15-2016 20:29:58 GMT\ttargetPriorityType=MEDIUM\tsignature=Active_Threat\tdevTimeFormat=MMM dd yyyy HH:mm:ss z\tincidentId=VPJZJ\ttype=THREAT\temail=COMPANY\\rat01@company.net.demo\tdeviceVersion=XP x86 SP: 0\tapplicationName=win3dx.DLL\tindicatorName=KNOWN_BACKDOOR\tsha256Hash=ba6db998cda7cdaa7eea235e26776d1bed99c73f4c9789ed70c98053a8d18559', 'LEEF:2.0|CarbonBlack|CbDefense|0.1|RUN_MALWARE_APP|x09|identHostName=COMPANY\\Demo_RAT_01\tdeviceName=COMPANY\\Demo_RAT_01\tsev=7\tdeviceHostName=\texternalIpAddress=\tdeviceId=2004116\truleName=syslog alert\tidentSrc=\tcat=THREAT\teventId=f72cf95a035211e6aab2b97cae4f83f3\tsrc=\tresource=COMPANY\\Demo_RAT_01\ttargetPriorityCode=0\turl=https://testserver.company.net/ui#investigate/events/device/2004116/incident/VPJZJ\tinternalIpAddress=\tdst=\tsummary=A known virus (Keylogger, Password or Data stealer, Backdoor) was detected running.\tgroupName=default\tdeviceType=WINDOWS\tdevTime=Apr-15-2016 20:29:58 GMT\ttargetPriorityType=MEDIUM\tsignature=Active_Threat\tdevTimeFormat=MMM dd yyyy HH:mm:ss z\tincidentId=VPJZJ\ttype=THREAT\temail=COMPANY\\rat01@company.net.demo\tdeviceVersion=XP x86 SP: 0\tapplicationName=svchost.exe\tindicatorName=RUN_MALWARE_APP\tsha256Hash=2910ebc692d833d949bfd56059e8106d324a276d5f165f874f3fb1b6c613cdd5', 'LEEF:2.0|CarbonBlack|CbDefense|0.1|THREAT|x09|identHostName=COMPANY\\fakeav_driveby\tdeviceName=COMPANY\\fakeav_driveby\tsev=3\tdeviceHostName=\texternalIpAddress=\tdeviceId=2004122\truleName=syslog alert\tidentSrc=\tcat=THREAT\teventId=f73313db035211e6aab2b97cae4f83f3\tsrc=\tresource=COMPANY\\fakeav_driveby\ttargetPriorityCode=0\turl=https://testserver.company.net/ui#investigate/events/device/2004122/incident/6OJFC\tinternalIpAddress=\tdst=\tsummary=A known virus (FakeRean) was detected running.\tgroupName=default\tdeviceType=WINDOWS\tdevTime=Apr-15-2016 20:32:01 GMT\ttargetPriorityType=MEDIUM\tsignature=Active_Threat\tdevTimeFormat=MMM dd yyyy HH:mm:ss z\tincidentId=6OJFC\ttype=THREAT\temail=COMPANY\\fakeav_driveby@company.net.demo\tdeviceVersion=Windows 7 x86 SP: 0', 'LEEF:2.0|CarbonBlack|CbDefense|0.1|KNOWN_ROGUE|x09|identHostName=COMPANY\\fakeav_driveby\tdeviceName=COMPANY\\fakeav_driveby\tsev=3\tdeviceHostName=\texternalIpAddress=\tdeviceId=2004122\truleName=syslog alert\tidentSrc=\tcat=THREAT\teventId=f73313db035211e6aab2b97cae4f83f3\tsrc=\tresource=COMPANY\\fakeav_driveby\ttargetPriorityCode=0\turl=https://testserver.company.net/ui#investigate/events/device/2004122/incident/6OJFC\tinternalIpAddress=\tdst=\tsummary=A known virus (FakeRean) was detected running.\tgroupName=default\tdeviceType=WINDOWS\tdevTime=Apr-15-2016 20:32:01 GMT\ttargetPriorityType=MEDIUM\tsignature=Active_Threat\tdevTimeFormat=MMM dd yyyy HH:mm:ss z\tincidentId=6OJFC\ttype=THREAT\temail=COMPANY\\fakeav_driveby@company.net.demo\tdeviceVersion=Windows 7 x86 SP: 0\tapplicationName=svc.exe\tindicatorName=KNOWN_ROGUE\tsha256Hash=a37dd4f85117539ce4401c02c2bea403d7a724bedaccb5969980c8cf39b2a01a', 'LEEF:2.0|CarbonBlack|CbDefense|0.1|MODIFY_MEMORY_PROTECTION|x09|identHostName=COMPANY\\fakeav_driveby\tdeviceName=COMPANY\\fakeav_driveby\tsev=3\tdeviceHostName=\texternalIpAddress=\tdeviceId=2004122\truleName=syslog alert\tidentSrc=\tcat=THREAT\teventId=f73313db035211e6aab2b97cae4f83f3\tsrc=\tresource=COMPANY\\fakeav_driveby\ttargetPriorityCode=0\turl=https://testserver.company.net/ui#investigate/events/device/2004122/incident/6OJFC\tinternalIpAddress=\tdst=\tsummary=A known virus (FakeRean) was detected running.\tgroupName=default\tdeviceType=WINDOWS\tdevTime=Apr-15-2016 20:32:01 GMT\ttargetPriorityType=MEDIUM\tsignature=Active_Threat\tdevTimeFormat=MMM dd yyyy HH:mm:ss z\tincidentId=6OJFC\ttype=THREAT\temail=COMPANY\\fakeav_driveby@company.net.demo\tdeviceVersion=Windows 7 x86 SP: 0\tapplicationName=svc.exe\tindicatorName=MODIFY_MEMORY_PROTECTION\tsha256Hash=a37dd4f85117539ce4401c02c2bea403d7a724bedaccb5969980c8cf39b2a01a', 'LEEF:2.0|CarbonBlack|CbDefense|0.1|MODIFY_OWN_PROCESS|x09|identHostName=COMPANY\\fakeav_driveby\tdeviceName=COMPANY\\fakeav_driveby\tsev=3\tdeviceHostName=\texternalIpAddress=\tdeviceId=2004122\truleName=syslog alert\tidentSrc=\tcat=THREAT\teventId=f73313db035211e6aab2b97cae4f83f3\tsrc=\tresource=COMPANY\\fakeav_driveby\ttargetPriorityCode=0\turl=https://testserver.company.net/ui#investigate/events/device/2004122/incident/6OJFC\tinternalIpAddress=\tdst=\tsummary=A known virus (FakeRean) was detected running.\tgroupName=default\tdeviceType=WINDOWS\tdevTime=Apr-15-2016 20:32:01 GMT\ttargetPriorityType=MEDIUM\tsignature=Active_Threat\tdevTimeFormat=MMM dd yyyy HH:mm:ss z\tincidentId=6OJFC\ttype=THREAT\temail=COMPANY\\fakeav_driveby@company.net.demo\tdeviceVersion=Windows 7 x86 SP: 0\tapplicationName=svc.exe\tindicatorName=MODIFY_OWN_PROCESS\tsha256Hash=a37dd4f85117539ce4401c02c2bea403d7a724bedaccb5969980c8cf39b2a01a', 'LEEF:2.0|CarbonBlack|CbDefense|0.1|MALWARE_APP|x09|identHostName=COMPANY\\fakeav_driveby\tdeviceName=COMPANY\\fakeav_driveby\tsev=3\tdeviceHostName=\texternalIpAddress=\tdeviceId=2004122\truleName=syslog alert\tidentSrc=\tcat=THREAT\teventId=f73313db035211e6aab2b97cae4f83f3\tsrc=\tresource=COMPANY\\fakeav_driveby\ttargetPriorityCode=0\turl=https://testserver.company.net/ui#investigate/events/device/2004122/incident/6OJFC\tinternalIpAddress=\tdst=\tsummary=A known virus (FakeRean) was detected running.\tgroupName=default\tdeviceType=WINDOWS\tdevTime=Apr-15-2016 20:32:01 GMT\ttargetPriorityType=MEDIUM\tsignature=Active_Threat\tdevTimeFormat=MMM dd yyyy HH:mm:ss z\tincidentId=6OJFC\ttype=THREAT\temail=COMPANY\\fakeav_driveby@company.net.demo\tdeviceVersion=Windows 7 x86 SP: 0\tapplicationName=svc.exe\tindicatorName=MALWARE_APP\tsha256Hash=a37dd4f85117539ce4401c02c2bea403d7a724bedaccb5969980c8cf39b2a01a', 'LEEF:2.0|CarbonBlack|CbDefense|0.1|PACKED_CALL|x09|identHostName=COMPANY\\fakeav_driveby\tdeviceName=COMPANY\\fakeav_driveby\tsev=3\tdeviceHostName=\texternalIpAddress=\tdeviceId=2004122\truleName=syslog alert\tidentSrc=\tcat=THREAT\teventId=f73313db035211e6aab2b97cae4f83f3\tsrc=\tresource=COMPANY\\fakeav_driveby\ttargetPriorityCode=0\turl=https://testserver.company.net/ui#investigate/events/device/2004122/incident/6OJFC\tinternalIpAddress=\tdst=\tsummary=A known virus (FakeRean) was detected running.\tgroupName=default\tdeviceType=WINDOWS\tdevTime=Apr-15-2016 20:32:01 GMT\ttargetPriorityType=MEDIUM\tsignature=Active_Threat\tdevTimeFormat=MMM dd yyyy HH:mm:ss z\tincidentId=6OJFC\ttype=THREAT\temail=COMPANY\\fakeav_driveby@company.net.demo\tdeviceVersion=Windows 7 x86 SP: 0\tapplicationName=svc.exe\tindicatorName=PACKED_CALL\tsha256Hash=a37dd4f85117539ce4401c02c2bea403d7a724bedaccb5969980c8cf39b2a01a', 'LEEF:2.0|CarbonBlack|CbDefense|0.1|HAS_PACKED_CODE|x09|identHostName=COMPANY\\fakeav_driveby\tdeviceName=COMPANY\\fakeav_driveby\tsev=3\tdeviceHostName=\texternalIpAddress=\tdeviceId=2004122\truleName=syslog alert\tidentSrc=\tcat=THREAT\teventId=f73313db035211e6aab2b97cae4f83f3\tsrc=\tresource=COMPANY\\fakeav_driveby\ttargetPriorityCode=0\turl=https://testserver.company.net/ui#investigate/events/device/2004122/incident/6OJFC\tinternalIpAddress=\tdst=\tsummary=A known virus (FakeRean) was detected running.\tgroupName=default\tdeviceType=WINDOWS\tdevTime=Apr-15-2016 20:32:01 GMT\ttargetPriorityType=MEDIUM\tsignature=Active_Threat\tdevTimeFormat=MMM dd yyyy HH:mm:ss z\tincidentId=6OJFC\ttype=THREAT\temail=COMPANY\\fakeav_driveby@company.net.demo\tdeviceVersion=Windows 7 x86 SP: 0\tapplicationName=svc.exe\tindicatorName=HAS_PACKED_CODE\tsha256Hash=a37dd4f85117539ce4401c02c2bea403d7a724bedaccb5969980c8cf39b2a01a', 'LEEF:2.0|CarbonBlack|CbDefense|0.1|THREAT|x09|identHostName=COMPANY\\fakeav_driveby\tdeviceName=COMPANY\\fakeav_driveby\tsev=4\tdeviceHostName=\texternalIpAddress=\tdeviceId=2004122\truleName=syslog alert\tidentSrc=\tcat=THREAT\teventId=fadb33aa035211e6be8701df2c083974\tsrc=\tresource=COMPANY\\fakeav_driveby\ttargetPriorityCode=0\turl=https://testserver.company.net/ui#investigate/events/device/2004122/incident/DRE26\tinternalIpAddress=\tdst=\tsummary=An application has created an executable which is a known virus or on the Company Black List.\tgroupName=default\tdeviceType=WINDOWS\tdevTime=Apr-15-2016 20:32:01 GMT\ttargetPriorityType=MEDIUM\tsignature=Active_Threat\tdevTimeFormat=MMM dd yyyy HH:mm:ss z\tincidentId=DRE26\ttype=THREAT\temail=COMPANY\\fakeav_driveby@company.net.demo\tdeviceVersion=Windows 7 x86 SP: 0', 'LEEF:2.0|CarbonBlack|CbDefense|0.1|HAS_SCRIPT_DLL|x09|identHostName=COMPANY\\fakeav_driveby\tdeviceName=COMPANY\\fakeav_driveby\tsev=4\tdeviceHostName=\texternalIpAddress=\tdeviceId=2004122\truleName=syslog alert\tidentSrc=\tcat=THREAT\teventId=fadb33aa035211e6be8701df2c083974\tsrc=\tresource=COMPANY\\fakeav_driveby\ttargetPriorityCode=0\turl=https://testserver.company.net/ui#investigate/events/device/2004122/incident/DRE26\tinternalIpAddress=\tdst=\tsummary=An application has created an executable which is a known virus or on the Company Black List.\tgroupName=default\tdeviceType=WINDOWS\tdevTime=Apr-15-2016 20:32:01 GMT\ttargetPriorityType=MEDIUM\tsignature=Active_Threat\tdevTimeFormat=MMM dd yyyy HH:mm:ss z\tincidentId=DRE26\ttype=THREAT\temail=COMPANY\\fakeav_driveby@company.net.demo\tdeviceVersion=Windows 7 x86 SP: 0\tapplicationName=iexplore.exe\tindicatorName=HAS_SCRIPT_DLL\tsha256Hash=422d380855c449e81a30fcf840b44cb8b6291549b05768b23954616b4772fc45', 'LEEF:2.0|CarbonBlack|CbDefense|0.1|MODIFY_OWN_PROCESS|x09|identHostName=COMPANY\\fakeav_driveby\tdeviceName=COMPANY\\fakeav_driveby\tsev=4\tdeviceHostName=\texternalIpAddress=\tdeviceId=2004122\truleName=syslog alert\tidentSrc=\tcat=THREAT\teventId=fadb33aa035211e6be8701df2c083974\tsrc=\tresource=COMPANY\\fakeav_driveby\ttargetPriorityCode=0\turl=https://testserver.company.net/ui#investigate/events/device/2004122/incident/DRE26\tinternalIpAddress=\tdst=\tsummary=An application has created an executable which is a known virus or on the Company Black List.\tgroupName=default\tdeviceType=WINDOWS\tdevTime=Apr-15-2016 20:32:01 GMT\ttargetPriorityType=MEDIUM\tsignature=Active_Threat\tdevTimeFormat=MMM dd yyyy HH:mm:ss z\tincidentId=DRE26\ttype=THREAT\temail=COMPANY\\fakeav_driveby@company.net.demo\tdeviceVersion=Windows 7 x86 SP: 0\tapplicationName=svc.exe\tindicatorName=MODIFY_OWN_PROCESS\tsha256Hash=a37dd4f85117539ce4401c02c2bea403d7a724bedaccb5969980c8cf39b2a01a', 'LEEF:2.0|CarbonBlack|CbDefense|0.1|HAS_PACKED_CODE|x09|identHostName=COMPANY\\fakeav_driveby\tdeviceName=COMPANY\\fakeav_driveby\tsev=4\tdeviceHostName=\texternalIpAddress=\tdeviceId=2004122\truleName=syslog alert\tidentSrc=\tcat=THREAT\teventId=fadb33aa035211e6be8701df2c083974\tsrc=\tresource=COMPANY\\fakeav_driveby\ttargetPriorityCode=0\turl=https://testserver.company.net/ui#investigate/events/device/2004122/incident/DRE26\tinternalIpAddress=\tdst=\tsummary=An application has created an executable which is a known virus or on the Company Black List.\tgroupName=default\tdeviceType=WINDOWS\tdevTime=Apr-15-2016 20:32:01 GMT\ttargetPriorityType=MEDIUM\tsignature=Active_Threat\tdevTimeFormat=MMM dd yyyy HH:mm:ss z\tincidentId=DRE26\ttype=THREAT\temail=COMPANY\\fakeav_driveby@company.net.demo\tdeviceVersion=Windows 7 x86 SP: 0\tapplicationName=iexplore.exe\tindicatorName=HAS_PACKED_CODE\tsha256Hash=422d380855c449e81a30fcf840b44cb8b6291549b05768b23954616b4772fc45', 'LEEF:2.0|CarbonBlack|CbDefense|0.1|CODE_DROP|x09|identHostName=COMPANY\\fakeav_driveby\tdeviceName=COMPANY\\fakeav_driveby\tsev=4\tdeviceHostName=\texternalIpAddress=\tdeviceId=2004122\truleName=syslog alert\tidentSrc=\tcat=THREAT\teventId=fadb33aa035211e6be8701df2c083974\tsrc=\tresource=COMPANY\\fakeav_driveby\ttargetPriorityCode=0\turl=https://testserver.company.net/ui#investigate/events/device/2004122/incident/DRE26\tinternalIpAddress=\tdst=\tsummary=An application has created an executable which is a known virus or on the Company Black List.\tgroupName=default\tdeviceType=WINDOWS\tdevTime=Apr-15-2016 20:32:01 GMT\ttargetPriorityType=MEDIUM\tsignature=Active_Threat\tdevTimeFormat=MMM dd yyyy HH:mm:ss z\tincidentId=DRE26\ttype=THREAT\temail=COMPANY\\fakeav_driveby@company.net.demo\tdeviceVersion=Windows 7 x86 SP: 0\tapplicationName=iexplore.exe\tindicatorName=CODE_DROP\tsha256Hash=422d380855c449e81a30fcf840b44cb8b6291549b05768b23954616b4772fc45', 'LEEF:2.0|CarbonBlack|CbDefense|0.1|RUN_MALWARE_APP|x09|identHostName=COMPANY\\fakeav_driveby\tdeviceName=COMPANY\\fakeav_driveby\tsev=4\tdeviceHostName=\texternalIpAddress=\tdeviceId=2004122\truleName=syslog alert\tidentSrc=\tcat=THREAT\teventId=fadb33aa035211e6be8701df2c083974\tsrc=\tresource=COMPANY\\fakeav_driveby\ttargetPriorityCode=0\turl=https://testserver.company.net/ui#investigate/events/device/2004122/incident/DRE26\tinternalIpAddress=\tdst=\tsummary=An application has created an executable which is a known virus or on the Company Black List.\tgroupName=default\tdeviceType=WINDOWS\tdevTime=Apr-15-2016 20:32:01 GMT\ttargetPriorityType=MEDIUM\tsignature=Active_Threat\tdevTimeFormat=MMM dd yyyy HH:mm:ss z\tincidentId=DRE26\ttype=THREAT\temail=COMPANY\\fakeav_driveby@company.net.demo\tdeviceVersion=Windows 7 x86 SP: 0\tapplicationName=iexplore.exe\tindicatorName=RUN_MALWARE_APP\tsha256Hash=422d380855c449e81a30fcf840b44cb8b6291549b05768b23954616b4772fc45', 'LEEF:2.0|CarbonBlack|CbDefense|0.1|RUN_ANOTHER_APP|x09|identHostName=COMPANY\\fakeav_driveby\tdeviceName=COMPANY\\fakeav_driveby\tsev=4\tdeviceHostName=\texternalIpAddress=\tdeviceId=2004122\truleName=syslog alert\tidentSrc=\tcat=THREAT\teventId=fadb33aa035211e6be8701df2c083974\tsrc=\tresource=COMPANY\\fakeav_driveby\ttargetPriorityCode=0\turl=https://testserver.company.net/ui#investigate/events/device/2004122/incident/DRE26\tinternalIpAddress=\tdst=\tsummary=An application has created an executable which is a known virus or on the Company Black List.\tgroupName=default\tdeviceType=WINDOWS\tdevTime=Apr-15-2016 20:32:01 GMT\ttargetPriorityType=MEDIUM\tsignature=Active_Threat\tdevTimeFormat=MMM dd yyyy HH:mm:ss z\tincidentId=DRE26\ttype=THREAT\temail=COMPANY\\fakeav_driveby@company.net.demo\tdeviceVersion=Windows 7 x86 SP: 0\tapplicationName=iexplore.exe\tindicatorName=RUN_ANOTHER_APP\tsha256Hash=422d380855c449e81a30fcf840b44cb8b6291549b05768b23954616b4772fc45', 'LEEF:2.0|CarbonBlack|CbDefense|0.1|PACKED_CALL|x09|identHostName=COMPANY\\fakeav_driveby\tdeviceName=COMPANY\\fakeav_driveby\tsev=4\tdeviceHostName=\texternalIpAddress=\tdeviceId=2004122\truleName=syslog alert\tidentSrc=\tcat=THREAT\teventId=fadb33aa035211e6be8701df2c083974\tsrc=\tresource=COMPANY\\fakeav_driveby\ttargetPriorityCode=0\turl=https://testserver.company.net/ui#investigate/events/device/2004122/incident/DRE26\tinternalIpAddress=\tdst=\tsummary=An application has created an executable which is a known virus or on the Company Black List.\tgroupName=default\tdeviceType=WINDOWS\tdevTime=Apr-15-2016 20:32:01 GMT\ttargetPriorityType=MEDIUM\tsignature=Active_Threat\tdevTimeFormat=MMM dd yyyy HH:mm:ss z\tincidentId=DRE26\ttype=THREAT\temail=COMPANY\\fakeav_driveby@company.net.demo\tdeviceVersion=Windows 7 x86 SP: 0\tapplicationName=svc.exe\tindicatorName=PACKED_CALL\tsha256Hash=a37dd4f85117539ce4401c02c2bea403d7a724bedaccb5969980c8cf39b2a01a', 'LEEF:2.0|CarbonBlack|CbDefense|0.1|MALWARE_APP|x09|identHostName=COMPANY\\fakeav_driveby\tdeviceName=COMPANY\\fakeav_driveby\tsev=4\tdeviceHostName=\texternalIpAddress=\tdeviceId=2004122\truleName=syslog alert\tidentSrc=\tcat=THREAT\teventId=fadb33aa035211e6be8701df2c083974\tsrc=\tresource=COMPANY\\fakeav_driveby\ttargetPriorityCode=0\turl=https://testserver.company.net/ui#investigate/events/device/2004122/incident/DRE26\tinternalIpAddress=\tdst=\tsummary=An application has created an executable which is a known virus or on the Company Black List.\tgroupName=default\tdeviceType=WINDOWS\tdevTime=Apr-15-2016 20:32:01 GMT\ttargetPriorityType=MEDIUM\tsignature=Active_Threat\tdevTimeFormat=MMM dd yyyy HH:mm:ss z\tincidentId=DRE26\ttype=THREAT\temail=COMPANY\\fakeav_driveby@company.net.demo\tdeviceVersion=Windows 7 x86 SP: 0\tapplicationName=svc.exe\tindicatorName=MALWARE_APP\tsha256Hash=a37dd4f85117539ce4401c02c2bea403d7a724bedaccb5969980c8cf39b2a01a', 'LEEF:2.0|CarbonBlack|CbDefense|0.1|MODIFY_MEMORY_PROTECTION|x09|identHostName=COMPANY\\fakeav_driveby\tdeviceName=COMPANY\\fakeav_driveby\tsev=4\tdeviceHostName=\texternalIpAddress=\tdeviceId=2004122\truleName=syslog alert\tidentSrc=\tcat=THREAT\teventId=fadb33aa035211e6be8701df2c083974\tsrc=\tresource=COMPANY\\fakeav_driveby\ttargetPriorityCode=0\turl=https://testserver.company.net/ui#investigate/events/device/2004122/incident/DRE26\tinternalIpAddress=\tdst=\tsummary=An application has created an executable which is a known virus or on the Company Black List.\tgroupName=default\tdeviceType=WINDOWS\tdevTime=Apr-15-2016 20:32:01 GMT\ttargetPriorityType=MEDIUM\tsignature=Active_Threat\tdevTimeFormat=MMM dd yyyy HH:mm:ss z\tincidentId=DRE26\ttype=THREAT\temail=COMPANY\\fakeav_driveby@company.net.demo\tdeviceVersion=Windows 7 x86 SP: 0\tapplicationName=svc.exe\tindicatorName=MODIFY_MEMORY_PROTECTION\tsha256Hash=a37dd4f85117539ce4401c02c2bea403d7a724bedaccb5969980c8cf39b2a01a', 'LEEF:2.0|CarbonBlack|CbDefense|0.1|NEW_SCRIPT_DLL|x09|identHostName=COMPANY\\fakeav_driveby\tdeviceName=COMPANY\\fakeav_driveby\tsev=4\tdeviceHostName=\texternalIpAddress=\tdeviceId=2004122\truleName=syslog alert\tidentSrc=\tcat=THREAT\teventId=fadb33aa035211e6be8701df2c083974\tsrc=\tresource=COMPANY\\fakeav_driveby\ttargetPriorityCode=0\turl=https://testserver.company.net/ui#investigate/events/device/2004122/incident/DRE26\tinternalIpAddress=\tdst=\tsummary=An application has created an executable which is a known virus or on the Company Black List.\tgroupName=default\tdeviceType=WINDOWS\tdevTime=Apr-15-2016 20:32:01 GMT\ttargetPriorityType=MEDIUM\tsignature=Active_Threat\tdevTimeFormat=MMM dd yyyy HH:mm:ss z\tincidentId=DRE26\ttype=THREAT\temail=COMPANY\\fakeav_driveby@company.net.demo\tdeviceVersion=Windows 7 x86 SP: 0\tapplicationName=iexplore.exe\tindicatorName=NEW_SCRIPT_DLL\tsha256Hash=422d380855c449e81a30fcf840b44cb8b6291549b05768b23954616b4772fc45', 'LEEF:2.0|CarbonBlack|CbDefense|0.1|TARGET_MALWARE_APP|x09|identHostName=COMPANY\\fakeav_driveby\tdeviceName=COMPANY\\fakeav_driveby\tsev=4\tdeviceHostName=\texternalIpAddress=\tdeviceId=2004122\truleName=syslog alert\tidentSrc=\tcat=THREAT\teventId=fadb33aa035211e6be8701df2c083974\tsrc=\tresource=COMPANY\\fakeav_driveby\ttargetPriorityCode=0\turl=https://testserver.company.net/ui#investigate/events/device/2004122/incident/DRE26\tinternalIpAddress=\tdst=\tsummary=An application has created an executable which is a known virus or on the Company Black List.\tgroupName=default\tdeviceType=WINDOWS\tdevTime=Apr-15-2016 20:32:01 GMT\ttargetPriorityType=MEDIUM\tsignature=Active_Threat\tdevTimeFormat=MMM dd yyyy HH:mm:ss z\tincidentId=DRE26\ttype=THREAT\temail=COMPANY\\fakeav_driveby@company.net.demo\tdeviceVersion=Windows 7 x86 SP: 0\tapplicationName=iexplore.exe\tindicatorName=TARGET_MALWARE_APP\tsha256Hash=422d380855c449e81a30fcf840b44cb8b6291549b05768b23954616b4772fc45', 'LEEF:2.0|CarbonBlack|CbDefense|0.1|KNOWN_ROGUE|x09|identHostName=COMPANY\\fakeav_driveby\tdeviceName=COMPANY\\fakeav_driveby\tsev=4\tdeviceHostName=\texternalIpAddress=\tdeviceId=2004122\truleName=syslog alert\tidentSrc=\tcat=THREAT\teventId=fadb33aa035211e6be8701df2c083974\tsrc=\tresource=COMPANY\\fakeav_driveby\ttargetPriorityCode=0\turl=https://testserver.company.net/ui#investigate/events/device/2004122/incident/DRE26\tinternalIpAddress=\tdst=\tsummary=An application has created an executable which is a known virus or on the Company Black List.\tgroupName=default\tdeviceType=WINDOWS\tdevTime=Apr-15-2016 20:32:01 GMT\ttargetPriorityType=MEDIUM\tsignature=Active_Threat\tdevTimeFormat=MMM dd yyyy HH:mm:ss z\tincidentId=DRE26\ttype=THREAT\temail=COMPANY\\fakeav_driveby@company.net.demo\tdeviceVersion=Windows 7 x86 SP: 0\tapplicationName=svc.exe\tindicatorName=KNOWN_ROGUE\tsha256Hash=a37dd4f85117539ce4401c02c2bea403d7a724bedaccb5969980c8cf39b2a01a', 'LEEF:2.0|CarbonBlack|CbDefense|0.1|HAS_PACKED_CODE|x09|identHostName=COMPANY\\fakeav_driveby\tdeviceName=COMPANY\\fakeav_driveby\tsev=4\tdeviceHostName=\texternalIpAddress=\tdeviceId=2004122\truleName=syslog alert\tidentSrc=\tcat=THREAT\teventId=fadb33aa035211e6be8701df2c083974\tsrc=\tresource=COMPANY\\fakeav_driveby\ttargetPriorityCode=0\turl=https://testserver.company.net/ui#investigate/events/device/2004122/incident/DRE26\tinternalIpAddress=\tdst=\tsummary=An application has created an executable which is a known virus or on the Company Black List.\tgroupName=default\tdeviceType=WINDOWS\tdevTime=Apr-15-2016 20:32:01 GMT\ttargetPriorityType=MEDIUM\tsignature=Active_Threat\tdevTimeFormat=MMM dd yyyy HH:mm:ss z\tincidentId=DRE26\ttype=THREAT\temail=COMPANY\\fakeav_driveby@company.net.demo\tdeviceVersion=Windows 7 x86 SP: 0\tapplicationName=svc.exe\tindicatorName=HAS_PACKED_CODE\tsha256Hash=a37dd4f85117539ce4401c02c2bea403d7a724bedaccb5969980c8cf39b2a01a', 'LEEF:2.0|CarbonBlack|CbDefense|0.1|MALWARE_DROP|x09|identHostName=COMPANY\\fakeav_driveby\tdeviceName=COMPANY\\fakeav_driveby\tsev=4\tdeviceHostName=\texternalIpAddress=\tdeviceId=2004122\truleName=syslog alert\tidentSrc=\tcat=THREAT\teventId=fadb33aa035211e6be8701df2c083974\tsrc=\tresource=COMPANY\\fakeav_driveby\ttargetPriorityCode=0\turl=https://testserver.company.net/ui#investigate/events/device/2004122/incident/DRE26\tinternalIpAddress=\tdst=\tsummary=An application has created an executable which is a known virus or on the Company Black List.\tgroupName=default\tdeviceType=WINDOWS\tdevTime=Apr-15-2016 20:32:01 GMT\ttargetPriorityType=MEDIUM\tsignature=Active_Threat\tdevTimeFormat=MMM dd yyyy HH:mm:ss z\tincidentId=DRE26\ttype=THREAT\temail=COMPANY\\fakeav_driveby@company.net.demo\tdeviceVersion=Windows 7 x86 SP: 0\tapplicationName=iexplore.exe\tindicatorName=MALWARE_DROP\tsha256Hash=422d380855c449e81a30fcf840b44cb8b6291549b05768b23954616b4772fc45', 'LEEF:2.0|CarbonBlack|CbDefense|0.1|THREAT|x09|identHostName=COMPANY\\Demo_CaretoMac\tdeviceName=COMPANY\\Demo_CaretoMac\tsev=8\tdeviceHostName=\texternalIpAddress=\tdeviceId=2004117\truleName=syslog alert\tidentSrc=\tcat=THREAT\teventId=fadd7d9b035211e6be8701df2c083974\tsrc=\tresource=COMPANY\\Demo_CaretoMac\ttargetPriorityCode=0\turl=https://testserver.company.net/ui#investigate/events/device/2004117/incident/8OI0O\tinternalIpAddress=\tdst=\tsummary=A known virus (Appetite: Keylogger, Password or Data stealer, Backdoor, Rootkit, Ransomware or Worm) attempted a network connection.\tgroupName=default\tdeviceType=MAC\tdevTime=Apr-15-2016 20:33:09 GMT\ttargetPriorityType=MEDIUM\tsignature=Active_Threat\tdevTimeFormat=MMM dd yyyy HH:mm:ss z\tincidentId=8OI0O\ttype=THREAT\temail=COMPANY\\caretoOsx@company.net.demo\tdeviceVersion=MAC OS X 10.9.0', 'LEEF:2.0|CarbonBlack|CbDefense|0.1|ATTEMPTED_CLIENT|x09|identHostName=COMPANY\\Demo_CaretoMac\tdeviceName=COMPANY\\Demo_CaretoMac\tsev=8\tdeviceHostName=\texternalIpAddress=\tdeviceId=2004117\truleName=syslog alert\tidentSrc=\tcat=THREAT\teventId=fadd7d9b035211e6be8701df2c083974\tsrc=\tresource=COMPANY\\Demo_CaretoMac\ttargetPriorityCode=0\turl=https://testserver.company.net/ui#investigate/events/device/2004117/incident/8OI0O\tinternalIpAddress=\tdst=\tsummary=A known virus (Appetite: Keylogger, Password or Data stealer, Backdoor, Rootkit, Ransomware or Worm) attempted a network connection.\tgroupName=default\tdeviceType=MAC\tdevTime=Apr-15-2016 20:33:09 GMT\ttargetPriorityType=MEDIUM\tsignature=Active_Threat\tdevTimeFormat=MMM dd yyyy HH:mm:ss z\tincidentId=8OI0O\ttype=THREAT\temail=COMPANY\\caretoOsx@company.net.demo\tdeviceVersion=MAC OS X 10.9.0\tapplicationName=caretoosxdropper\tindicatorName=ATTEMPTED_CLIENT\tsha256Hash=0710be16ba8a36712c3cac21776c8846e29897300271f09ba0a41983e370e1a0', 'LEEF:2.0|CarbonBlack|CbDefense|0.1|BEACON|x09|identHostName=COMPANY\\Demo_CaretoMac\tdeviceName=COMPANY\\Demo_CaretoMac\tsev=8\tdeviceHostName=\texternalIpAddress=\tdeviceId=2004117\truleName=syslog alert\tidentSrc=\tcat=THREAT\teventId=fadd7d9b035211e6be8701df2c083974\tsrc=\tresource=COMPANY\\Demo_CaretoMac\ttargetPriorityCode=0\turl=https://testserver.company.net/ui#investigate/events/device/2004117/incident/8OI0O\tinternalIpAddress=\tdst=\tsummary=A known virus (Appetite: Keylogger, Password or Data stealer, Backdoor, Rootkit, Ransomware or Worm) attempted a network connection.\tgroupName=default\tdeviceType=MAC\tdevTime=Apr-15-2016 20:33:09 GMT\ttargetPriorityType=MEDIUM\tsignature=Active_Threat\tdevTimeFormat=MMM dd yyyy HH:mm:ss z\tincidentId=8OI0O\ttype=THREAT\temail=COMPANY\\caretoOsx@company.net.demo\tdeviceVersion=MAC OS X 10.9.0\tapplicationName=caretoosxdropper\tindicatorName=BEACON\tsha256Hash=0710be16ba8a36712c3cac21776c8846e29897300271f09ba0a41983e370e1a0', 'LEEF:2.0|CarbonBlack|CbDefense|0.1|MALWARE_DROP|x09|identHostName=COMPANY\\Demo_CaretoMac\tdeviceName=COMPANY\\Demo_CaretoMac\tsev=8\tdeviceHostName=\texternalIpAddress=\tdeviceId=2004117\truleName=syslog alert\tidentSrc=\tcat=THREAT\teventId=fadd7d9b035211e6be8701df2c083974\tsrc=\tresource=COMPANY\\Demo_CaretoMac\ttargetPriorityCode=0\turl=https://testserver.company.net/ui#investigate/events/device/2004117/incident/8OI0O\tinternalIpAddress=\tdst=\tsummary=A known virus (Appetite: Keylogger, Password or Data stealer, Backdoor, Rootkit, Ransomware or Worm) attempted a network connection.\tgroupName=default\tdeviceType=MAC\tdevTime=Apr-15-2016 20:33:09 GMT\ttargetPriorityType=MEDIUM\tsignature=Active_Threat\tdevTimeFormat=MMM dd yyyy HH:mm:ss z\tincidentId=8OI0O\ttype=THREAT\temail=COMPANY\\caretoOsx@company.net.demo\tdeviceVersion=MAC OS X 10.9.0\tapplicationName=xpcproxy\tindicatorName=MALWARE_DROP\tsha256Hash=ab0d18bd9d4a32e3b5cdc7e2231760833c0e6c2a315b479109df5bceae28b221', 'LEEF:2.0|CarbonBlack|CbDefense|0.1|KNOWN_MALWARE_ON_NETWORK|x09|identHostName=COMPANY\\Demo_CaretoMac\tdeviceName=COMPANY\\Demo_CaretoMac\tsev=8\tdeviceHostName=\texternalIpAddress=\tdeviceId=2004117\truleName=syslog alert\tidentSrc=\tcat=THREAT\teventId=fadd7d9b035211e6be8701df2c083974\tsrc=\tresource=COMPANY\\Demo_CaretoMac\ttargetPriorityCode=0\turl=https://testserver.company.net/ui#investigate/events/device/2004117/incident/8OI0O\tinternalIpAddress=\tdst=\tsummary=A known virus (Appetite: Keylogger, Password or Data stealer, Backdoor, Rootkit, Ransomware or Worm) attempted a network connection.\tgroupName=default\tdeviceType=MAC\tdevTime=Apr-15-2016 20:33:09 GMT\ttargetPriorityType=MEDIUM\tsignature=Active_Threat\tdevTimeFormat=MMM dd yyyy HH:mm:ss z\tincidentId=8OI0O\ttype=THREAT\temail=COMPANY\\caretoOsx@company.net.demo\tdeviceVersion=MAC OS X 10.9.0\tapplicationName=caretoosxdropper\tindicatorName=KNOWN_MALWARE_ON_NETWORK\tsha256Hash=0710be16ba8a36712c3cac21776c8846e29897300271f09ba0a41983e370e1a0', 'LEEF:2.0|CarbonBlack|CbDefense|0.1|MALWARE_APP|x09|identHostName=COMPANY\\Demo_CaretoMac\tdeviceName=COMPANY\\Demo_CaretoMac\tsev=8\tdeviceHostName=\texternalIpAddress=\tdeviceId=2004117\truleName=syslog alert\tidentSrc=\tcat=THREAT\teventId=fadd7d9b035211e6be8701df2c083974\tsrc=\tresource=COMPANY\\Demo_CaretoMac\ttargetPriorityCode=0\turl=https://testserver.company.net/ui#investigate/events/device/2004117/incident/8OI0O\tinternalIpAddress=\tdst=\tsummary=A known virus (Appetite: Keylogger, Password or Data stealer, Backdoor, Rootkit, Ransomware or Worm) attempted a network connection.\tgroupName=default\tdeviceType=MAC\tdevTime=Apr-15-2016 20:33:09 GMT\ttargetPriorityType=MEDIUM\tsignature=Active_Threat\tdevTimeFormat=MMM dd yyyy HH:mm:ss z\tincidentId=8OI0O\ttype=THREAT\temail=COMPANY\\caretoOsx@company.net.demo\tdeviceVersion=MAC OS X 10.9.0\tapplicationName=caretoosxdropper\tindicatorName=MALWARE_APP\tsha256Hash=0710be16ba8a36712c3cac21776c8846e29897300271f09ba0a41983e370e1a0', 'LEEF:2.0|CarbonBlack|CbDefense|0.1|TARGET_MALWARE_APP|x09|identHostName=COMPANY\\Demo_CaretoMac\tdeviceName=COMPANY\\Demo_CaretoMac\tsev=8\tdeviceHostName=\texternalIpAddress=\tdeviceId=2004117\truleName=syslog alert\tidentSrc=\tcat=THREAT\teventId=fadd7d9b035211e6be8701df2c083974\tsrc=\tresource=COMPANY\\Demo_CaretoMac\ttargetPriorityCode=0\turl=https://testserver.company.net/ui#investigate/events/device/2004117/incident/8OI0O\tinternalIpAddress=\tdst=\tsummary=A known virus (Appetite: Keylogger, Password or Data stealer, Backdoor, Rootkit, Ransomware or Worm) attempted a network connection.\tgroupName=default\tdeviceType=MAC\tdevTime=Apr-15-2016 20:33:09 GMT\ttargetPriorityType=MEDIUM\tsignature=Active_Threat\tdevTimeFormat=MMM dd yyyy HH:mm:ss z\tincidentId=8OI0O\ttype=THREAT\temail=COMPANY\\caretoOsx@company.net.demo\tdeviceVersion=MAC OS X 10.9.0\tapplicationName=xpcproxy\tindicatorName=TARGET_MALWARE_APP\tsha256Hash=ab0d18bd9d4a32e3b5cdc7e2231760833c0e6c2a315b479109df5bceae28b221', 'LEEF:2.0|CarbonBlack|CbDefense|0.1|CODE_DROP|x09|identHostName=COMPANY\\Demo_CaretoMac\tdeviceName=COMPANY\\Demo_CaretoMac\tsev=8\tdeviceHostName=\texternalIpAddress=\tdeviceId=2004117\truleName=syslog alert\tidentSrc=\tcat=THREAT\teventId=fadd7d9b035211e6be8701df2c083974\tsrc=\tresource=COMPANY\\Demo_CaretoMac\ttargetPriorityCode=0\turl=https://testserver.company.net/ui#investigate/events/device/2004117/incident/8OI0O\tinternalIpAddress=\tdst=\tsummary=A known virus (Appetite: Keylogger, Password or Data stealer, Backdoor, Rootkit, Ransomware or Worm) attempted a network connection.\tgroupName=default\tdeviceType=MAC\tdevTime=Apr-15-2016 20:33:09 GMT\ttargetPriorityType=MEDIUM\tsignature=Active_Threat\tdevTimeFormat=MMM dd yyyy HH:mm:ss z\tincidentId=8OI0O\ttype=THREAT\temail=COMPANY\\caretoOsx@company.net.demo\tdeviceVersion=MAC OS X 10.9.0\tapplicationName=xpcproxy\tindicatorName=CODE_DROP\tsha256Hash=ab0d18bd9d4a32e3b5cdc7e2231760833c0e6c2a315b479109df5bceae28b221', 'LEEF:2.0|CarbonBlack|CbDefense|0.1|KNOWN_BACKDOOR|x09|identHostName=COMPANY\\Demo_CaretoMac\tdeviceName=COMPANY\\Demo_CaretoMac\tsev=8\tdeviceHostName=\texternalIpAddress=\tdeviceId=2004117\truleName=syslog alert\tidentSrc=\tcat=THREAT\teventId=fadd7d9b035211e6be8701df2c083974\tsrc=\tresource=COMPANY\\Demo_CaretoMac\ttargetPriorityCode=0\turl=https://testserver.company.net/ui#investigate/events/device/2004117/incident/8OI0O\tinternalIpAddress=\tdst=\tsummary=A known virus (Appetite: Keylogger, Password or Data stealer, Backdoor, Rootkit, Ransomware or Worm) attempted a network connection.\tgroupName=default\tdeviceType=MAC\tdevTime=Apr-15-2016 20:33:09 GMT\ttargetPriorityType=MEDIUM\tsignature=Active_Threat\tdevTimeFormat=MMM dd yyyy HH:mm:ss z\tincidentId=8OI0O\ttype=THREAT\temail=COMPANY\\caretoOsx@company.net.demo\tdeviceVersion=MAC OS X 10.9.0\tapplicationName=caretoosxdropper\tindicatorName=KNOWN_BACKDOOR\tsha256Hash=0710be16ba8a36712c3cac21776c8846e29897300271f09ba0a41983e370e1a0', 'LEEF:2.0|CarbonBlack|CbDefense|0.1|RUN_MALWARE_APP|x09|identHostName=COMPANY\\Demo_CaretoMac\tdeviceName=COMPANY\\Demo_CaretoMac\tsev=8\tdeviceHostName=\texternalIpAddress=\tdeviceId=2004117\truleName=syslog alert\tidentSrc=\tcat=THREAT\teventId=fadd7d9b035211e6be8701df2c083974\tsrc=\tresource=COMPANY\\Demo_CaretoMac\ttargetPriorityCode=0\turl=https://testserver.company.net/ui#investigate/events/device/2004117/incident/8OI0O\tinternalIpAddress=\tdst=\tsummary=A known virus (Appetite: Keylogger, Password or Data stealer, Backdoor, Rootkit, Ransomware or Worm) attempted a network connection.\tgroupName=default\tdeviceType=MAC\tdevTime=Apr-15-2016 20:33:09 GMT\ttargetPriorityType=MEDIUM\tsignature=Active_Threat\tdevTimeFormat=MMM dd yyyy HH:mm:ss z\tincidentId=8OI0O\ttype=THREAT\temail=COMPANY\\caretoOsx@company.net.demo\tdeviceVersion=MAC OS X 10.9.0\tapplicationName=bash\tindicatorName=RUN_MALWARE_APP\tsha256Hash=737867f9e519c2eae2b064c33dc0608b283ebd6045fcf8b19736651ec34c0e37', 'LEEF:2.0|CarbonBlack|CbDefense|0.1|THREAT|x09|identHostName=COMPANY\\Demo_CaretoMac\tdeviceName=COMPANY\\Demo_CaretoMac\tsev=8\tdeviceHostName=\texternalIpAddress=\tdeviceId=2004117\truleName=syslog alert\tidentSrc=\tcat=THREAT\teventId=faf9dfdd035211e6aab2b97cae4f83f3\tsrc=\tresource=COMPANY\\Demo_CaretoMac\ttargetPriorityCode=0\turl=https://testserver.company.net/ui#investigate/events/device/2004117/incident/3WTHN\tinternalIpAddress=\tdst=\tsummary=A known virus (Appetite: Keylogger, Password or Data stealer, Backdoor, Rootkit, Ransomware or Worm) attempted a network connection.\tgroupName=default\tdeviceType=MAC\tdevTime=Apr-15-2016 20:33:09 GMT\ttargetPriorityType=MEDIUM\tsignature=Active_Threat\tdevTimeFormat=MMM dd yyyy HH:mm:ss z\tincidentId=3WTHN\ttype=THREAT\temail=COMPANY\\caretoOsx@company.net.demo\tdeviceVersion=MAC OS X 10.9.0', 'LEEF:2.0|CarbonBlack|CbDefense|0.1|BEACON|x09|identHostName=COMPANY\\Demo_CaretoMac\tdeviceName=COMPANY\\Demo_CaretoMac\tsev=8\tdeviceHostName=\texternalIpAddress=\tdeviceId=2004117\truleName=syslog alert\tidentSrc=\tcat=THREAT\teventId=faf9dfdd035211e6aab2b97cae4f83f3\tsrc=\tresource=COMPANY\\Demo_CaretoMac\ttargetPriorityCode=0\turl=https://testserver.company.net/ui#investigate/events/device/2004117/incident/3WTHN\tinternalIpAddress=\tdst=\tsummary=A known virus (Appetite: Keylogger, Password or Data stealer, Backdoor, Rootkit, Ransomware or Worm) attempted a network connection.\tgroupName=default\tdeviceType=MAC\tdevTime=Apr-15-2016 20:33:09 GMT\ttargetPriorityType=MEDIUM\tsignature=Active_Threat\tdevTimeFormat=MMM dd yyyy HH:mm:ss z\tincidentId=3WTHN\ttype=THREAT\temail=COMPANY\\caretoOsx@company.net.demo\tdeviceVersion=MAC OS X 10.9.0\tapplicationName=caretoosxdropper\tindicatorName=BEACON\tsha256Hash=0710be16ba8a36712c3cac21776c8846e29897300271f09ba0a41983e370e1a0', 'LEEF:2.0|CarbonBlack|CbDefense|0.1|KNOWN_MALWARE_ON_NETWORK|x09|identHostName=COMPANY\\Demo_CaretoMac\tdeviceName=COMPANY\\Demo_CaretoMac\tsev=8\tdeviceHostName=\texternalIpAddress=\tdeviceId=2004117\truleName=syslog alert\tidentSrc=\tcat=THREAT\teventId=faf9dfdd035211e6aab2b97cae4f83f3\tsrc=\tresource=COMPANY\\Demo_CaretoMac\ttargetPriorityCode=0\turl=https://testserver.company.net/ui#investigate/events/device/2004117/incident/3WTHN\tinternalIpAddress=\tdst=\tsummary=A known virus (Appetite: Keylogger, Password or Data stealer, Backdoor, Rootkit, Ransomware or Worm) attempted a network connection.\tgroupName=default\tdeviceType=MAC\tdevTime=Apr-15-2016 20:33:09 GMT\ttargetPriorityType=MEDIUM\tsignature=Active_Threat\tdevTimeFormat=MMM dd yyyy HH:mm:ss z\tincidentId=3WTHN\ttype=THREAT\temail=COMPANY\\caretoOsx@company.net.demo\tdeviceVersion=MAC OS X 10.9.0\tapplicationName=caretoosxdropper\tindicatorName=KNOWN_MALWARE_ON_NETWORK\tsha256Hash=0710be16ba8a36712c3cac21776c8846e29897300271f09ba0a41983e370e1a0', 'LEEF:2.0|CarbonBlack|CbDefense|0.1|MALWARE_APP|x09|identHostName=COMPANY\\Demo_CaretoMac\tdeviceName=COMPANY\\Demo_CaretoMac\tsev=8\tdeviceHostName=\texternalIpAddress=\tdeviceId=2004117\truleName=syslog alert\tidentSrc=\tcat=THREAT\teventId=faf9dfdd035211e6aab2b97cae4f83f3\tsrc=\tresource=COMPANY\\Demo_CaretoMac\ttargetPriorityCode=0\turl=https://testserver.company.net/ui#investigate/events/device/2004117/incident/3WTHN\tinternalIpAddress=\tdst=\tsummary=A known virus (Appetite: Keylogger, Password or Data stealer, Backdoor, Rootkit, Ransomware or Worm) attempted a network connection.\tgroupName=default\tdeviceType=MAC\tdevTime=Apr-15-2016 20:33:09 GMT\ttargetPriorityType=MEDIUM\tsignature=Active_Threat\tdevTimeFormat=MMM dd yyyy HH:mm:ss z\tincidentId=3WTHN\ttype=THREAT\temail=COMPANY\\caretoOsx@company.net.demo\tdeviceVersion=MAC OS X 10.9.0\tapplicationName=caretoosxdropper\tindicatorName=MALWARE_APP\tsha256Hash=0710be16ba8a36712c3cac21776c8846e29897300271f09ba0a41983e370e1a0', 'LEEF:2.0|CarbonBlack|CbDefense|0.1|KNOWN_BACKDOOR|x09|identHostName=COMPANY\\Demo_CaretoMac\tdeviceName=COMPANY\\Demo_CaretoMac\tsev=8\tdeviceHostName=\texternalIpAddress=\tdeviceId=2004117\truleName=syslog alert\tidentSrc=\tcat=THREAT\teventId=faf9dfdd035211e6aab2b97cae4f83f3\tsrc=\tresource=COMPANY\\Demo_CaretoMac\ttargetPriorityCode=0\turl=https://testserver.company.net/ui#investigate/events/device/2004117/incident/3WTHN\tinternalIpAddress=\tdst=\tsummary=A known virus (Appetite: Keylogger, Password or Data stealer, Backdoor, Rootkit, Ransomware or Worm) attempted a network connection.\tgroupName=default\tdeviceType=MAC\tdevTime=Apr-15-2016 20:33:09 GMT\ttargetPriorityType=MEDIUM\tsignature=Active_Threat\tdevTimeFormat=MMM dd yyyy HH:mm:ss z\tincidentId=3WTHN\ttype=THREAT\temail=COMPANY\\caretoOsx@company.net.demo\tdeviceVersion=MAC OS X 10.9.0\tapplicationName=caretoosxdropper\tindicatorName=KNOWN_BACKDOOR\tsha256Hash=0710be16ba8a36712c3cac21776c8846e29897300271f09ba0a41983e370e1a0', 'LEEF:2.0|CarbonBlack|CbDefense|0.1|ATTEMPTED_CLIENT|x09|identHostName=COMPANY\\Demo_CaretoMac\tdeviceName=COMPANY\\Demo_CaretoMac\tsev=8\tdeviceHostName=\texternalIpAddress=\tdeviceId=2004117\truleName=syslog alert\tidentSrc=\tcat=THREAT\teventId=faf9dfdd035211e6aab2b97cae4f83f3\tsrc=\tresource=COMPANY\\Demo_CaretoMac\ttargetPriorityCode=0\turl=https://testserver.company.net/ui#investigate/events/device/2004117/incident/3WTHN\tinternalIpAddress=\tdst=\tsummary=A known virus (Appetite: Keylogger, Password or Data stealer, Backdoor, Rootkit, Ransomware or Worm) attempted a network connection.\tgroupName=default\tdeviceType=MAC\tdevTime=Apr-15-2016 20:33:09 GMT\ttargetPriorityType=MEDIUM\tsignature=Active_Threat\tdevTimeFormat=MMM dd yyyy HH:mm:ss z\tincidentId=3WTHN\ttype=THREAT\temail=COMPANY\\caretoOsx@company.net.demo\tdeviceVersion=MAC OS X 10.9.0\tapplicationName=caretoosxdropper\tindicatorName=ATTEMPTED_CLIENT\tsha256Hash=0710be16ba8a36712c3cac21776c8846e29897300271f09ba0a41983e370e1a0', 'LEEF:2.0|CarbonBlack|CbDefense|0.1|THREAT|x09|identHostName=COMPANY\\Demo_Mac_Shell\tdeviceName=COMPANY\\Demo_Mac_Shell\tsev=2\tdeviceHostName=\texternalIpAddress=\tdeviceId=2004119\truleName=syslog alert\tidentSrc=\tcat=THREAT\teventId=f6357957035211e6be8701df2c083974\tsrc=\tresource=COMPANY\\Demo_Mac_Shell\ttargetPriorityCode=0\turl=https://testserver.company.net/ui#investigate/events/device/2004119/incident/81RTK\tinternalIpAddress=\tdst=\tsummary=Multiple commands were executed via a script.\tgroupName=default\tdeviceType=MAC\tdevTime=Apr-15-2016 20:33:11 GMT\ttargetPriorityType=MEDIUM\tsignature=Active_Threat\tdevTimeFormat=MMM dd yyyy HH:mm:ss z\tincidentId=81RTK\ttype=THREAT\temail=COMPANY\\macReverseShell@company.net.demo\tdeviceVersion=MAC OS X 10.9.0', 'LEEF:2.0|CarbonBlack|CbDefense|0.1|RUN_ANOTHER_APP|x09|identHostName=COMPANY\\Demo_Mac_Shell\tdeviceName=COMPANY\\Demo_Mac_Shell\tsev=2\tdeviceHostName=\texternalIpAddress=\tdeviceId=2004119\truleName=syslog alert\tidentSrc=\tcat=THREAT\teventId=f6357957035211e6be8701df2c083974\tsrc=\tresource=COMPANY\\Demo_Mac_Shell\ttargetPriorityCode=0\turl=https://testserver.company.net/ui#investigate/events/device/2004119/incident/81RTK\tinternalIpAddress=\tdst=\tsummary=Multiple commands were executed via a script.\tgroupName=default\tdeviceType=MAC\tdevTime=Apr-15-2016 20:33:11 GMT\ttargetPriorityType=MEDIUM\tsignature=Active_Threat\tdevTimeFormat=MMM dd yyyy HH:mm:ss z\tincidentId=81RTK\ttype=THREAT\temail=COMPANY\\macReverseShell@company.net.demo\tdeviceVersion=MAC OS X 10.9.0\tapplicationName=Payload.class\tindicatorName=RUN_ANOTHER_APP\tsha256Hash=6750c319c5d1ba2d2937ef602c2e5c03df6fb60449566e5efb0331310a655c4e', 'LEEF:2.0|CarbonBlack|CbDefense|0.1|SCRIPT_COMMAND|x09|identHostName=COMPANY\\Demo_Mac_Shell\tdeviceName=COMPANY\\Demo_Mac_Shell\tsev=2\tdeviceHostName=\texternalIpAddress=\tdeviceId=2004119\truleName=syslog alert\tidentSrc=\tcat=THREAT\teventId=f6357957035211e6be8701df2c083974\tsrc=\tresource=COMPANY\\Demo_Mac_Shell\ttargetPriorityCode=0\turl=https://testserver.company.net/ui#investigate/events/device/2004119/incident/81RTK\tinternalIpAddress=\tdst=\tsummary=Multiple commands were executed via a script.\tgroupName=default\tdeviceType=MAC\tdevTime=Apr-15-2016 20:33:11 GMT\ttargetPriorityType=MEDIUM\tsignature=Active_Threat\tdevTimeFormat=MMM dd yyyy HH:mm:ss z\tincidentId=81RTK\ttype=THREAT\temail=COMPANY\\macReverseShell@company.net.demo\tdeviceVersion=MAC OS X 10.9.0\tapplicationName=Payload.class\tindicatorName=SCRIPT_COMMAND\tsha256Hash=6750c319c5d1ba2d2937ef602c2e5c03df6fb60449566e5efb0331310a655c4e', 'LEEF:2.0|CarbonBlack|CbDefense|0.1|SCRIPT_COMMAND|x09|identHostName=COMPANY\\Demo_Mac_Shell\tdeviceName=COMPANY\\Demo_Mac_Shell\tsev=2\tdeviceHostName=\texternalIpAddress=\tdeviceId=2004119\truleName=syslog alert\tidentSrc=\tcat=THREAT\teventId=f6357957035211e6be8701df2c083974\tsrc=\tresource=COMPANY\\Demo_Mac_Shell\ttargetPriorityCode=0\turl=https://testserver.company.net/ui#investigate/events/device/2004119/incident/81RTK\tinternalIpAddress=\tdst=\tsummary=Multiple commands were executed via a script.\tgroupName=default\tdeviceType=MAC\tdevTime=Apr-15-2016 20:33:11 GMT\ttargetPriorityType=MEDIUM\tsignature=Active_Threat\tdevTimeFormat=MMM dd yyyy HH:mm:ss z\tincidentId=81RTK\ttype=THREAT\temail=COMPANY\\macReverseShell@company.net.demo\tdeviceVersion=MAC OS X 10.9.0\tapplicationName=Payload.class\tindicatorName=SCRIPT_COMMAND\tsha256Hash=f84adcc7dc36e494dc89fd1c81c30233c91d0cb875c6cf5171dea19ab55cb72f', 'LEEF:2.0|CarbonBlack|CbDefense|0.1|RUN_ANOTHER_APP|x09|identHostName=COMPANY\\Demo_Mac_Shell\tdeviceName=COMPANY\\Demo_Mac_Shell\tsev=2\tdeviceHostName=\texternalIpAddress=\tdeviceId=2004119\truleName=syslog alert\tidentSrc=\tcat=THREAT\teventId=f6357957035211e6be8701df2c083974\tsrc=\tresource=COMPANY\\Demo_Mac_Shell\ttargetPriorityCode=0\turl=https://testserver.company.net/ui#investigate/events/device/2004119/incident/81RTK\tinternalIpAddress=\tdst=\tsummary=Multiple commands were executed via a script.\tgroupName=default\tdeviceType=MAC\tdevTime=Apr-15-2016 20:33:11 GMT\ttargetPriorityType=MEDIUM\tsignature=Active_Threat\tdevTimeFormat=MMM dd yyyy HH:mm:ss z\tincidentId=81RTK\ttype=THREAT\temail=COMPANY\\macReverseShell@company.net.demo\tdeviceVersion=MAC OS X 10.9.0\tapplicationName=Payload.class\tindicatorName=RUN_ANOTHER_APP\tsha256Hash=9afae0b82960d6fce7544efba1cb0509522dc29ba76539b63c30b5afce86388f', 'LEEF:2.0|CarbonBlack|CbDefense|0.1|RUN_ANOTHER_APP|x09|identHostName=COMPANY\\Demo_Mac_Shell\tdeviceName=COMPANY\\Demo_Mac_Shell\tsev=2\tdeviceHostName=\texternalIpAddress=\tdeviceId=2004119\truleName=syslog alert\tidentSrc=\tcat=THREAT\teventId=f6357957035211e6be8701df2c083974\tsrc=\tresource=COMPANY\\Demo_Mac_Shell\ttargetPriorityCode=0\turl=https://testserver.company.net/ui#investigate/events/device/2004119/incident/81RTK\tinternalIpAddress=\tdst=\tsummary=Multiple commands were executed via a script.\tgroupName=default\tdeviceType=MAC\tdevTime=Apr-15-2016 20:33:11 GMT\ttargetPriorityType=MEDIUM\tsignature=Active_Threat\tdevTimeFormat=MMM dd yyyy HH:mm:ss z\tincidentId=81RTK\ttype=THREAT\temail=COMPANY\\macReverseShell@company.net.demo\tdeviceVersion=MAC OS X 10.9.0\tapplicationName=Payload.class\tindicatorName=RUN_ANOTHER_APP\tsha256Hash=f84adcc7dc36e494dc89fd1c81c30233c91d0cb875c6cf5171dea19ab55cb72f', 'LEEF:2.0|CarbonBlack|CbDefense|0.1|THREAT|x09|identHostName=COMPANY\\Demo_Time\tdeviceName=COMPANY\\Demo_Time\tsev=2\tdeviceHostName=\texternalIpAddress=\tdeviceId=2004119\truleName=syslog alert\tidentSrc=\tcat=THREAT\teventId=f6357957035211e6be8701df2c083974\tsrc=\tresource=COMPANY\\Demo_Time\ttargetPriorityCode=0\turl=https://testserver.company.net/ui#investigate/events/device/2004119/incident/81RTK\tinternalIpAddress=\tdst=\tsummary=Test of various issues with \xc3\xbcmlauts and Unicode characters \xc3\xb8.\tgroupName=default\tdeviceType=MAC\tdevTime=Apr-15-2016 20:33:11 GMT\ttargetPriorityType=MEDIUM\tsignature=Active_Threat\tdevTimeFormat=MMM dd yyyy HH:mm:ss z\tincidentId=ZZ123\ttype=THREAT\temail=COMPANY\\schlo\xc3\x9fuser\tdeviceVersion=MAC OS X 10.9.0', 'LEEF:2.0|CarbonBlack|CbDefense|0.1|RUN_ANOTHER_APP|x09|identHostName=COMPANY\\Demo_Time\tdeviceName=COMPANY\\Demo_Time\tsev=2\tdeviceHostName=\texternalIpAddress=\tdeviceId=2004119\truleName=syslog alert\tidentSrc=\tcat=THREAT\teventId=f6357957035211e6be8701df2c083974\tsrc=\tresource=COMPANY\\Demo_Time\ttargetPriorityCode=0\turl=https://testserver.company.net/ui#investigate/events/device/2004119/incident/81RTK\tinternalIpAddress=\tdst=\tsummary=Test of various issues with \xc3\xbcmlauts and Unicode characters \xc3\xb8.\tgroupName=default\tdeviceType=MAC\tdevTime=Apr-15-2016 20:33:11 GMT\ttargetPriorityType=MEDIUM\tsignature=Active_Threat\tdevTimeFormat=MMM dd yyyy HH:mm:ss z\tincidentId=ZZ123\ttype=THREAT\temail=COMPANY\\schlo\xc3\x9fuser\tdeviceVersion=MAC OS X 10.9.0\tapplicationName=Payload.class\tindicatorName=RUN_ANOTHER_APP\tsha256Hash=6750c319c5d1ba2d2937ef602c2e5c03df6fb60449566e5efb0331310a655c4e', 'LEEF:2.0|CarbonBlack|CbDefense|0.1|SCRIPT_COMMAND|x09|identHostName=COMPANY\\Demo_Time\tdeviceName=COMPANY\\Demo_Time\tsev=2\tdeviceHostName=\texternalIpAddress=\tdeviceId=2004119\truleName=syslog alert\tidentSrc=\tcat=THREAT\teventId=f6357957035211e6be8701df2c083974\tsrc=\tresource=COMPANY\\Demo_Time\ttargetPriorityCode=0\turl=https://testserver.company.net/ui#investigate/events/device/2004119/incident/81RTK\tinternalIpAddress=\tdst=\tsummary=Test of various issues with \xc3\xbcmlauts and Unicode characters \xc3\xb8.\tgroupName=default\tdeviceType=MAC\tdevTime=Apr-15-2016 20:33:11 GMT\ttargetPriorityType=MEDIUM\tsignature=Active_Threat\tdevTimeFormat=MMM dd yyyy HH:mm:ss z\tincidentId=ZZ123\ttype=THREAT\temail=COMPANY\\schlo\xc3\x9fuser\tdeviceVersion=MAC OS X 10.9.0\tapplicationName=Payload.class\tindicatorName=SCRIPT_COMMAND\tsha256Hash=6750c319c5d1ba2d2937ef602c2e5c03df6fb60449566e5efb0331310a655c4e', 'LEEF:2.0|CarbonBlack|CbDefense|0.1|SCRIPT_COMMAND|x09|identHostName=COMPANY\\Demo_Time\tdeviceName=COMPANY\\Demo_Time\tsev=2\tdeviceHostName=\texternalIpAddress=\tdeviceId=2004119\truleName=syslog alert\tidentSrc=\tcat=THREAT\teventId=f6357957035211e6be8701df2c083974\tsrc=\tresource=COMPANY\\Demo_Time\ttargetPriorityCode=0\turl=https://testserver.company.net/ui#investigate/events/device/2004119/incident/81RTK\tinternalIpAddress=\tdst=\tsummary=Test of various issues with \xc3\xbcmlauts and Unicode characters \xc3\xb8.\tgroupName=default\tdeviceType=MAC\tdevTime=Apr-15-2016 20:33:11 GMT\ttargetPriorityType=MEDIUM\tsignature=Active_Threat\tdevTimeFormat=MMM dd yyyy HH:mm:ss z\tincidentId=ZZ123\ttype=THREAT\temail=COMPANY\\schlo\xc3\x9fuser\tdeviceVersion=MAC OS X 10.9.0\tapplicationName=Payload.class\tindicatorName=SCRIPT_COMMAND\tsha256Hash=f84adcc7dc36e494dc89fd1c81c30233c91d0cb875c6cf5171dea19ab55cb72f', 'LEEF:2.0|CarbonBlack|CbDefense|0.1|RUN_ANOTHER_APP|x09|identHostName=COMPANY\\Demo_Time\tdeviceName=COMPANY\\Demo_Time\tsev=2\tdeviceHostName=\texternalIpAddress=\tdeviceId=2004119\truleName=syslog alert\tidentSrc=\tcat=THREAT\teventId=f6357957035211e6be8701df2c083974\tsrc=\tresource=COMPANY\\Demo_Time\ttargetPriorityCode=0\turl=https://testserver.company.net/ui#investigate/events/device/2004119/incident/81RTK\tinternalIpAddress=\tdst=\tsummary=Test of various issues with \xc3\xbcmlauts and Unicode characters \xc3\xb8.\tgroupName=default\tdeviceType=MAC\tdevTime=Apr-15-2016 20:33:11 GMT\ttargetPriorityType=MEDIUM\tsignature=Active_Threat\tdevTimeFormat=MMM dd yyyy HH:mm:ss z\tincidentId=ZZ123\ttype=THREAT\temail=COMPANY\\schlo\xc3\x9fuser\tdeviceVersion=MAC OS X 10.9.0\tapplicationName=\xc3\xa9xplorer.exe\tindicatorName=RUN_ANOTHER_APP\tsha256Hash=9afae0b82960d6fce7544efba1cb0509522dc29ba76539b63c30b5afce86388f', 'LEEF:2.0|CarbonBlack|CbDefense|0.1|RUN_ANOTHER_APP|x09|identHostName=COMPANY\\Demo_Time\tdeviceName=COMPANY\\Demo_Time\tsev=2\tdeviceHostName=\texternalIpAddress=\tdeviceId=2004119\truleName=syslog alert\tidentSrc=\tcat=THREAT\teventId=f6357957035211e6be8701df2c083974\tsrc=\tresource=COMPANY\\Demo_Time\ttargetPriorityCode=0\turl=https://testserver.company.net/ui#investigate/events/device/2004119/incident/81RTK\tinternalIpAddress=\tdst=\tsummary=Test of various issues with \xc3\xbcmlauts and Unicode characters \xc3\xb8.\tgroupName=default\tdeviceType=MAC\tdevTime=Apr-15-2016 20:33:11 GMT\ttargetPriorityType=MEDIUM\tsignature=Active_Threat\tdevTimeFormat=MMM dd yyyy HH:mm:ss z\tincidentId=ZZ123\ttype=THREAT\temail=COMPANY\\schlo\xc3\x9fuser\tdeviceVersion=MAC OS X 10.9.0\tapplicationName=Payload.class\tindicatorName=RUN_ANOTHER_APP\tsha256Hash=f84adcc7dc36e494dc89fd1c81c30233c91d0cb875c6cf5171dea19ab55cb72f']


json_output_notification=[{'eventId': 'f279d0e6035211e6be8701df2c083974', 'source': 'test', 'eventTime': 1460703240678, 'eventDescription': '[syslog alert] [Cb Defense has detected a threat against your company.] [https://testserver.company.net/ui#device/2004118/incident/Z7NG6] [A known virus (Sality: Keylogger, Password or Data stealer, Backdoor) was detected running.] [Incident id: Z7NG6] [Threat score: 7] [Group: default] [Email: FirstName.LastName@company.net.demo] [Name: Demo_CaretoPC] [Type and OS: WINDOWS XP x86 SP: 0]\n', 'ruleName': 'syslog alert', 'url': 'https://testserver.company.net/ui#investigate/events/device/2004118/incident/Z7NG6', 'type': 'AUDIT', 'deviceInfo': {'deviceName': 'COMPANY\\Demo_CaretoPC', 'deviceHostName': '', 'externalIpAddress': '', 'deviceId': 2004118, 'targetPriorityCode': 0, 'internalIpAddress': '', 'groupName': 'default', 'deviceType': 'WINDOWS', 'deviceVersion': 'XP x86 SP: 0', 'email': 'COMPANY\\FirstName.LastName', 'targetPriorityType': 'MEDIUM'}, 'threatInfo': {'indicators': [{'applicationName': 'ShippingInvoice.pdf.exe', 'indicatorName': 'PACKED_CALL', 'sha256Hash': 'cfe0ae57f314a9f747a7cec605907cdaf1984b3cdea74ee8d5893d00ae0886cc'}, {'applicationName': 'explorer.exe', 'indicatorName': 'TARGET_MALWARE_APP', 'sha256Hash': '1e675cb7df214172f7eb0497f7275556038a0d09c6e5a3e6862c5e26885ef455'}, {'applicationName': 'ShippingInvoice.pdf.exe', 'indicatorName': 'HAS_PACKED_CODE', 'sha256Hash': 'cfe0ae57f314a9f747a7cec605907cdaf1984b3cdea74ee8d5893d00ae0886cc'}, {'applicationName': 'ShippingInvoice.pdf.exe', 'indicatorName': 'KNOWN_DOWNLOADER', 'sha256Hash': 'cfe0ae57f314a9f747a7cec605907cdaf1984b3cdea74ee8d5893d00ae0886cc'}, {'applicationName': 'ShippingInvoice.pdf.exe', 'indicatorName': 'ENUMERATE_PROCESSES', 'sha256Hash': 'cfe0ae57f314a9f747a7cec605907cdaf1984b3cdea74ee8d5893d00ae0886cc'}, {'applicationName': 'ShippingInvoice.pdf.exe', 'indicatorName': 'SET_SYSTEM_SECURITY', 'sha256Hash': 'cfe0ae57f314a9f747a7cec605907cdaf1984b3cdea74ee8d5893d00ae0886cc'}, {'applicationName': 'ShippingInvoice.pdf.exe', 'indicatorName': 'MODIFY_MEMORY_PROTECTION', 'sha256Hash': 'cfe0ae57f314a9f747a7cec605907cdaf1984b3cdea74ee8d5893d00ae0886cc'}, {'applicationName': 'ShippingInvoice.pdf.exe', 'indicatorName': 'KNOWN_PASSWORD_STEALER', 'sha256Hash': 'cfe0ae57f314a9f747a7cec605907cdaf1984b3cdea74ee8d5893d00ae0886cc'}, {'applicationName': 'explorer.exe', 'indicatorName': 'RUN_MALWARE_APP', 'sha256Hash': '1e675cb7df214172f7eb0497f7275556038a0d09c6e5a3e6862c5e26885ef455'}, {'applicationName': 'ShippingInvoice.pdf.exe', 'indicatorName': 'MODIFY_PROCESS', 'sha256Hash': 'cfe0ae57f314a9f747a7cec605907cdaf1984b3cdea74ee8d5893d00ae0886cc'}, {'applicationName': 'ShippingInvoice.pdf.exe', 'indicatorName': 'MALWARE_APP', 'sha256Hash': 'cfe0ae57f314a9f747a7cec605907cdaf1984b3cdea74ee8d5893d00ae0886cc'}], 'time': 1460703240678, 'incidentId': 'Z7NG6', 'score': 7, 'summary': 'A known virus (Sality: Keylogger, Password or Data stealer, Backdoor) was detected running.'}}, {'eventId': 'f44087c9035211e6aab2b97cae4f83f3', 'source': 'test', 'eventTime': 1460703240678, 'eventDescription': '[syslog alert] [Cb Defense has detected a threat against your company.] [https://testserver.company.net/ui#device/2004118/incident/YL5RZ] [A known virus (Sality: Keylogger, Password or Data stealer, Backdoor) was detected running.] [Incident id: YL5RZ] [Threat score: 7] [Group: default] [Email: FirstName.LastName@company.net.demo] [Name: Demo_CaretoPC] [Type and OS: WINDOWS XP x86 SP: 0]\n', 'ruleName': 'syslog alert', 'url': 'https://testserver.company.net/ui#investigate/events/device/2004118/incident/YL5RZ', 'type': 'AUDIT', 'deviceInfo': {'deviceName': 'COMPANY\\Demo_CaretoPC', 'deviceHostName': '', 'externalIpAddress': '', 'deviceId': 2004118, 'targetPriorityCode': 0, 'internalIpAddress': '', 'groupName': 'default', 'deviceType': 'WINDOWS', 'deviceVersion': 'XP x86 SP: 0', 'email': 'COMPANY\\FirstName.LastName@company.net.demo', 'targetPriorityType': 'MEDIUM'}, 'threatInfo': {'indicators': [{'applicationName': 'ShippingInvoice.pdf.exe', 'indicatorName': 'PACKED_CALL', 'sha256Hash': 'cfe0ae57f314a9f747a7cec605907cdaf1984b3cdea74ee8d5893d00ae0886cc'}, {'applicationName': 'ShippingInvoice.pdf.exe', 'indicatorName': 'MODIFY_PROCESS', 'sha256Hash': 'cfe0ae57f314a9f747a7cec605907cdaf1984b3cdea74ee8d5893d00ae0886cc'}, {'applicationName': 'ShippingInvoice.pdf.exe', 'indicatorName': 'ENUMERATE_PROCESSES', 'sha256Hash': 'cfe0ae57f314a9f747a7cec605907cdaf1984b3cdea74ee8d5893d00ae0886cc'}, {'applicationName': 'ShippingInvoice.pdf.exe', 'indicatorName': 'MALWARE_APP', 'sha256Hash': 'cfe0ae57f314a9f747a7cec605907cdaf1984b3cdea74ee8d5893d00ae0886cc'}, {'applicationName': 'ShippingInvoice.pdf.exe', 'indicatorName': 'SET_SYSTEM_SECURITY', 'sha256Hash': 'cfe0ae57f314a9f747a7cec605907cdaf1984b3cdea74ee8d5893d00ae0886cc'}, {'applicationName': 'ShippingInvoice.pdf.exe', 'indicatorName': 'KNOWN_DOWNLOADER', 'sha256Hash': 'cfe0ae57f314a9f747a7cec605907cdaf1984b3cdea74ee8d5893d00ae0886cc'}, {'applicationName': 'ShippingInvoice.pdf.exe', 'indicatorName': 'HAS_PACKED_CODE', 'sha256Hash': 'cfe0ae57f314a9f747a7cec605907cdaf1984b3cdea74ee8d5893d00ae0886cc'}, {'applicationName': 'ShippingInvoice.pdf.exe', 'indicatorName': 'KNOWN_PASSWORD_STEALER', 'sha256Hash': 'cfe0ae57f314a9f747a7cec605907cdaf1984b3cdea74ee8d5893d00ae0886cc'}, {'applicationName': 'ShippingInvoice.pdf.exe', 'indicatorName': 'MODIFY_MEMORY_PROTECTION', 'sha256Hash': 'cfe0ae57f314a9f747a7cec605907cdaf1984b3cdea74ee8d5893d00ae0886cc'}], 'time': 1460703240678, 'incidentId': 'YL5RZ', 'score': 7, 'summary': 'A known virus (Sality: Keylogger, Password or Data stealer, Backdoor) was detected running.'}}, {'eventId': 'f66bcb98035211e6be8701df2c083974', 'source': 'test', 'eventTime': 1460751097691, 'eventDescription': '[syslog alert] [Cb Defense has detected a threat against your company.] [https://testserver.company.net/ui#device/2004121/incident/IDWID] [A known virus (iWorm) is actively attempting a network connection.] [Incident id: IDWID] [Threat score: 7] [Group: default] [Email: iworm_test@company.net.demo] [Name: iworm_test] [Type and OS: MAC MAC OS X 10.9.0]\n', 'ruleName': 'syslog alert', 'url': 'https://testserver.company.net/ui#investigate/events/device/2004121/incident/IDWID', 'type': 'AUDIT', 'deviceInfo': {'deviceName': 'COMPANY\\iworm_test', 'deviceHostName': '', 'externalIpAddress': '', 'deviceId': 2004121, 'targetPriorityCode': 0, 'internalIpAddress': '', 'groupName': 'default', 'deviceType': 'MAC', 'deviceVersion': 'MAC OS X 10.9.0', 'email': 'COMPANY\\iworm_test', 'targetPriorityType': 'MEDIUM'}, 'threatInfo': {'indicators': [{'applicationName': 'Mac.BackDoor.iWorm_sample_2', 'indicatorName': 'ATTEMPTED_CLIENT', 'sha256Hash': '0b374d3dfd2fcae65d191dd1810cd8cc0b497c48b509f260654b0f3fe4cc9f8f'}, {'applicationName': 'Mac.BackDoor.iWorm_sample_2', 'indicatorName': 'ACTIVE_CLIENT', 'sha256Hash': '0b374d3dfd2fcae65d191dd1810cd8cc0b497c48b509f260654b0f3fe4cc9f8f'}, {'applicationName': 'Mac.BackDoor.iWorm_sample_2', 'indicatorName': 'KNOWN_MALWARE_ON_NETWORK', 'sha256Hash': '0b374d3dfd2fcae65d191dd1810cd8cc0b497c48b509f260654b0f3fe4cc9f8f'}, {'applicationName': 'Mac.BackDoor.iWorm_sample_2', 'indicatorName': 'RUN_SYSTEM_APP', 'sha256Hash': '0b374d3dfd2fcae65d191dd1810cd8cc0b497c48b509f260654b0f3fe4cc9f8f'}, {'applicationName': 'Mac.BackDoor.iWorm_sample_2', 'indicatorName': 'MALWARE_APP', 'sha256Hash': '0b374d3dfd2fcae65d191dd1810cd8cc0b497c48b509f260654b0f3fe4cc9f8f'}, {'applicationName': 'Mac.BackDoor.iWorm_sample_2', 'indicatorName': 'BEACON', 'sha256Hash': '0b374d3dfd2fcae65d191dd1810cd8cc0b497c48b509f260654b0f3fe4cc9f8f'}, {'applicationName': 'Mac.BackDoor.iWorm_sample_2', 'indicatorName': 'INTERNATIONAL_SITE', 'sha256Hash': '0b374d3dfd2fcae65d191dd1810cd8cc0b497c48b509f260654b0f3fe4cc9f8f'}, {'applicationName': 'Mac.BackDoor.iWorm_sample_2', 'indicatorName': 'RUN_ANOTHER_APP', 'sha256Hash': '0b374d3dfd2fcae65d191dd1810cd8cc0b497c48b509f260654b0f3fe4cc9f8f'}, {'applicationName': 'Mac.BackDoor.iWorm_sample_2', 'indicatorName': 'NETWORK_ACCESS', 'sha256Hash': '0b374d3dfd2fcae65d191dd1810cd8cc0b497c48b509f260654b0f3fe4cc9f8f'}], 'time': 1460751097691, 'incidentId': 'IDWID', 'score': 7, 'summary': 'A known virus (iWorm) is actively attempting a network connection.'}}, {'eventId': 'f7e85a1c035211e6aab2b97cae4f83f3', 'source': 'test', 'eventTime': 1460751097691, 'eventDescription': '[syslog alert] [Cb Defense has detected a threat against your company.] [https://testserver.company.net/ui#device/2004121/incident/UHMZ3] [A known virus (iWorm) is actively attempting a network connection.] [Incident id: UHMZ3] [Threat score: 7] [Group: default] [Email: iworm_test@company.net.demo] [Name: iworm_test] [Type and OS: MAC MAC OS X 10.9.0]\n', 'ruleName': 'syslog alert', 'url': 'https://testserver.company.net/ui#investigate/events/device/2004121/incident/UHMZ3', 'type': 'AUDIT', 'deviceInfo': {'deviceName': 'COMPANY\\iworm_test', 'deviceHostName': '', 'externalIpAddress': '', 'deviceId': 2004121, 'targetPriorityCode': 0, 'internalIpAddress': '', 'groupName': 'default', 'deviceType': 'MAC', 'deviceVersion': 'MAC OS X 10.9.0', 'email': 'COMPANY\\iworm_test', 'targetPriorityType': 'MEDIUM'}, 'threatInfo': {'indicators': [{'applicationName': 'Mac.BackDoor.iWorm_sample_2', 'indicatorName': 'MALWARE_APP', 'sha256Hash': '0b374d3dfd2fcae65d191dd1810cd8cc0b497c48b509f260654b0f3fe4cc9f8f'}, {'applicationName': 'Mac.BackDoor.iWorm_sample_2', 'indicatorName': 'INTERNATIONAL_SITE', 'sha256Hash': '0b374d3dfd2fcae65d191dd1810cd8cc0b497c48b509f260654b0f3fe4cc9f8f'}, {'applicationName': 'Mac.BackDoor.iWorm_sample_2', 'indicatorName': 'NETWORK_ACCESS', 'sha256Hash': '0b374d3dfd2fcae65d191dd1810cd8cc0b497c48b509f260654b0f3fe4cc9f8f'}, {'applicationName': 'Mac.BackDoor.iWorm_sample_2', 'indicatorName': 'KNOWN_MALWARE_ON_NETWORK', 'sha256Hash': '0b374d3dfd2fcae65d191dd1810cd8cc0b497c48b509f260654b0f3fe4cc9f8f'}, {'applicationName': 'Mac.BackDoor.iWorm_sample_2', 'indicatorName': 'BEACON', 'sha256Hash': '0b374d3dfd2fcae65d191dd1810cd8cc0b497c48b509f260654b0f3fe4cc9f8f'}, {'applicationName': 'Mac.BackDoor.iWorm_sample_2', 'indicatorName': 'ATTEMPTED_CLIENT', 'sha256Hash': '0b374d3dfd2fcae65d191dd1810cd8cc0b497c48b509f260654b0f3fe4cc9f8f'}, {'applicationName': 'bash', 'indicatorName': 'RUN_MALWARE_APP', 'sha256Hash': '737867f9e519c2eae2b064c33dc0608b283ebd6045fcf8b19736651ec34c0e37'}, {'applicationName': 'Mac.BackDoor.iWorm_sample_2', 'indicatorName': 'RUN_SYSTEM_APP', 'sha256Hash': '0b374d3dfd2fcae65d191dd1810cd8cc0b497c48b509f260654b0f3fe4cc9f8f'}, {'applicationName': 'Mac.BackDoor.iWorm_sample_2', 'indicatorName': 'ACTIVE_CLIENT', 'sha256Hash': '0b374d3dfd2fcae65d191dd1810cd8cc0b497c48b509f260654b0f3fe4cc9f8f'}, {'applicationName': 'bash', 'indicatorName': 'TARGET_MALWARE_APP', 'sha256Hash': '737867f9e519c2eae2b064c33dc0608b283ebd6045fcf8b19736651ec34c0e37'}, {'applicationName': 'Mac.BackDoor.iWorm_sample_2', 'indicatorName': 'RUN_ANOTHER_APP', 'sha256Hash': '0b374d3dfd2fcae65d191dd1810cd8cc0b497c48b509f260654b0f3fe4cc9f8f'}], 'time': 1460751097691, 'incidentId': 'UHMZ3', 'score': 7, 'summary': 'A known virus (iWorm) is actively attempting a network connection.'}}, {'eventId': 'fb1752ee035211e6aab2b97cae4f83f3', 'source': 'test', 'eventTime': 1460752031552, 'eventDescription': '[syslog alert] [Cb Defense has detected a threat against your company.] [https://testserver.company.net/ui#device/2004120/incident/DKI00] [An unknown, suspect or compromised application, has exhibited dangerous virus-like behavior.] [Incident id: DKI00] [Threat score: 3] [Group: default] [Email: osxInjection@company.net.demo] [Name: Demo_Mac_Injection] [Type and OS: MAC MAC OS X 10.9.0]\n', 'ruleName': 'syslog alert', 'url': 'https://testserver.company.net/ui#investigate/events/device/2004120/incident/DKI00', 'type': 'AUDIT', 'deviceInfo': {'deviceName': 'Demo_Mac_Injection', 'deviceHostName': '', 'externalIpAddress': '', 'deviceId': 2004120, 'targetPriorityCode': 0, 'internalIpAddress': '', 'groupName': 'default', 'deviceType': 'MAC', 'deviceVersion': 'MAC OS X 10.9.0', 'email': 'osxInjection@company.net.demo', 'targetPriorityType': 'MEDIUM'}, 'threatInfo': {'indicators': [{'applicationName': 'osxinj', 'indicatorName': 'ENUMERATE_PROCESSES', 'sha256Hash': '8cae6527b19ddc3395f09b537c727bbfaa5a0fe010ae42229d3d1b4470f2434b'}, {'applicationName': 'osxinj', 'indicatorName': 'INJECT_CODE', 'sha256Hash': '8cae6527b19ddc3395f09b537c727bbfaa5a0fe010ae42229d3d1b4470f2434b'}, {'applicationName': 'osxinj', 'indicatorName': 'SUSPICIOUS_BEHAVIOR', 'sha256Hash': '8cae6527b19ddc3395f09b537c727bbfaa5a0fe010ae42229d3d1b4470f2434b'}], 'time': 1460752031552, 'incidentId': 'DKI00', 'score': 3, 'summary': 'An unknown, suspect or compromised application, has exhibited dangerous virus-like behavior.'}}, {'eventId': 'f73005f9035211e6be8701df2c083974', 'source': 'test', 'eventTime': 1460752197249, 'eventDescription': '[syslog alert] [Cb Defense has detected a threat against your company.] [https://testserver.company.net/ui#device/2004116/incident/140XP] [A known virus (Thoper: Keylogger, Password or Data stealer, Backdoor) was detected running.] [Incident id: 140XP] [Threat score: 7] [Group: default] [Email: rat01@company.net.demo] [Name: Demo_RAT_01] [Type and OS: WINDOWS XP x86 SP: 0]\n', 'ruleName': 'syslog alert', 'url': 'https://testserver.company.net/ui#investigate/events/device/2004116/incident/140XP', 'type': 'AUDIT', 'deviceInfo': {'deviceName': 'COMPANY\\Demo_RAT_01', 'deviceHostName': '', 'externalIpAddress': '', 'deviceId': 2004116, 'targetPriorityCode': 0, 'internalIpAddress': '', 'groupName': 'default', 'deviceType': 'WINDOWS', 'deviceVersion': 'XP x86 SP: 0', 'email': 'COMPANY\\rat01@company.net.demo', 'targetPriorityType': 'MEDIUM'}, 'threatInfo': {'indicators': [{'applicationName': 'win3dx.DLL', 'indicatorName': 'MODIFY_MEMORY_PROTECTION', 'sha256Hash': 'ba6db998cda7cdaa7eea235e26776d1bed99c73f4c9789ed70c98053a8d18559'}, {'applicationName': 'win3dx.DLL', 'indicatorName': 'MALWARE_APP', 'sha256Hash': 'ba6db998cda7cdaa7eea235e26776d1bed99c73f4c9789ed70c98053a8d18559'}, {'applicationName': 'win3dx.DLL', 'indicatorName': 'KNOWN_BACKDOOR', 'sha256Hash': 'ba6db998cda7cdaa7eea235e26776d1bed99c73f4c9789ed70c98053a8d18559'}, {'applicationName': 'win3dx.DLL', 'indicatorName': 'KNOWN_PASSWORD_STEALER', 'sha256Hash': 'ba6db998cda7cdaa7eea235e26776d1bed99c73f4c9789ed70c98053a8d18559'}, {'applicationName': 'win3dx.DLL', 'indicatorName': 'KNOWN_KEYLOGGER', 'sha256Hash': 'ba6db998cda7cdaa7eea235e26776d1bed99c73f4c9789ed70c98053a8d18559'}, {'applicationName': 'win3dx.DLL', 'indicatorName': 'MODIFY_SERVICE', 'sha256Hash': 'ba6db998cda7cdaa7eea235e26776d1bed99c73f4c9789ed70c98053a8d18559'}], 'time': 1460752197249, 'incidentId': '140XP', 'score': 7, 'summary': 'A known virus (Thoper: Keylogger, Password or Data stealer, Backdoor) was detected running.'}}, {'eventId': 'f72cf95a035211e6aab2b97cae4f83f3', 'source': 'test', 'eventTime': 1460752198380, 'eventDescription': '[syslog alert] [Cb Defense has detected a threat against your company.] [https://testserver.company.net/ui#device/2004116/incident/VPJZJ] [A known virus (Keylogger, Password or Data stealer, Backdoor) was detected running.] [Incident id: VPJZJ] [Threat score: 7] [Group: default] [Email: rat01@company.net.demo] [Name: Demo_RAT_01] [Type and OS: WINDOWS XP x86 SP: 0]\n', 'ruleName': 'syslog alert', 'url': 'https://testserver.company.net/ui#investigate/events/device/2004116/incident/VPJZJ', 'type': 'AUDIT', 'deviceInfo': {'deviceName': 'COMPANY\\Demo_RAT_01', 'deviceHostName': '', 'externalIpAddress': '', 'deviceId': 2004116, 'targetPriorityCode': 0, 'internalIpAddress': '', 'groupName': 'default', 'deviceType': 'WINDOWS', 'deviceVersion': 'XP x86 SP: 0', 'email': 'COMPANY\\rat01@company.net.demo', 'targetPriorityType': 'MEDIUM'}, 'threatInfo': {'indicators': [{'applicationName': 'win3dx.DLL', 'indicatorName': 'MODIFY_SERVICE', 'sha256Hash': 'ba6db998cda7cdaa7eea235e26776d1bed99c73f4c9789ed70c98053a8d18559'}, {'applicationName': 'win3dx.DLL', 'indicatorName': 'KNOWN_KEYLOGGER', 'sha256Hash': 'ba6db998cda7cdaa7eea235e26776d1bed99c73f4c9789ed70c98053a8d18559'}, {'applicationName': 'win3dx.DLL', 'indicatorName': 'KNOWN_PASSWORD_STEALER', 'sha256Hash': 'ba6db998cda7cdaa7eea235e26776d1bed99c73f4c9789ed70c98053a8d18559'}, {'applicationName': 'explorer.exe', 'indicatorName': 'CODE_DROP', 'sha256Hash': '1e675cb7df214172f7eb0497f7275556038a0d09c6e5a3e6862c5e26885ef455'}, {'applicationName': 'win3dx.DLL', 'indicatorName': 'MALWARE_APP', 'sha256Hash': 'ba6db998cda7cdaa7eea235e26776d1bed99c73f4c9789ed70c98053a8d18559'}, {'applicationName': 'explorer.exe', 'indicatorName': 'MALWARE_DROP', 'sha256Hash': '1e675cb7df214172f7eb0497f7275556038a0d09c6e5a3e6862c5e26885ef455'}, {'applicationName': 'explorer.exe', 'indicatorName': 'TARGET_MALWARE_APP', 'sha256Hash': '1e675cb7df214172f7eb0497f7275556038a0d09c6e5a3e6862c5e26885ef455'}, {'applicationName': 'win3dx.DLL', 'indicatorName': 'MODIFY_MEMORY_PROTECTION', 'sha256Hash': 'ba6db998cda7cdaa7eea235e26776d1bed99c73f4c9789ed70c98053a8d18559'}, {'applicationName': 'win3dx.DLL', 'indicatorName': 'KNOWN_BACKDOOR', 'sha256Hash': 'ba6db998cda7cdaa7eea235e26776d1bed99c73f4c9789ed70c98053a8d18559'}, {'applicationName': 'svchost.exe', 'indicatorName': 'RUN_MALWARE_APP', 'sha256Hash': '2910ebc692d833d949bfd56059e8106d324a276d5f165f874f3fb1b6c613cdd5'}], 'time': 1460752198380, 'incidentId': 'VPJZJ', 'score': 7, 'summary': 'A known virus (Keylogger, Password or Data stealer, Backdoor) was detected running.'}}, {'eventId': 'f73313db035211e6aab2b97cae4f83f3', 'source': 'test', 'eventTime': 1460752321085, 'eventDescription': '[syslog alert] [Cb Defense has detected a threat against your company.] [https://testserver.company.net/ui#device/2004122/incident/6OJFC] [A known virus (FakeRean) was detected running.] [Incident id: 6OJFC] [Threat score: 3] [Group: default] [Email: fakeav_driveby@company.net.demo] [Name: fakeav_driveby] [Type and OS: WINDOWS Windows 7 x86 SP: 0]\n', 'ruleName': 'syslog alert', 'url': 'https://testserver.company.net/ui#investigate/events/device/2004122/incident/6OJFC', 'type': 'AUDIT', 'deviceInfo': {'deviceName': 'COMPANY\\fakeav_driveby', 'deviceHostName': '', 'externalIpAddress': '', 'deviceId': 2004122, 'targetPriorityCode': 0, 'internalIpAddress': '', 'groupName': 'default', 'deviceType': 'WINDOWS', 'deviceVersion': 'Windows 7 x86 SP: 0', 'email': 'COMPANY\\fakeav_driveby@company.net.demo', 'targetPriorityType': 'MEDIUM'}, 'threatInfo': {'indicators': [{'applicationName': 'svc.exe', 'indicatorName': 'KNOWN_ROGUE', 'sha256Hash': 'a37dd4f85117539ce4401c02c2bea403d7a724bedaccb5969980c8cf39b2a01a'}, {'applicationName': 'svc.exe', 'indicatorName': 'MODIFY_MEMORY_PROTECTION', 'sha256Hash': 'a37dd4f85117539ce4401c02c2bea403d7a724bedaccb5969980c8cf39b2a01a'}, {'applicationName': 'svc.exe', 'indicatorName': 'MODIFY_OWN_PROCESS', 'sha256Hash': 'a37dd4f85117539ce4401c02c2bea403d7a724bedaccb5969980c8cf39b2a01a'}, {'applicationName': 'svc.exe', 'indicatorName': 'MALWARE_APP', 'sha256Hash': 'a37dd4f85117539ce4401c02c2bea403d7a724bedaccb5969980c8cf39b2a01a'}, {'applicationName': 'svc.exe', 'indicatorName': 'PACKED_CALL', 'sha256Hash': 'a37dd4f85117539ce4401c02c2bea403d7a724bedaccb5969980c8cf39b2a01a'}, {'applicationName': 'svc.exe', 'indicatorName': 'HAS_PACKED_CODE', 'sha256Hash': 'a37dd4f85117539ce4401c02c2bea403d7a724bedaccb5969980c8cf39b2a01a'}], 'time': 1460752321085, 'incidentId': '6OJFC', 'score': 3, 'summary': 'A known virus (FakeRean) was detected running.'}}, {'eventId': 'fadb33aa035211e6be8701df2c083974', 'source': 'test', 'eventTime': 1460752321085, 'eventDescription': '[syslog alert] [Cb Defense has detected a threat against your company.] [https://testserver.company.net/ui#device/2004122/incident/DRE26] [An application has created an executable which is a known virus or on the Company Black List.] [Incident id: DRE26] [Threat score: 4] [Group: default] [Email: fakeav_driveby@company.net.demo] [Name: fakeav_driveby] [Type and OS: WINDOWS Windows 7 x86 SP: 0]\n', 'ruleName': 'syslog alert', 'url': 'https://testserver.company.net/ui#investigate/events/device/2004122/incident/DRE26', 'type': 'AUDIT', 'deviceInfo': {'deviceName': 'COMPANY\\fakeav_driveby', 'deviceHostName': '', 'externalIpAddress': '', 'deviceId': 2004122, 'targetPriorityCode': 0, 'internalIpAddress': '', 'groupName': 'default', 'deviceType': 'WINDOWS', 'deviceVersion': 'Windows 7 x86 SP: 0', 'email': 'COMPANY\\fakeav_driveby@company.net.demo', 'targetPriorityType': 'MEDIUM'}, 'threatInfo': {'indicators': [{'applicationName': 'iexplore.exe', 'indicatorName': 'HAS_SCRIPT_DLL', 'sha256Hash': '422d380855c449e81a30fcf840b44cb8b6291549b05768b23954616b4772fc45'}, {'applicationName': 'svc.exe', 'indicatorName': 'MODIFY_OWN_PROCESS', 'sha256Hash': 'a37dd4f85117539ce4401c02c2bea403d7a724bedaccb5969980c8cf39b2a01a'}, {'applicationName': 'iexplore.exe', 'indicatorName': 'HAS_PACKED_CODE', 'sha256Hash': '422d380855c449e81a30fcf840b44cb8b6291549b05768b23954616b4772fc45'}, {'applicationName': 'iexplore.exe', 'indicatorName': 'CODE_DROP', 'sha256Hash': '422d380855c449e81a30fcf840b44cb8b6291549b05768b23954616b4772fc45'}, {'applicationName': 'iexplore.exe', 'indicatorName': 'RUN_MALWARE_APP', 'sha256Hash': '422d380855c449e81a30fcf840b44cb8b6291549b05768b23954616b4772fc45'}, {'applicationName': 'iexplore.exe', 'indicatorName': 'RUN_ANOTHER_APP', 'sha256Hash': '422d380855c449e81a30fcf840b44cb8b6291549b05768b23954616b4772fc45'}, {'applicationName': 'svc.exe', 'indicatorName': 'PACKED_CALL', 'sha256Hash': 'a37dd4f85117539ce4401c02c2bea403d7a724bedaccb5969980c8cf39b2a01a'}, {'applicationName': 'svc.exe', 'indicatorName': 'MALWARE_APP', 'sha256Hash': 'a37dd4f85117539ce4401c02c2bea403d7a724bedaccb5969980c8cf39b2a01a'}, {'applicationName': 'svc.exe', 'indicatorName': 'MODIFY_MEMORY_PROTECTION', 'sha256Hash': 'a37dd4f85117539ce4401c02c2bea403d7a724bedaccb5969980c8cf39b2a01a'}, {'applicationName': 'iexplore.exe', 'indicatorName': 'NEW_SCRIPT_DLL', 'sha256Hash': '422d380855c449e81a30fcf840b44cb8b6291549b05768b23954616b4772fc45'}, {'applicationName': 'iexplore.exe', 'indicatorName': 'TARGET_MALWARE_APP', 'sha256Hash': '422d380855c449e81a30fcf840b44cb8b6291549b05768b23954616b4772fc45'}, {'applicationName': 'svc.exe', 'indicatorName': 'KNOWN_ROGUE', 'sha256Hash': 'a37dd4f85117539ce4401c02c2bea403d7a724bedaccb5969980c8cf39b2a01a'}, {'applicationName': 'svc.exe', 'indicatorName': 'HAS_PACKED_CODE', 'sha256Hash': 'a37dd4f85117539ce4401c02c2bea403d7a724bedaccb5969980c8cf39b2a01a'}, {'applicationName': 'iexplore.exe', 'indicatorName': 'MALWARE_DROP', 'sha256Hash': '422d380855c449e81a30fcf840b44cb8b6291549b05768b23954616b4772fc45'}], 'time': 1460752321085, 'incidentId': 'DRE26', 'score': 4, 'summary': 'An application has created an executable which is a known virus or on the Company Black List.'}}, {'eventId': 'fadd7d9b035211e6be8701df2c083974', 'source': 'test', 'eventTime': 1460752389112, 'eventDescription': '[syslog alert] [Cb Defense has detected a threat against your company.] [https://testserver.company.net/ui#device/2004117/incident/8OI0O] [A known virus (Appetite: Keylogger, Password or Data stealer, Backdoor, Rootkit, Ransomware or Worm) attempted a network connection.] [Incident id: 8OI0O] [Threat score: 8] [Group: default] [Email: caretoOsx@company.net.demo] [Name: Demo_CaretoMac] [Type and OS: MAC MAC OS X 10.9.0]\n', 'ruleName': 'syslog alert', 'url': 'https://testserver.company.net/ui#investigate/events/device/2004117/incident/8OI0O', 'type': 'AUDIT', 'deviceInfo': {'deviceName': 'COMPANY\\Demo_CaretoMac', 'deviceHostName': '', 'externalIpAddress': '', 'deviceId': 2004117, 'targetPriorityCode': 0, 'internalIpAddress': '', 'groupName': 'default', 'deviceType': 'MAC', 'deviceVersion': 'MAC OS X 10.9.0', 'email': 'COMPANY\\caretoOsx@company.net.demo', 'targetPriorityType': 'MEDIUM'}, 'threatInfo': {'indicators': [{'applicationName': 'caretoosxdropper', 'indicatorName': 'ATTEMPTED_CLIENT', 'sha256Hash': '0710be16ba8a36712c3cac21776c8846e29897300271f09ba0a41983e370e1a0'}, {'applicationName': 'caretoosxdropper', 'indicatorName': 'BEACON', 'sha256Hash': '0710be16ba8a36712c3cac21776c8846e29897300271f09ba0a41983e370e1a0'}, {'applicationName': 'xpcproxy', 'indicatorName': 'MALWARE_DROP', 'sha256Hash': 'ab0d18bd9d4a32e3b5cdc7e2231760833c0e6c2a315b479109df5bceae28b221'}, {'applicationName': 'caretoosxdropper', 'indicatorName': 'KNOWN_MALWARE_ON_NETWORK', 'sha256Hash': '0710be16ba8a36712c3cac21776c8846e29897300271f09ba0a41983e370e1a0'}, {'applicationName': 'caretoosxdropper', 'indicatorName': 'MALWARE_APP', 'sha256Hash': '0710be16ba8a36712c3cac21776c8846e29897300271f09ba0a41983e370e1a0'}, {'applicationName': 'xpcproxy', 'indicatorName': 'TARGET_MALWARE_APP', 'sha256Hash': 'ab0d18bd9d4a32e3b5cdc7e2231760833c0e6c2a315b479109df5bceae28b221'}, {'applicationName': 'xpcproxy', 'indicatorName': 'CODE_DROP', 'sha256Hash': 'ab0d18bd9d4a32e3b5cdc7e2231760833c0e6c2a315b479109df5bceae28b221'}, {'applicationName': 'caretoosxdropper', 'indicatorName': 'KNOWN_BACKDOOR', 'sha256Hash': '0710be16ba8a36712c3cac21776c8846e29897300271f09ba0a41983e370e1a0'}, {'applicationName': 'bash', 'indicatorName': 'RUN_MALWARE_APP', 'sha256Hash': '737867f9e519c2eae2b064c33dc0608b283ebd6045fcf8b19736651ec34c0e37'}], 'time': 1460752389112, 'incidentId': '8OI0O', 'score': 8, 'summary': 'A known virus (Appetite: Keylogger, Password or Data stealer, Backdoor, Rootkit, Ransomware or Worm) attempted a network connection.'}}, {'eventId': 'faf9dfdd035211e6aab2b97cae4f83f3', 'source': 'test', 'eventTime': 1460752389112, 'eventDescription': '[syslog alert] [Cb Defense has detected a threat against your company.] [https://testserver.company.net/ui#device/2004117/incident/3WTHN] [A known virus (Appetite: Keylogger, Password or Data stealer, Backdoor, Rootkit, Ransomware or Worm) attempted a network connection.] [Incident id: 3WTHN] [Threat score: 8] [Group: default] [Email: caretoOsx@company.net.demo] [Name: Demo_CaretoMac] [Type and OS: MAC MAC OS X 10.9.0]\n', 'ruleName': 'syslog alert', 'url': 'https://testserver.company.net/ui#investigate/events/device/2004117/incident/3WTHN', 'type': 'AUDIT', 'deviceInfo': {'deviceName': 'COMPANY\\Demo_CaretoMac', 'deviceHostName': '', 'externalIpAddress': '', 'deviceId': 2004117, 'targetPriorityCode': 0, 'internalIpAddress': '', 'groupName': 'default', 'deviceType': 'MAC', 'deviceVersion': 'MAC OS X 10.9.0', 'email': 'COMPANY\\caretoOsx@company.net.demo', 'targetPriorityType': 'MEDIUM'}, 'threatInfo': {'indicators': [{'applicationName': 'caretoosxdropper', 'indicatorName': 'BEACON', 'sha256Hash': '0710be16ba8a36712c3cac21776c8846e29897300271f09ba0a41983e370e1a0'}, {'applicationName': 'caretoosxdropper', 'indicatorName': 'KNOWN_MALWARE_ON_NETWORK', 'sha256Hash': '0710be16ba8a36712c3cac21776c8846e29897300271f09ba0a41983e370e1a0'}, {'applicationName': 'caretoosxdropper', 'indicatorName': 'MALWARE_APP', 'sha256Hash': '0710be16ba8a36712c3cac21776c8846e29897300271f09ba0a41983e370e1a0'}, {'applicationName': 'caretoosxdropper', 'indicatorName': 'KNOWN_BACKDOOR', 'sha256Hash': '0710be16ba8a36712c3cac21776c8846e29897300271f09ba0a41983e370e1a0'}, {'applicationName': 'caretoosxdropper', 'indicatorName': 'ATTEMPTED_CLIENT', 'sha256Hash': '0710be16ba8a36712c3cac21776c8846e29897300271f09ba0a41983e370e1a0'}], 'time': 1460752389112, 'incidentId': '3WTHN', 'score': 8, 'summary': 'A known virus (Appetite: Keylogger, Password or Data stealer, Backdoor, Rootkit, Ransomware or Worm) attempted a network connection.'}}, {'eventId': 'f6357957035211e6be8701df2c083974', 'source': 'test', 'eventTime': 1460752391454, 'eventDescription': '[syslog alert] [Cb Defense has detected a threat against your company.] [https://testserver.company.net/ui#device/2004119/incident/81RTK] [Multiple commands were executed via a script.] [Incident id: 81RTK] [Threat score: 2] [Group: default] [Email: macReverseShell@company.net.demo] [Name: Demo_Mac_Shell] [Type and OS: MAC MAC OS X 10.9.0]\n', 'ruleName': 'syslog alert', 'url': 'https://testserver.company.net/ui#investigate/events/device/2004119/incident/81RTK', 'type': 'AUDIT', 'deviceInfo': {'deviceName': 'COMPANY\\Demo_Mac_Shell', 'deviceHostName': '', 'externalIpAddress': '', 'deviceId': 2004119, 'targetPriorityCode': 0, 'internalIpAddress': '', 'groupName': 'default', 'deviceType': 'MAC', 'deviceVersion': 'MAC OS X 10.9.0', 'email': 'COMPANY\\macReverseShell@company.net.demo', 'targetPriorityType': 'MEDIUM'}, 'threatInfo': {'indicators': [{'applicationName': 'Payload.class', 'indicatorName': 'RUN_ANOTHER_APP', 'sha256Hash': '6750c319c5d1ba2d2937ef602c2e5c03df6fb60449566e5efb0331310a655c4e'}, {'applicationName': 'Payload.class', 'indicatorName': 'SCRIPT_COMMAND', 'sha256Hash': '6750c319c5d1ba2d2937ef602c2e5c03df6fb60449566e5efb0331310a655c4e'}, {'applicationName': 'Payload.class', 'indicatorName': 'SCRIPT_COMMAND', 'sha256Hash': 'f84adcc7dc36e494dc89fd1c81c30233c91d0cb875c6cf5171dea19ab55cb72f'}, {'applicationName': 'Payload.class', 'indicatorName': 'RUN_ANOTHER_APP', 'sha256Hash': '9afae0b82960d6fce7544efba1cb0509522dc29ba76539b63c30b5afce86388f'}, {'applicationName': 'Payload.class', 'indicatorName': 'RUN_ANOTHER_APP', 'sha256Hash': 'f84adcc7dc36e494dc89fd1c81c30233c91d0cb875c6cf5171dea19ab55cb72f'}], 'time': 1460752391454, 'incidentId': '81RTK', 'score': 2, 'summary': 'Multiple commands were executed via a script.'}}, {'eventId': 'f6357957035211e6be8701df2c083974', 'source': 'test', 'eventTime': 1460752391454, 'eventDescription': '[syslog alert] [Cb Defense has detected a threat against your company.] [https://testserver.company.net/ui#device/2004119/incident/81RTK] [Multiple commands were executed via a script.] [Incident id: 81RTK] [Threat score: 2] [Group: default] [Email: macReverseShell@company.net.demo] [Name: Demo_Mac_Shell] [Type and OS: MAC MAC OS X 10.9.0]\n', 'ruleName': 'syslog alert', 'url': 'https://testserver.company.net/ui#investigate/events/device/2004119/incident/81RTK', 'type': 'AUDIT', 'deviceInfo': {'deviceName': u'COMPANY\\Demo_Time', 'deviceHostName': '', 'externalIpAddress': '', 'deviceId': 2004119, 'targetPriorityCode': 0, 'internalIpAddress': '', 'groupName': 'default', 'deviceType': 'MAC', 'deviceVersion': 'MAC OS X 10.9.0', 'email': u'COMPANY\\schlo\xdfuser', 'targetPriorityType': 'MEDIUM'}, 'threatInfo': {'indicators': [{'applicationName': 'Payload.class', 'indicatorName': 'RUN_ANOTHER_APP', 'sha256Hash': '6750c319c5d1ba2d2937ef602c2e5c03df6fb60449566e5efb0331310a655c4e'}, {'applicationName': 'Payload.class', 'indicatorName': 'SCRIPT_COMMAND', 'sha256Hash': '6750c319c5d1ba2d2937ef602c2e5c03df6fb60449566e5efb0331310a655c4e'}, {'applicationName': 'Payload.class', 'indicatorName': 'SCRIPT_COMMAND', 'sha256Hash': 'f84adcc7dc36e494dc89fd1c81c30233c91d0cb875c6cf5171dea19ab55cb72f'}, {'applicationName': '\xc3\xa9xplorer.exe', 'indicatorName': 'RUN_ANOTHER_APP', 'sha256Hash': '9afae0b82960d6fce7544efba1cb0509522dc29ba76539b63c30b5afce86388f'}, {'applicationName': 'Payload.class', 'indicatorName': 'RUN_ANOTHER_APP', 'sha256Hash': 'f84adcc7dc36e494dc89fd1c81c30233c91d0cb875c6cf5171dea19ab55cb72f'}], 'time': 1460752391454, 'incidentId': 'ZZ123', 'score': 2, 'summary': u'Test of various issues with \xfcmlauts and Unicode characters \xf8.'}}]
