# -*- coding: utf-8 -*-
# Generated by Django 1.11.8 on 2017-12-29 00:48
from __future__ import unicode_literals

from django.db import migrations, models
import django.db.models.deletion
import django_mail_admin.fields
import django_mail_admin.settings
import django_mail_admin.utils
import django_mail_admin.validators
import jsonfield.fields


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='Attachment',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('file', models.FileField(upload_to=django_mail_admin.utils.get_attachment_save_path, verbose_name='File')),
                ('name', models.CharField(help_text='The original filename', max_length=255, verbose_name='Name')),
                ('mimetype', models.CharField(blank=True, default='', max_length=255)),
            ],
            options={
                'verbose_name': 'Attachment',
                'verbose_name_plural': 'Attachments',
            },
        ),
        migrations.CreateModel(
            name='EmailTemplate',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=254, verbose_name='Template name')),
                ('description', models.TextField(blank=True, verbose_name='Template description')),
                ('subject', models.CharField(max_length=254, validators=[django_mail_admin.validators.validate_template_syntax], verbose_name='Subject')),
                ('email_html_text', models.TextField(blank=True, validators=[django_mail_admin.validators.validate_template_syntax], verbose_name='Email html text')),
            ],
            options={
                'verbose_name': 'Email template',
                'verbose_name_plural': 'Email templates',
            },
        ),
        migrations.CreateModel(
            name='IncomingAttachment',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('headers', models.TextField(blank=True, null=True, verbose_name='Headers')),
                ('document', models.FileField(upload_to=django_mail_admin.utils.get_attachment_save_path, verbose_name='Document')),
            ],
            options={
                'verbose_name': 'IncomingEmail attachment',
                'verbose_name_plural': 'IncomingEmail attachments',
            },
        ),
        migrations.CreateModel(
            name='IncomingEmail',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('subject', models.CharField(max_length=255, verbose_name='Subject')),
                ('message_id', models.CharField(max_length=255, verbose_name='IncomingEmail ID')),
                ('from_header', models.CharField(max_length=255, verbose_name='From header')),
                ('to_header', models.TextField(verbose_name='To header')),
                ('body', models.TextField(verbose_name='Body')),
                ('encoded', models.BooleanField(default=False, help_text='True if the e-mail body is Base64 encoded', verbose_name='Encoded')),
                ('processed', models.DateTimeField(auto_now_add=True, verbose_name='Processed')),
                ('read', models.DateTimeField(blank=True, default=None, null=True, verbose_name='Read')),
                ('eml', models.FileField(help_text='Original full content of message', null=True, upload_to='messages', verbose_name='Raw message contents')),
            ],
            options={
                'verbose_name': 'Incoming email',
                'verbose_name_plural': 'Incoming emails',
            },
        ),
        migrations.CreateModel(
            name='Log',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('date', models.DateTimeField(auto_now_add=True)),
                ('status', models.PositiveSmallIntegerField(choices=[(0, 'sent'), (1, 'failed')], verbose_name='Status')),
                ('exception_type', models.CharField(blank=True, max_length=255, verbose_name='Exception type')),
                ('message', models.TextField(verbose_name='Message')),
            ],
            options={
                'verbose_name': 'Log',
                'verbose_name_plural': 'Logs',
            },
        ),
        migrations.CreateModel(
            name='Mailbox',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255, verbose_name='Name')),
                ('uri', models.CharField(blank=True, default=None, help_text="Example: imap+ssl://myusername:mypassword@someserver <br /><br />Internet transports include 'imap' and 'pop3'; common local file transports include 'maildir', 'mbox', and less commonly 'babyl', 'mh', and 'mmdf'. <br /><br />Be sure to urlencode your username and password should they contain illegal characters (like @, :, etc).", max_length=255, null=True, verbose_name='URI')),
                ('from_email', models.CharField(blank=True, default=None, help_text="Example: MailBot &lt;mailbot@yourdomain.com&gt;<br />'From' header to set for outgoing email.<br /><br />If you do not use this e-mail inbox for outgoing mail, this setting is unnecessary.<br />If you send e-mail without setting this, your 'From' header will'be set to match the setting `DEFAULT_FROM_EMAIL`.", max_length=255, null=True, verbose_name='From email')),
                ('active', models.BooleanField(default=True, help_text='Check this e-mail inbox for new e-mail messages during polling cycles.  This checkbox does not have an effect upon whether mail is collected here when this mailbox receives mail from a pipe, and does not affect whether e-mail messages can be dispatched from this mailbox. ', verbose_name='Active')),
                ('last_polling', models.DateTimeField(blank=True, help_text='The time of last successful polling for messages.It is blank for new mailboxes and is not set for mailboxes that only receive messages via a pipe.', null=True, verbose_name='Last polling')),
            ],
            options={
                'verbose_name': 'Mailbox',
                'verbose_name_plural': 'Mailboxes',
            },
        ),
        migrations.CreateModel(
            name='Outbox',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255, verbose_name='Name')),
                ('email_use_tls', models.BooleanField(default=True, verbose_name='EMAIL_USE_TLS')),
                ('email_use_ssl', models.BooleanField(default=False, verbose_name='EMAIL_USE_SSL')),
                ('email_ssl_keyfile', models.CharField(blank=True, max_length=1024, null=True, verbose_name='EMAIL_SSL_KEYFILE')),
                ('email_ssl_certfile', models.CharField(blank=True, max_length=1024, null=True, verbose_name='EMAIL_SSL_CERTFILE')),
                ('email_host', models.CharField(max_length=1024, verbose_name='EMAIL_HOST')),
                ('email_host_user', models.CharField(max_length=255, verbose_name='EMAIL_HOST_USER')),
                ('email_host_password', models.CharField(max_length=255, verbose_name='EMAIL_HOST_PASSWORD')),
                ('email_port', models.PositiveSmallIntegerField(default=587, verbose_name='EMAIL_PORT')),
                ('email_timeout', models.PositiveSmallIntegerField(blank=True, null=True, verbose_name='EMAIL_TIMEOUT')),
                ('active', models.BooleanField(default=False, verbose_name='Active')),
            ],
            options={
                'verbose_name': 'Outbox',
                'verbose_name_plural': 'Outboxes',
            },
        ),
        migrations.CreateModel(
            name='OutgoingEmail',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('from_email', models.CharField(max_length=254, validators=[django_mail_admin.validators.validate_email_with_name], verbose_name='From email')),
                ('to', django_mail_admin.fields.CommaSeparatedEmailField(blank=True, verbose_name='To email(s)')),
                ('cc', django_mail_admin.fields.CommaSeparatedEmailField(blank=True, verbose_name='Cc')),
                ('bcc', django_mail_admin.fields.CommaSeparatedEmailField(blank=True, verbose_name='Bcc')),
                ('subject', models.CharField(blank=True, max_length=989, verbose_name='Subject')),
                ('message', models.TextField(blank=True, verbose_name='Message')),
                ('html_message', models.TextField(blank=True, help_text='Used only if template is not selected', verbose_name='HTML Message')),
                ('created', models.DateTimeField(auto_now_add=True, db_index=True)),
                ('last_updated', models.DateTimeField(auto_now=True, db_index=True)),
                ('scheduled_time', models.DateTimeField(blank=True, db_index=True, null=True, verbose_name='The scheduled sending time')),
                ('headers', jsonfield.fields.JSONField(blank=True, null=True, verbose_name='Headers')),
                ('status', models.PositiveSmallIntegerField(blank=True, choices=[(0, 'sent'), (1, 'failed'), (2, 'queued')], db_index=True, null=True, verbose_name='Status')),
                ('priority', models.PositiveSmallIntegerField(blank=True, choices=[(0, 'low'), (1, 'medium'), (2, 'high'), (3, 'now')], null=True, verbose_name='Priority')),
                ('send_now', models.BooleanField(default=False, verbose_name='Send now')),
                ('backend_alias', models.CharField(blank=True, default='', help_text=django_mail_admin.settings.get_backend_names_str, max_length=64, verbose_name='Backend alias')),
                ('template', models.ForeignKey(blank=True, help_text='If template is selected, HTML message and subject fields will not be used - they will be populated from template', null=True, on_delete=django.db.models.deletion.CASCADE, to='django_mail_admin.EmailTemplate', verbose_name='Template')),
            ],
            options={
                'verbose_name': 'Outgoing email',
                'verbose_name_plural': 'Outgoing emails',
            },
        ),
        migrations.CreateModel(
            name='TemplateVariable',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=254, verbose_name='Variable name')),
                ('value', models.TextField(blank=True, verbose_name='Variable value')),
                ('email', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='django_mail_admin.OutgoingEmail')),
            ],
            options={
                'verbose_name': 'Template variable',
                'verbose_name_plural': 'Template variables',
            },
        ),
        migrations.AddField(
            model_name='log',
            name='email',
            field=models.ForeignKey(editable=False, on_delete=django.db.models.deletion.CASCADE, related_name='logs', to='django_mail_admin.OutgoingEmail', verbose_name='Email address'),
        ),
        migrations.AddField(
            model_name='incomingemail',
            name='in_reply_to',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='replies', to='django_mail_admin.OutgoingEmail', verbose_name='In reply to'),
        ),
        migrations.AddField(
            model_name='incomingemail',
            name='mailbox',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='messages', to='django_mail_admin.Mailbox', verbose_name='Mailbox'),
        ),
        migrations.AddField(
            model_name='incomingattachment',
            name='message',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='attachments', to='django_mail_admin.IncomingEmail', verbose_name='IncomingEmail'),
        ),
        migrations.AddField(
            model_name='attachment',
            name='emails',
            field=models.ManyToManyField(blank=True, related_name='attachments', to='django_mail_admin.OutgoingEmail', verbose_name='Email addresses'),
        ),
    ]
