# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['fastq_dl']

package_data = \
{'': ['*']}

install_requires = \
['executor>=23.2,<24.0',
 'pysradb>=1.4,<2.0',
 'requests>=2.28.2,<3.0.0',
 'rich-click>=1.6.1,<2.0.0',
 'rich>=13.3.1,<14.0.0']

entry_points = \
{'console_scripts': ['fastq-dl = fastq_dl.fastq_dl:main']}

setup_kwargs = {
    'name': 'fastq-dl',
    'version': '2.0.0',
    'description': 'Download FASTQ files from SRA or ENA repositories.',
    'long_description': "[![GitHub release (latest by date)](https://img.shields.io/github/v/release/rpetit3/fastq-dl)](https://github.com/bactopia/rpetit3/fastq-dl)\n[![Anaconda-Server Badge](https://anaconda.org/bioconda/fastq-dl/badges/downloads.svg)](https://anaconda.org/bioconda/fastq-dl)\n[![Gitpod ready-to-code](https://img.shields.io/badge/Gitpod-ready--to--code-908a85?logo=gitpod)](https://gitpod.io/#https://github.com/rpetit3/fastq-dl)\n\n# fastq-dl\n\nDownload FASTQ files from the [European Nucleotide Archive](https://www.ebi.ac.uk/ena) or the\n[Sequence Read Archive](https://www.ncbi.nlm.nih.gov/sra) repositories.\n\n## Introduction\n\n`fastq-dl` takes an ENA/SRA accession (Study, Sample, Experiment, or Run) and queries ENA (via\n[Data Warehouse API](https://www.ebi.ac.uk/ena/browse/search-rest)) to determine the associated\nmetadata. It then downloads FASTQ files for each Run. For Samples or Experiments with multiple\nRuns, users can optionally merge the runs.\n\n## Installation\n\n### Bioconda\n\n`fastq-dl` is available from [Bioconda](https://bioconda.github.io/) and I highly recommend you\ngo this route to for installation.\n\n```{bash}\nconda create -n fastq-dl -c conda-forge -c bioconda fastq-dl\nconda activate fastq-dl \n```\n\n## Usage\n\n```{bash}\nfastq-dl --help\n                                                                                          \n Usage: fastq-dl [OPTIONS]                                                                \n                                                                                          \n Download FASTQ files from ENA or SRA.                                                    \n                                                                                          \n╭─ Required Options ─────────────────────────────────────────────────────────────────────╮\n│ *  --accession  -a  TEXT  ENA/SRA accession to query. (Study, Sample, Experiment, Run  │\n│                           accession) [required]                                        │\n╰────────────────────────────────────────────────────────────────────────────────────────╯\n╭─ Additional Options ───────────────────────────────────────────────────────────────────╮\n│ --provider                 [ena|sra]  Specify which provider (ENA or SRA) to use.      │\n│                                       [default: ena]                                   │\n│ --group-by-experiment                 Group Runs by experiment accession.              │\n│ --group-by-sample                     Group Runs by sample accession.                  │\n│ --outdir               -o  TEXT       Directory to output downloads to. [default: ./]  │\n│ --prefix                   TEXT       Prefix to use for naming log files.              │\n│                                       [default: fastq]                                 │\n│ --cpus                     INTEGER    Total cpus used for downloading from SRA.        │\n│                                       [default: 1]                                     │\n│ --max-attempts         -m  INTEGER    Maximum number of download attempts.             │\n│                                       [default: 10]                                    │\n│ --only-provider        -F             Only attempt download from specified provider.   │\n│ --silent                              Only critical errors will be printed.            │\n│ --version              -V             Show the version and exit.                       │\n│ --verbose              -v             Print debug related text.                        │\n│ --help                 -h             Show this message and exit.                      │\n╰────────────────────────────────────────────────────────────────────────────────────────╯\n```\n\n*fastq-dl* requires a single ENA/SRA Study, Sample, Experiment, or Run accession and FASTQs\nfor all Runs that fall under the given accession will be downloaded. For example, if a Study\naccession is given all Runs under that studies umbrella will be downloaded. By default, \n`fastq-dl` will try to download from ENA first, then SRA.\n\n### --accession\n\nThe accession you would like to download associated FASTQS for. Currently the following types\nof accessions are accepted.\n\n| Accession Type | Prefixes            | Example                                  |\n|----------------|---------------------|------------------------------------------|\n| BioProject     | PRJEB, PRJNA, PRJDB | PRJEB42779, PRJNA480016, PRJDB14838      |\n| Study          | ERP, DRP, SRP       | ERP126685, DRP009283, SRP158268          |\n| BioSample      | SAMD, SAME, SAMN    | SAMD00258402, SAMEA7997453, SAMN06479985 |\n| Sample         | ERS, DRS, SRS       | ERS5684710, DRS259711, SRS2024210        |\n| Experiment     | ERX, DRX, SRX       | ERX5050800, DRX406443, SRX4563689        |\n| Run            | ERR, DRR, SRR       | ERR5260405, DRR421224, SRR7706354        |\n\nThe accessions are using regular expressions from the [ENA Training Modules - Accession Numbers](https://ena-docs.readthedocs.io/en/latest/submit/general-guide/accessions.html#accession-numbers) section.\n\n### --provider\n\n`fastq-dl` gives you the option to download from ENA or SRA. the `--provider` option will\nspecify which provider you would like to attempt downloads from first. If a download fails\nfrom the first provider, additional attempts will be made using the other provider.\n\nENA was selected as the default provider because the FASTQs are available directly without\nthe need for conversion.\n\n### --only-provider\n\nBy default, `fastq-dl` will fallback on a secondary provider to attempt downloads. There\nmay be cases where you would prefer to disable this feature, and that is exactly the\npurpose of `--only-provider`. When provided, if a FASTQ cannot be downloaded from the\noriginal provider, no additional attempts will be made.\n\n### --group-by-experiment & --group-by-sample\n\nThere maybe times you might want to group Run accessions based on a Experiment or Sample\naccessions. This will merge FASTQs associated with a Run accession based its associated\nExperiment accession (`--group-by-experiment`) or Sample accession (`--group-by-sample`).\n\n## Output Files\n\n| Extension          | Description                                                                              |\n|--------------------|------------------------------------------------------------------------------------------|\n| `-run-info.tsv`    | Tab-delimited file containing metadata for each Run downloaded                           |\n| `-run-mergers.tsv` | Tab-delimited file merge information from `--group-by-experiment` or `--group-by-sample` |\n| `.fastq.gz`        | FASTQ files downloaded from ENA or SRA                                                   |\n\n## Example Usage\n\n#### Download FASTQs associated with a Study\n\nSometimes you might be reading a paper and they very kindly provided a Bioproject of all\nthe samples they sequenced. So, you decide you want to download FASTQs for all the samples\nasscociated with the Bioproject. `fastq-dl` can help you with that! \n\n```{bash}\nfastq-dl --accession PRJNA248678 --provider SRA\nfastq-dl --accession PRJNA248678\n```\n\nThe above commands will download the 3 Runs that fall under Study accession [PRJNA248678](https://www.ebi.ac.uk/ena/browser/view/PRJNA248678)\nfrom either SRA (`--provider SRA`) or ENA (without `--provider`).\n\n#### Download FASTQs associated with an Experiment\n\nLet's say instead of the whole Bioproject you just want a single Experiment. You can do\nthat as well.\n\n```{bash}\nfastq-dl --accession SRX477044\n```\n\nThe above command would download the Run accessions from ENA that fall under Experiment SRX477044.\n\nThe relationship of Experiment to Run is a 1-to-many relationship, or there can be many Run accessions\nassociated with a single Experiment Accession (e.g. re-sequencing the same sample). Although in most\ncases, it is a 1-to-1 relationship, you can use `--group-by-experiment` to merge multiple runs\nassociated with an Experiment accession into a single FASTQ file.\n\n#### Download FASTQs associated with an Sample\n\nOk, this time you just want a single Sample, or Biosample.\n\n```{bash}\nfastq-dl --accession SRS1904245 --provider SRA\n```\n\nThe above command would download the Run accessions from SRA that fall under Sample SRS1904245.\n\nSimilar to Experiment accessions, the relationship of Sample to Run is a 1-to-many relationship,\nor there can be many Run accessions associated with a single Sample Accession. Although in most\ncases, it is a 1-to-1 relationship, you can use `--group-by-sample` to merge multiple runs\nassociated with an Sample accession into a single FASTQ file.\n\n_Warning! For some type strains (e.g. S. aureus USA300) a Biosample accession might be associated with\n100s or 1000s of Run accessions. These Runs are likely associated with many different conditions and\nreally should not fall under a single BioSample accession. Please consider this when using\n`--group-by-sample`.\n\n#### Download FASTQs associated with a Run\n\nLet's keep it super simple and just download a Run.\n\n```\nfastq-dl --accession SRR1178105 --provider SRA\n```\n\nThe above command would download the Run SRR1178105 from SRA. Run accessions are the end of the\nline (1-to-1 relationship), so you will always get the expected Run.\n\n## Alternatives\n`fastq-dl`, is a spin-off of [ena-dl](https://github.com/rpetit3/ena-dl), that has been developed for\nusage with [Bactopia](https://github.com/bactopia/bactopia). With this in mind, EBI/NCBI and provide\ntheir own tools ([enaBrowserTools](https://github.com/enasequence/enaBrowserTools) and\n[SRA Toolkit](https://github.com/ncbi/sra-tools)) that offer more extensive access to their databases.\n",
    'author': 'Robert A. Petit III',
    'author_email': 'robbie.petit@gmail.com',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'https://github.com/rpetit3/fastq-dl',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.7.1,<4.0.0',
}


setup(**setup_kwargs)
