<div align="center">
  <img src="images/icevision-logo-slogan.png" alt="logo" width="400px" style="display: block; margin-left: auto; margin-right: auto"/>
  <h2><b>An Agnostic Object Detection Framework</b></h2>
</div>

* * * * *
>**Note: "We Need Your Help"**
    If you find this work useful, please let other people know by **starring** it,
    and sharing it. 
    Thank you!
    
<div align="center">
    
[![tests](https://github.com/airctic/icevision/workflows/tests/badge.svg?event=push)](https://github.com/airctic/icevision/actions?query=workflow%3Atests)
[![docs](https://github.com/airctic/icevision/workflows/docs/badge.svg)](https://airctic.com)
[![codecov](https://codecov.io/gh/airctic/icevision/branch/master/graph/badge.svg)](https://codecov.io/gh/airctic/icevision)
[![PyPI version](https://badge.fury.io/py/icevision.svg)](https://badge.fury.io/py/icevision)
[![Downloads](https://pepy.tech/badge/icevision)](https://pepy.tech/project/icevision)

[![black](https://img.shields.io/badge/code%20style-black-000000.svg)](https://github.com/psf/black)
[![license](https://img.shields.io/badge/License-Apache%202.0-blue.svg)](https://github.com/airctic/icevision/blob/master/LICENSE)
[![Discord](https://img.shields.io/discord/735877944085446747?label=Discord&logo=Discord)](https://discord.gg/2jqrwrQ)

</div>


* * * * *

![image](images/icevision-end-to-end-training.gif)

<!-- Not included in docs - start -->
## **Contributors**

[![](https://sourcerer.io/fame/lgvaz/airctic/icevision/images/0)](https://sourcerer.io/fame/lgvaz/airctic/icevision/links/0)[![](https://sourcerer.io/fame/lgvaz/airctic/icevision/images/1)](https://sourcerer.io/fame/lgvaz/airctic/icevision/links/1)[![](https://sourcerer.io/fame/lgvaz/airctic/icevision/images/2)](https://sourcerer.io/fame/lgvaz/airctic/icevision/links/2)[![](https://sourcerer.io/fame/lgvaz/airctic/icevision/images/3)](https://sourcerer.io/fame/lgvaz/airctic/icevision/links/3)[![](https://sourcerer.io/fame/lgvaz/airctic/icevision/images/4)](https://sourcerer.io/fame/lgvaz/airctic/icevision/links/4)[![](https://sourcerer.io/fame/lgvaz/airctic/icevision/images/5)](https://sourcerer.io/fame/lgvaz/airctic/icevision/links/5)[![](https://sourcerer.io/fame/lgvaz/airctic/icevision/images/6)](https://sourcerer.io/fame/lgvaz/airctic/icevision/links/6)[![](https://sourcerer.io/fame/lgvaz/airctic/icevision/images/7)](https://sourcerer.io/fame/lgvaz/airctic/icevision/links/7)

## Installation

```bash
pip install icevision[all]
```

For more installation options, check our [docs](https://airctic.github.io/icevision/install/).

**Important:** We currently only support Linux/MacOS.
<!-- Not included in docs - end -->


## Why IceVision?

- IceVision is an Object-Detection Framework that connects to different libraries/frameworks such as Fastai, Pytorch Lightning, and Pytorch with more to come.

- Features a Unified Data API with out-of-the-box support for common annotation formats (COCO, VOC, etc.)

- The [IceData repo](https://github.com/airctic/icedata) hosts community maintained parsers and custom datasets 

- Provides flexible model implementations with pluggable backbones

- Helps researchers reproduce, replicate, and go beyond published models

- Enables practioners to get moving with object detection technology quickly


## Quick Example: How to train the **PETS Dataset**
[**Source Code**](https://airctic.github.io/icevision/examples/training/)
![image](images/icevision-readme.png)


## Happy Learning!
If you need any assistance, feel free to:

[Join our Forum](https://discord.gg/JDBeZYK)