"use strict";
// Copyright (c) cdr4eelz
// Distributed under the terms of the Modified BSD License.
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
const base_1 = require("@jupyter-widgets/base");
const version_1 = require("./version");
// Import the CSS
require("../css/widget.css");
const utils = __importStar(require("@jupyter-widgets/base"));
const coreutils_1 = require("@lumino/coreutils");
const webseriallink_1 = require("./webseriallink");
class SerialHubModel extends base_1.DOMWidgetModel {
    defaults() {
        return Object.assign(Object.assign({}, super.defaults()), { _model_name: SerialHubModel.model_name, _model_module: SerialHubModel.model_module, _model_module_version: SerialHubModel.model_module_version, _view_name: SerialHubModel.view_name, _view_module: SerialHubModel.view_module, _view_module_version: SerialHubModel.view_module_version, value: 'serial-on-your-hub', xtra: 'font-weight: bolder' });
    }
}
exports.SerialHubModel = SerialHubModel;
SerialHubModel.mytempid = utils.uuid();
SerialHubModel.serializers = Object.assign({}, base_1.DOMWidgetModel.serializers);
SerialHubModel.model_name = 'SerialHubModel';
SerialHubModel.model_module = version_1.MODULE_NAME;
SerialHubModel.model_module_version = version_1.MODULE_VERSION;
SerialHubModel.view_name = 'SerialHubView'; // Set to null if no view
SerialHubModel.view_module = version_1.MODULE_NAME; // Set to null if no view
SerialHubModel.view_module_version = version_1.MODULE_VERSION;
class SerialHubView extends base_1.DOMWidgetView {
    render() {
        this.el.id = coreutils_1.UUID.uuid4();
        this.el.classList.add('xx-serialhub-widget');
        this.el.onclick = (ev) => this.clickme(ev);
        this.value_changed();
        this.xtra_changed();
        this.model.on('change:value', this.value_changed, this);
        this.model.on('change:xtra', this.xtra_changed, this);
    }
    value_changed() {
        this.el.textContent = this.model.get('value');
    }
    xtra_changed() {
        this.el.style = this.model.get('xtra');
    }
    clickme(ev) {
        console.log(this, arguments);
        console.log(this.model);
        this.model.set('value', 'newvalue');
        this.touch();
        webseriallink_1.SerialHubPort.test();
    }
}
exports.SerialHubView = SerialHubView;
//# sourceMappingURL=widget.js.map