"use strict";
// Copyright (c) cdr4eelz
// Distributed under the terms of the Modified BSD License.
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
class SerialHubPort {
    constructor(oldSP) {
        if (oldSP)
            oldSP.disconnect(); //Dispose of prior "port" if passed to us
        this.port = null;
        this.outputStream = null;
        this.outputDone = null;
        this.inputStream = null;
        this.inputDone = null;
        this.reader = null;
    }
    connect() {
        return __awaiter(this, void 0, void 0, function* () {
            if (this.port) {
                yield this.disconnect();
            }
            if (!SerialHubPort.NAV.serial)
                return;
            const filter = { usbVendorId: 0x2047 }; // TI proper ; unused 0x0451 for "TUSB2046 Hub"
            let rawPort = yield SerialHubPort.NAV.serial.requestPort({ filters: [filter] });
            if (!rawPort)
                return;
            this.port = rawPort;
            yield this.port.open({ baudrate: 115200 });
            const encoder = new TextEncoderStream();
            this.outputDone = encoder.readable.pipeTo(this.port.writable);
            this.outputStream = encoder.writable;
            let decoder = new TextDecoderStream();
            this.inputDone = this.port.readable.pipeTo(decoder.writable);
            this.inputStream = decoder.readable;
            this.reader = this.inputStream.getReader();
            console.log("CONNECT: ", this);
            this.readLoop();
        });
    }
    disconnect() {
        return __awaiter(this, void 0, void 0, function* () {
            console.log("CLOSE: ", this);
            if (this.reader) {
                yield this.reader.cancel();
                if (this.inputDone)
                    yield this.inputDone.catch(() => { });
                this.reader = null;
                this.inputDone = null;
            }
            if (this.outputStream) {
                yield this.outputStream.getWriter().close();
                yield this.outputDone;
                this.outputStream = null;
                this.outputDone = null;
            }
            if (this.port) {
                yield this.port.close();
                this.port = null;
            }
        });
    }
    writeToStream(...lines) {
        if (!this.outputStream)
            return;
        const writer = this.outputStream.getWriter();
        lines.forEach(line => {
            console.log("[SEND]", line);
            writer.write(line + "\n");
        });
        writer.releaseLock();
    }
    readLoop() {
        return __awaiter(this, void 0, void 0, function* () {
            while (true) {
                if (!this.reader)
                    break;
                const { value, done } = yield this.reader.read();
                if (value) {
                    console.log("[readLoop] VALUE", value);
                    //let CC=Backbone.$("#custom-custom")[0];
                    //if (CC) CC.innerText += value;
                }
                if (done) {
                    console.log("[readLoop] DONE", done);
                    this.reader.releaseLock();
                    break;
                }
            }
        });
    }
    static test() {
        let W = window;
        W.serPort = new SerialHubPort(W.serPort);
        W.P1 = W.serPort.connect().then((val) => {
            console.log(val);
            W.serPort.writeToStream("1");
        });
    }
}
exports.SerialHubPort = SerialHubPort;
SerialHubPort.NAV = window.navigator;
//# sourceMappingURL=webseriallink.js.map