# jupyterlab-ui-profiler

[![Github Actions Status](https://github.com/jupyterlab/ui-profiler/workflows/Build/badge.svg)](https://github.com/jupyterlab/ui-profiler/actions/workflows/build.yml)
[![Binder](https://mybinder.org/badge_logo.svg)](https://mybinder.org/v2/gh/jupyterlab/ui-profiler/main?urlpath=lab)
[![Documentation Status](https://readthedocs.org/projects/ui-profiler/badge/?version=latest)](http://ui-profiler.readthedocs.io/en/latest/)

JupyterLab extension for profiling UI performance.

![UI Profiler UI](https://raw.githubusercontent.com/jupyterlab/ui-profiler/main/ui-tests/tests/results.spec.ts-snapshots/ui-profiler-with-boxplot-linux.png)

You can find more information in our [User Guide](http://ui-profiler.readthedocs.io/en/latest/en/user_guide.html).

Note: when this extension is enabled, the server will return additional headers:

- to allow high-precision `performance.now()` measurements in Firefox 79+:

  ```
  Cross-Origin-Opener-Policy: same-origin,
  Cross-Origin-Embedder-Policy: require-corp
  ```

- to enable JavaScript self-profiling in Chrome:
  ```
  Document-Policy: js-profiling
  ```

If this is undesirable in your deployment, but you still want to use the profiler without these functions,
you can disable the server extension which sets these headers with:

```
jupyter server extension disable jupyterlab_ui_profiler
```

## Requirements

- JupyterLab >= 3.0

## Install

To install the extension, execute:

```bash
pip install jupyterlab-ui-profiler
```

## Uninstall

To remove the extension, execute:

```bash
pip uninstall jupyterlab-ui-profiler
```

## Contributing

### Development install

Note: You will need NodeJS to build the extension package.

The `jlpm` command is JupyterLab's pinned version of
[yarn](https://yarnpkg.com/) that is installed with JupyterLab. You may use
`yarn` or `npm` in lieu of `jlpm` below.

```bash
# Clone the repo to your local environment
# Change directory to the jupyterlab-ui-profiler directory
# Install package in development mode
pip install -e .
# Link your development version of the extension with JupyterLab
jupyter labextension develop . --overwrite
# Rebuild extension Typescript source after making changes
jlpm build
```

You can watch the source directory and run JupyterLab at the same time in different terminals to watch for changes in the extension's source and automatically rebuild the extension.

```bash
# Watch the source directory in one terminal, automatically rebuilding when needed
jlpm watch
# Run JupyterLab in another terminal
jupyter lab
```

With the watch command running, every saved change will immediately be built locally and available in your running JupyterLab. Refresh JupyterLab to load the change in your browser (you may need to wait several seconds for the extension to be rebuilt).

By default, the `jlpm build` command generates the source maps for this extension to make it easier to debug using the browser dev tools. To also generate source maps for the JupyterLab core extensions, you can run the following command:

```bash
jupyter lab build --minimize=False
```

### Development uninstall

```bash
pip uninstall jupyterlab-ui-profiler
```

In development mode, you will also need to remove the symlink created by `jupyter labextension develop`
command. To find its location, you can run `jupyter labextension list` to figure out where the `labextensions`
folder is located. Then you can remove the symlink named `@jupyterlab/ui-profiler` within that folder.

### Testing the extension

#### Frontend tests

This extension is using [Jest](https://jestjs.io/) for JavaScript code testing.

To execute them, execute:

```sh
jlpm
jlpm test
```

#### Integration tests

This extension uses [Playwright](https://playwright.dev/docs/intro/) for the integration tests (aka user level tests).
More precisely, the JupyterLab helper [Galata](https://github.com/jupyterlab/jupyterlab/tree/master/galata) is used to handle testing the extension in JupyterLab.

More information are provided within the [ui-tests](https://github.com/jupyterlab/ui-profiler/main/ui-tests/README.md) README.

### Documentation

To build locally:

```
make -C docs/ html SPHINXOPTS="-W"
```

To build in watch mode:

```
sphinx-autobuild docs/source docs/build/html
```

### Packaging the extension

See [RELEASE](https://github.com/jupyterlab/ui-profiler/main/RELEASE.md)
