from setuptools import setup, find_packages
from codecs import open
from os import path

here = path.abspath(path.dirname(__file__))

# Get the long description from the README file
with open(path.join(here, 'README.rst'), encoding='utf-8') as f:
    long_description = f.read()

setup(
    name='mljar',
    version='0.0.9',
    description='Python wrapper over MLJAR API',
    long_description=long_description,
    url='https://github.com/mljar/mljar-api-python',
    author='Piotr Plonski',
    author_email='contact@mljar.com',
    license='Apache-2.0',
    packages=find_packages(exclude=["*.tests", "*.tests.*", "tests.*", "tests"]),
    install_requires=['requests', 'marshmallow'],
    classifiers=[
        'Programming Language :: Python',
        'Programming Language :: Python :: 2.7',
        'Programming Language :: Python :: 3.6'
    ]
)
