SECAT: Size-Exclusion Chromatography Algorithmic Toolkit
============

*SECAT* is an algorithm for the network-centric data analysis of SEC-SWATH-MS data. The tool is implemented as a multi-step command line application.

Dependencies
------------

*SECAT* depends on several Python packages (listed in ``setup.py``). SECAT has been tested on Linux (CentOS 7) and macOS (10.14) operating systems and might run on other versions too.

Installation
------------

We strongly advice to install *SECAT* in a Python [*virtualenv*](https://virtualenv.pypa.io/en/stable/). *SECAT* is compatible with Python 3.7 and higher and installation should require a few minutes with a correctly set-up Python environment.

Install the development version of *SECAT* from GitHub:

````
pip install git+https://github.com/grosenberger/secat.git@master
````

Install the stable version of *SECAT* from the Python Package Index (PyPI):

````
pip install secat
````

You can alternatively create a `conda` environment with SECAT. First create a new conda environment and install python, numpy and pip.

```
conda create -n secat python=3.10.8 numpy pip -y
```

Activate the secat environment
```
conda activate secat
```

Install secat and its dependencies.
```
pip install secat
```

Docker
------

SECAT is also available from [Dockerhub](https://hub.docker.com/repository/docker/grosenberger/secat):

````
docker pull grosenberger/secat:latest # "latest" can be replaced by the version number, e.g. "1.0.4"
````

You can also build the Docker image on your machine with the command below. Again, make sure you are at the root level of this repository when executing this command. When building locally, feel free to replace the part after `-t` with anything you find convenient. This is simply a tag to easily identify the Docker container on your machine. Here it is tagged as `grosenberger/secat:latest` to remain interoperable with the other instructions in the `README.md`.

```
docker build . -t grosenberger/secat:latest
```

Print the installed Python versions:

````
docker run --name secat --rm -v $PWD:/data -i -t grosenberger/secat:latest pip list
````

Run SECAT:

````
docker run --name secat --rm -v $PWD:/data -i -t grosenberger/secat:latest secat --help
````

Running SECAT
-------------

SECAT requires 1-4h running time with a SEC-SWATH-MS data set of two conditions and three replicates each, covering about 5,000 proteins and 80,000 peptides on a typical desktop computer with 4 CPU cores and 16GB RAM.

The exemplary input data (``HeLa-CC.tgz`` and ``Common.tgz`` are required) can be found on Zenodo: [![DOI](https://zenodo.org/badge/DOI/10.5281/zenodo.3515928.svg)](https://doi.org/10.5281/zenodo.3515928)

The data set includes the expected output as SQLite-files. Note: Since the ``PyProphet`` semi-supervised learning step is initialized by a randomized seed, the output might vary slightly from run-to-run with numeric deviations. To completely reproduce the results, the pretrained PyProphet classifier can be applied to as described in the ``secat learn`` step. The Zenodo repository contains all parameters and instructions to reproduce the SECAT analysis results of the other data sets.

*SECAT* consists of the following steps:


**1. Data preprocessing**

The primary input for SECAT are quantitative, proteotypic/unique peptide-level profiles, e.g. acquired by SEC-SWATH-MS. The input can be supplied either as matrix (protein, peptide and run-wise peptide intensities columns) or as transposed long list. Protein identifiers need to be provided in UniProtKB/Swiss-Prot format. The column names can be freely specified (``secat preprocess --columns``; see help for a complete description).

The second required input file represents the experimental design and molecular weight calibration of the experiment. The primary column covers the run identifiers (matching the quantitative profiles above), with additional columns for SEC fraction identifiers (integer value), SEC molecular weight (float value), a group condition identifier (freetext value) and a replicate identifier (freetext value). The column names can be freely specified (``secat preprocess --columns``; see help for a complete description).

The third required file covers UniProtKB/Swiss-Prot meta data in XML format, matching the proteome, and can be obtained from [UniProt](https://www.uniprot.org/downloads).

Optionally, reference PPI networks can be specified to support semi-supervised learning and to restrict the peptide query space. SECAT can accept three files: A positive reference network and a negative reference network for the learning steps and a separate reference network to restrict the query space. SECAT natively supports HUPO-PSI MITAB (2.5-2.7), STRING-DB, BioPlex and PrePPI formats and provides filtering options to optionally exclude lower confidence PPIs. The inverted CORUM reference PPI network was generated by using the inverted set of PPI (i.e. all possible PPI that are not covered by CORUM) and removing all PPI in this set covered by STRING, IID, PrePPI or BioPlex.

The Zenodo archives linked above contain example files and parameter sets for all described analyses and can be used to test the algorithm and reproduce the results.

First, the input quantitative proteomics matrix and parameters are preprocessed to a single file:

````
secat preprocess
--out=hela_string.secat \ # Output filename
--sec=input/hela_sec_mw.csv \ # SEC annotation file
--net=common/9606.protein.links.v11.0.txt.gz \ # Reference PPI network
--posnet=common/corum_targets.txt.gz \ # Reference positive interaction network for learning
--negnet=common/corum_decoys.txt.gz \ # Reference negative interaction network for learning
--uniprot=common/uniprot_9606_20190402.xml.gz \ # Uniprot reference XML file
--min_interaction_confidence=0 # Minimum interaction confidence
input/pep*.tsv \ # Input data files
````

**2. Signal processing**

Next, the signal processing is conducted in a parallelized fashion:

````
secat score --in=hela_string.secat --threads=8
````

**3. PPI detection**

The statistical confidence of the PPI is evaluated by machine learning:

````
secat learn --in=hela_string.secat --threads=5
````

**4. PPI quantification**

Quantitative features are generated for all PPIs and proteins:

````
secat quantify --in=hela_string.secat --control_condition=inter
````

**5. Export of results**

CSV tables can be exported for import in downstream tools, e.g. Cytoscape:

````
secat export --in=hela_string.secat
````

**6. Plotting of chromatograms**

PDF reports can be generated for the top (or selected) results:

````
secat plot --in=hela_string.secat
````

**7. Report of statistics**

Statistics reports can be generated for the top (or selected) results:

````
secat statistics --in=hela_string.secat
````

**Further options and default parameters**

All options and the default parameters can be displayed by:
````
secat --help
secat preprocess --help
secat score --help
secat learn --help
secat quantify --help
secat export --help
secat plot --help
secat statistics --help
````
