from pathlib import Path
import pandas as pd
import numpy as np
import subprocess
import cloudpickle

# Centralized output dirs
PNG_DIR = Path('pngs')
DATA_DIR = Path('data')
FP_DATA_DIR = DATA_DIR / 'fault_prevention'
FT_DATA_DIR = DATA_DIR / 'fault_tolerance'
FR_DATA_DIR = DATA_DIR / 'fault_recovery'

PNG_DIR.mkdir(exist_ok=True, parents=True)
DATA_DIR.mkdir(exist_ok=True, parents=True)
FP_DATA_DIR.mkdir(exist_ok=True, parents=True)
FT_DATA_DIR.mkdir(exist_ok=True, parents=True)
FR_DATA_DIR.mkdir(exist_ok=True, parents=True)

# Fixed configuration
LOGS_DIR = "/users/jzhou24/afs/taskvine-report-tool/logs/"
EXPERIMENT = "fault_tolerance"
REPEAT_IDS = [1, 2, 3]
WORKFLOWS = ["TopEFT", "RSTriPhoton", "DV5"]


FP_TEMPLATES = ["baseline",
				"disk-load-balance",
				"priority-mode-random", "priority-mode-largest-input-first"]
FT_TEMPLATES = ["baseline",
				"prune-depth-2", "prune-depth-3", "prune-depth-4", "prune-depth-5", "prune-depth-6",
				"replica-count-2", "replica-count-3", "replica-count-4", "replica-count-5", "replica-count-6",
				"checkpoint-percentage-0.1", "checkpoint-percentage-0.2", "checkpoint-percentage-0.3",
				"checkpoint-percentage-0.4", "checkpoint-percentage-0.5", "checkpoint-percentage-0.6",
				"checkpoint-percentage-0.7", "checkpoint-percentage-0.8", "checkpoint-percentage-0.9",
				"checkpoint-percentage-1.0",]
FT_TEMPLATES = ["baseline"]
FT_HYBRID_TEMPLATES = ["PD2-RC2-CP0.1", "PD3-RC3-CP0.2", "PD4-RC4-CP0.3",]
FR_TEMPLATES = ["baseline",
				"immediate-recovery"]


def get_all_templates(experiment="fault_tolerance"):
	all_templates_absolute_paths = []
	for wf in WORKFLOWS:
		for rid in REPEAT_IDS:
			if experiment == "fault_tolerance":
				for template in FT_TEMPLATES:
					all_templates_absolute_paths.append(Path(LOGS_DIR) / experiment / wf / f"repeat{rid}" / template)
			elif experiment == "fault_prevention":
				for template in FP_TEMPLATES:
					all_templates_absolute_paths.append(Path(LOGS_DIR) / experiment / wf / f"repeat{rid}" / template)
			elif experiment == "fault_recovery":
				for template in FR_TEMPLATES:
					all_templates_absolute_paths.append(Path(LOGS_DIR) / experiment / wf / f"repeat{rid}" / template)
			else:
				raise ValueError(f"Unknown experiment: {experiment}")
	return all_templates_absolute_paths

