"""
Layout items for Foundation components.

Inherits from the default **crispy_forms** layout objects to force templates on
the right ``TEMPLATE_PACK`` (defined from ``settings.CRISPY_TEMPLATE_PACK``)
and implements Foundation components.
"""
from __future__ import absolute_import

from .base import (
    PrependedAppendedText,
    AppendedText,
    PrependedText,
    FormActions,
    InlineCheckboxes,
    InlineRadios,
    Container,
    ContainerHolder,
    Tab,
    TabHolder,
    AccordionGroup,
    Accordion,
    Alert,
)


__all__ = [
    "PrependedAppendedText",
    "AppendedText",
    "PrependedText",
    "FormActions",
    "InlineCheckboxes",
    "InlineRadios",
    "FieldWithButtons",
    "StrictButton",
    "Container",
    "ContainerHolder",
    "Tab",
    "TabHolder",
    "Accordion",
    "AccordionGroup",
    "Alert",
]
