# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['autorequests',
 'autorequests.lib',
 'autorequests.parsing',
 'autorequests.utilities']

package_data = \
{'': ['*']}

install_requires = \
['rich>=10.0.0,<11.0.0']

entry_points = \
{'console_scripts': ['autorequests = autorequests:main']}

setup_kwargs = {
    'name': 'autorequests',
    'version': '1.1.1',
    'description': 'Automatically create a simple Python API wrapper from request data generated by your browser',
    'long_description': '<h1 align=center>AutoRequests</h1>\n<p align=center>\n  <span>Automatically create a simple Python API wrapper from request data generated by your browser</span>\n  <br>\n\n  <a title="PyPI - Version" href="https://pypi.org/project/autorequests/" target="_blank">\n    <img src="https://img.shields.io/pypi/v/autorequests?color=390099&style=for-the-badge"/>\n  </a>\n\n  <a title="PyPI - Python Version" href="https://www.python.org/downloads/" target="_blank">\n     <img src="https://img.shields.io/pypi/pyversions/autorequests?color=B80068&style=for-the-badge&logo=python&logoColor=fff"/>\n  </a>\n\n  <a title="License - MIT" href="LICENSE" target="_blank">\n    <img src="https://img.shields.io/github/license/Hexiro/autorequests?style=for-the-badge&color=390099&labelColor=474747">\n  </a>\n\n  <img alt="GitHub Workflow Status" src="https://img.shields.io/github/workflow/status/Hexiro/autorequests/tests?logo=github&style=for-the-badge&label=tests">\n  <br>\n</p>\n\n### 📺 Demo\n\n<img alt="Demo" src="https://user-images.githubusercontent.com/42787085/137994635-cadbafad-4371-4c22-892a-7e9a82785c56.gif"/>\n\n### 💼 Example Use Cases\n\n* Creating a foundation for an API wrapper\n* Recreating a request outside the browser\n* Testing what cookies or headers are required for a server to understand your request\n\n### ✂️ How to Copy\n\n1. Inspect Element\n2. Go to `Network` tab\n3. Find web request\n4. Right-Click\n5. Copy\n6. Choose one of the following:\n    1. Powershell\n    2. Node.js fetch\n\n## 📦 Installation\n\ninstall the package with pip\n\n```\n$ pip install autorequests\n```\n\nor download the latest development build from GitHub\n\n```\n$ pip install -U git+https://github.com/Hexiro/autorequests\n```\n\n## 🖥️ Command Line\n\n```console\n$ autorequests --help\n```\n\ndirectory options\n\n```console\n  -i, --input           Input Directory\n  -o, --output          Output Directory\n```\n\ngeneration options\n\n```\n  --return-text         Makes the generated method\'s responses return .text instead of .json()\n  --no-headers          Removes all headers from the operation\n  --no-cookies          Removes all cookies from the operation\n  --parameters          Replaces hardcoded params, json, data, etc with parameters that have default values\n```\n\n## 🚩 Known Issues\n\n* Method names are parsed from the url, but if the URL doesn\'t have any paths with a valid method name, an invalid\n  method name will be used.\n* Sometimes when copying from the browser, important headers aren\'t included which causes the resulting API wrapper to\n  fail requests.\n* Parsing multipart/form-data when copying with the powershell mode isn\'t supported\n\n## 🐞 Contributing\n\nsee [CONTRIBUTING.md](./CONTRIBUTING.md)\n\n## 📅 # TODO\n\n* better unit test coverage\n* more cli options\n* better cli output',
    'author': 'Hexiro',
    'author_email': None,
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/Hexiro/autorequests',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.6,<4.0',
}


setup(**setup_kwargs)
