# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['anyrepo', 'anyrepo._cli']

package_data = \
{'': ['*']}

install_requires = \
['appdirs>=1.4.4,<2.0.0',
 'click>=8.0.0,<9.0.0',
 'coloredlogs>=15.0.1,<16.0.0',
 'pydantic>=1.10.0,<2.0.0',
 'tomlkit>=0.11.5,<1.0.0']

entry_points = \
{'console_scripts': ['anyrepo = anyrepo._cli:main']}

setup_kwargs = {
    'name': 'anyrepo',
    'version': '0.5.0',
    'description': 'Multi Repository Management Tool',
    'long_description': '[![pypi-version](https://badge.fury.io/py/anyrepo.svg)](https://badge.fury.io/py/anyrepo)\n[![pypi-downloads](https://img.shields.io/pypi/dm/anyrepo.svg?label=pypi%20downloads)](https://pypi.python.org/pypi/anyrepo)\n[![doc](https://readthedocs.org/projects/anyrepo/badge/?version=latest)](https://anyrepo.readthedocs.io/en/latest/?badge=latest)\n[![Coverage Status](https://coveralls.io/repos/github/c0fec0de/anyrepo/badge.svg?branch=main)](https://coveralls.io/github/c0fec0de/anyrepo?branch=main)\n[![python-versions](https://img.shields.io/pypi/pyversions/anyrepo.svg)](https://pypi.python.org/pypi/anyrepo)\n[![pylint](https://img.shields.io/badge/linter-pylint-%231674b1?style=flat)](https://www.pylint.org/)\n[![black](https://img.shields.io/badge/code%20style-black-000000.svg)](https://github.com/psf/black)\n\n# Multi Repository Management Tool\n\n* [Installation](#installation)\n* [Usage](#usage)\n* [Cheat-Sheet](#cheatsheet)\n* [Python API](#api)\n* [Alternatives](#alternatives)\n\nAnyRepo is a lightweight tool for creating and managing *workspaces* consisting of several interdependent `git` repositories. Starting from a *main repository*, AnyRepo discovers dependencies specified in a *manifest file*, fetching any specified required repositories and assembling them into a single workspace.\n\n![Workspace](https://github.com/c0fec0de/anyrepo/raw/main/docs/images/workspace.png)\n\n👉 You can read more about the used [nomenclature](https://anyrepo.readthedocs.io/en/latest/manual/nomenclature.html) in the [documentation](https://anyrepo.readthedocs.io/en/latest/index.html).\n\n\n<a name="installation"/>\n\n# 📦 Installation\n\nAnyRepo is written in Python and - as usual - installing it is pretty easy:\n\n```bash\npip install anyrepo\n```\n\nAnd that\'s it! Ideally, if your project also uses Python, we recommend adding AnyRepo as a dependency to it as well, so that you can track the exact version of it together with your other dependencies. For example, if you use `poetry`, add it by running\n\n```bash\n# Add AnyRepo as development dependency:\npoetry add --group dev anyrepo\n```\n\n\n<a name="usage"/>\n\n# 📔 Usage\n\nAnyRepo comes with a command line client called `anyrepo` - this is what you will be using most of the time.\n\nLet\'s assume we have a project called `myapp`, which requires a library `mylib` that is maintained in another `git` repository. In order to use this project with AnyRepo, `myapp` needs to provide a so called *manifest*. An AnyRepo manifest is a simple [TOML](https://toml.io/) file - by default called `anyrepo.toml` in the project\'s root folder - which defines the dependencies a project has as well as some other meta information. A minimal manifest for our project could look like this:\n\n```toml\n[[dependencies]]\nname = "mylib"\nurl = "git@github.com:example/mylib.git"\nrevision = "v2.3.4"\n```\n\nIf `myapp` and `mylib` are stored on the same server (side-by-side), than the manifest can even be simpler:\n\n```toml\n[[dependencies]]\nname = "mylib"\nrevision = "v2.3.4"\n```\n\nThe project will be searched via a relative path (which is either `../mylib` or `../mylib.git` depending on the main repository\'s URL). Relative paths are in general useful as they allow to use the same protocol for the main repository as well as any of its dependencies.\n\nTo build a workspace from a project prepared like that, simply clone it via `anyrepo`:\n\n```bash\ncd $HOME/Projects\nmkdir my_app_workspace\ncd my_app_workspace\nanyrepo clone --update git@github.com:example/myapp.git\n```\n\n👉 Without the `--update` option, only the main repository will be fetched.\n\nThe above will clone the app repository and also the library side-by-side:\n\n```bash\nls -a\n# Should print something like\n# . .. .anyrepo myapp mylib\n```\n\nAs you can see, besides the two repositories we wanted, there is also a hidden `.anyrepo` folder where the tool stores the needed configuration data.\n\nSometimes there are use cases where using `anyrepo clone` cannot be used. For example, when a CI/CD system creates the initial clone of the main repository, you may need a way to fetch the remaining projects. This can be done by simply running the following within the main project:\n\n```bash\nanyrepo init --update\n```\n\n👉 As with `anyrepo clone`, without the `--update`, no dependencies will be fetched.\n\nAnother important use case is keeping a workspace up-to-date. Lets say you pull in an update in the main repository, which in turn might cause changes in the manifest to be pulled in as well. Updating the existing workspace is as simple as\n\n```bash\n# Update the workspace (main and all dependent repositories):\nanyrepo update\n\n# Alternatively, run `git rebase` instead of `git pull` in dependencies:\nanyrepo update --rebase\n```\n<a name="cheatsheet"/>\n\n## Cheat-Sheet\n\n| Command | Description |\n| --- | --- |\n| `anyrepo clone URL` | Clone git repository from `URL` as main repository and initialize AnyRepo workspace |\n| `anyrepo init` | Initialize AnyRepo workspace. Use existing git clone as main repository |\n| `anyrepo manifest create` | Create well documented, empty manifest |\n| `anyrepo update` | Pull latest changes on main repository and all dependent repositories (and clone them if needed) |\n| `anyrepo update --rebase` | Same as above, but fetch and rebase instead |\n| `anyrepo status` | Run `git status` on all repositories (displayed paths include the actual clone path) |\n| `anyrepo add FILES` | Run `git add FILE` on `FILES` in the corresponding repositories |\n| `anyrepo reset FILES` | Run `git reset FILE` on `FILES` in the corresponding repositories. Undo `git add` |\n| `anyrepo commit FILES -m MESSAGE` | Run `git commit FILE` on `FILES` in the corresponding repositories |\n| `anyrepo checkout FILES` | Run `git checkout FILE` on `FILES` in the corresponding repositories |\n| `anyrepo checkout` | Checkout git revision specified as specified in the manifests |\n| `anyrepo push` | Run `git push` on all repositories |\n| `anyrepo fetch` | Run `git fetch` on all repositories |\n| `anyrepo rebase` | Run `git rebase` on all repositories |\n| `anyrepo pull` | Run `git pull` on all repositories |\n| `anyrepo diff` | Run `git diff` on all repositories |\n| `anyrepo git CMD` | Run `git CMD` on all repositories |\n| `anyrepo foreach CMD` | Run `CMD` on all repositories |\n| `anyrepo manifest freeze` | Print The Resolved Manifest With SHAs For All Project Revisions |\n| `anyrepo manifest resolve` | Print The Manifest With All Imports Resolved |\n\n<a name="api"/>\n\n## 🐍 Python API\n\nAnyRepo is written in Python. Besides the `anyrepo` command line tool, there is also an API which you can use to further automate workspace creation and maintenance. If you are interested, have a look into the [API documentation](https://anyrepo.readthedocs.io/en/latest/api/anyrepo.html).\n\n\n<a name="alternatives"/>\n\n## 🤝 Alternatives\n\nBefore writing AnyRepo, we investigates several other existing tools in the hope they would fulfil out needs. In particular, we looked into the following tools and methodologies which are widely used to organize large projects:\n\n- [`git submodules`](https://git-scm.com/book/en/v2/Git-Tools-Submodules).\n- Google\'s [repo](https://gerrit.googlesource.com/git-repo/) tool.\n- The [`west`](https://docs.zephyrproject.org/latest/develop/west/index.html) tool developed in the scope of [Zephyr](https://www.zephyrproject.org/).\n- Leaving the pure `git` domain, one can also use a package manager like [`conan`](https://conan.io/).\n- And lastly, there are also approaches to still pack everything into a large so called *monorepo*.\n\nUnfortunately, none of the tools we tested really satisfied us. But hey, as we are developers - *why not starting our own tool for the purpose?*\n\nAnd that\'s what we did - AnyRepo is a our tool for managing a large workspace consisting of several smaller `git` projects. Here is how it compares to the other tools we evaluated:\n\n\n|                           | `git submodules` | `repo` | `west` | *Monorepos* | *AnyRepo* |\n| ------------------------- | ---------------- | ------ | ------ | ----------- | --------- |\n| Reusable Components       | ✅               | ✅     | ✅     | ➖          | ✅        |\n| Ease of Use               | ➖               | ✅     | ✅     | ✅          | ✅        |\n| Editable Components       | ➖               | ✅     | ➖     | ✅          | ✅        |\n| Freezing Configurations   | ✅               | ✅     | ✅     | ✅          | ✅        |\n| Transitive Dependencies   | ➖               | ➖     | ✅     | ➖          | ✅        |\n| Relative Dependency Paths | ✅               | ✅     | ➖     | ➖          | ✅        |\n\n👉 Please note that our view on the various features might be biased. As we did, always look at all the options available to you before deciding for one tool or the other. While the other tools in comparison did not model what we needed for our workflow, they might just be what you are looking for.\n\nIf you want to learn more, have a look into the [documentation](https://anyrepo.readthedocs.io/en/latest/manual/why.html).\n\n',
    'author': 'c0fec0de',
    'author_email': 'c0fec0de@gmail.com',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'None',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
