"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.transformAttributeValueMap = exports.getDynamoResourceArn = exports.DynamoMethod = void 0;
const sfn = require("../../../../aws-stepfunctions"); // Automatically re-written from '@aws-cdk/aws-stepfunctions'
const task_utils_1 = require("../../private/task-utils");
var DynamoMethod;
(function (DynamoMethod) {
    DynamoMethod["GET"] = "Get";
    DynamoMethod["PUT"] = "Put";
    DynamoMethod["DELETE"] = "Delete";
    DynamoMethod["UPDATE"] = "Update";
})(DynamoMethod = exports.DynamoMethod || (exports.DynamoMethod = {}));
function getDynamoResourceArn(method) {
    return task_utils_1.integrationResourceArn('dynamodb', `${method.toLowerCase()}Item`, sfn.IntegrationPattern.REQUEST_RESPONSE);
}
exports.getDynamoResourceArn = getDynamoResourceArn;
function transformAttributeValueMap(attrMap) {
    const transformedValue = {};
    for (const key in attrMap) {
        if (key) {
            transformedValue[key] = attrMap[key].toObject();
        }
    }
    return attrMap ? transformedValue : undefined;
}
exports.transformAttributeValueMap = transformAttributeValueMap;
//# sourceMappingURL=data:application/json;base64,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