"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ResourcePolicy = void 0;
const iam = require("../../aws-iam"); // Automatically re-written from '@aws-cdk/aws-iam'
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
const secretsmanager_generated_1 = require("./secretsmanager.generated");
/**
 * Secret Resource Policy
 */
class ResourcePolicy extends core_1.Resource {
    constructor(scope, id, props) {
        super(scope, id);
        /**
         * The IAM policy document for this policy.
         */
        this.document = new iam.PolicyDocument();
        new secretsmanager_generated_1.CfnResourcePolicy(this, 'Resource', {
            resourcePolicy: this.document,
            secretId: props.secret.secretArn,
        });
    }
}
exports.ResourcePolicy = ResourcePolicy;
//# sourceMappingURL=data:application/json;base64,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