"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.compare = void 0;
/**
 * Compare two version strings. Fails if the comparison has to tiebreak with non-numbers.
 * @returns 0 if both are same, 1 if 'a' is later version than 'b' and -1 if 'b' is later version than 'a'
 */
function compare(a, b) {
    const aParts = a.split('.');
    const bParts = b.split('.');
    for (let i = 0; i < Math.max(aParts.length, bParts.length); i++) {
        if (i === aParts.length) {
            return -1;
        }
        if (i === bParts.length) {
            return 1;
        }
        if (!aParts[i] || !bParts[i] || isNaN(aParts[i]) || isNaN(bParts[i])) {
            throw new Error(`Can only compare version strings with numbers. Received [${a}] and [${b}].`);
        }
        const partCompare = parseInt(aParts[i], 10) - parseInt(bParts[i], 10);
        if (partCompare < 0) {
            return -1;
        }
        if (partCompare > 0) {
            return 1;
        }
    }
    return 0;
}
exports.compare = compare;
//# sourceMappingURL=data:application/json;base64,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