"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.KinesisDestination = void 0;
const iam = require("../../aws-iam"); // Automatically re-written from '@aws-cdk/aws-iam'
/**
 * Use a Kinesis stream as the destination for a log subscription
 */
class KinesisDestination {
    constructor(stream) {
        this.stream = stream;
    }
    bind(scope, _sourceLogGroup) {
        // Following example from https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/SubscriptionFilters.html#DestinationKinesisExample
        // Create a role to be assumed by CWL that can write to this stream and pass itself.
        const id = 'CloudWatchLogsCanPutRecords';
        const role = scope.node.tryFindChild(id) || new iam.Role(scope, id, {
            assumedBy: new iam.ServicePrincipal('logs.amazonaws.com'),
        });
        this.stream.grantWrite(role);
        role.grantPassRole(role);
        return { arn: this.stream.streamArn, role };
    }
}
exports.KinesisDestination = KinesisDestination;
//# sourceMappingURL=data:application/json;base64,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