"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.findClosestPathContaining = exports.nodeMajorVersion = exports.parseStackTrace = void 0;
const fs = require("fs");
const path = require("path");
// From https://github.com/errwischt/stacktrace-parser/blob/master/src/stack-trace-parser.js
const STACK_RE = /^\s*at (?:((?:\[object object\])?[^\\/]+(?: \[as \S+\])?) )?\(?(.*?):(\d+)(?::(\d+))?\)?\s*$/i;
/**
 * Parses the stack trace of an error
 */
function parseStackTrace(error) {
    const err = error || new Error();
    if (!err.stack) {
        return [];
    }
    const lines = err.stack.split('\n');
    const stackTrace = [];
    for (const line of lines) {
        const results = STACK_RE.exec(line);
        if (results) {
            stackTrace.push({
                file: results[2],
                methodName: results[1],
                lineNumber: parseInt(results[3], 10),
                column: parseInt(results[4], 10),
            });
        }
    }
    return stackTrace;
}
exports.parseStackTrace = parseStackTrace;
/**
 * Returns the major version of node installation
 */
function nodeMajorVersion() {
    return parseInt(process.versions.node.split('.')[0], 10);
}
exports.nodeMajorVersion = nodeMajorVersion;
/**
 * Finds the closest path containg a path
 */
function findClosestPathContaining(p) {
    for (const nodeModulesPath of module.paths) {
        if (fs.existsSync(path.join(path.dirname(nodeModulesPath), p))) {
            return path.dirname(nodeModulesPath);
        }
    }
    return undefined;
}
exports.findClosestPathContaining = findClosestPathContaining;
//# sourceMappingURL=data:application/json;base64,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