/**
 * A package.json manager to act on the closest package.json file.
 *
 * Configuring the bundler requires to manipulate the package.json and then
 * restore it.
 */
export declare class PackageJsonManager {
    private readonly pkgPath;
    private readonly pkg;
    private readonly pkgJson;
    constructor();
    /**
     * Update the package.json
     */
    update(data: any): void;
    /**
     * Restore the package.json to the original
     */
    restore(): void;
    /**
     * Extract versions for a list of modules
     */
    getVersions(modules: string[]): {
        [key: string]: string;
    };
}
