"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isComplete = exports.onEvent = void 0;
// eslint-disable-next-line import/no-extraneous-dependencies
const aws = require("aws-sdk");
const cluster_1 = require("./cluster");
const consts = require("./consts");
const fargate_1 = require("./fargate");
aws.config.logger = console;
let eks;
const defaultEksClient = {
    createCluster: req => getEksClient().createCluster(req).promise(),
    deleteCluster: req => getEksClient().deleteCluster(req).promise(),
    describeCluster: req => getEksClient().describeCluster(req).promise(),
    describeUpdate: req => getEksClient().describeUpdate(req).promise(),
    updateClusterConfig: req => getEksClient().updateClusterConfig(req).promise(),
    updateClusterVersion: req => getEksClient().updateClusterVersion(req).promise(),
    createFargateProfile: req => getEksClient().createFargateProfile(req).promise(),
    deleteFargateProfile: req => getEksClient().deleteFargateProfile(req).promise(),
    describeFargateProfile: req => getEksClient().describeFargateProfile(req).promise(),
    configureAssumeRole: req => {
        console.log(JSON.stringify({ assumeRole: req }, undefined, 2));
        const creds = new aws.ChainableTemporaryCredentials({
            params: req,
        });
        eks = new aws.EKS({ credentials: creds });
    },
};
function getEksClient() {
    if (!eks) {
        throw new Error('EKS client not initialized (call "configureAssumeRole")');
    }
    return eks;
}
async function onEvent(event) {
    const provider = createResourceHandler(event);
    return provider.onEvent();
}
exports.onEvent = onEvent;
async function isComplete(event) {
    const provider = createResourceHandler(event);
    return provider.isComplete();
}
exports.isComplete = isComplete;
function createResourceHandler(event) {
    switch (event.ResourceType) {
        case consts.CLUSTER_RESOURCE_TYPE: return new cluster_1.ClusterResourceHandler(defaultEksClient, event);
        case consts.FARGATE_PROFILE_RESOURCE_TYPE: return new fargate_1.FargateProfileResourceHandler(defaultEksClient, event);
        default:
            throw new Error(`Unsupported resource type "${event.ResourceType}`);
    }
}
//# sourceMappingURL=data:application/json;base64,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