"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AccessPoint = void 0;
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
const efs_generated_1 = require("./efs.generated");
/**
 * Represents the AccessPoint
 */
class AccessPoint extends core_1.Resource {
    constructor(scope, id, props) {
        super(scope, id);
        const resource = new efs_generated_1.CfnAccessPoint(this, 'Resource', {
            fileSystemId: props.fileSystem.fileSystemId,
            rootDirectory: {
                creationInfo: props.createAcl ? {
                    ownerGid: props.createAcl.ownerGid,
                    ownerUid: props.createAcl.ownerUid,
                    permissions: props.createAcl.permissions,
                } : undefined,
                path: props.path,
            },
            posixUser: props.posixUser ? {
                uid: props.posixUser.uid,
                gid: props.posixUser.gid,
                secondaryGids: props.posixUser.secondaryGids,
            } : undefined,
        });
        this.accessPointId = resource.ref;
        this.accessPointArn = core_1.Stack.of(scope).formatArn({
            service: 'elasticfilesystem',
            resource: 'access-point',
            resourceName: this.accessPointId,
        });
    }
    /**
     * Import an existing Access Point
     */
    static fromAccessPointId(scope, id, accessPointId) {
        class Import extends core_1.Resource {
            constructor() {
                super(...arguments);
                this.accessPointId = accessPointId;
                this.accessPointArn = core_1.Stack.of(scope).formatArn({
                    service: 'elasticfilesystem',
                    resource: 'access-point',
                    resourceName: accessPointId,
                });
            }
        }
        return new Import(scope, id);
    }
}
exports.AccessPoint = AccessPoint;
//# sourceMappingURL=data:application/json;base64,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