"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.JournaldLogDriver = void 0;
const log_driver_1 = require("./log-driver");
const utils_1 = require("./utils");
/**
 * A log driver that sends log information to journald Logs.
 */
class JournaldLogDriver extends log_driver_1.LogDriver {
    /**
     * Constructs a new instance of the JournaldLogDriver class.
     *
     * @param props the journald log driver configuration options.
     */
    constructor(props = {}) {
        super();
        this.props = props;
    }
    /**
     * Called when the log driver is configured on a container
     */
    bind(_scope, _containerDefinition) {
        return {
            logDriver: 'journald',
            options: utils_1.stringifyOptions({
                ...utils_1.renderCommonLogDriverOptions(this.props),
            }),
        };
    }
}
exports.JournaldLogDriver = JournaldLogDriver;
//# sourceMappingURL=data:application/json;base64,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