"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ScalableTaskCount = void 0;
const appscaling = require("../../../aws-applicationautoscaling"); // Automatically re-written from '@aws-cdk/aws-applicationautoscaling'
/**
 * The scalable attribute representing task count.
 */
class ScalableTaskCount extends appscaling.BaseScalableAttribute {
    /**
     * Constructs a new instance of the ScalableTaskCount class.
     */
    constructor(scope, id, props) {
        super(scope, id, props);
    }
    /**
     * Scales in or out based on a specified scheduled time.
     */
    scaleOnSchedule(id, props) {
        return super.doScaleOnSchedule(id, props);
    }
    /**
     * Scales in or out based on a specified metric value.
     */
    scaleOnMetric(id, props) {
        return super.doScaleOnMetric(id, props);
    }
    /**
     * Scales in or out to achieve a target CPU utilization.
     */
    scaleOnCpuUtilization(id, props) {
        return super.doScaleToTrackMetric(id, {
            predefinedMetric: appscaling.PredefinedMetric.ECS_SERVICE_AVERAGE_CPU_UTILIZATION,
            policyName: props.policyName,
            disableScaleIn: props.disableScaleIn,
            targetValue: props.targetUtilizationPercent,
            scaleInCooldown: props.scaleInCooldown,
            scaleOutCooldown: props.scaleOutCooldown,
        });
    }
    /**
     * Scales in or out to achieve a target memory utilization.
     */
    scaleOnMemoryUtilization(id, props) {
        return super.doScaleToTrackMetric(id, {
            predefinedMetric: appscaling.PredefinedMetric.ECS_SERVICE_AVERAGE_MEMORY_UTILIZATION,
            targetValue: props.targetUtilizationPercent,
            policyName: props.policyName,
            disableScaleIn: props.disableScaleIn,
            scaleInCooldown: props.scaleInCooldown,
            scaleOutCooldown: props.scaleOutCooldown,
        });
    }
    /**
     * Scales in or out to achieve a target Application Load Balancer request count per target.
     */
    scaleOnRequestCount(id, props) {
        const resourceLabel = props.targetGroup.firstLoadBalancerFullName +
            '/' + props.targetGroup.targetGroupFullName;
        return super.doScaleToTrackMetric(id, {
            predefinedMetric: appscaling.PredefinedMetric.ALB_REQUEST_COUNT_PER_TARGET,
            resourceLabel,
            targetValue: props.requestsPerTarget,
            policyName: props.policyName,
            disableScaleIn: props.disableScaleIn,
            scaleInCooldown: props.scaleInCooldown,
            scaleOutCooldown: props.scaleOutCooldown,
        });
    }
    /**
     * Scales in or out to achieve a target on a custom metric.
     */
    scaleToTrackCustomMetric(id, props) {
        return super.doScaleToTrackMetric(id, {
            customMetric: props.metric,
            targetValue: props.targetValue,
            policyName: props.policyName,
            disableScaleIn: props.disableScaleIn,
            scaleInCooldown: props.scaleInCooldown,
            scaleOutCooldown: props.scaleOutCooldown,
        });
    }
}
exports.ScalableTaskCount = ScalableTaskCount;
//# sourceMappingURL=data:application/json;base64,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