"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnUserPoolUserToGroupAttachment = exports.CfnUserPoolUser = exports.CfnUserPoolUICustomizationAttachment = exports.CfnUserPoolRiskConfigurationAttachment = exports.CfnUserPoolResourceServer = exports.CfnUserPoolIdentityProvider = exports.CfnUserPoolGroup = exports.CfnUserPoolDomain = exports.CfnUserPoolClient = exports.CfnUserPool = exports.CfnIdentityPoolRoleAttachment = exports.CfnIdentityPool = void 0;
// Copyright 2012-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
// Generated from the AWS CloudFormation Resource Specification
// See: docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cfn-resource-specification.html
// @cfn2ts:meta@ {"generated":"2020-07-01T08:33:11.356Z","fingerprint":"Cxu7IZwEk71S8GQUgqHBuWPN69Y7vPesNUosjOeQNzk="}
// tslint:disable:max-line-length | This is generated code - line lengths are difficult to control
const cdk = require("../../core"); // Automatically re-written from '@aws-cdk/core'
const cfn_parse = require("../../core/lib/cfn-parse"); // Automatically re-written from '@aws-cdk/core/lib/cfn-parse'
/**
 * Determine whether the given properties match those of a `CfnIdentityPoolProps`
 *
 * @param properties - the TypeScript properties of a `CfnIdentityPoolProps`
 *
 * @returns the result of the validation.
 */
function CfnIdentityPoolPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('allowClassicFlow', cdk.validateBoolean)(properties.allowClassicFlow));
    errors.collect(cdk.propertyValidator('allowUnauthenticatedIdentities', cdk.requiredValidator)(properties.allowUnauthenticatedIdentities));
    errors.collect(cdk.propertyValidator('allowUnauthenticatedIdentities', cdk.validateBoolean)(properties.allowUnauthenticatedIdentities));
    errors.collect(cdk.propertyValidator('cognitoEvents', cdk.validateObject)(properties.cognitoEvents));
    errors.collect(cdk.propertyValidator('cognitoIdentityProviders', cdk.listValidator(CfnIdentityPool_CognitoIdentityProviderPropertyValidator))(properties.cognitoIdentityProviders));
    errors.collect(cdk.propertyValidator('cognitoStreams', CfnIdentityPool_CognitoStreamsPropertyValidator)(properties.cognitoStreams));
    errors.collect(cdk.propertyValidator('developerProviderName', cdk.validateString)(properties.developerProviderName));
    errors.collect(cdk.propertyValidator('identityPoolName', cdk.validateString)(properties.identityPoolName));
    errors.collect(cdk.propertyValidator('openIdConnectProviderArns', cdk.listValidator(cdk.validateString))(properties.openIdConnectProviderArns));
    errors.collect(cdk.propertyValidator('pushSync', CfnIdentityPool_PushSyncPropertyValidator)(properties.pushSync));
    errors.collect(cdk.propertyValidator('samlProviderArns', cdk.listValidator(cdk.validateString))(properties.samlProviderArns));
    errors.collect(cdk.propertyValidator('supportedLoginProviders', cdk.validateObject)(properties.supportedLoginProviders));
    return errors.wrap('supplied properties not correct for "CfnIdentityPoolProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Cognito::IdentityPool` resource
 *
 * @param properties - the TypeScript properties of a `CfnIdentityPoolProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Cognito::IdentityPool` resource.
 */
// @ts-ignore TS6133
function cfnIdentityPoolPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnIdentityPoolPropsValidator(properties).assertSuccess();
    return {
        AllowUnauthenticatedIdentities: cdk.booleanToCloudFormation(properties.allowUnauthenticatedIdentities),
        AllowClassicFlow: cdk.booleanToCloudFormation(properties.allowClassicFlow),
        CognitoEvents: cdk.objectToCloudFormation(properties.cognitoEvents),
        CognitoIdentityProviders: cdk.listMapper(cfnIdentityPoolCognitoIdentityProviderPropertyToCloudFormation)(properties.cognitoIdentityProviders),
        CognitoStreams: cfnIdentityPoolCognitoStreamsPropertyToCloudFormation(properties.cognitoStreams),
        DeveloperProviderName: cdk.stringToCloudFormation(properties.developerProviderName),
        IdentityPoolName: cdk.stringToCloudFormation(properties.identityPoolName),
        OpenIdConnectProviderARNs: cdk.listMapper(cdk.stringToCloudFormation)(properties.openIdConnectProviderArns),
        PushSync: cfnIdentityPoolPushSyncPropertyToCloudFormation(properties.pushSync),
        SamlProviderARNs: cdk.listMapper(cdk.stringToCloudFormation)(properties.samlProviderArns),
        SupportedLoginProviders: cdk.objectToCloudFormation(properties.supportedLoginProviders),
    };
}
// @ts-ignore TS6133
function CfnIdentityPoolPropsFromCloudFormation(properties) {
    properties = properties || {};
    return {
        allowUnauthenticatedIdentities: cfn_parse.FromCloudFormation.getBoolean(properties.AllowUnauthenticatedIdentities),
        allowClassicFlow: properties.AllowClassicFlow == null ? undefined : cfn_parse.FromCloudFormation.getBoolean(properties.AllowClassicFlow),
        cognitoEvents: properties.CognitoEvents == null ? undefined : cfn_parse.FromCloudFormation.getAny(properties.CognitoEvents),
        cognitoIdentityProviders: cfn_parse.FromCloudFormation.getArray(properties.CognitoIdentityProviders, (prop1) => CfnIdentityPoolCognitoIdentityProviderPropertyFromCloudFormation(prop1)),
        cognitoStreams: properties.CognitoStreams == null ? undefined : CfnIdentityPoolCognitoStreamsPropertyFromCloudFormation(properties.CognitoStreams),
        developerProviderName: properties.DeveloperProviderName == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.DeveloperProviderName),
        identityPoolName: properties.IdentityPoolName == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.IdentityPoolName),
        openIdConnectProviderArns: cfn_parse.FromCloudFormation.getStringArray(properties.OpenIdConnectProviderARNs),
        pushSync: properties.PushSync == null ? undefined : CfnIdentityPoolPushSyncPropertyFromCloudFormation(properties.PushSync),
        samlProviderArns: cfn_parse.FromCloudFormation.getStringArray(properties.SamlProviderARNs),
        supportedLoginProviders: properties.SupportedLoginProviders == null ? undefined : cfn_parse.FromCloudFormation.getAny(properties.SupportedLoginProviders),
    };
}
/**
 * A CloudFormation `AWS::Cognito::IdentityPool`
 *
 * @cloudformationResource AWS::Cognito::IdentityPool
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypool.html
 */
class CfnIdentityPool extends cdk.CfnResource {
    /**
     * Create a new `AWS::Cognito::IdentityPool`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnIdentityPool.CFN_RESOURCE_TYPE_NAME, properties: props });
        cdk.requireProperty(props, 'allowUnauthenticatedIdentities', this);
        this.attrName = cdk.Token.asString(this.getAtt('Name'));
        this.allowUnauthenticatedIdentities = props.allowUnauthenticatedIdentities;
        this.allowClassicFlow = props.allowClassicFlow;
        this.cognitoEvents = props.cognitoEvents;
        this.cognitoIdentityProviders = props.cognitoIdentityProviders;
        this.cognitoStreams = props.cognitoStreams;
        this.developerProviderName = props.developerProviderName;
        this.identityPoolName = props.identityPoolName;
        this.openIdConnectProviderArns = props.openIdConnectProviderArns;
        this.pushSync = props.pushSync;
        this.samlProviderArns = props.samlProviderArns;
        this.supportedLoginProviders = props.supportedLoginProviders;
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @experimental
     */
    static fromCloudFormation(scope, id, resourceAttributes, options) {
        var _a;
        resourceAttributes = resourceAttributes || {};
        const cfnParser = new cfn_parse.CfnParser({
            finder: options.finder,
        });
        const resourceProperties = cfnParser.parseValue(resourceAttributes.Properties);
        const props = CfnIdentityPoolPropsFromCloudFormation(resourceProperties);
        const ret = new CfnIdentityPool(scope, id, props);
        const cfnOptions = ret.cfnOptions;
        cfnOptions.creationPolicy = cfnParser.parseCreationPolicy(resourceAttributes.CreationPolicy);
        cfnOptions.updatePolicy = cfnParser.parseUpdatePolicy(resourceAttributes.UpdatePolicy);
        cfnOptions.deletionPolicy = cfnParser.parseDeletionPolicy(resourceAttributes.DeletionPolicy);
        cfnOptions.updateReplacePolicy = cfnParser.parseDeletionPolicy(resourceAttributes.UpdateReplacePolicy);
        cfnOptions.metadata = cfnParser.parseValue(resourceAttributes.Metadata);
        // handle DependsOn
        resourceAttributes.DependsOn = (_a = resourceAttributes.DependsOn) !== null && _a !== void 0 ? _a : [];
        const dependencies = Array.isArray(resourceAttributes.DependsOn) ? resourceAttributes.DependsOn : [resourceAttributes.DependsOn];
        for (const dep of dependencies) {
            const depResource = options.finder.findResource(dep);
            if (!depResource) {
                throw new Error(`Resource '${id}' depends on '${dep}' that doesn't exist`);
            }
            ret.node.addDependency(depResource);
        }
        // handle Condition
        if (resourceAttributes.Condition) {
            const condition = options.finder.findCondition(resourceAttributes.Condition);
            if (!condition) {
                throw new Error(`Resource '${id}' uses Condition '${resourceAttributes.Condition}' that doesn't exist`);
            }
            cfnOptions.condition = condition;
        }
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector) {
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnIdentityPool.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            allowUnauthenticatedIdentities: this.allowUnauthenticatedIdentities,
            allowClassicFlow: this.allowClassicFlow,
            cognitoEvents: this.cognitoEvents,
            cognitoIdentityProviders: this.cognitoIdentityProviders,
            cognitoStreams: this.cognitoStreams,
            developerProviderName: this.developerProviderName,
            identityPoolName: this.identityPoolName,
            openIdConnectProviderArns: this.openIdConnectProviderArns,
            pushSync: this.pushSync,
            samlProviderArns: this.samlProviderArns,
            supportedLoginProviders: this.supportedLoginProviders,
        };
    }
    renderProperties(props) {
        return cfnIdentityPoolPropsToCloudFormation(props);
    }
}
exports.CfnIdentityPool = CfnIdentityPool;
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnIdentityPool.CFN_RESOURCE_TYPE_NAME = "AWS::Cognito::IdentityPool";
/**
 * Determine whether the given properties match those of a `CognitoIdentityProviderProperty`
 *
 * @param properties - the TypeScript properties of a `CognitoIdentityProviderProperty`
 *
 * @returns the result of the validation.
 */
function CfnIdentityPool_CognitoIdentityProviderPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('clientId', cdk.validateString)(properties.clientId));
    errors.collect(cdk.propertyValidator('providerName', cdk.validateString)(properties.providerName));
    errors.collect(cdk.propertyValidator('serverSideTokenCheck', cdk.validateBoolean)(properties.serverSideTokenCheck));
    return errors.wrap('supplied properties not correct for "CognitoIdentityProviderProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Cognito::IdentityPool.CognitoIdentityProvider` resource
 *
 * @param properties - the TypeScript properties of a `CognitoIdentityProviderProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Cognito::IdentityPool.CognitoIdentityProvider` resource.
 */
// @ts-ignore TS6133
function cfnIdentityPoolCognitoIdentityProviderPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnIdentityPool_CognitoIdentityProviderPropertyValidator(properties).assertSuccess();
    return {
        ClientId: cdk.stringToCloudFormation(properties.clientId),
        ProviderName: cdk.stringToCloudFormation(properties.providerName),
        ServerSideTokenCheck: cdk.booleanToCloudFormation(properties.serverSideTokenCheck),
    };
}
// @ts-ignore TS6133
function CfnIdentityPoolCognitoIdentityProviderPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return properties;
    }
    properties = properties || {};
    return {
        clientId: properties.ClientId == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.ClientId),
        providerName: properties.ProviderName == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.ProviderName),
        serverSideTokenCheck: properties.ServerSideTokenCheck == null ? undefined : cfn_parse.FromCloudFormation.getBoolean(properties.ServerSideTokenCheck),
    };
}
/**
 * Determine whether the given properties match those of a `CognitoStreamsProperty`
 *
 * @param properties - the TypeScript properties of a `CognitoStreamsProperty`
 *
 * @returns the result of the validation.
 */
function CfnIdentityPool_CognitoStreamsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('roleArn', cdk.validateString)(properties.roleArn));
    errors.collect(cdk.propertyValidator('streamName', cdk.validateString)(properties.streamName));
    errors.collect(cdk.propertyValidator('streamingStatus', cdk.validateString)(properties.streamingStatus));
    return errors.wrap('supplied properties not correct for "CognitoStreamsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Cognito::IdentityPool.CognitoStreams` resource
 *
 * @param properties - the TypeScript properties of a `CognitoStreamsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Cognito::IdentityPool.CognitoStreams` resource.
 */
// @ts-ignore TS6133
function cfnIdentityPoolCognitoStreamsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnIdentityPool_CognitoStreamsPropertyValidator(properties).assertSuccess();
    return {
        RoleArn: cdk.stringToCloudFormation(properties.roleArn),
        StreamName: cdk.stringToCloudFormation(properties.streamName),
        StreamingStatus: cdk.stringToCloudFormation(properties.streamingStatus),
    };
}
// @ts-ignore TS6133
function CfnIdentityPoolCognitoStreamsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return properties;
    }
    properties = properties || {};
    return {
        roleArn: properties.RoleArn == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.RoleArn),
        streamName: properties.StreamName == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.StreamName),
        streamingStatus: properties.StreamingStatus == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.StreamingStatus),
    };
}
/**
 * Determine whether the given properties match those of a `PushSyncProperty`
 *
 * @param properties - the TypeScript properties of a `PushSyncProperty`
 *
 * @returns the result of the validation.
 */
function CfnIdentityPool_PushSyncPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('applicationArns', cdk.listValidator(cdk.validateString))(properties.applicationArns));
    errors.collect(cdk.propertyValidator('roleArn', cdk.validateString)(properties.roleArn));
    return errors.wrap('supplied properties not correct for "PushSyncProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Cognito::IdentityPool.PushSync` resource
 *
 * @param properties - the TypeScript properties of a `PushSyncProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Cognito::IdentityPool.PushSync` resource.
 */
// @ts-ignore TS6133
function cfnIdentityPoolPushSyncPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnIdentityPool_PushSyncPropertyValidator(properties).assertSuccess();
    return {
        ApplicationArns: cdk.listMapper(cdk.stringToCloudFormation)(properties.applicationArns),
        RoleArn: cdk.stringToCloudFormation(properties.roleArn),
    };
}
// @ts-ignore TS6133
function CfnIdentityPoolPushSyncPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return properties;
    }
    properties = properties || {};
    return {
        applicationArns: cfn_parse.FromCloudFormation.getStringArray(properties.ApplicationArns),
        roleArn: properties.RoleArn == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.RoleArn),
    };
}
/**
 * Determine whether the given properties match those of a `CfnIdentityPoolRoleAttachmentProps`
 *
 * @param properties - the TypeScript properties of a `CfnIdentityPoolRoleAttachmentProps`
 *
 * @returns the result of the validation.
 */
function CfnIdentityPoolRoleAttachmentPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('identityPoolId', cdk.requiredValidator)(properties.identityPoolId));
    errors.collect(cdk.propertyValidator('identityPoolId', cdk.validateString)(properties.identityPoolId));
    errors.collect(cdk.propertyValidator('roleMappings', cdk.hashValidator(CfnIdentityPoolRoleAttachment_RoleMappingPropertyValidator))(properties.roleMappings));
    errors.collect(cdk.propertyValidator('roles', cdk.validateObject)(properties.roles));
    return errors.wrap('supplied properties not correct for "CfnIdentityPoolRoleAttachmentProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Cognito::IdentityPoolRoleAttachment` resource
 *
 * @param properties - the TypeScript properties of a `CfnIdentityPoolRoleAttachmentProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Cognito::IdentityPoolRoleAttachment` resource.
 */
// @ts-ignore TS6133
function cfnIdentityPoolRoleAttachmentPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnIdentityPoolRoleAttachmentPropsValidator(properties).assertSuccess();
    return {
        IdentityPoolId: cdk.stringToCloudFormation(properties.identityPoolId),
        RoleMappings: cdk.hashMapper(cfnIdentityPoolRoleAttachmentRoleMappingPropertyToCloudFormation)(properties.roleMappings),
        Roles: cdk.objectToCloudFormation(properties.roles),
    };
}
// @ts-ignore TS6133
function CfnIdentityPoolRoleAttachmentPropsFromCloudFormation(properties) {
    properties = properties || {};
    return {
        identityPoolId: cfn_parse.FromCloudFormation.getString(properties.IdentityPoolId),
        roleMappings: cfn_parse.FromCloudFormation.getMap(properties.RoleMappings, (prop1) => CfnIdentityPoolRoleAttachmentRoleMappingPropertyFromCloudFormation(prop1)),
        roles: properties.Roles == null ? undefined : cfn_parse.FromCloudFormation.getAny(properties.Roles),
    };
}
/**
 * A CloudFormation `AWS::Cognito::IdentityPoolRoleAttachment`
 *
 * @cloudformationResource AWS::Cognito::IdentityPoolRoleAttachment
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypoolroleattachment.html
 */
class CfnIdentityPoolRoleAttachment extends cdk.CfnResource {
    /**
     * Create a new `AWS::Cognito::IdentityPoolRoleAttachment`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnIdentityPoolRoleAttachment.CFN_RESOURCE_TYPE_NAME, properties: props });
        cdk.requireProperty(props, 'identityPoolId', this);
        this.identityPoolId = props.identityPoolId;
        this.roleMappings = props.roleMappings;
        this.roles = props.roles;
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @experimental
     */
    static fromCloudFormation(scope, id, resourceAttributes, options) {
        var _a;
        resourceAttributes = resourceAttributes || {};
        const cfnParser = new cfn_parse.CfnParser({
            finder: options.finder,
        });
        const resourceProperties = cfnParser.parseValue(resourceAttributes.Properties);
        const props = CfnIdentityPoolRoleAttachmentPropsFromCloudFormation(resourceProperties);
        const ret = new CfnIdentityPoolRoleAttachment(scope, id, props);
        const cfnOptions = ret.cfnOptions;
        cfnOptions.creationPolicy = cfnParser.parseCreationPolicy(resourceAttributes.CreationPolicy);
        cfnOptions.updatePolicy = cfnParser.parseUpdatePolicy(resourceAttributes.UpdatePolicy);
        cfnOptions.deletionPolicy = cfnParser.parseDeletionPolicy(resourceAttributes.DeletionPolicy);
        cfnOptions.updateReplacePolicy = cfnParser.parseDeletionPolicy(resourceAttributes.UpdateReplacePolicy);
        cfnOptions.metadata = cfnParser.parseValue(resourceAttributes.Metadata);
        // handle DependsOn
        resourceAttributes.DependsOn = (_a = resourceAttributes.DependsOn) !== null && _a !== void 0 ? _a : [];
        const dependencies = Array.isArray(resourceAttributes.DependsOn) ? resourceAttributes.DependsOn : [resourceAttributes.DependsOn];
        for (const dep of dependencies) {
            const depResource = options.finder.findResource(dep);
            if (!depResource) {
                throw new Error(`Resource '${id}' depends on '${dep}' that doesn't exist`);
            }
            ret.node.addDependency(depResource);
        }
        // handle Condition
        if (resourceAttributes.Condition) {
            const condition = options.finder.findCondition(resourceAttributes.Condition);
            if (!condition) {
                throw new Error(`Resource '${id}' uses Condition '${resourceAttributes.Condition}' that doesn't exist`);
            }
            cfnOptions.condition = condition;
        }
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector) {
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnIdentityPoolRoleAttachment.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            identityPoolId: this.identityPoolId,
            roleMappings: this.roleMappings,
            roles: this.roles,
        };
    }
    renderProperties(props) {
        return cfnIdentityPoolRoleAttachmentPropsToCloudFormation(props);
    }
}
exports.CfnIdentityPoolRoleAttachment = CfnIdentityPoolRoleAttachment;
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnIdentityPoolRoleAttachment.CFN_RESOURCE_TYPE_NAME = "AWS::Cognito::IdentityPoolRoleAttachment";
/**
 * Determine whether the given properties match those of a `MappingRuleProperty`
 *
 * @param properties - the TypeScript properties of a `MappingRuleProperty`
 *
 * @returns the result of the validation.
 */
function CfnIdentityPoolRoleAttachment_MappingRulePropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('claim', cdk.requiredValidator)(properties.claim));
    errors.collect(cdk.propertyValidator('claim', cdk.validateString)(properties.claim));
    errors.collect(cdk.propertyValidator('matchType', cdk.requiredValidator)(properties.matchType));
    errors.collect(cdk.propertyValidator('matchType', cdk.validateString)(properties.matchType));
    errors.collect(cdk.propertyValidator('roleArn', cdk.requiredValidator)(properties.roleArn));
    errors.collect(cdk.propertyValidator('roleArn', cdk.validateString)(properties.roleArn));
    errors.collect(cdk.propertyValidator('value', cdk.requiredValidator)(properties.value));
    errors.collect(cdk.propertyValidator('value', cdk.validateString)(properties.value));
    return errors.wrap('supplied properties not correct for "MappingRuleProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Cognito::IdentityPoolRoleAttachment.MappingRule` resource
 *
 * @param properties - the TypeScript properties of a `MappingRuleProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Cognito::IdentityPoolRoleAttachment.MappingRule` resource.
 */
// @ts-ignore TS6133
function cfnIdentityPoolRoleAttachmentMappingRulePropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnIdentityPoolRoleAttachment_MappingRulePropertyValidator(properties).assertSuccess();
    return {
        Claim: cdk.stringToCloudFormation(properties.claim),
        MatchType: cdk.stringToCloudFormation(properties.matchType),
        RoleARN: cdk.stringToCloudFormation(properties.roleArn),
        Value: cdk.stringToCloudFormation(properties.value),
    };
}
// @ts-ignore TS6133
function CfnIdentityPoolRoleAttachmentMappingRulePropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return properties;
    }
    properties = properties || {};
    return {
        claim: cfn_parse.FromCloudFormation.getString(properties.Claim),
        matchType: cfn_parse.FromCloudFormation.getString(properties.MatchType),
        roleArn: cfn_parse.FromCloudFormation.getString(properties.RoleARN),
        value: cfn_parse.FromCloudFormation.getString(properties.Value),
    };
}
/**
 * Determine whether the given properties match those of a `RoleMappingProperty`
 *
 * @param properties - the TypeScript properties of a `RoleMappingProperty`
 *
 * @returns the result of the validation.
 */
function CfnIdentityPoolRoleAttachment_RoleMappingPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('ambiguousRoleResolution', cdk.validateString)(properties.ambiguousRoleResolution));
    errors.collect(cdk.propertyValidator('identityProvider', cdk.validateString)(properties.identityProvider));
    errors.collect(cdk.propertyValidator('rulesConfiguration', CfnIdentityPoolRoleAttachment_RulesConfigurationTypePropertyValidator)(properties.rulesConfiguration));
    errors.collect(cdk.propertyValidator('type', cdk.requiredValidator)(properties.type));
    errors.collect(cdk.propertyValidator('type', cdk.validateString)(properties.type));
    return errors.wrap('supplied properties not correct for "RoleMappingProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Cognito::IdentityPoolRoleAttachment.RoleMapping` resource
 *
 * @param properties - the TypeScript properties of a `RoleMappingProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Cognito::IdentityPoolRoleAttachment.RoleMapping` resource.
 */
// @ts-ignore TS6133
function cfnIdentityPoolRoleAttachmentRoleMappingPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnIdentityPoolRoleAttachment_RoleMappingPropertyValidator(properties).assertSuccess();
    return {
        AmbiguousRoleResolution: cdk.stringToCloudFormation(properties.ambiguousRoleResolution),
        IdentityProvider: cdk.stringToCloudFormation(properties.identityProvider),
        RulesConfiguration: cfnIdentityPoolRoleAttachmentRulesConfigurationTypePropertyToCloudFormation(properties.rulesConfiguration),
        Type: cdk.stringToCloudFormation(properties.type),
    };
}
// @ts-ignore TS6133
function CfnIdentityPoolRoleAttachmentRoleMappingPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return properties;
    }
    properties = properties || {};
    return {
        ambiguousRoleResolution: properties.AmbiguousRoleResolution == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.AmbiguousRoleResolution),
        identityProvider: properties.IdentityProvider == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.IdentityProvider),
        rulesConfiguration: properties.RulesConfiguration == null ? undefined : CfnIdentityPoolRoleAttachmentRulesConfigurationTypePropertyFromCloudFormation(properties.RulesConfiguration),
        type: cfn_parse.FromCloudFormation.getString(properties.Type),
    };
}
/**
 * Determine whether the given properties match those of a `RulesConfigurationTypeProperty`
 *
 * @param properties - the TypeScript properties of a `RulesConfigurationTypeProperty`
 *
 * @returns the result of the validation.
 */
function CfnIdentityPoolRoleAttachment_RulesConfigurationTypePropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('rules', cdk.requiredValidator)(properties.rules));
    errors.collect(cdk.propertyValidator('rules', cdk.listValidator(CfnIdentityPoolRoleAttachment_MappingRulePropertyValidator))(properties.rules));
    return errors.wrap('supplied properties not correct for "RulesConfigurationTypeProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Cognito::IdentityPoolRoleAttachment.RulesConfigurationType` resource
 *
 * @param properties - the TypeScript properties of a `RulesConfigurationTypeProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Cognito::IdentityPoolRoleAttachment.RulesConfigurationType` resource.
 */
// @ts-ignore TS6133
function cfnIdentityPoolRoleAttachmentRulesConfigurationTypePropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnIdentityPoolRoleAttachment_RulesConfigurationTypePropertyValidator(properties).assertSuccess();
    return {
        Rules: cdk.listMapper(cfnIdentityPoolRoleAttachmentMappingRulePropertyToCloudFormation)(properties.rules),
    };
}
// @ts-ignore TS6133
function CfnIdentityPoolRoleAttachmentRulesConfigurationTypePropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return properties;
    }
    properties = properties || {};
    return {
        rules: cfn_parse.FromCloudFormation.getArray(properties.Rules, (prop1) => CfnIdentityPoolRoleAttachmentMappingRulePropertyFromCloudFormation(prop1)),
    };
}
/**
 * Determine whether the given properties match those of a `CfnUserPoolProps`
 *
 * @param properties - the TypeScript properties of a `CfnUserPoolProps`
 *
 * @returns the result of the validation.
 */
function CfnUserPoolPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('accountRecoverySetting', CfnUserPool_AccountRecoverySettingPropertyValidator)(properties.accountRecoverySetting));
    errors.collect(cdk.propertyValidator('adminCreateUserConfig', CfnUserPool_AdminCreateUserConfigPropertyValidator)(properties.adminCreateUserConfig));
    errors.collect(cdk.propertyValidator('aliasAttributes', cdk.listValidator(cdk.validateString))(properties.aliasAttributes));
    errors.collect(cdk.propertyValidator('autoVerifiedAttributes', cdk.listValidator(cdk.validateString))(properties.autoVerifiedAttributes));
    errors.collect(cdk.propertyValidator('deviceConfiguration', CfnUserPool_DeviceConfigurationPropertyValidator)(properties.deviceConfiguration));
    errors.collect(cdk.propertyValidator('emailConfiguration', CfnUserPool_EmailConfigurationPropertyValidator)(properties.emailConfiguration));
    errors.collect(cdk.propertyValidator('emailVerificationMessage', cdk.validateString)(properties.emailVerificationMessage));
    errors.collect(cdk.propertyValidator('emailVerificationSubject', cdk.validateString)(properties.emailVerificationSubject));
    errors.collect(cdk.propertyValidator('enabledMfas', cdk.listValidator(cdk.validateString))(properties.enabledMfas));
    errors.collect(cdk.propertyValidator('lambdaConfig', CfnUserPool_LambdaConfigPropertyValidator)(properties.lambdaConfig));
    errors.collect(cdk.propertyValidator('mfaConfiguration', cdk.validateString)(properties.mfaConfiguration));
    errors.collect(cdk.propertyValidator('policies', CfnUserPool_PoliciesPropertyValidator)(properties.policies));
    errors.collect(cdk.propertyValidator('schema', cdk.listValidator(CfnUserPool_SchemaAttributePropertyValidator))(properties.schema));
    errors.collect(cdk.propertyValidator('smsAuthenticationMessage', cdk.validateString)(properties.smsAuthenticationMessage));
    errors.collect(cdk.propertyValidator('smsConfiguration', CfnUserPool_SmsConfigurationPropertyValidator)(properties.smsConfiguration));
    errors.collect(cdk.propertyValidator('smsVerificationMessage', cdk.validateString)(properties.smsVerificationMessage));
    errors.collect(cdk.propertyValidator('userPoolAddOns', CfnUserPool_UserPoolAddOnsPropertyValidator)(properties.userPoolAddOns));
    errors.collect(cdk.propertyValidator('userPoolName', cdk.validateString)(properties.userPoolName));
    errors.collect(cdk.propertyValidator('userPoolTags', cdk.validateObject)(properties.userPoolTags));
    errors.collect(cdk.propertyValidator('usernameAttributes', cdk.listValidator(cdk.validateString))(properties.usernameAttributes));
    errors.collect(cdk.propertyValidator('usernameConfiguration', CfnUserPool_UsernameConfigurationPropertyValidator)(properties.usernameConfiguration));
    errors.collect(cdk.propertyValidator('verificationMessageTemplate', CfnUserPool_VerificationMessageTemplatePropertyValidator)(properties.verificationMessageTemplate));
    return errors.wrap('supplied properties not correct for "CfnUserPoolProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Cognito::UserPool` resource
 *
 * @param properties - the TypeScript properties of a `CfnUserPoolProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Cognito::UserPool` resource.
 */
// @ts-ignore TS6133
function cfnUserPoolPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnUserPoolPropsValidator(properties).assertSuccess();
    return {
        AccountRecoverySetting: cfnUserPoolAccountRecoverySettingPropertyToCloudFormation(properties.accountRecoverySetting),
        AdminCreateUserConfig: cfnUserPoolAdminCreateUserConfigPropertyToCloudFormation(properties.adminCreateUserConfig),
        AliasAttributes: cdk.listMapper(cdk.stringToCloudFormation)(properties.aliasAttributes),
        AutoVerifiedAttributes: cdk.listMapper(cdk.stringToCloudFormation)(properties.autoVerifiedAttributes),
        DeviceConfiguration: cfnUserPoolDeviceConfigurationPropertyToCloudFormation(properties.deviceConfiguration),
        EmailConfiguration: cfnUserPoolEmailConfigurationPropertyToCloudFormation(properties.emailConfiguration),
        EmailVerificationMessage: cdk.stringToCloudFormation(properties.emailVerificationMessage),
        EmailVerificationSubject: cdk.stringToCloudFormation(properties.emailVerificationSubject),
        EnabledMfas: cdk.listMapper(cdk.stringToCloudFormation)(properties.enabledMfas),
        LambdaConfig: cfnUserPoolLambdaConfigPropertyToCloudFormation(properties.lambdaConfig),
        MfaConfiguration: cdk.stringToCloudFormation(properties.mfaConfiguration),
        Policies: cfnUserPoolPoliciesPropertyToCloudFormation(properties.policies),
        Schema: cdk.listMapper(cfnUserPoolSchemaAttributePropertyToCloudFormation)(properties.schema),
        SmsAuthenticationMessage: cdk.stringToCloudFormation(properties.smsAuthenticationMessage),
        SmsConfiguration: cfnUserPoolSmsConfigurationPropertyToCloudFormation(properties.smsConfiguration),
        SmsVerificationMessage: cdk.stringToCloudFormation(properties.smsVerificationMessage),
        UsernameAttributes: cdk.listMapper(cdk.stringToCloudFormation)(properties.usernameAttributes),
        UsernameConfiguration: cfnUserPoolUsernameConfigurationPropertyToCloudFormation(properties.usernameConfiguration),
        UserPoolAddOns: cfnUserPoolUserPoolAddOnsPropertyToCloudFormation(properties.userPoolAddOns),
        UserPoolName: cdk.stringToCloudFormation(properties.userPoolName),
        UserPoolTags: cdk.objectToCloudFormation(properties.userPoolTags),
        VerificationMessageTemplate: cfnUserPoolVerificationMessageTemplatePropertyToCloudFormation(properties.verificationMessageTemplate),
    };
}
// @ts-ignore TS6133
function CfnUserPoolPropsFromCloudFormation(properties) {
    properties = properties || {};
    return {
        accountRecoverySetting: properties.AccountRecoverySetting == null ? undefined : CfnUserPoolAccountRecoverySettingPropertyFromCloudFormation(properties.AccountRecoverySetting),
        adminCreateUserConfig: properties.AdminCreateUserConfig == null ? undefined : CfnUserPoolAdminCreateUserConfigPropertyFromCloudFormation(properties.AdminCreateUserConfig),
        aliasAttributes: cfn_parse.FromCloudFormation.getStringArray(properties.AliasAttributes),
        autoVerifiedAttributes: cfn_parse.FromCloudFormation.getStringArray(properties.AutoVerifiedAttributes),
        deviceConfiguration: properties.DeviceConfiguration == null ? undefined : CfnUserPoolDeviceConfigurationPropertyFromCloudFormation(properties.DeviceConfiguration),
        emailConfiguration: properties.EmailConfiguration == null ? undefined : CfnUserPoolEmailConfigurationPropertyFromCloudFormation(properties.EmailConfiguration),
        emailVerificationMessage: properties.EmailVerificationMessage == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.EmailVerificationMessage),
        emailVerificationSubject: properties.EmailVerificationSubject == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.EmailVerificationSubject),
        enabledMfas: cfn_parse.FromCloudFormation.getStringArray(properties.EnabledMfas),
        lambdaConfig: properties.LambdaConfig == null ? undefined : CfnUserPoolLambdaConfigPropertyFromCloudFormation(properties.LambdaConfig),
        mfaConfiguration: properties.MfaConfiguration == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.MfaConfiguration),
        policies: properties.Policies == null ? undefined : CfnUserPoolPoliciesPropertyFromCloudFormation(properties.Policies),
        schema: cfn_parse.FromCloudFormation.getArray(properties.Schema, (prop1) => CfnUserPoolSchemaAttributePropertyFromCloudFormation(prop1)),
        smsAuthenticationMessage: properties.SmsAuthenticationMessage == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.SmsAuthenticationMessage),
        smsConfiguration: properties.SmsConfiguration == null ? undefined : CfnUserPoolSmsConfigurationPropertyFromCloudFormation(properties.SmsConfiguration),
        smsVerificationMessage: properties.SmsVerificationMessage == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.SmsVerificationMessage),
        usernameAttributes: cfn_parse.FromCloudFormation.getStringArray(properties.UsernameAttributes),
        usernameConfiguration: properties.UsernameConfiguration == null ? undefined : CfnUserPoolUsernameConfigurationPropertyFromCloudFormation(properties.UsernameConfiguration),
        userPoolAddOns: properties.UserPoolAddOns == null ? undefined : CfnUserPoolUserPoolAddOnsPropertyFromCloudFormation(properties.UserPoolAddOns),
        userPoolName: properties.UserPoolName == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.UserPoolName),
        userPoolTags: properties.UserPoolTags == null ? undefined : cfn_parse.FromCloudFormation.getAny(properties.UserPoolTags),
        verificationMessageTemplate: properties.VerificationMessageTemplate == null ? undefined : CfnUserPoolVerificationMessageTemplatePropertyFromCloudFormation(properties.VerificationMessageTemplate),
    };
}
/**
 * A CloudFormation `AWS::Cognito::UserPool`
 *
 * @cloudformationResource AWS::Cognito::UserPool
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpool.html
 */
class CfnUserPool extends cdk.CfnResource {
    /**
     * Create a new `AWS::Cognito::UserPool`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props = {}) {
        super(scope, id, { type: CfnUserPool.CFN_RESOURCE_TYPE_NAME, properties: props });
        this.attrArn = cdk.Token.asString(this.getAtt('Arn'));
        this.attrProviderName = cdk.Token.asString(this.getAtt('ProviderName'));
        this.attrProviderUrl = cdk.Token.asString(this.getAtt('ProviderURL'));
        this.accountRecoverySetting = props.accountRecoverySetting;
        this.adminCreateUserConfig = props.adminCreateUserConfig;
        this.aliasAttributes = props.aliasAttributes;
        this.autoVerifiedAttributes = props.autoVerifiedAttributes;
        this.deviceConfiguration = props.deviceConfiguration;
        this.emailConfiguration = props.emailConfiguration;
        this.emailVerificationMessage = props.emailVerificationMessage;
        this.emailVerificationSubject = props.emailVerificationSubject;
        this.enabledMfas = props.enabledMfas;
        this.lambdaConfig = props.lambdaConfig;
        this.mfaConfiguration = props.mfaConfiguration;
        this.policies = props.policies;
        this.schema = props.schema;
        this.smsAuthenticationMessage = props.smsAuthenticationMessage;
        this.smsConfiguration = props.smsConfiguration;
        this.smsVerificationMessage = props.smsVerificationMessage;
        this.usernameAttributes = props.usernameAttributes;
        this.usernameConfiguration = props.usernameConfiguration;
        this.userPoolAddOns = props.userPoolAddOns;
        this.userPoolName = props.userPoolName;
        this.tags = new cdk.TagManager(cdk.TagType.MAP, "AWS::Cognito::UserPool", props.userPoolTags, { tagPropertyName: 'userPoolTags' });
        this.verificationMessageTemplate = props.verificationMessageTemplate;
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @experimental
     */
    static fromCloudFormation(scope, id, resourceAttributes, options) {
        var _a;
        resourceAttributes = resourceAttributes || {};
        const cfnParser = new cfn_parse.CfnParser({
            finder: options.finder,
        });
        const resourceProperties = cfnParser.parseValue(resourceAttributes.Properties);
        const props = CfnUserPoolPropsFromCloudFormation(resourceProperties);
        const ret = new CfnUserPool(scope, id, props);
        const cfnOptions = ret.cfnOptions;
        cfnOptions.creationPolicy = cfnParser.parseCreationPolicy(resourceAttributes.CreationPolicy);
        cfnOptions.updatePolicy = cfnParser.parseUpdatePolicy(resourceAttributes.UpdatePolicy);
        cfnOptions.deletionPolicy = cfnParser.parseDeletionPolicy(resourceAttributes.DeletionPolicy);
        cfnOptions.updateReplacePolicy = cfnParser.parseDeletionPolicy(resourceAttributes.UpdateReplacePolicy);
        cfnOptions.metadata = cfnParser.parseValue(resourceAttributes.Metadata);
        // handle DependsOn
        resourceAttributes.DependsOn = (_a = resourceAttributes.DependsOn) !== null && _a !== void 0 ? _a : [];
        const dependencies = Array.isArray(resourceAttributes.DependsOn) ? resourceAttributes.DependsOn : [resourceAttributes.DependsOn];
        for (const dep of dependencies) {
            const depResource = options.finder.findResource(dep);
            if (!depResource) {
                throw new Error(`Resource '${id}' depends on '${dep}' that doesn't exist`);
            }
            ret.node.addDependency(depResource);
        }
        // handle Condition
        if (resourceAttributes.Condition) {
            const condition = options.finder.findCondition(resourceAttributes.Condition);
            if (!condition) {
                throw new Error(`Resource '${id}' uses Condition '${resourceAttributes.Condition}' that doesn't exist`);
            }
            cfnOptions.condition = condition;
        }
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector) {
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnUserPool.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            accountRecoverySetting: this.accountRecoverySetting,
            adminCreateUserConfig: this.adminCreateUserConfig,
            aliasAttributes: this.aliasAttributes,
            autoVerifiedAttributes: this.autoVerifiedAttributes,
            deviceConfiguration: this.deviceConfiguration,
            emailConfiguration: this.emailConfiguration,
            emailVerificationMessage: this.emailVerificationMessage,
            emailVerificationSubject: this.emailVerificationSubject,
            enabledMfas: this.enabledMfas,
            lambdaConfig: this.lambdaConfig,
            mfaConfiguration: this.mfaConfiguration,
            policies: this.policies,
            schema: this.schema,
            smsAuthenticationMessage: this.smsAuthenticationMessage,
            smsConfiguration: this.smsConfiguration,
            smsVerificationMessage: this.smsVerificationMessage,
            usernameAttributes: this.usernameAttributes,
            usernameConfiguration: this.usernameConfiguration,
            userPoolAddOns: this.userPoolAddOns,
            userPoolName: this.userPoolName,
            userPoolTags: this.tags.renderTags(),
            verificationMessageTemplate: this.verificationMessageTemplate,
        };
    }
    renderProperties(props) {
        return cfnUserPoolPropsToCloudFormation(props);
    }
}
exports.CfnUserPool = CfnUserPool;
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnUserPool.CFN_RESOURCE_TYPE_NAME = "AWS::Cognito::UserPool";
/**
 * Determine whether the given properties match those of a `AccountRecoverySettingProperty`
 *
 * @param properties - the TypeScript properties of a `AccountRecoverySettingProperty`
 *
 * @returns the result of the validation.
 */
function CfnUserPool_AccountRecoverySettingPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('recoveryMechanisms', cdk.listValidator(CfnUserPool_RecoveryOptionPropertyValidator))(properties.recoveryMechanisms));
    return errors.wrap('supplied properties not correct for "AccountRecoverySettingProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Cognito::UserPool.AccountRecoverySetting` resource
 *
 * @param properties - the TypeScript properties of a `AccountRecoverySettingProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Cognito::UserPool.AccountRecoverySetting` resource.
 */
// @ts-ignore TS6133
function cfnUserPoolAccountRecoverySettingPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnUserPool_AccountRecoverySettingPropertyValidator(properties).assertSuccess();
    return {
        RecoveryMechanisms: cdk.listMapper(cfnUserPoolRecoveryOptionPropertyToCloudFormation)(properties.recoveryMechanisms),
    };
}
// @ts-ignore TS6133
function CfnUserPoolAccountRecoverySettingPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return properties;
    }
    properties = properties || {};
    return {
        recoveryMechanisms: cfn_parse.FromCloudFormation.getArray(properties.RecoveryMechanisms, (prop1) => CfnUserPoolRecoveryOptionPropertyFromCloudFormation(prop1)),
    };
}
/**
 * Determine whether the given properties match those of a `AdminCreateUserConfigProperty`
 *
 * @param properties - the TypeScript properties of a `AdminCreateUserConfigProperty`
 *
 * @returns the result of the validation.
 */
function CfnUserPool_AdminCreateUserConfigPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('allowAdminCreateUserOnly', cdk.validateBoolean)(properties.allowAdminCreateUserOnly));
    errors.collect(cdk.propertyValidator('inviteMessageTemplate', CfnUserPool_InviteMessageTemplatePropertyValidator)(properties.inviteMessageTemplate));
    errors.collect(cdk.propertyValidator('unusedAccountValidityDays', cdk.validateNumber)(properties.unusedAccountValidityDays));
    return errors.wrap('supplied properties not correct for "AdminCreateUserConfigProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Cognito::UserPool.AdminCreateUserConfig` resource
 *
 * @param properties - the TypeScript properties of a `AdminCreateUserConfigProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Cognito::UserPool.AdminCreateUserConfig` resource.
 */
// @ts-ignore TS6133
function cfnUserPoolAdminCreateUserConfigPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnUserPool_AdminCreateUserConfigPropertyValidator(properties).assertSuccess();
    return {
        AllowAdminCreateUserOnly: cdk.booleanToCloudFormation(properties.allowAdminCreateUserOnly),
        InviteMessageTemplate: cfnUserPoolInviteMessageTemplatePropertyToCloudFormation(properties.inviteMessageTemplate),
        UnusedAccountValidityDays: cdk.numberToCloudFormation(properties.unusedAccountValidityDays),
    };
}
// @ts-ignore TS6133
function CfnUserPoolAdminCreateUserConfigPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return properties;
    }
    properties = properties || {};
    return {
        allowAdminCreateUserOnly: properties.AllowAdminCreateUserOnly == null ? undefined : cfn_parse.FromCloudFormation.getBoolean(properties.AllowAdminCreateUserOnly),
        inviteMessageTemplate: properties.InviteMessageTemplate == null ? undefined : CfnUserPoolInviteMessageTemplatePropertyFromCloudFormation(properties.InviteMessageTemplate),
        unusedAccountValidityDays: properties.UnusedAccountValidityDays == null ? undefined : cfn_parse.FromCloudFormation.getNumber(properties.UnusedAccountValidityDays),
    };
}
/**
 * Determine whether the given properties match those of a `DeviceConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `DeviceConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnUserPool_DeviceConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('challengeRequiredOnNewDevice', cdk.validateBoolean)(properties.challengeRequiredOnNewDevice));
    errors.collect(cdk.propertyValidator('deviceOnlyRememberedOnUserPrompt', cdk.validateBoolean)(properties.deviceOnlyRememberedOnUserPrompt));
    return errors.wrap('supplied properties not correct for "DeviceConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Cognito::UserPool.DeviceConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `DeviceConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Cognito::UserPool.DeviceConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnUserPoolDeviceConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnUserPool_DeviceConfigurationPropertyValidator(properties).assertSuccess();
    return {
        ChallengeRequiredOnNewDevice: cdk.booleanToCloudFormation(properties.challengeRequiredOnNewDevice),
        DeviceOnlyRememberedOnUserPrompt: cdk.booleanToCloudFormation(properties.deviceOnlyRememberedOnUserPrompt),
    };
}
// @ts-ignore TS6133
function CfnUserPoolDeviceConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return properties;
    }
    properties = properties || {};
    return {
        challengeRequiredOnNewDevice: properties.ChallengeRequiredOnNewDevice == null ? undefined : cfn_parse.FromCloudFormation.getBoolean(properties.ChallengeRequiredOnNewDevice),
        deviceOnlyRememberedOnUserPrompt: properties.DeviceOnlyRememberedOnUserPrompt == null ? undefined : cfn_parse.FromCloudFormation.getBoolean(properties.DeviceOnlyRememberedOnUserPrompt),
    };
}
/**
 * Determine whether the given properties match those of a `EmailConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `EmailConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnUserPool_EmailConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('configurationSet', cdk.validateString)(properties.configurationSet));
    errors.collect(cdk.propertyValidator('emailSendingAccount', cdk.validateString)(properties.emailSendingAccount));
    errors.collect(cdk.propertyValidator('from', cdk.validateString)(properties.from));
    errors.collect(cdk.propertyValidator('replyToEmailAddress', cdk.validateString)(properties.replyToEmailAddress));
    errors.collect(cdk.propertyValidator('sourceArn', cdk.validateString)(properties.sourceArn));
    return errors.wrap('supplied properties not correct for "EmailConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Cognito::UserPool.EmailConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `EmailConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Cognito::UserPool.EmailConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnUserPoolEmailConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnUserPool_EmailConfigurationPropertyValidator(properties).assertSuccess();
    return {
        ConfigurationSet: cdk.stringToCloudFormation(properties.configurationSet),
        EmailSendingAccount: cdk.stringToCloudFormation(properties.emailSendingAccount),
        From: cdk.stringToCloudFormation(properties.from),
        ReplyToEmailAddress: cdk.stringToCloudFormation(properties.replyToEmailAddress),
        SourceArn: cdk.stringToCloudFormation(properties.sourceArn),
    };
}
// @ts-ignore TS6133
function CfnUserPoolEmailConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return properties;
    }
    properties = properties || {};
    return {
        configurationSet: properties.ConfigurationSet == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.ConfigurationSet),
        emailSendingAccount: properties.EmailSendingAccount == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.EmailSendingAccount),
        from: properties.From == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.From),
        replyToEmailAddress: properties.ReplyToEmailAddress == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.ReplyToEmailAddress),
        sourceArn: properties.SourceArn == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.SourceArn),
    };
}
/**
 * Determine whether the given properties match those of a `InviteMessageTemplateProperty`
 *
 * @param properties - the TypeScript properties of a `InviteMessageTemplateProperty`
 *
 * @returns the result of the validation.
 */
function CfnUserPool_InviteMessageTemplatePropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('emailMessage', cdk.validateString)(properties.emailMessage));
    errors.collect(cdk.propertyValidator('emailSubject', cdk.validateString)(properties.emailSubject));
    errors.collect(cdk.propertyValidator('smsMessage', cdk.validateString)(properties.smsMessage));
    return errors.wrap('supplied properties not correct for "InviteMessageTemplateProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Cognito::UserPool.InviteMessageTemplate` resource
 *
 * @param properties - the TypeScript properties of a `InviteMessageTemplateProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Cognito::UserPool.InviteMessageTemplate` resource.
 */
// @ts-ignore TS6133
function cfnUserPoolInviteMessageTemplatePropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnUserPool_InviteMessageTemplatePropertyValidator(properties).assertSuccess();
    return {
        EmailMessage: cdk.stringToCloudFormation(properties.emailMessage),
        EmailSubject: cdk.stringToCloudFormation(properties.emailSubject),
        SMSMessage: cdk.stringToCloudFormation(properties.smsMessage),
    };
}
// @ts-ignore TS6133
function CfnUserPoolInviteMessageTemplatePropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return properties;
    }
    properties = properties || {};
    return {
        emailMessage: properties.EmailMessage == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.EmailMessage),
        emailSubject: properties.EmailSubject == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.EmailSubject),
        smsMessage: properties.SMSMessage == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.SMSMessage),
    };
}
/**
 * Determine whether the given properties match those of a `LambdaConfigProperty`
 *
 * @param properties - the TypeScript properties of a `LambdaConfigProperty`
 *
 * @returns the result of the validation.
 */
function CfnUserPool_LambdaConfigPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('createAuthChallenge', cdk.validateString)(properties.createAuthChallenge));
    errors.collect(cdk.propertyValidator('customMessage', cdk.validateString)(properties.customMessage));
    errors.collect(cdk.propertyValidator('defineAuthChallenge', cdk.validateString)(properties.defineAuthChallenge));
    errors.collect(cdk.propertyValidator('postAuthentication', cdk.validateString)(properties.postAuthentication));
    errors.collect(cdk.propertyValidator('postConfirmation', cdk.validateString)(properties.postConfirmation));
    errors.collect(cdk.propertyValidator('preAuthentication', cdk.validateString)(properties.preAuthentication));
    errors.collect(cdk.propertyValidator('preSignUp', cdk.validateString)(properties.preSignUp));
    errors.collect(cdk.propertyValidator('preTokenGeneration', cdk.validateString)(properties.preTokenGeneration));
    errors.collect(cdk.propertyValidator('userMigration', cdk.validateString)(properties.userMigration));
    errors.collect(cdk.propertyValidator('verifyAuthChallengeResponse', cdk.validateString)(properties.verifyAuthChallengeResponse));
    return errors.wrap('supplied properties not correct for "LambdaConfigProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Cognito::UserPool.LambdaConfig` resource
 *
 * @param properties - the TypeScript properties of a `LambdaConfigProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Cognito::UserPool.LambdaConfig` resource.
 */
// @ts-ignore TS6133
function cfnUserPoolLambdaConfigPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnUserPool_LambdaConfigPropertyValidator(properties).assertSuccess();
    return {
        CreateAuthChallenge: cdk.stringToCloudFormation(properties.createAuthChallenge),
        CustomMessage: cdk.stringToCloudFormation(properties.customMessage),
        DefineAuthChallenge: cdk.stringToCloudFormation(properties.defineAuthChallenge),
        PostAuthentication: cdk.stringToCloudFormation(properties.postAuthentication),
        PostConfirmation: cdk.stringToCloudFormation(properties.postConfirmation),
        PreAuthentication: cdk.stringToCloudFormation(properties.preAuthentication),
        PreSignUp: cdk.stringToCloudFormation(properties.preSignUp),
        PreTokenGeneration: cdk.stringToCloudFormation(properties.preTokenGeneration),
        UserMigration: cdk.stringToCloudFormation(properties.userMigration),
        VerifyAuthChallengeResponse: cdk.stringToCloudFormation(properties.verifyAuthChallengeResponse),
    };
}
// @ts-ignore TS6133
function CfnUserPoolLambdaConfigPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return properties;
    }
    properties = properties || {};
    return {
        createAuthChallenge: properties.CreateAuthChallenge == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.CreateAuthChallenge),
        customMessage: properties.CustomMessage == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.CustomMessage),
        defineAuthChallenge: properties.DefineAuthChallenge == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.DefineAuthChallenge),
        postAuthentication: properties.PostAuthentication == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.PostAuthentication),
        postConfirmation: properties.PostConfirmation == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.PostConfirmation),
        preAuthentication: properties.PreAuthentication == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.PreAuthentication),
        preSignUp: properties.PreSignUp == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.PreSignUp),
        preTokenGeneration: properties.PreTokenGeneration == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.PreTokenGeneration),
        userMigration: properties.UserMigration == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.UserMigration),
        verifyAuthChallengeResponse: properties.VerifyAuthChallengeResponse == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.VerifyAuthChallengeResponse),
    };
}
/**
 * Determine whether the given properties match those of a `NumberAttributeConstraintsProperty`
 *
 * @param properties - the TypeScript properties of a `NumberAttributeConstraintsProperty`
 *
 * @returns the result of the validation.
 */
function CfnUserPool_NumberAttributeConstraintsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('maxValue', cdk.validateString)(properties.maxValue));
    errors.collect(cdk.propertyValidator('minValue', cdk.validateString)(properties.minValue));
    return errors.wrap('supplied properties not correct for "NumberAttributeConstraintsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Cognito::UserPool.NumberAttributeConstraints` resource
 *
 * @param properties - the TypeScript properties of a `NumberAttributeConstraintsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Cognito::UserPool.NumberAttributeConstraints` resource.
 */
// @ts-ignore TS6133
function cfnUserPoolNumberAttributeConstraintsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnUserPool_NumberAttributeConstraintsPropertyValidator(properties).assertSuccess();
    return {
        MaxValue: cdk.stringToCloudFormation(properties.maxValue),
        MinValue: cdk.stringToCloudFormation(properties.minValue),
    };
}
// @ts-ignore TS6133
function CfnUserPoolNumberAttributeConstraintsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return properties;
    }
    properties = properties || {};
    return {
        maxValue: properties.MaxValue == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.MaxValue),
        minValue: properties.MinValue == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.MinValue),
    };
}
/**
 * Determine whether the given properties match those of a `PasswordPolicyProperty`
 *
 * @param properties - the TypeScript properties of a `PasswordPolicyProperty`
 *
 * @returns the result of the validation.
 */
function CfnUserPool_PasswordPolicyPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('minimumLength', cdk.validateNumber)(properties.minimumLength));
    errors.collect(cdk.propertyValidator('requireLowercase', cdk.validateBoolean)(properties.requireLowercase));
    errors.collect(cdk.propertyValidator('requireNumbers', cdk.validateBoolean)(properties.requireNumbers));
    errors.collect(cdk.propertyValidator('requireSymbols', cdk.validateBoolean)(properties.requireSymbols));
    errors.collect(cdk.propertyValidator('requireUppercase', cdk.validateBoolean)(properties.requireUppercase));
    errors.collect(cdk.propertyValidator('temporaryPasswordValidityDays', cdk.validateNumber)(properties.temporaryPasswordValidityDays));
    return errors.wrap('supplied properties not correct for "PasswordPolicyProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Cognito::UserPool.PasswordPolicy` resource
 *
 * @param properties - the TypeScript properties of a `PasswordPolicyProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Cognito::UserPool.PasswordPolicy` resource.
 */
// @ts-ignore TS6133
function cfnUserPoolPasswordPolicyPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnUserPool_PasswordPolicyPropertyValidator(properties).assertSuccess();
    return {
        MinimumLength: cdk.numberToCloudFormation(properties.minimumLength),
        RequireLowercase: cdk.booleanToCloudFormation(properties.requireLowercase),
        RequireNumbers: cdk.booleanToCloudFormation(properties.requireNumbers),
        RequireSymbols: cdk.booleanToCloudFormation(properties.requireSymbols),
        RequireUppercase: cdk.booleanToCloudFormation(properties.requireUppercase),
        TemporaryPasswordValidityDays: cdk.numberToCloudFormation(properties.temporaryPasswordValidityDays),
    };
}
// @ts-ignore TS6133
function CfnUserPoolPasswordPolicyPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return properties;
    }
    properties = properties || {};
    return {
        minimumLength: properties.MinimumLength == null ? undefined : cfn_parse.FromCloudFormation.getNumber(properties.MinimumLength),
        requireLowercase: properties.RequireLowercase == null ? undefined : cfn_parse.FromCloudFormation.getBoolean(properties.RequireLowercase),
        requireNumbers: properties.RequireNumbers == null ? undefined : cfn_parse.FromCloudFormation.getBoolean(properties.RequireNumbers),
        requireSymbols: properties.RequireSymbols == null ? undefined : cfn_parse.FromCloudFormation.getBoolean(properties.RequireSymbols),
        requireUppercase: properties.RequireUppercase == null ? undefined : cfn_parse.FromCloudFormation.getBoolean(properties.RequireUppercase),
        temporaryPasswordValidityDays: properties.TemporaryPasswordValidityDays == null ? undefined : cfn_parse.FromCloudFormation.getNumber(properties.TemporaryPasswordValidityDays),
    };
}
/**
 * Determine whether the given properties match those of a `PoliciesProperty`
 *
 * @param properties - the TypeScript properties of a `PoliciesProperty`
 *
 * @returns the result of the validation.
 */
function CfnUserPool_PoliciesPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('passwordPolicy', CfnUserPool_PasswordPolicyPropertyValidator)(properties.passwordPolicy));
    return errors.wrap('supplied properties not correct for "PoliciesProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Cognito::UserPool.Policies` resource
 *
 * @param properties - the TypeScript properties of a `PoliciesProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Cognito::UserPool.Policies` resource.
 */
// @ts-ignore TS6133
function cfnUserPoolPoliciesPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnUserPool_PoliciesPropertyValidator(properties).assertSuccess();
    return {
        PasswordPolicy: cfnUserPoolPasswordPolicyPropertyToCloudFormation(properties.passwordPolicy),
    };
}
// @ts-ignore TS6133
function CfnUserPoolPoliciesPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return properties;
    }
    properties = properties || {};
    return {
        passwordPolicy: properties.PasswordPolicy == null ? undefined : CfnUserPoolPasswordPolicyPropertyFromCloudFormation(properties.PasswordPolicy),
    };
}
/**
 * Determine whether the given properties match those of a `RecoveryOptionProperty`
 *
 * @param properties - the TypeScript properties of a `RecoveryOptionProperty`
 *
 * @returns the result of the validation.
 */
function CfnUserPool_RecoveryOptionPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('name', cdk.validateString)(properties.name));
    errors.collect(cdk.propertyValidator('priority', cdk.validateNumber)(properties.priority));
    return errors.wrap('supplied properties not correct for "RecoveryOptionProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Cognito::UserPool.RecoveryOption` resource
 *
 * @param properties - the TypeScript properties of a `RecoveryOptionProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Cognito::UserPool.RecoveryOption` resource.
 */
// @ts-ignore TS6133
function cfnUserPoolRecoveryOptionPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnUserPool_RecoveryOptionPropertyValidator(properties).assertSuccess();
    return {
        Name: cdk.stringToCloudFormation(properties.name),
        Priority: cdk.numberToCloudFormation(properties.priority),
    };
}
// @ts-ignore TS6133
function CfnUserPoolRecoveryOptionPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return properties;
    }
    properties = properties || {};
    return {
        name: properties.Name == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.Name),
        priority: properties.Priority == null ? undefined : cfn_parse.FromCloudFormation.getNumber(properties.Priority),
    };
}
/**
 * Determine whether the given properties match those of a `SchemaAttributeProperty`
 *
 * @param properties - the TypeScript properties of a `SchemaAttributeProperty`
 *
 * @returns the result of the validation.
 */
function CfnUserPool_SchemaAttributePropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('attributeDataType', cdk.validateString)(properties.attributeDataType));
    errors.collect(cdk.propertyValidator('developerOnlyAttribute', cdk.validateBoolean)(properties.developerOnlyAttribute));
    errors.collect(cdk.propertyValidator('mutable', cdk.validateBoolean)(properties.mutable));
    errors.collect(cdk.propertyValidator('name', cdk.validateString)(properties.name));
    errors.collect(cdk.propertyValidator('numberAttributeConstraints', CfnUserPool_NumberAttributeConstraintsPropertyValidator)(properties.numberAttributeConstraints));
    errors.collect(cdk.propertyValidator('required', cdk.validateBoolean)(properties.required));
    errors.collect(cdk.propertyValidator('stringAttributeConstraints', CfnUserPool_StringAttributeConstraintsPropertyValidator)(properties.stringAttributeConstraints));
    return errors.wrap('supplied properties not correct for "SchemaAttributeProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Cognito::UserPool.SchemaAttribute` resource
 *
 * @param properties - the TypeScript properties of a `SchemaAttributeProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Cognito::UserPool.SchemaAttribute` resource.
 */
// @ts-ignore TS6133
function cfnUserPoolSchemaAttributePropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnUserPool_SchemaAttributePropertyValidator(properties).assertSuccess();
    return {
        AttributeDataType: cdk.stringToCloudFormation(properties.attributeDataType),
        DeveloperOnlyAttribute: cdk.booleanToCloudFormation(properties.developerOnlyAttribute),
        Mutable: cdk.booleanToCloudFormation(properties.mutable),
        Name: cdk.stringToCloudFormation(properties.name),
        NumberAttributeConstraints: cfnUserPoolNumberAttributeConstraintsPropertyToCloudFormation(properties.numberAttributeConstraints),
        Required: cdk.booleanToCloudFormation(properties.required),
        StringAttributeConstraints: cfnUserPoolStringAttributeConstraintsPropertyToCloudFormation(properties.stringAttributeConstraints),
    };
}
// @ts-ignore TS6133
function CfnUserPoolSchemaAttributePropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return properties;
    }
    properties = properties || {};
    return {
        attributeDataType: properties.AttributeDataType == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.AttributeDataType),
        developerOnlyAttribute: properties.DeveloperOnlyAttribute == null ? undefined : cfn_parse.FromCloudFormation.getBoolean(properties.DeveloperOnlyAttribute),
        mutable: properties.Mutable == null ? undefined : cfn_parse.FromCloudFormation.getBoolean(properties.Mutable),
        name: properties.Name == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.Name),
        numberAttributeConstraints: properties.NumberAttributeConstraints == null ? undefined : CfnUserPoolNumberAttributeConstraintsPropertyFromCloudFormation(properties.NumberAttributeConstraints),
        required: properties.Required == null ? undefined : cfn_parse.FromCloudFormation.getBoolean(properties.Required),
        stringAttributeConstraints: properties.StringAttributeConstraints == null ? undefined : CfnUserPoolStringAttributeConstraintsPropertyFromCloudFormation(properties.StringAttributeConstraints),
    };
}
/**
 * Determine whether the given properties match those of a `SmsConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `SmsConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnUserPool_SmsConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('externalId', cdk.validateString)(properties.externalId));
    errors.collect(cdk.propertyValidator('snsCallerArn', cdk.validateString)(properties.snsCallerArn));
    return errors.wrap('supplied properties not correct for "SmsConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Cognito::UserPool.SmsConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `SmsConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Cognito::UserPool.SmsConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnUserPoolSmsConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnUserPool_SmsConfigurationPropertyValidator(properties).assertSuccess();
    return {
        ExternalId: cdk.stringToCloudFormation(properties.externalId),
        SnsCallerArn: cdk.stringToCloudFormation(properties.snsCallerArn),
    };
}
// @ts-ignore TS6133
function CfnUserPoolSmsConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return properties;
    }
    properties = properties || {};
    return {
        externalId: properties.ExternalId == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.ExternalId),
        snsCallerArn: properties.SnsCallerArn == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.SnsCallerArn),
    };
}
/**
 * Determine whether the given properties match those of a `StringAttributeConstraintsProperty`
 *
 * @param properties - the TypeScript properties of a `StringAttributeConstraintsProperty`
 *
 * @returns the result of the validation.
 */
function CfnUserPool_StringAttributeConstraintsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('maxLength', cdk.validateString)(properties.maxLength));
    errors.collect(cdk.propertyValidator('minLength', cdk.validateString)(properties.minLength));
    return errors.wrap('supplied properties not correct for "StringAttributeConstraintsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Cognito::UserPool.StringAttributeConstraints` resource
 *
 * @param properties - the TypeScript properties of a `StringAttributeConstraintsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Cognito::UserPool.StringAttributeConstraints` resource.
 */
// @ts-ignore TS6133
function cfnUserPoolStringAttributeConstraintsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnUserPool_StringAttributeConstraintsPropertyValidator(properties).assertSuccess();
    return {
        MaxLength: cdk.stringToCloudFormation(properties.maxLength),
        MinLength: cdk.stringToCloudFormation(properties.minLength),
    };
}
// @ts-ignore TS6133
function CfnUserPoolStringAttributeConstraintsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return properties;
    }
    properties = properties || {};
    return {
        maxLength: properties.MaxLength == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.MaxLength),
        minLength: properties.MinLength == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.MinLength),
    };
}
/**
 * Determine whether the given properties match those of a `UserPoolAddOnsProperty`
 *
 * @param properties - the TypeScript properties of a `UserPoolAddOnsProperty`
 *
 * @returns the result of the validation.
 */
function CfnUserPool_UserPoolAddOnsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('advancedSecurityMode', cdk.validateString)(properties.advancedSecurityMode));
    return errors.wrap('supplied properties not correct for "UserPoolAddOnsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Cognito::UserPool.UserPoolAddOns` resource
 *
 * @param properties - the TypeScript properties of a `UserPoolAddOnsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Cognito::UserPool.UserPoolAddOns` resource.
 */
// @ts-ignore TS6133
function cfnUserPoolUserPoolAddOnsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnUserPool_UserPoolAddOnsPropertyValidator(properties).assertSuccess();
    return {
        AdvancedSecurityMode: cdk.stringToCloudFormation(properties.advancedSecurityMode),
    };
}
// @ts-ignore TS6133
function CfnUserPoolUserPoolAddOnsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return properties;
    }
    properties = properties || {};
    return {
        advancedSecurityMode: properties.AdvancedSecurityMode == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.AdvancedSecurityMode),
    };
}
/**
 * Determine whether the given properties match those of a `UsernameConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `UsernameConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnUserPool_UsernameConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('caseSensitive', cdk.validateBoolean)(properties.caseSensitive));
    return errors.wrap('supplied properties not correct for "UsernameConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Cognito::UserPool.UsernameConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `UsernameConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Cognito::UserPool.UsernameConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnUserPoolUsernameConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnUserPool_UsernameConfigurationPropertyValidator(properties).assertSuccess();
    return {
        CaseSensitive: cdk.booleanToCloudFormation(properties.caseSensitive),
    };
}
// @ts-ignore TS6133
function CfnUserPoolUsernameConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return properties;
    }
    properties = properties || {};
    return {
        caseSensitive: properties.CaseSensitive == null ? undefined : cfn_parse.FromCloudFormation.getBoolean(properties.CaseSensitive),
    };
}
/**
 * Determine whether the given properties match those of a `VerificationMessageTemplateProperty`
 *
 * @param properties - the TypeScript properties of a `VerificationMessageTemplateProperty`
 *
 * @returns the result of the validation.
 */
function CfnUserPool_VerificationMessageTemplatePropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('defaultEmailOption', cdk.validateString)(properties.defaultEmailOption));
    errors.collect(cdk.propertyValidator('emailMessage', cdk.validateString)(properties.emailMessage));
    errors.collect(cdk.propertyValidator('emailMessageByLink', cdk.validateString)(properties.emailMessageByLink));
    errors.collect(cdk.propertyValidator('emailSubject', cdk.validateString)(properties.emailSubject));
    errors.collect(cdk.propertyValidator('emailSubjectByLink', cdk.validateString)(properties.emailSubjectByLink));
    errors.collect(cdk.propertyValidator('smsMessage', cdk.validateString)(properties.smsMessage));
    return errors.wrap('supplied properties not correct for "VerificationMessageTemplateProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Cognito::UserPool.VerificationMessageTemplate` resource
 *
 * @param properties - the TypeScript properties of a `VerificationMessageTemplateProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Cognito::UserPool.VerificationMessageTemplate` resource.
 */
// @ts-ignore TS6133
function cfnUserPoolVerificationMessageTemplatePropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnUserPool_VerificationMessageTemplatePropertyValidator(properties).assertSuccess();
    return {
        DefaultEmailOption: cdk.stringToCloudFormation(properties.defaultEmailOption),
        EmailMessage: cdk.stringToCloudFormation(properties.emailMessage),
        EmailMessageByLink: cdk.stringToCloudFormation(properties.emailMessageByLink),
        EmailSubject: cdk.stringToCloudFormation(properties.emailSubject),
        EmailSubjectByLink: cdk.stringToCloudFormation(properties.emailSubjectByLink),
        SmsMessage: cdk.stringToCloudFormation(properties.smsMessage),
    };
}
// @ts-ignore TS6133
function CfnUserPoolVerificationMessageTemplatePropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return properties;
    }
    properties = properties || {};
    return {
        defaultEmailOption: properties.DefaultEmailOption == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.DefaultEmailOption),
        emailMessage: properties.EmailMessage == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.EmailMessage),
        emailMessageByLink: properties.EmailMessageByLink == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.EmailMessageByLink),
        emailSubject: properties.EmailSubject == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.EmailSubject),
        emailSubjectByLink: properties.EmailSubjectByLink == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.EmailSubjectByLink),
        smsMessage: properties.SmsMessage == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.SmsMessage),
    };
}
/**
 * Determine whether the given properties match those of a `CfnUserPoolClientProps`
 *
 * @param properties - the TypeScript properties of a `CfnUserPoolClientProps`
 *
 * @returns the result of the validation.
 */
function CfnUserPoolClientPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('allowedOAuthFlows', cdk.listValidator(cdk.validateString))(properties.allowedOAuthFlows));
    errors.collect(cdk.propertyValidator('allowedOAuthFlowsUserPoolClient', cdk.validateBoolean)(properties.allowedOAuthFlowsUserPoolClient));
    errors.collect(cdk.propertyValidator('allowedOAuthScopes', cdk.listValidator(cdk.validateString))(properties.allowedOAuthScopes));
    errors.collect(cdk.propertyValidator('analyticsConfiguration', CfnUserPoolClient_AnalyticsConfigurationPropertyValidator)(properties.analyticsConfiguration));
    errors.collect(cdk.propertyValidator('callbackUrLs', cdk.listValidator(cdk.validateString))(properties.callbackUrLs));
    errors.collect(cdk.propertyValidator('clientName', cdk.validateString)(properties.clientName));
    errors.collect(cdk.propertyValidator('defaultRedirectUri', cdk.validateString)(properties.defaultRedirectUri));
    errors.collect(cdk.propertyValidator('explicitAuthFlows', cdk.listValidator(cdk.validateString))(properties.explicitAuthFlows));
    errors.collect(cdk.propertyValidator('generateSecret', cdk.validateBoolean)(properties.generateSecret));
    errors.collect(cdk.propertyValidator('logoutUrLs', cdk.listValidator(cdk.validateString))(properties.logoutUrLs));
    errors.collect(cdk.propertyValidator('preventUserExistenceErrors', cdk.validateString)(properties.preventUserExistenceErrors));
    errors.collect(cdk.propertyValidator('readAttributes', cdk.listValidator(cdk.validateString))(properties.readAttributes));
    errors.collect(cdk.propertyValidator('refreshTokenValidity', cdk.validateNumber)(properties.refreshTokenValidity));
    errors.collect(cdk.propertyValidator('supportedIdentityProviders', cdk.listValidator(cdk.validateString))(properties.supportedIdentityProviders));
    errors.collect(cdk.propertyValidator('userPoolId', cdk.requiredValidator)(properties.userPoolId));
    errors.collect(cdk.propertyValidator('userPoolId', cdk.validateString)(properties.userPoolId));
    errors.collect(cdk.propertyValidator('writeAttributes', cdk.listValidator(cdk.validateString))(properties.writeAttributes));
    return errors.wrap('supplied properties not correct for "CfnUserPoolClientProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Cognito::UserPoolClient` resource
 *
 * @param properties - the TypeScript properties of a `CfnUserPoolClientProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Cognito::UserPoolClient` resource.
 */
// @ts-ignore TS6133
function cfnUserPoolClientPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnUserPoolClientPropsValidator(properties).assertSuccess();
    return {
        UserPoolId: cdk.stringToCloudFormation(properties.userPoolId),
        AllowedOAuthFlows: cdk.listMapper(cdk.stringToCloudFormation)(properties.allowedOAuthFlows),
        AllowedOAuthFlowsUserPoolClient: cdk.booleanToCloudFormation(properties.allowedOAuthFlowsUserPoolClient),
        AllowedOAuthScopes: cdk.listMapper(cdk.stringToCloudFormation)(properties.allowedOAuthScopes),
        AnalyticsConfiguration: cfnUserPoolClientAnalyticsConfigurationPropertyToCloudFormation(properties.analyticsConfiguration),
        CallbackURLs: cdk.listMapper(cdk.stringToCloudFormation)(properties.callbackUrLs),
        ClientName: cdk.stringToCloudFormation(properties.clientName),
        DefaultRedirectURI: cdk.stringToCloudFormation(properties.defaultRedirectUri),
        ExplicitAuthFlows: cdk.listMapper(cdk.stringToCloudFormation)(properties.explicitAuthFlows),
        GenerateSecret: cdk.booleanToCloudFormation(properties.generateSecret),
        LogoutURLs: cdk.listMapper(cdk.stringToCloudFormation)(properties.logoutUrLs),
        PreventUserExistenceErrors: cdk.stringToCloudFormation(properties.preventUserExistenceErrors),
        ReadAttributes: cdk.listMapper(cdk.stringToCloudFormation)(properties.readAttributes),
        RefreshTokenValidity: cdk.numberToCloudFormation(properties.refreshTokenValidity),
        SupportedIdentityProviders: cdk.listMapper(cdk.stringToCloudFormation)(properties.supportedIdentityProviders),
        WriteAttributes: cdk.listMapper(cdk.stringToCloudFormation)(properties.writeAttributes),
    };
}
// @ts-ignore TS6133
function CfnUserPoolClientPropsFromCloudFormation(properties) {
    properties = properties || {};
    return {
        userPoolId: cfn_parse.FromCloudFormation.getString(properties.UserPoolId),
        allowedOAuthFlows: cfn_parse.FromCloudFormation.getStringArray(properties.AllowedOAuthFlows),
        allowedOAuthFlowsUserPoolClient: properties.AllowedOAuthFlowsUserPoolClient == null ? undefined : cfn_parse.FromCloudFormation.getBoolean(properties.AllowedOAuthFlowsUserPoolClient),
        allowedOAuthScopes: cfn_parse.FromCloudFormation.getStringArray(properties.AllowedOAuthScopes),
        analyticsConfiguration: properties.AnalyticsConfiguration == null ? undefined : CfnUserPoolClientAnalyticsConfigurationPropertyFromCloudFormation(properties.AnalyticsConfiguration),
        callbackUrLs: cfn_parse.FromCloudFormation.getStringArray(properties.CallbackURLs),
        clientName: properties.ClientName == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.ClientName),
        defaultRedirectUri: properties.DefaultRedirectURI == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.DefaultRedirectURI),
        explicitAuthFlows: cfn_parse.FromCloudFormation.getStringArray(properties.ExplicitAuthFlows),
        generateSecret: properties.GenerateSecret == null ? undefined : cfn_parse.FromCloudFormation.getBoolean(properties.GenerateSecret),
        logoutUrLs: cfn_parse.FromCloudFormation.getStringArray(properties.LogoutURLs),
        preventUserExistenceErrors: properties.PreventUserExistenceErrors == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.PreventUserExistenceErrors),
        readAttributes: cfn_parse.FromCloudFormation.getStringArray(properties.ReadAttributes),
        refreshTokenValidity: properties.RefreshTokenValidity == null ? undefined : cfn_parse.FromCloudFormation.getNumber(properties.RefreshTokenValidity),
        supportedIdentityProviders: cfn_parse.FromCloudFormation.getStringArray(properties.SupportedIdentityProviders),
        writeAttributes: cfn_parse.FromCloudFormation.getStringArray(properties.WriteAttributes),
    };
}
/**
 * A CloudFormation `AWS::Cognito::UserPoolClient`
 *
 * @cloudformationResource AWS::Cognito::UserPoolClient
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolclient.html
 */
class CfnUserPoolClient extends cdk.CfnResource {
    /**
     * Create a new `AWS::Cognito::UserPoolClient`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnUserPoolClient.CFN_RESOURCE_TYPE_NAME, properties: props });
        cdk.requireProperty(props, 'userPoolId', this);
        this.attrClientSecret = cdk.Token.asString(this.getAtt('ClientSecret'));
        this.attrName = cdk.Token.asString(this.getAtt('Name'));
        this.userPoolId = props.userPoolId;
        this.allowedOAuthFlows = props.allowedOAuthFlows;
        this.allowedOAuthFlowsUserPoolClient = props.allowedOAuthFlowsUserPoolClient;
        this.allowedOAuthScopes = props.allowedOAuthScopes;
        this.analyticsConfiguration = props.analyticsConfiguration;
        this.callbackUrLs = props.callbackUrLs;
        this.clientName = props.clientName;
        this.defaultRedirectUri = props.defaultRedirectUri;
        this.explicitAuthFlows = props.explicitAuthFlows;
        this.generateSecret = props.generateSecret;
        this.logoutUrLs = props.logoutUrLs;
        this.preventUserExistenceErrors = props.preventUserExistenceErrors;
        this.readAttributes = props.readAttributes;
        this.refreshTokenValidity = props.refreshTokenValidity;
        this.supportedIdentityProviders = props.supportedIdentityProviders;
        this.writeAttributes = props.writeAttributes;
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @experimental
     */
    static fromCloudFormation(scope, id, resourceAttributes, options) {
        var _a;
        resourceAttributes = resourceAttributes || {};
        const cfnParser = new cfn_parse.CfnParser({
            finder: options.finder,
        });
        const resourceProperties = cfnParser.parseValue(resourceAttributes.Properties);
        const props = CfnUserPoolClientPropsFromCloudFormation(resourceProperties);
        const ret = new CfnUserPoolClient(scope, id, props);
        const cfnOptions = ret.cfnOptions;
        cfnOptions.creationPolicy = cfnParser.parseCreationPolicy(resourceAttributes.CreationPolicy);
        cfnOptions.updatePolicy = cfnParser.parseUpdatePolicy(resourceAttributes.UpdatePolicy);
        cfnOptions.deletionPolicy = cfnParser.parseDeletionPolicy(resourceAttributes.DeletionPolicy);
        cfnOptions.updateReplacePolicy = cfnParser.parseDeletionPolicy(resourceAttributes.UpdateReplacePolicy);
        cfnOptions.metadata = cfnParser.parseValue(resourceAttributes.Metadata);
        // handle DependsOn
        resourceAttributes.DependsOn = (_a = resourceAttributes.DependsOn) !== null && _a !== void 0 ? _a : [];
        const dependencies = Array.isArray(resourceAttributes.DependsOn) ? resourceAttributes.DependsOn : [resourceAttributes.DependsOn];
        for (const dep of dependencies) {
            const depResource = options.finder.findResource(dep);
            if (!depResource) {
                throw new Error(`Resource '${id}' depends on '${dep}' that doesn't exist`);
            }
            ret.node.addDependency(depResource);
        }
        // handle Condition
        if (resourceAttributes.Condition) {
            const condition = options.finder.findCondition(resourceAttributes.Condition);
            if (!condition) {
                throw new Error(`Resource '${id}' uses Condition '${resourceAttributes.Condition}' that doesn't exist`);
            }
            cfnOptions.condition = condition;
        }
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector) {
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnUserPoolClient.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            userPoolId: this.userPoolId,
            allowedOAuthFlows: this.allowedOAuthFlows,
            allowedOAuthFlowsUserPoolClient: this.allowedOAuthFlowsUserPoolClient,
            allowedOAuthScopes: this.allowedOAuthScopes,
            analyticsConfiguration: this.analyticsConfiguration,
            callbackUrLs: this.callbackUrLs,
            clientName: this.clientName,
            defaultRedirectUri: this.defaultRedirectUri,
            explicitAuthFlows: this.explicitAuthFlows,
            generateSecret: this.generateSecret,
            logoutUrLs: this.logoutUrLs,
            preventUserExistenceErrors: this.preventUserExistenceErrors,
            readAttributes: this.readAttributes,
            refreshTokenValidity: this.refreshTokenValidity,
            supportedIdentityProviders: this.supportedIdentityProviders,
            writeAttributes: this.writeAttributes,
        };
    }
    renderProperties(props) {
        return cfnUserPoolClientPropsToCloudFormation(props);
    }
}
exports.CfnUserPoolClient = CfnUserPoolClient;
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnUserPoolClient.CFN_RESOURCE_TYPE_NAME = "AWS::Cognito::UserPoolClient";
/**
 * Determine whether the given properties match those of a `AnalyticsConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `AnalyticsConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnUserPoolClient_AnalyticsConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('applicationId', cdk.validateString)(properties.applicationId));
    errors.collect(cdk.propertyValidator('externalId', cdk.validateString)(properties.externalId));
    errors.collect(cdk.propertyValidator('roleArn', cdk.validateString)(properties.roleArn));
    errors.collect(cdk.propertyValidator('userDataShared', cdk.validateBoolean)(properties.userDataShared));
    return errors.wrap('supplied properties not correct for "AnalyticsConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Cognito::UserPoolClient.AnalyticsConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `AnalyticsConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Cognito::UserPoolClient.AnalyticsConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnUserPoolClientAnalyticsConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnUserPoolClient_AnalyticsConfigurationPropertyValidator(properties).assertSuccess();
    return {
        ApplicationId: cdk.stringToCloudFormation(properties.applicationId),
        ExternalId: cdk.stringToCloudFormation(properties.externalId),
        RoleArn: cdk.stringToCloudFormation(properties.roleArn),
        UserDataShared: cdk.booleanToCloudFormation(properties.userDataShared),
    };
}
// @ts-ignore TS6133
function CfnUserPoolClientAnalyticsConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return properties;
    }
    properties = properties || {};
    return {
        applicationId: properties.ApplicationId == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.ApplicationId),
        externalId: properties.ExternalId == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.ExternalId),
        roleArn: properties.RoleArn == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.RoleArn),
        userDataShared: properties.UserDataShared == null ? undefined : cfn_parse.FromCloudFormation.getBoolean(properties.UserDataShared),
    };
}
/**
 * Determine whether the given properties match those of a `CfnUserPoolDomainProps`
 *
 * @param properties - the TypeScript properties of a `CfnUserPoolDomainProps`
 *
 * @returns the result of the validation.
 */
function CfnUserPoolDomainPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('customDomainConfig', CfnUserPoolDomain_CustomDomainConfigTypePropertyValidator)(properties.customDomainConfig));
    errors.collect(cdk.propertyValidator('domain', cdk.requiredValidator)(properties.domain));
    errors.collect(cdk.propertyValidator('domain', cdk.validateString)(properties.domain));
    errors.collect(cdk.propertyValidator('userPoolId', cdk.requiredValidator)(properties.userPoolId));
    errors.collect(cdk.propertyValidator('userPoolId', cdk.validateString)(properties.userPoolId));
    return errors.wrap('supplied properties not correct for "CfnUserPoolDomainProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Cognito::UserPoolDomain` resource
 *
 * @param properties - the TypeScript properties of a `CfnUserPoolDomainProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Cognito::UserPoolDomain` resource.
 */
// @ts-ignore TS6133
function cfnUserPoolDomainPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnUserPoolDomainPropsValidator(properties).assertSuccess();
    return {
        Domain: cdk.stringToCloudFormation(properties.domain),
        UserPoolId: cdk.stringToCloudFormation(properties.userPoolId),
        CustomDomainConfig: cfnUserPoolDomainCustomDomainConfigTypePropertyToCloudFormation(properties.customDomainConfig),
    };
}
// @ts-ignore TS6133
function CfnUserPoolDomainPropsFromCloudFormation(properties) {
    properties = properties || {};
    return {
        domain: cfn_parse.FromCloudFormation.getString(properties.Domain),
        userPoolId: cfn_parse.FromCloudFormation.getString(properties.UserPoolId),
        customDomainConfig: properties.CustomDomainConfig == null ? undefined : CfnUserPoolDomainCustomDomainConfigTypePropertyFromCloudFormation(properties.CustomDomainConfig),
    };
}
/**
 * A CloudFormation `AWS::Cognito::UserPoolDomain`
 *
 * @cloudformationResource AWS::Cognito::UserPoolDomain
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpooldomain.html
 */
class CfnUserPoolDomain extends cdk.CfnResource {
    /**
     * Create a new `AWS::Cognito::UserPoolDomain`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnUserPoolDomain.CFN_RESOURCE_TYPE_NAME, properties: props });
        cdk.requireProperty(props, 'domain', this);
        cdk.requireProperty(props, 'userPoolId', this);
        this.domain = props.domain;
        this.userPoolId = props.userPoolId;
        this.customDomainConfig = props.customDomainConfig;
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @experimental
     */
    static fromCloudFormation(scope, id, resourceAttributes, options) {
        var _a;
        resourceAttributes = resourceAttributes || {};
        const cfnParser = new cfn_parse.CfnParser({
            finder: options.finder,
        });
        const resourceProperties = cfnParser.parseValue(resourceAttributes.Properties);
        const props = CfnUserPoolDomainPropsFromCloudFormation(resourceProperties);
        const ret = new CfnUserPoolDomain(scope, id, props);
        const cfnOptions = ret.cfnOptions;
        cfnOptions.creationPolicy = cfnParser.parseCreationPolicy(resourceAttributes.CreationPolicy);
        cfnOptions.updatePolicy = cfnParser.parseUpdatePolicy(resourceAttributes.UpdatePolicy);
        cfnOptions.deletionPolicy = cfnParser.parseDeletionPolicy(resourceAttributes.DeletionPolicy);
        cfnOptions.updateReplacePolicy = cfnParser.parseDeletionPolicy(resourceAttributes.UpdateReplacePolicy);
        cfnOptions.metadata = cfnParser.parseValue(resourceAttributes.Metadata);
        // handle DependsOn
        resourceAttributes.DependsOn = (_a = resourceAttributes.DependsOn) !== null && _a !== void 0 ? _a : [];
        const dependencies = Array.isArray(resourceAttributes.DependsOn) ? resourceAttributes.DependsOn : [resourceAttributes.DependsOn];
        for (const dep of dependencies) {
            const depResource = options.finder.findResource(dep);
            if (!depResource) {
                throw new Error(`Resource '${id}' depends on '${dep}' that doesn't exist`);
            }
            ret.node.addDependency(depResource);
        }
        // handle Condition
        if (resourceAttributes.Condition) {
            const condition = options.finder.findCondition(resourceAttributes.Condition);
            if (!condition) {
                throw new Error(`Resource '${id}' uses Condition '${resourceAttributes.Condition}' that doesn't exist`);
            }
            cfnOptions.condition = condition;
        }
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector) {
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnUserPoolDomain.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            domain: this.domain,
            userPoolId: this.userPoolId,
            customDomainConfig: this.customDomainConfig,
        };
    }
    renderProperties(props) {
        return cfnUserPoolDomainPropsToCloudFormation(props);
    }
}
exports.CfnUserPoolDomain = CfnUserPoolDomain;
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnUserPoolDomain.CFN_RESOURCE_TYPE_NAME = "AWS::Cognito::UserPoolDomain";
/**
 * Determine whether the given properties match those of a `CustomDomainConfigTypeProperty`
 *
 * @param properties - the TypeScript properties of a `CustomDomainConfigTypeProperty`
 *
 * @returns the result of the validation.
 */
function CfnUserPoolDomain_CustomDomainConfigTypePropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('certificateArn', cdk.validateString)(properties.certificateArn));
    return errors.wrap('supplied properties not correct for "CustomDomainConfigTypeProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Cognito::UserPoolDomain.CustomDomainConfigType` resource
 *
 * @param properties - the TypeScript properties of a `CustomDomainConfigTypeProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Cognito::UserPoolDomain.CustomDomainConfigType` resource.
 */
// @ts-ignore TS6133
function cfnUserPoolDomainCustomDomainConfigTypePropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnUserPoolDomain_CustomDomainConfigTypePropertyValidator(properties).assertSuccess();
    return {
        CertificateArn: cdk.stringToCloudFormation(properties.certificateArn),
    };
}
// @ts-ignore TS6133
function CfnUserPoolDomainCustomDomainConfigTypePropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return properties;
    }
    properties = properties || {};
    return {
        certificateArn: properties.CertificateArn == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.CertificateArn),
    };
}
/**
 * Determine whether the given properties match those of a `CfnUserPoolGroupProps`
 *
 * @param properties - the TypeScript properties of a `CfnUserPoolGroupProps`
 *
 * @returns the result of the validation.
 */
function CfnUserPoolGroupPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('description', cdk.validateString)(properties.description));
    errors.collect(cdk.propertyValidator('groupName', cdk.validateString)(properties.groupName));
    errors.collect(cdk.propertyValidator('precedence', cdk.validateNumber)(properties.precedence));
    errors.collect(cdk.propertyValidator('roleArn', cdk.validateString)(properties.roleArn));
    errors.collect(cdk.propertyValidator('userPoolId', cdk.requiredValidator)(properties.userPoolId));
    errors.collect(cdk.propertyValidator('userPoolId', cdk.validateString)(properties.userPoolId));
    return errors.wrap('supplied properties not correct for "CfnUserPoolGroupProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Cognito::UserPoolGroup` resource
 *
 * @param properties - the TypeScript properties of a `CfnUserPoolGroupProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Cognito::UserPoolGroup` resource.
 */
// @ts-ignore TS6133
function cfnUserPoolGroupPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnUserPoolGroupPropsValidator(properties).assertSuccess();
    return {
        UserPoolId: cdk.stringToCloudFormation(properties.userPoolId),
        Description: cdk.stringToCloudFormation(properties.description),
        GroupName: cdk.stringToCloudFormation(properties.groupName),
        Precedence: cdk.numberToCloudFormation(properties.precedence),
        RoleArn: cdk.stringToCloudFormation(properties.roleArn),
    };
}
// @ts-ignore TS6133
function CfnUserPoolGroupPropsFromCloudFormation(properties) {
    properties = properties || {};
    return {
        userPoolId: cfn_parse.FromCloudFormation.getString(properties.UserPoolId),
        description: properties.Description == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.Description),
        groupName: properties.GroupName == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.GroupName),
        precedence: properties.Precedence == null ? undefined : cfn_parse.FromCloudFormation.getNumber(properties.Precedence),
        roleArn: properties.RoleArn == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.RoleArn),
    };
}
/**
 * A CloudFormation `AWS::Cognito::UserPoolGroup`
 *
 * @cloudformationResource AWS::Cognito::UserPoolGroup
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolgroup.html
 */
class CfnUserPoolGroup extends cdk.CfnResource {
    /**
     * Create a new `AWS::Cognito::UserPoolGroup`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnUserPoolGroup.CFN_RESOURCE_TYPE_NAME, properties: props });
        cdk.requireProperty(props, 'userPoolId', this);
        this.userPoolId = props.userPoolId;
        this.description = props.description;
        this.groupName = props.groupName;
        this.precedence = props.precedence;
        this.roleArn = props.roleArn;
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @experimental
     */
    static fromCloudFormation(scope, id, resourceAttributes, options) {
        var _a;
        resourceAttributes = resourceAttributes || {};
        const cfnParser = new cfn_parse.CfnParser({
            finder: options.finder,
        });
        const resourceProperties = cfnParser.parseValue(resourceAttributes.Properties);
        const props = CfnUserPoolGroupPropsFromCloudFormation(resourceProperties);
        const ret = new CfnUserPoolGroup(scope, id, props);
        const cfnOptions = ret.cfnOptions;
        cfnOptions.creationPolicy = cfnParser.parseCreationPolicy(resourceAttributes.CreationPolicy);
        cfnOptions.updatePolicy = cfnParser.parseUpdatePolicy(resourceAttributes.UpdatePolicy);
        cfnOptions.deletionPolicy = cfnParser.parseDeletionPolicy(resourceAttributes.DeletionPolicy);
        cfnOptions.updateReplacePolicy = cfnParser.parseDeletionPolicy(resourceAttributes.UpdateReplacePolicy);
        cfnOptions.metadata = cfnParser.parseValue(resourceAttributes.Metadata);
        // handle DependsOn
        resourceAttributes.DependsOn = (_a = resourceAttributes.DependsOn) !== null && _a !== void 0 ? _a : [];
        const dependencies = Array.isArray(resourceAttributes.DependsOn) ? resourceAttributes.DependsOn : [resourceAttributes.DependsOn];
        for (const dep of dependencies) {
            const depResource = options.finder.findResource(dep);
            if (!depResource) {
                throw new Error(`Resource '${id}' depends on '${dep}' that doesn't exist`);
            }
            ret.node.addDependency(depResource);
        }
        // handle Condition
        if (resourceAttributes.Condition) {
            const condition = options.finder.findCondition(resourceAttributes.Condition);
            if (!condition) {
                throw new Error(`Resource '${id}' uses Condition '${resourceAttributes.Condition}' that doesn't exist`);
            }
            cfnOptions.condition = condition;
        }
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector) {
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnUserPoolGroup.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            userPoolId: this.userPoolId,
            description: this.description,
            groupName: this.groupName,
            precedence: this.precedence,
            roleArn: this.roleArn,
        };
    }
    renderProperties(props) {
        return cfnUserPoolGroupPropsToCloudFormation(props);
    }
}
exports.CfnUserPoolGroup = CfnUserPoolGroup;
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnUserPoolGroup.CFN_RESOURCE_TYPE_NAME = "AWS::Cognito::UserPoolGroup";
/**
 * Determine whether the given properties match those of a `CfnUserPoolIdentityProviderProps`
 *
 * @param properties - the TypeScript properties of a `CfnUserPoolIdentityProviderProps`
 *
 * @returns the result of the validation.
 */
function CfnUserPoolIdentityProviderPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('attributeMapping', cdk.validateObject)(properties.attributeMapping));
    errors.collect(cdk.propertyValidator('idpIdentifiers', cdk.listValidator(cdk.validateString))(properties.idpIdentifiers));
    errors.collect(cdk.propertyValidator('providerDetails', cdk.validateObject)(properties.providerDetails));
    errors.collect(cdk.propertyValidator('providerName', cdk.requiredValidator)(properties.providerName));
    errors.collect(cdk.propertyValidator('providerName', cdk.validateString)(properties.providerName));
    errors.collect(cdk.propertyValidator('providerType', cdk.requiredValidator)(properties.providerType));
    errors.collect(cdk.propertyValidator('providerType', cdk.validateString)(properties.providerType));
    errors.collect(cdk.propertyValidator('userPoolId', cdk.requiredValidator)(properties.userPoolId));
    errors.collect(cdk.propertyValidator('userPoolId', cdk.validateString)(properties.userPoolId));
    return errors.wrap('supplied properties not correct for "CfnUserPoolIdentityProviderProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Cognito::UserPoolIdentityProvider` resource
 *
 * @param properties - the TypeScript properties of a `CfnUserPoolIdentityProviderProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Cognito::UserPoolIdentityProvider` resource.
 */
// @ts-ignore TS6133
function cfnUserPoolIdentityProviderPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnUserPoolIdentityProviderPropsValidator(properties).assertSuccess();
    return {
        ProviderName: cdk.stringToCloudFormation(properties.providerName),
        ProviderType: cdk.stringToCloudFormation(properties.providerType),
        UserPoolId: cdk.stringToCloudFormation(properties.userPoolId),
        AttributeMapping: cdk.objectToCloudFormation(properties.attributeMapping),
        IdpIdentifiers: cdk.listMapper(cdk.stringToCloudFormation)(properties.idpIdentifiers),
        ProviderDetails: cdk.objectToCloudFormation(properties.providerDetails),
    };
}
// @ts-ignore TS6133
function CfnUserPoolIdentityProviderPropsFromCloudFormation(properties) {
    properties = properties || {};
    return {
        providerName: cfn_parse.FromCloudFormation.getString(properties.ProviderName),
        providerType: cfn_parse.FromCloudFormation.getString(properties.ProviderType),
        userPoolId: cfn_parse.FromCloudFormation.getString(properties.UserPoolId),
        attributeMapping: properties.AttributeMapping == null ? undefined : cfn_parse.FromCloudFormation.getAny(properties.AttributeMapping),
        idpIdentifiers: cfn_parse.FromCloudFormation.getStringArray(properties.IdpIdentifiers),
        providerDetails: properties.ProviderDetails == null ? undefined : cfn_parse.FromCloudFormation.getAny(properties.ProviderDetails),
    };
}
/**
 * A CloudFormation `AWS::Cognito::UserPoolIdentityProvider`
 *
 * @cloudformationResource AWS::Cognito::UserPoolIdentityProvider
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolidentityprovider.html
 */
class CfnUserPoolIdentityProvider extends cdk.CfnResource {
    /**
     * Create a new `AWS::Cognito::UserPoolIdentityProvider`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnUserPoolIdentityProvider.CFN_RESOURCE_TYPE_NAME, properties: props });
        cdk.requireProperty(props, 'providerName', this);
        cdk.requireProperty(props, 'providerType', this);
        cdk.requireProperty(props, 'userPoolId', this);
        this.providerName = props.providerName;
        this.providerType = props.providerType;
        this.userPoolId = props.userPoolId;
        this.attributeMapping = props.attributeMapping;
        this.idpIdentifiers = props.idpIdentifiers;
        this.providerDetails = props.providerDetails;
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @experimental
     */
    static fromCloudFormation(scope, id, resourceAttributes, options) {
        var _a;
        resourceAttributes = resourceAttributes || {};
        const cfnParser = new cfn_parse.CfnParser({
            finder: options.finder,
        });
        const resourceProperties = cfnParser.parseValue(resourceAttributes.Properties);
        const props = CfnUserPoolIdentityProviderPropsFromCloudFormation(resourceProperties);
        const ret = new CfnUserPoolIdentityProvider(scope, id, props);
        const cfnOptions = ret.cfnOptions;
        cfnOptions.creationPolicy = cfnParser.parseCreationPolicy(resourceAttributes.CreationPolicy);
        cfnOptions.updatePolicy = cfnParser.parseUpdatePolicy(resourceAttributes.UpdatePolicy);
        cfnOptions.deletionPolicy = cfnParser.parseDeletionPolicy(resourceAttributes.DeletionPolicy);
        cfnOptions.updateReplacePolicy = cfnParser.parseDeletionPolicy(resourceAttributes.UpdateReplacePolicy);
        cfnOptions.metadata = cfnParser.parseValue(resourceAttributes.Metadata);
        // handle DependsOn
        resourceAttributes.DependsOn = (_a = resourceAttributes.DependsOn) !== null && _a !== void 0 ? _a : [];
        const dependencies = Array.isArray(resourceAttributes.DependsOn) ? resourceAttributes.DependsOn : [resourceAttributes.DependsOn];
        for (const dep of dependencies) {
            const depResource = options.finder.findResource(dep);
            if (!depResource) {
                throw new Error(`Resource '${id}' depends on '${dep}' that doesn't exist`);
            }
            ret.node.addDependency(depResource);
        }
        // handle Condition
        if (resourceAttributes.Condition) {
            const condition = options.finder.findCondition(resourceAttributes.Condition);
            if (!condition) {
                throw new Error(`Resource '${id}' uses Condition '${resourceAttributes.Condition}' that doesn't exist`);
            }
            cfnOptions.condition = condition;
        }
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector) {
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnUserPoolIdentityProvider.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            providerName: this.providerName,
            providerType: this.providerType,
            userPoolId: this.userPoolId,
            attributeMapping: this.attributeMapping,
            idpIdentifiers: this.idpIdentifiers,
            providerDetails: this.providerDetails,
        };
    }
    renderProperties(props) {
        return cfnUserPoolIdentityProviderPropsToCloudFormation(props);
    }
}
exports.CfnUserPoolIdentityProvider = CfnUserPoolIdentityProvider;
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnUserPoolIdentityProvider.CFN_RESOURCE_TYPE_NAME = "AWS::Cognito::UserPoolIdentityProvider";
/**
 * Determine whether the given properties match those of a `CfnUserPoolResourceServerProps`
 *
 * @param properties - the TypeScript properties of a `CfnUserPoolResourceServerProps`
 *
 * @returns the result of the validation.
 */
function CfnUserPoolResourceServerPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('identifier', cdk.requiredValidator)(properties.identifier));
    errors.collect(cdk.propertyValidator('identifier', cdk.validateString)(properties.identifier));
    errors.collect(cdk.propertyValidator('name', cdk.requiredValidator)(properties.name));
    errors.collect(cdk.propertyValidator('name', cdk.validateString)(properties.name));
    errors.collect(cdk.propertyValidator('scopes', cdk.listValidator(CfnUserPoolResourceServer_ResourceServerScopeTypePropertyValidator))(properties.scopes));
    errors.collect(cdk.propertyValidator('userPoolId', cdk.requiredValidator)(properties.userPoolId));
    errors.collect(cdk.propertyValidator('userPoolId', cdk.validateString)(properties.userPoolId));
    return errors.wrap('supplied properties not correct for "CfnUserPoolResourceServerProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Cognito::UserPoolResourceServer` resource
 *
 * @param properties - the TypeScript properties of a `CfnUserPoolResourceServerProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Cognito::UserPoolResourceServer` resource.
 */
// @ts-ignore TS6133
function cfnUserPoolResourceServerPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnUserPoolResourceServerPropsValidator(properties).assertSuccess();
    return {
        Identifier: cdk.stringToCloudFormation(properties.identifier),
        Name: cdk.stringToCloudFormation(properties.name),
        UserPoolId: cdk.stringToCloudFormation(properties.userPoolId),
        Scopes: cdk.listMapper(cfnUserPoolResourceServerResourceServerScopeTypePropertyToCloudFormation)(properties.scopes),
    };
}
// @ts-ignore TS6133
function CfnUserPoolResourceServerPropsFromCloudFormation(properties) {
    properties = properties || {};
    return {
        identifier: cfn_parse.FromCloudFormation.getString(properties.Identifier),
        name: cfn_parse.FromCloudFormation.getString(properties.Name),
        userPoolId: cfn_parse.FromCloudFormation.getString(properties.UserPoolId),
        scopes: cfn_parse.FromCloudFormation.getArray(properties.Scopes, (prop1) => CfnUserPoolResourceServerResourceServerScopeTypePropertyFromCloudFormation(prop1)),
    };
}
/**
 * A CloudFormation `AWS::Cognito::UserPoolResourceServer`
 *
 * @cloudformationResource AWS::Cognito::UserPoolResourceServer
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolresourceserver.html
 */
class CfnUserPoolResourceServer extends cdk.CfnResource {
    /**
     * Create a new `AWS::Cognito::UserPoolResourceServer`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnUserPoolResourceServer.CFN_RESOURCE_TYPE_NAME, properties: props });
        cdk.requireProperty(props, 'identifier', this);
        cdk.requireProperty(props, 'name', this);
        cdk.requireProperty(props, 'userPoolId', this);
        this.identifier = props.identifier;
        this.name = props.name;
        this.userPoolId = props.userPoolId;
        this.scopes = props.scopes;
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @experimental
     */
    static fromCloudFormation(scope, id, resourceAttributes, options) {
        var _a;
        resourceAttributes = resourceAttributes || {};
        const cfnParser = new cfn_parse.CfnParser({
            finder: options.finder,
        });
        const resourceProperties = cfnParser.parseValue(resourceAttributes.Properties);
        const props = CfnUserPoolResourceServerPropsFromCloudFormation(resourceProperties);
        const ret = new CfnUserPoolResourceServer(scope, id, props);
        const cfnOptions = ret.cfnOptions;
        cfnOptions.creationPolicy = cfnParser.parseCreationPolicy(resourceAttributes.CreationPolicy);
        cfnOptions.updatePolicy = cfnParser.parseUpdatePolicy(resourceAttributes.UpdatePolicy);
        cfnOptions.deletionPolicy = cfnParser.parseDeletionPolicy(resourceAttributes.DeletionPolicy);
        cfnOptions.updateReplacePolicy = cfnParser.parseDeletionPolicy(resourceAttributes.UpdateReplacePolicy);
        cfnOptions.metadata = cfnParser.parseValue(resourceAttributes.Metadata);
        // handle DependsOn
        resourceAttributes.DependsOn = (_a = resourceAttributes.DependsOn) !== null && _a !== void 0 ? _a : [];
        const dependencies = Array.isArray(resourceAttributes.DependsOn) ? resourceAttributes.DependsOn : [resourceAttributes.DependsOn];
        for (const dep of dependencies) {
            const depResource = options.finder.findResource(dep);
            if (!depResource) {
                throw new Error(`Resource '${id}' depends on '${dep}' that doesn't exist`);
            }
            ret.node.addDependency(depResource);
        }
        // handle Condition
        if (resourceAttributes.Condition) {
            const condition = options.finder.findCondition(resourceAttributes.Condition);
            if (!condition) {
                throw new Error(`Resource '${id}' uses Condition '${resourceAttributes.Condition}' that doesn't exist`);
            }
            cfnOptions.condition = condition;
        }
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector) {
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnUserPoolResourceServer.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            identifier: this.identifier,
            name: this.name,
            userPoolId: this.userPoolId,
            scopes: this.scopes,
        };
    }
    renderProperties(props) {
        return cfnUserPoolResourceServerPropsToCloudFormation(props);
    }
}
exports.CfnUserPoolResourceServer = CfnUserPoolResourceServer;
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnUserPoolResourceServer.CFN_RESOURCE_TYPE_NAME = "AWS::Cognito::UserPoolResourceServer";
/**
 * Determine whether the given properties match those of a `ResourceServerScopeTypeProperty`
 *
 * @param properties - the TypeScript properties of a `ResourceServerScopeTypeProperty`
 *
 * @returns the result of the validation.
 */
function CfnUserPoolResourceServer_ResourceServerScopeTypePropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('scopeDescription', cdk.requiredValidator)(properties.scopeDescription));
    errors.collect(cdk.propertyValidator('scopeDescription', cdk.validateString)(properties.scopeDescription));
    errors.collect(cdk.propertyValidator('scopeName', cdk.requiredValidator)(properties.scopeName));
    errors.collect(cdk.propertyValidator('scopeName', cdk.validateString)(properties.scopeName));
    return errors.wrap('supplied properties not correct for "ResourceServerScopeTypeProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Cognito::UserPoolResourceServer.ResourceServerScopeType` resource
 *
 * @param properties - the TypeScript properties of a `ResourceServerScopeTypeProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Cognito::UserPoolResourceServer.ResourceServerScopeType` resource.
 */
// @ts-ignore TS6133
function cfnUserPoolResourceServerResourceServerScopeTypePropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnUserPoolResourceServer_ResourceServerScopeTypePropertyValidator(properties).assertSuccess();
    return {
        ScopeDescription: cdk.stringToCloudFormation(properties.scopeDescription),
        ScopeName: cdk.stringToCloudFormation(properties.scopeName),
    };
}
// @ts-ignore TS6133
function CfnUserPoolResourceServerResourceServerScopeTypePropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return properties;
    }
    properties = properties || {};
    return {
        scopeDescription: cfn_parse.FromCloudFormation.getString(properties.ScopeDescription),
        scopeName: cfn_parse.FromCloudFormation.getString(properties.ScopeName),
    };
}
/**
 * Determine whether the given properties match those of a `CfnUserPoolRiskConfigurationAttachmentProps`
 *
 * @param properties - the TypeScript properties of a `CfnUserPoolRiskConfigurationAttachmentProps`
 *
 * @returns the result of the validation.
 */
function CfnUserPoolRiskConfigurationAttachmentPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('accountTakeoverRiskConfiguration', CfnUserPoolRiskConfigurationAttachment_AccountTakeoverRiskConfigurationTypePropertyValidator)(properties.accountTakeoverRiskConfiguration));
    errors.collect(cdk.propertyValidator('clientId', cdk.requiredValidator)(properties.clientId));
    errors.collect(cdk.propertyValidator('clientId', cdk.validateString)(properties.clientId));
    errors.collect(cdk.propertyValidator('compromisedCredentialsRiskConfiguration', CfnUserPoolRiskConfigurationAttachment_CompromisedCredentialsRiskConfigurationTypePropertyValidator)(properties.compromisedCredentialsRiskConfiguration));
    errors.collect(cdk.propertyValidator('riskExceptionConfiguration', CfnUserPoolRiskConfigurationAttachment_RiskExceptionConfigurationTypePropertyValidator)(properties.riskExceptionConfiguration));
    errors.collect(cdk.propertyValidator('userPoolId', cdk.requiredValidator)(properties.userPoolId));
    errors.collect(cdk.propertyValidator('userPoolId', cdk.validateString)(properties.userPoolId));
    return errors.wrap('supplied properties not correct for "CfnUserPoolRiskConfigurationAttachmentProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Cognito::UserPoolRiskConfigurationAttachment` resource
 *
 * @param properties - the TypeScript properties of a `CfnUserPoolRiskConfigurationAttachmentProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Cognito::UserPoolRiskConfigurationAttachment` resource.
 */
// @ts-ignore TS6133
function cfnUserPoolRiskConfigurationAttachmentPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnUserPoolRiskConfigurationAttachmentPropsValidator(properties).assertSuccess();
    return {
        ClientId: cdk.stringToCloudFormation(properties.clientId),
        UserPoolId: cdk.stringToCloudFormation(properties.userPoolId),
        AccountTakeoverRiskConfiguration: cfnUserPoolRiskConfigurationAttachmentAccountTakeoverRiskConfigurationTypePropertyToCloudFormation(properties.accountTakeoverRiskConfiguration),
        CompromisedCredentialsRiskConfiguration: cfnUserPoolRiskConfigurationAttachmentCompromisedCredentialsRiskConfigurationTypePropertyToCloudFormation(properties.compromisedCredentialsRiskConfiguration),
        RiskExceptionConfiguration: cfnUserPoolRiskConfigurationAttachmentRiskExceptionConfigurationTypePropertyToCloudFormation(properties.riskExceptionConfiguration),
    };
}
// @ts-ignore TS6133
function CfnUserPoolRiskConfigurationAttachmentPropsFromCloudFormation(properties) {
    properties = properties || {};
    return {
        clientId: cfn_parse.FromCloudFormation.getString(properties.ClientId),
        userPoolId: cfn_parse.FromCloudFormation.getString(properties.UserPoolId),
        accountTakeoverRiskConfiguration: properties.AccountTakeoverRiskConfiguration == null ? undefined : CfnUserPoolRiskConfigurationAttachmentAccountTakeoverRiskConfigurationTypePropertyFromCloudFormation(properties.AccountTakeoverRiskConfiguration),
        compromisedCredentialsRiskConfiguration: properties.CompromisedCredentialsRiskConfiguration == null ? undefined : CfnUserPoolRiskConfigurationAttachmentCompromisedCredentialsRiskConfigurationTypePropertyFromCloudFormation(properties.CompromisedCredentialsRiskConfiguration),
        riskExceptionConfiguration: properties.RiskExceptionConfiguration == null ? undefined : CfnUserPoolRiskConfigurationAttachmentRiskExceptionConfigurationTypePropertyFromCloudFormation(properties.RiskExceptionConfiguration),
    };
}
/**
 * A CloudFormation `AWS::Cognito::UserPoolRiskConfigurationAttachment`
 *
 * @cloudformationResource AWS::Cognito::UserPoolRiskConfigurationAttachment
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolriskconfigurationattachment.html
 */
class CfnUserPoolRiskConfigurationAttachment extends cdk.CfnResource {
    /**
     * Create a new `AWS::Cognito::UserPoolRiskConfigurationAttachment`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnUserPoolRiskConfigurationAttachment.CFN_RESOURCE_TYPE_NAME, properties: props });
        cdk.requireProperty(props, 'clientId', this);
        cdk.requireProperty(props, 'userPoolId', this);
        this.clientId = props.clientId;
        this.userPoolId = props.userPoolId;
        this.accountTakeoverRiskConfiguration = props.accountTakeoverRiskConfiguration;
        this.compromisedCredentialsRiskConfiguration = props.compromisedCredentialsRiskConfiguration;
        this.riskExceptionConfiguration = props.riskExceptionConfiguration;
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @experimental
     */
    static fromCloudFormation(scope, id, resourceAttributes, options) {
        var _a;
        resourceAttributes = resourceAttributes || {};
        const cfnParser = new cfn_parse.CfnParser({
            finder: options.finder,
        });
        const resourceProperties = cfnParser.parseValue(resourceAttributes.Properties);
        const props = CfnUserPoolRiskConfigurationAttachmentPropsFromCloudFormation(resourceProperties);
        const ret = new CfnUserPoolRiskConfigurationAttachment(scope, id, props);
        const cfnOptions = ret.cfnOptions;
        cfnOptions.creationPolicy = cfnParser.parseCreationPolicy(resourceAttributes.CreationPolicy);
        cfnOptions.updatePolicy = cfnParser.parseUpdatePolicy(resourceAttributes.UpdatePolicy);
        cfnOptions.deletionPolicy = cfnParser.parseDeletionPolicy(resourceAttributes.DeletionPolicy);
        cfnOptions.updateReplacePolicy = cfnParser.parseDeletionPolicy(resourceAttributes.UpdateReplacePolicy);
        cfnOptions.metadata = cfnParser.parseValue(resourceAttributes.Metadata);
        // handle DependsOn
        resourceAttributes.DependsOn = (_a = resourceAttributes.DependsOn) !== null && _a !== void 0 ? _a : [];
        const dependencies = Array.isArray(resourceAttributes.DependsOn) ? resourceAttributes.DependsOn : [resourceAttributes.DependsOn];
        for (const dep of dependencies) {
            const depResource = options.finder.findResource(dep);
            if (!depResource) {
                throw new Error(`Resource '${id}' depends on '${dep}' that doesn't exist`);
            }
            ret.node.addDependency(depResource);
        }
        // handle Condition
        if (resourceAttributes.Condition) {
            const condition = options.finder.findCondition(resourceAttributes.Condition);
            if (!condition) {
                throw new Error(`Resource '${id}' uses Condition '${resourceAttributes.Condition}' that doesn't exist`);
            }
            cfnOptions.condition = condition;
        }
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector) {
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnUserPoolRiskConfigurationAttachment.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            clientId: this.clientId,
            userPoolId: this.userPoolId,
            accountTakeoverRiskConfiguration: this.accountTakeoverRiskConfiguration,
            compromisedCredentialsRiskConfiguration: this.compromisedCredentialsRiskConfiguration,
            riskExceptionConfiguration: this.riskExceptionConfiguration,
        };
    }
    renderProperties(props) {
        return cfnUserPoolRiskConfigurationAttachmentPropsToCloudFormation(props);
    }
}
exports.CfnUserPoolRiskConfigurationAttachment = CfnUserPoolRiskConfigurationAttachment;
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnUserPoolRiskConfigurationAttachment.CFN_RESOURCE_TYPE_NAME = "AWS::Cognito::UserPoolRiskConfigurationAttachment";
/**
 * Determine whether the given properties match those of a `AccountTakeoverActionTypeProperty`
 *
 * @param properties - the TypeScript properties of a `AccountTakeoverActionTypeProperty`
 *
 * @returns the result of the validation.
 */
function CfnUserPoolRiskConfigurationAttachment_AccountTakeoverActionTypePropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('eventAction', cdk.requiredValidator)(properties.eventAction));
    errors.collect(cdk.propertyValidator('eventAction', cdk.validateString)(properties.eventAction));
    errors.collect(cdk.propertyValidator('notify', cdk.requiredValidator)(properties.notify));
    errors.collect(cdk.propertyValidator('notify', cdk.validateBoolean)(properties.notify));
    return errors.wrap('supplied properties not correct for "AccountTakeoverActionTypeProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Cognito::UserPoolRiskConfigurationAttachment.AccountTakeoverActionType` resource
 *
 * @param properties - the TypeScript properties of a `AccountTakeoverActionTypeProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Cognito::UserPoolRiskConfigurationAttachment.AccountTakeoverActionType` resource.
 */
// @ts-ignore TS6133
function cfnUserPoolRiskConfigurationAttachmentAccountTakeoverActionTypePropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnUserPoolRiskConfigurationAttachment_AccountTakeoverActionTypePropertyValidator(properties).assertSuccess();
    return {
        EventAction: cdk.stringToCloudFormation(properties.eventAction),
        Notify: cdk.booleanToCloudFormation(properties.notify),
    };
}
// @ts-ignore TS6133
function CfnUserPoolRiskConfigurationAttachmentAccountTakeoverActionTypePropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return properties;
    }
    properties = properties || {};
    return {
        eventAction: cfn_parse.FromCloudFormation.getString(properties.EventAction),
        notify: cfn_parse.FromCloudFormation.getBoolean(properties.Notify),
    };
}
/**
 * Determine whether the given properties match those of a `AccountTakeoverActionsTypeProperty`
 *
 * @param properties - the TypeScript properties of a `AccountTakeoverActionsTypeProperty`
 *
 * @returns the result of the validation.
 */
function CfnUserPoolRiskConfigurationAttachment_AccountTakeoverActionsTypePropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('highAction', CfnUserPoolRiskConfigurationAttachment_AccountTakeoverActionTypePropertyValidator)(properties.highAction));
    errors.collect(cdk.propertyValidator('lowAction', CfnUserPoolRiskConfigurationAttachment_AccountTakeoverActionTypePropertyValidator)(properties.lowAction));
    errors.collect(cdk.propertyValidator('mediumAction', CfnUserPoolRiskConfigurationAttachment_AccountTakeoverActionTypePropertyValidator)(properties.mediumAction));
    return errors.wrap('supplied properties not correct for "AccountTakeoverActionsTypeProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Cognito::UserPoolRiskConfigurationAttachment.AccountTakeoverActionsType` resource
 *
 * @param properties - the TypeScript properties of a `AccountTakeoverActionsTypeProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Cognito::UserPoolRiskConfigurationAttachment.AccountTakeoverActionsType` resource.
 */
// @ts-ignore TS6133
function cfnUserPoolRiskConfigurationAttachmentAccountTakeoverActionsTypePropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnUserPoolRiskConfigurationAttachment_AccountTakeoverActionsTypePropertyValidator(properties).assertSuccess();
    return {
        HighAction: cfnUserPoolRiskConfigurationAttachmentAccountTakeoverActionTypePropertyToCloudFormation(properties.highAction),
        LowAction: cfnUserPoolRiskConfigurationAttachmentAccountTakeoverActionTypePropertyToCloudFormation(properties.lowAction),
        MediumAction: cfnUserPoolRiskConfigurationAttachmentAccountTakeoverActionTypePropertyToCloudFormation(properties.mediumAction),
    };
}
// @ts-ignore TS6133
function CfnUserPoolRiskConfigurationAttachmentAccountTakeoverActionsTypePropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return properties;
    }
    properties = properties || {};
    return {
        highAction: properties.HighAction == null ? undefined : CfnUserPoolRiskConfigurationAttachmentAccountTakeoverActionTypePropertyFromCloudFormation(properties.HighAction),
        lowAction: properties.LowAction == null ? undefined : CfnUserPoolRiskConfigurationAttachmentAccountTakeoverActionTypePropertyFromCloudFormation(properties.LowAction),
        mediumAction: properties.MediumAction == null ? undefined : CfnUserPoolRiskConfigurationAttachmentAccountTakeoverActionTypePropertyFromCloudFormation(properties.MediumAction),
    };
}
/**
 * Determine whether the given properties match those of a `AccountTakeoverRiskConfigurationTypeProperty`
 *
 * @param properties - the TypeScript properties of a `AccountTakeoverRiskConfigurationTypeProperty`
 *
 * @returns the result of the validation.
 */
function CfnUserPoolRiskConfigurationAttachment_AccountTakeoverRiskConfigurationTypePropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('actions', cdk.requiredValidator)(properties.actions));
    errors.collect(cdk.propertyValidator('actions', CfnUserPoolRiskConfigurationAttachment_AccountTakeoverActionsTypePropertyValidator)(properties.actions));
    errors.collect(cdk.propertyValidator('notifyConfiguration', CfnUserPoolRiskConfigurationAttachment_NotifyConfigurationTypePropertyValidator)(properties.notifyConfiguration));
    return errors.wrap('supplied properties not correct for "AccountTakeoverRiskConfigurationTypeProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Cognito::UserPoolRiskConfigurationAttachment.AccountTakeoverRiskConfigurationType` resource
 *
 * @param properties - the TypeScript properties of a `AccountTakeoverRiskConfigurationTypeProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Cognito::UserPoolRiskConfigurationAttachment.AccountTakeoverRiskConfigurationType` resource.
 */
// @ts-ignore TS6133
function cfnUserPoolRiskConfigurationAttachmentAccountTakeoverRiskConfigurationTypePropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnUserPoolRiskConfigurationAttachment_AccountTakeoverRiskConfigurationTypePropertyValidator(properties).assertSuccess();
    return {
        Actions: cfnUserPoolRiskConfigurationAttachmentAccountTakeoverActionsTypePropertyToCloudFormation(properties.actions),
        NotifyConfiguration: cfnUserPoolRiskConfigurationAttachmentNotifyConfigurationTypePropertyToCloudFormation(properties.notifyConfiguration),
    };
}
// @ts-ignore TS6133
function CfnUserPoolRiskConfigurationAttachmentAccountTakeoverRiskConfigurationTypePropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return properties;
    }
    properties = properties || {};
    return {
        actions: CfnUserPoolRiskConfigurationAttachmentAccountTakeoverActionsTypePropertyFromCloudFormation(properties.Actions),
        notifyConfiguration: properties.NotifyConfiguration == null ? undefined : CfnUserPoolRiskConfigurationAttachmentNotifyConfigurationTypePropertyFromCloudFormation(properties.NotifyConfiguration),
    };
}
/**
 * Determine whether the given properties match those of a `CompromisedCredentialsActionsTypeProperty`
 *
 * @param properties - the TypeScript properties of a `CompromisedCredentialsActionsTypeProperty`
 *
 * @returns the result of the validation.
 */
function CfnUserPoolRiskConfigurationAttachment_CompromisedCredentialsActionsTypePropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('eventAction', cdk.requiredValidator)(properties.eventAction));
    errors.collect(cdk.propertyValidator('eventAction', cdk.validateString)(properties.eventAction));
    return errors.wrap('supplied properties not correct for "CompromisedCredentialsActionsTypeProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Cognito::UserPoolRiskConfigurationAttachment.CompromisedCredentialsActionsType` resource
 *
 * @param properties - the TypeScript properties of a `CompromisedCredentialsActionsTypeProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Cognito::UserPoolRiskConfigurationAttachment.CompromisedCredentialsActionsType` resource.
 */
// @ts-ignore TS6133
function cfnUserPoolRiskConfigurationAttachmentCompromisedCredentialsActionsTypePropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnUserPoolRiskConfigurationAttachment_CompromisedCredentialsActionsTypePropertyValidator(properties).assertSuccess();
    return {
        EventAction: cdk.stringToCloudFormation(properties.eventAction),
    };
}
// @ts-ignore TS6133
function CfnUserPoolRiskConfigurationAttachmentCompromisedCredentialsActionsTypePropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return properties;
    }
    properties = properties || {};
    return {
        eventAction: cfn_parse.FromCloudFormation.getString(properties.EventAction),
    };
}
/**
 * Determine whether the given properties match those of a `CompromisedCredentialsRiskConfigurationTypeProperty`
 *
 * @param properties - the TypeScript properties of a `CompromisedCredentialsRiskConfigurationTypeProperty`
 *
 * @returns the result of the validation.
 */
function CfnUserPoolRiskConfigurationAttachment_CompromisedCredentialsRiskConfigurationTypePropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('actions', cdk.requiredValidator)(properties.actions));
    errors.collect(cdk.propertyValidator('actions', CfnUserPoolRiskConfigurationAttachment_CompromisedCredentialsActionsTypePropertyValidator)(properties.actions));
    errors.collect(cdk.propertyValidator('eventFilter', cdk.listValidator(cdk.validateString))(properties.eventFilter));
    return errors.wrap('supplied properties not correct for "CompromisedCredentialsRiskConfigurationTypeProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Cognito::UserPoolRiskConfigurationAttachment.CompromisedCredentialsRiskConfigurationType` resource
 *
 * @param properties - the TypeScript properties of a `CompromisedCredentialsRiskConfigurationTypeProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Cognito::UserPoolRiskConfigurationAttachment.CompromisedCredentialsRiskConfigurationType` resource.
 */
// @ts-ignore TS6133
function cfnUserPoolRiskConfigurationAttachmentCompromisedCredentialsRiskConfigurationTypePropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnUserPoolRiskConfigurationAttachment_CompromisedCredentialsRiskConfigurationTypePropertyValidator(properties).assertSuccess();
    return {
        Actions: cfnUserPoolRiskConfigurationAttachmentCompromisedCredentialsActionsTypePropertyToCloudFormation(properties.actions),
        EventFilter: cdk.listMapper(cdk.stringToCloudFormation)(properties.eventFilter),
    };
}
// @ts-ignore TS6133
function CfnUserPoolRiskConfigurationAttachmentCompromisedCredentialsRiskConfigurationTypePropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return properties;
    }
    properties = properties || {};
    return {
        actions: CfnUserPoolRiskConfigurationAttachmentCompromisedCredentialsActionsTypePropertyFromCloudFormation(properties.Actions),
        eventFilter: cfn_parse.FromCloudFormation.getStringArray(properties.EventFilter),
    };
}
/**
 * Determine whether the given properties match those of a `NotifyConfigurationTypeProperty`
 *
 * @param properties - the TypeScript properties of a `NotifyConfigurationTypeProperty`
 *
 * @returns the result of the validation.
 */
function CfnUserPoolRiskConfigurationAttachment_NotifyConfigurationTypePropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('blockEmail', CfnUserPoolRiskConfigurationAttachment_NotifyEmailTypePropertyValidator)(properties.blockEmail));
    errors.collect(cdk.propertyValidator('from', cdk.validateString)(properties.from));
    errors.collect(cdk.propertyValidator('mfaEmail', CfnUserPoolRiskConfigurationAttachment_NotifyEmailTypePropertyValidator)(properties.mfaEmail));
    errors.collect(cdk.propertyValidator('noActionEmail', CfnUserPoolRiskConfigurationAttachment_NotifyEmailTypePropertyValidator)(properties.noActionEmail));
    errors.collect(cdk.propertyValidator('replyTo', cdk.validateString)(properties.replyTo));
    errors.collect(cdk.propertyValidator('sourceArn', cdk.requiredValidator)(properties.sourceArn));
    errors.collect(cdk.propertyValidator('sourceArn', cdk.validateString)(properties.sourceArn));
    return errors.wrap('supplied properties not correct for "NotifyConfigurationTypeProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Cognito::UserPoolRiskConfigurationAttachment.NotifyConfigurationType` resource
 *
 * @param properties - the TypeScript properties of a `NotifyConfigurationTypeProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Cognito::UserPoolRiskConfigurationAttachment.NotifyConfigurationType` resource.
 */
// @ts-ignore TS6133
function cfnUserPoolRiskConfigurationAttachmentNotifyConfigurationTypePropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnUserPoolRiskConfigurationAttachment_NotifyConfigurationTypePropertyValidator(properties).assertSuccess();
    return {
        BlockEmail: cfnUserPoolRiskConfigurationAttachmentNotifyEmailTypePropertyToCloudFormation(properties.blockEmail),
        From: cdk.stringToCloudFormation(properties.from),
        MfaEmail: cfnUserPoolRiskConfigurationAttachmentNotifyEmailTypePropertyToCloudFormation(properties.mfaEmail),
        NoActionEmail: cfnUserPoolRiskConfigurationAttachmentNotifyEmailTypePropertyToCloudFormation(properties.noActionEmail),
        ReplyTo: cdk.stringToCloudFormation(properties.replyTo),
        SourceArn: cdk.stringToCloudFormation(properties.sourceArn),
    };
}
// @ts-ignore TS6133
function CfnUserPoolRiskConfigurationAttachmentNotifyConfigurationTypePropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return properties;
    }
    properties = properties || {};
    return {
        blockEmail: properties.BlockEmail == null ? undefined : CfnUserPoolRiskConfigurationAttachmentNotifyEmailTypePropertyFromCloudFormation(properties.BlockEmail),
        from: properties.From == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.From),
        mfaEmail: properties.MfaEmail == null ? undefined : CfnUserPoolRiskConfigurationAttachmentNotifyEmailTypePropertyFromCloudFormation(properties.MfaEmail),
        noActionEmail: properties.NoActionEmail == null ? undefined : CfnUserPoolRiskConfigurationAttachmentNotifyEmailTypePropertyFromCloudFormation(properties.NoActionEmail),
        replyTo: properties.ReplyTo == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.ReplyTo),
        sourceArn: cfn_parse.FromCloudFormation.getString(properties.SourceArn),
    };
}
/**
 * Determine whether the given properties match those of a `NotifyEmailTypeProperty`
 *
 * @param properties - the TypeScript properties of a `NotifyEmailTypeProperty`
 *
 * @returns the result of the validation.
 */
function CfnUserPoolRiskConfigurationAttachment_NotifyEmailTypePropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('htmlBody', cdk.validateString)(properties.htmlBody));
    errors.collect(cdk.propertyValidator('subject', cdk.requiredValidator)(properties.subject));
    errors.collect(cdk.propertyValidator('subject', cdk.validateString)(properties.subject));
    errors.collect(cdk.propertyValidator('textBody', cdk.validateString)(properties.textBody));
    return errors.wrap('supplied properties not correct for "NotifyEmailTypeProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Cognito::UserPoolRiskConfigurationAttachment.NotifyEmailType` resource
 *
 * @param properties - the TypeScript properties of a `NotifyEmailTypeProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Cognito::UserPoolRiskConfigurationAttachment.NotifyEmailType` resource.
 */
// @ts-ignore TS6133
function cfnUserPoolRiskConfigurationAttachmentNotifyEmailTypePropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnUserPoolRiskConfigurationAttachment_NotifyEmailTypePropertyValidator(properties).assertSuccess();
    return {
        HtmlBody: cdk.stringToCloudFormation(properties.htmlBody),
        Subject: cdk.stringToCloudFormation(properties.subject),
        TextBody: cdk.stringToCloudFormation(properties.textBody),
    };
}
// @ts-ignore TS6133
function CfnUserPoolRiskConfigurationAttachmentNotifyEmailTypePropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return properties;
    }
    properties = properties || {};
    return {
        htmlBody: properties.HtmlBody == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.HtmlBody),
        subject: cfn_parse.FromCloudFormation.getString(properties.Subject),
        textBody: properties.TextBody == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.TextBody),
    };
}
/**
 * Determine whether the given properties match those of a `RiskExceptionConfigurationTypeProperty`
 *
 * @param properties - the TypeScript properties of a `RiskExceptionConfigurationTypeProperty`
 *
 * @returns the result of the validation.
 */
function CfnUserPoolRiskConfigurationAttachment_RiskExceptionConfigurationTypePropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('blockedIpRangeList', cdk.listValidator(cdk.validateString))(properties.blockedIpRangeList));
    errors.collect(cdk.propertyValidator('skippedIpRangeList', cdk.listValidator(cdk.validateString))(properties.skippedIpRangeList));
    return errors.wrap('supplied properties not correct for "RiskExceptionConfigurationTypeProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Cognito::UserPoolRiskConfigurationAttachment.RiskExceptionConfigurationType` resource
 *
 * @param properties - the TypeScript properties of a `RiskExceptionConfigurationTypeProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Cognito::UserPoolRiskConfigurationAttachment.RiskExceptionConfigurationType` resource.
 */
// @ts-ignore TS6133
function cfnUserPoolRiskConfigurationAttachmentRiskExceptionConfigurationTypePropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnUserPoolRiskConfigurationAttachment_RiskExceptionConfigurationTypePropertyValidator(properties).assertSuccess();
    return {
        BlockedIPRangeList: cdk.listMapper(cdk.stringToCloudFormation)(properties.blockedIpRangeList),
        SkippedIPRangeList: cdk.listMapper(cdk.stringToCloudFormation)(properties.skippedIpRangeList),
    };
}
// @ts-ignore TS6133
function CfnUserPoolRiskConfigurationAttachmentRiskExceptionConfigurationTypePropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return properties;
    }
    properties = properties || {};
    return {
        blockedIpRangeList: cfn_parse.FromCloudFormation.getStringArray(properties.BlockedIPRangeList),
        skippedIpRangeList: cfn_parse.FromCloudFormation.getStringArray(properties.SkippedIPRangeList),
    };
}
/**
 * Determine whether the given properties match those of a `CfnUserPoolUICustomizationAttachmentProps`
 *
 * @param properties - the TypeScript properties of a `CfnUserPoolUICustomizationAttachmentProps`
 *
 * @returns the result of the validation.
 */
function CfnUserPoolUICustomizationAttachmentPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('css', cdk.validateString)(properties.css));
    errors.collect(cdk.propertyValidator('clientId', cdk.requiredValidator)(properties.clientId));
    errors.collect(cdk.propertyValidator('clientId', cdk.validateString)(properties.clientId));
    errors.collect(cdk.propertyValidator('userPoolId', cdk.requiredValidator)(properties.userPoolId));
    errors.collect(cdk.propertyValidator('userPoolId', cdk.validateString)(properties.userPoolId));
    return errors.wrap('supplied properties not correct for "CfnUserPoolUICustomizationAttachmentProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Cognito::UserPoolUICustomizationAttachment` resource
 *
 * @param properties - the TypeScript properties of a `CfnUserPoolUICustomizationAttachmentProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Cognito::UserPoolUICustomizationAttachment` resource.
 */
// @ts-ignore TS6133
function cfnUserPoolUICustomizationAttachmentPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnUserPoolUICustomizationAttachmentPropsValidator(properties).assertSuccess();
    return {
        ClientId: cdk.stringToCloudFormation(properties.clientId),
        UserPoolId: cdk.stringToCloudFormation(properties.userPoolId),
        CSS: cdk.stringToCloudFormation(properties.css),
    };
}
// @ts-ignore TS6133
function CfnUserPoolUICustomizationAttachmentPropsFromCloudFormation(properties) {
    properties = properties || {};
    return {
        clientId: cfn_parse.FromCloudFormation.getString(properties.ClientId),
        userPoolId: cfn_parse.FromCloudFormation.getString(properties.UserPoolId),
        css: properties.CSS == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.CSS),
    };
}
/**
 * A CloudFormation `AWS::Cognito::UserPoolUICustomizationAttachment`
 *
 * @cloudformationResource AWS::Cognito::UserPoolUICustomizationAttachment
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpooluicustomizationattachment.html
 */
class CfnUserPoolUICustomizationAttachment extends cdk.CfnResource {
    /**
     * Create a new `AWS::Cognito::UserPoolUICustomizationAttachment`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnUserPoolUICustomizationAttachment.CFN_RESOURCE_TYPE_NAME, properties: props });
        cdk.requireProperty(props, 'clientId', this);
        cdk.requireProperty(props, 'userPoolId', this);
        this.clientId = props.clientId;
        this.userPoolId = props.userPoolId;
        this.css = props.css;
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @experimental
     */
    static fromCloudFormation(scope, id, resourceAttributes, options) {
        var _a;
        resourceAttributes = resourceAttributes || {};
        const cfnParser = new cfn_parse.CfnParser({
            finder: options.finder,
        });
        const resourceProperties = cfnParser.parseValue(resourceAttributes.Properties);
        const props = CfnUserPoolUICustomizationAttachmentPropsFromCloudFormation(resourceProperties);
        const ret = new CfnUserPoolUICustomizationAttachment(scope, id, props);
        const cfnOptions = ret.cfnOptions;
        cfnOptions.creationPolicy = cfnParser.parseCreationPolicy(resourceAttributes.CreationPolicy);
        cfnOptions.updatePolicy = cfnParser.parseUpdatePolicy(resourceAttributes.UpdatePolicy);
        cfnOptions.deletionPolicy = cfnParser.parseDeletionPolicy(resourceAttributes.DeletionPolicy);
        cfnOptions.updateReplacePolicy = cfnParser.parseDeletionPolicy(resourceAttributes.UpdateReplacePolicy);
        cfnOptions.metadata = cfnParser.parseValue(resourceAttributes.Metadata);
        // handle DependsOn
        resourceAttributes.DependsOn = (_a = resourceAttributes.DependsOn) !== null && _a !== void 0 ? _a : [];
        const dependencies = Array.isArray(resourceAttributes.DependsOn) ? resourceAttributes.DependsOn : [resourceAttributes.DependsOn];
        for (const dep of dependencies) {
            const depResource = options.finder.findResource(dep);
            if (!depResource) {
                throw new Error(`Resource '${id}' depends on '${dep}' that doesn't exist`);
            }
            ret.node.addDependency(depResource);
        }
        // handle Condition
        if (resourceAttributes.Condition) {
            const condition = options.finder.findCondition(resourceAttributes.Condition);
            if (!condition) {
                throw new Error(`Resource '${id}' uses Condition '${resourceAttributes.Condition}' that doesn't exist`);
            }
            cfnOptions.condition = condition;
        }
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector) {
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnUserPoolUICustomizationAttachment.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            clientId: this.clientId,
            userPoolId: this.userPoolId,
            css: this.css,
        };
    }
    renderProperties(props) {
        return cfnUserPoolUICustomizationAttachmentPropsToCloudFormation(props);
    }
}
exports.CfnUserPoolUICustomizationAttachment = CfnUserPoolUICustomizationAttachment;
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnUserPoolUICustomizationAttachment.CFN_RESOURCE_TYPE_NAME = "AWS::Cognito::UserPoolUICustomizationAttachment";
/**
 * Determine whether the given properties match those of a `CfnUserPoolUserProps`
 *
 * @param properties - the TypeScript properties of a `CfnUserPoolUserProps`
 *
 * @returns the result of the validation.
 */
function CfnUserPoolUserPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('clientMetadata', cdk.validateObject)(properties.clientMetadata));
    errors.collect(cdk.propertyValidator('desiredDeliveryMediums', cdk.listValidator(cdk.validateString))(properties.desiredDeliveryMediums));
    errors.collect(cdk.propertyValidator('forceAliasCreation', cdk.validateBoolean)(properties.forceAliasCreation));
    errors.collect(cdk.propertyValidator('messageAction', cdk.validateString)(properties.messageAction));
    errors.collect(cdk.propertyValidator('userAttributes', cdk.listValidator(CfnUserPoolUser_AttributeTypePropertyValidator))(properties.userAttributes));
    errors.collect(cdk.propertyValidator('userPoolId', cdk.requiredValidator)(properties.userPoolId));
    errors.collect(cdk.propertyValidator('userPoolId', cdk.validateString)(properties.userPoolId));
    errors.collect(cdk.propertyValidator('username', cdk.validateString)(properties.username));
    errors.collect(cdk.propertyValidator('validationData', cdk.listValidator(CfnUserPoolUser_AttributeTypePropertyValidator))(properties.validationData));
    return errors.wrap('supplied properties not correct for "CfnUserPoolUserProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Cognito::UserPoolUser` resource
 *
 * @param properties - the TypeScript properties of a `CfnUserPoolUserProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Cognito::UserPoolUser` resource.
 */
// @ts-ignore TS6133
function cfnUserPoolUserPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnUserPoolUserPropsValidator(properties).assertSuccess();
    return {
        UserPoolId: cdk.stringToCloudFormation(properties.userPoolId),
        ClientMetadata: cdk.objectToCloudFormation(properties.clientMetadata),
        DesiredDeliveryMediums: cdk.listMapper(cdk.stringToCloudFormation)(properties.desiredDeliveryMediums),
        ForceAliasCreation: cdk.booleanToCloudFormation(properties.forceAliasCreation),
        MessageAction: cdk.stringToCloudFormation(properties.messageAction),
        UserAttributes: cdk.listMapper(cfnUserPoolUserAttributeTypePropertyToCloudFormation)(properties.userAttributes),
        Username: cdk.stringToCloudFormation(properties.username),
        ValidationData: cdk.listMapper(cfnUserPoolUserAttributeTypePropertyToCloudFormation)(properties.validationData),
    };
}
// @ts-ignore TS6133
function CfnUserPoolUserPropsFromCloudFormation(properties) {
    properties = properties || {};
    return {
        userPoolId: cfn_parse.FromCloudFormation.getString(properties.UserPoolId),
        clientMetadata: properties.ClientMetadata == null ? undefined : cfn_parse.FromCloudFormation.getAny(properties.ClientMetadata),
        desiredDeliveryMediums: cfn_parse.FromCloudFormation.getStringArray(properties.DesiredDeliveryMediums),
        forceAliasCreation: properties.ForceAliasCreation == null ? undefined : cfn_parse.FromCloudFormation.getBoolean(properties.ForceAliasCreation),
        messageAction: properties.MessageAction == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.MessageAction),
        userAttributes: cfn_parse.FromCloudFormation.getArray(properties.UserAttributes, (prop1) => CfnUserPoolUserAttributeTypePropertyFromCloudFormation(prop1)),
        username: properties.Username == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.Username),
        validationData: cfn_parse.FromCloudFormation.getArray(properties.ValidationData, (prop1) => CfnUserPoolUserAttributeTypePropertyFromCloudFormation(prop1)),
    };
}
/**
 * A CloudFormation `AWS::Cognito::UserPoolUser`
 *
 * @cloudformationResource AWS::Cognito::UserPoolUser
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpooluser.html
 */
class CfnUserPoolUser extends cdk.CfnResource {
    /**
     * Create a new `AWS::Cognito::UserPoolUser`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnUserPoolUser.CFN_RESOURCE_TYPE_NAME, properties: props });
        cdk.requireProperty(props, 'userPoolId', this);
        this.userPoolId = props.userPoolId;
        this.clientMetadata = props.clientMetadata;
        this.desiredDeliveryMediums = props.desiredDeliveryMediums;
        this.forceAliasCreation = props.forceAliasCreation;
        this.messageAction = props.messageAction;
        this.userAttributes = props.userAttributes;
        this.username = props.username;
        this.validationData = props.validationData;
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @experimental
     */
    static fromCloudFormation(scope, id, resourceAttributes, options) {
        var _a;
        resourceAttributes = resourceAttributes || {};
        const cfnParser = new cfn_parse.CfnParser({
            finder: options.finder,
        });
        const resourceProperties = cfnParser.parseValue(resourceAttributes.Properties);
        const props = CfnUserPoolUserPropsFromCloudFormation(resourceProperties);
        const ret = new CfnUserPoolUser(scope, id, props);
        const cfnOptions = ret.cfnOptions;
        cfnOptions.creationPolicy = cfnParser.parseCreationPolicy(resourceAttributes.CreationPolicy);
        cfnOptions.updatePolicy = cfnParser.parseUpdatePolicy(resourceAttributes.UpdatePolicy);
        cfnOptions.deletionPolicy = cfnParser.parseDeletionPolicy(resourceAttributes.DeletionPolicy);
        cfnOptions.updateReplacePolicy = cfnParser.parseDeletionPolicy(resourceAttributes.UpdateReplacePolicy);
        cfnOptions.metadata = cfnParser.parseValue(resourceAttributes.Metadata);
        // handle DependsOn
        resourceAttributes.DependsOn = (_a = resourceAttributes.DependsOn) !== null && _a !== void 0 ? _a : [];
        const dependencies = Array.isArray(resourceAttributes.DependsOn) ? resourceAttributes.DependsOn : [resourceAttributes.DependsOn];
        for (const dep of dependencies) {
            const depResource = options.finder.findResource(dep);
            if (!depResource) {
                throw new Error(`Resource '${id}' depends on '${dep}' that doesn't exist`);
            }
            ret.node.addDependency(depResource);
        }
        // handle Condition
        if (resourceAttributes.Condition) {
            const condition = options.finder.findCondition(resourceAttributes.Condition);
            if (!condition) {
                throw new Error(`Resource '${id}' uses Condition '${resourceAttributes.Condition}' that doesn't exist`);
            }
            cfnOptions.condition = condition;
        }
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector) {
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnUserPoolUser.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            userPoolId: this.userPoolId,
            clientMetadata: this.clientMetadata,
            desiredDeliveryMediums: this.desiredDeliveryMediums,
            forceAliasCreation: this.forceAliasCreation,
            messageAction: this.messageAction,
            userAttributes: this.userAttributes,
            username: this.username,
            validationData: this.validationData,
        };
    }
    renderProperties(props) {
        return cfnUserPoolUserPropsToCloudFormation(props);
    }
}
exports.CfnUserPoolUser = CfnUserPoolUser;
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnUserPoolUser.CFN_RESOURCE_TYPE_NAME = "AWS::Cognito::UserPoolUser";
/**
 * Determine whether the given properties match those of a `AttributeTypeProperty`
 *
 * @param properties - the TypeScript properties of a `AttributeTypeProperty`
 *
 * @returns the result of the validation.
 */
function CfnUserPoolUser_AttributeTypePropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('name', cdk.validateString)(properties.name));
    errors.collect(cdk.propertyValidator('value', cdk.validateString)(properties.value));
    return errors.wrap('supplied properties not correct for "AttributeTypeProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Cognito::UserPoolUser.AttributeType` resource
 *
 * @param properties - the TypeScript properties of a `AttributeTypeProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Cognito::UserPoolUser.AttributeType` resource.
 */
// @ts-ignore TS6133
function cfnUserPoolUserAttributeTypePropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnUserPoolUser_AttributeTypePropertyValidator(properties).assertSuccess();
    return {
        Name: cdk.stringToCloudFormation(properties.name),
        Value: cdk.stringToCloudFormation(properties.value),
    };
}
// @ts-ignore TS6133
function CfnUserPoolUserAttributeTypePropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return properties;
    }
    properties = properties || {};
    return {
        name: properties.Name == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.Name),
        value: properties.Value == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.Value),
    };
}
/**
 * Determine whether the given properties match those of a `CfnUserPoolUserToGroupAttachmentProps`
 *
 * @param properties - the TypeScript properties of a `CfnUserPoolUserToGroupAttachmentProps`
 *
 * @returns the result of the validation.
 */
function CfnUserPoolUserToGroupAttachmentPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('groupName', cdk.requiredValidator)(properties.groupName));
    errors.collect(cdk.propertyValidator('groupName', cdk.validateString)(properties.groupName));
    errors.collect(cdk.propertyValidator('userPoolId', cdk.requiredValidator)(properties.userPoolId));
    errors.collect(cdk.propertyValidator('userPoolId', cdk.validateString)(properties.userPoolId));
    errors.collect(cdk.propertyValidator('username', cdk.requiredValidator)(properties.username));
    errors.collect(cdk.propertyValidator('username', cdk.validateString)(properties.username));
    return errors.wrap('supplied properties not correct for "CfnUserPoolUserToGroupAttachmentProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Cognito::UserPoolUserToGroupAttachment` resource
 *
 * @param properties - the TypeScript properties of a `CfnUserPoolUserToGroupAttachmentProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Cognito::UserPoolUserToGroupAttachment` resource.
 */
// @ts-ignore TS6133
function cfnUserPoolUserToGroupAttachmentPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnUserPoolUserToGroupAttachmentPropsValidator(properties).assertSuccess();
    return {
        GroupName: cdk.stringToCloudFormation(properties.groupName),
        Username: cdk.stringToCloudFormation(properties.username),
        UserPoolId: cdk.stringToCloudFormation(properties.userPoolId),
    };
}
// @ts-ignore TS6133
function CfnUserPoolUserToGroupAttachmentPropsFromCloudFormation(properties) {
    properties = properties || {};
    return {
        groupName: cfn_parse.FromCloudFormation.getString(properties.GroupName),
        username: cfn_parse.FromCloudFormation.getString(properties.Username),
        userPoolId: cfn_parse.FromCloudFormation.getString(properties.UserPoolId),
    };
}
/**
 * A CloudFormation `AWS::Cognito::UserPoolUserToGroupAttachment`
 *
 * @cloudformationResource AWS::Cognito::UserPoolUserToGroupAttachment
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolusertogroupattachment.html
 */
class CfnUserPoolUserToGroupAttachment extends cdk.CfnResource {
    /**
     * Create a new `AWS::Cognito::UserPoolUserToGroupAttachment`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnUserPoolUserToGroupAttachment.CFN_RESOURCE_TYPE_NAME, properties: props });
        cdk.requireProperty(props, 'groupName', this);
        cdk.requireProperty(props, 'userPoolId', this);
        cdk.requireProperty(props, 'username', this);
        this.groupName = props.groupName;
        this.username = props.username;
        this.userPoolId = props.userPoolId;
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @experimental
     */
    static fromCloudFormation(scope, id, resourceAttributes, options) {
        var _a;
        resourceAttributes = resourceAttributes || {};
        const cfnParser = new cfn_parse.CfnParser({
            finder: options.finder,
        });
        const resourceProperties = cfnParser.parseValue(resourceAttributes.Properties);
        const props = CfnUserPoolUserToGroupAttachmentPropsFromCloudFormation(resourceProperties);
        const ret = new CfnUserPoolUserToGroupAttachment(scope, id, props);
        const cfnOptions = ret.cfnOptions;
        cfnOptions.creationPolicy = cfnParser.parseCreationPolicy(resourceAttributes.CreationPolicy);
        cfnOptions.updatePolicy = cfnParser.parseUpdatePolicy(resourceAttributes.UpdatePolicy);
        cfnOptions.deletionPolicy = cfnParser.parseDeletionPolicy(resourceAttributes.DeletionPolicy);
        cfnOptions.updateReplacePolicy = cfnParser.parseDeletionPolicy(resourceAttributes.UpdateReplacePolicy);
        cfnOptions.metadata = cfnParser.parseValue(resourceAttributes.Metadata);
        // handle DependsOn
        resourceAttributes.DependsOn = (_a = resourceAttributes.DependsOn) !== null && _a !== void 0 ? _a : [];
        const dependencies = Array.isArray(resourceAttributes.DependsOn) ? resourceAttributes.DependsOn : [resourceAttributes.DependsOn];
        for (const dep of dependencies) {
            const depResource = options.finder.findResource(dep);
            if (!depResource) {
                throw new Error(`Resource '${id}' depends on '${dep}' that doesn't exist`);
            }
            ret.node.addDependency(depResource);
        }
        // handle Condition
        if (resourceAttributes.Condition) {
            const condition = options.finder.findCondition(resourceAttributes.Condition);
            if (!condition) {
                throw new Error(`Resource '${id}' uses Condition '${resourceAttributes.Condition}' that doesn't exist`);
            }
            cfnOptions.condition = condition;
        }
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector) {
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnUserPoolUserToGroupAttachment.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            groupName: this.groupName,
            username: this.username,
            userPoolId: this.userPoolId,
        };
    }
    renderProperties(props) {
        return cfnUserPoolUserToGroupAttachmentPropsToCloudFormation(props);
    }
}
exports.CfnUserPoolUserToGroupAttachment = CfnUserPoolUserToGroupAttachment;
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnUserPoolUserToGroupAttachment.CFN_RESOURCE_TYPE_NAME = "AWS::Cognito::UserPoolUserToGroupAttachment";
//# sourceMappingURL=data:application/json;base64,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