"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.HttpIntegration = void 0;
const integration_1 = require("../integration");
/**
 * You can integrate an API method with an HTTP endpoint using the HTTP proxy
 * integration or the HTTP custom integration,.
 *
 * With the proxy integration, the setup is simple. You only need to set the
 * HTTP method and the HTTP endpoint URI, according to the backend requirements,
 * if you are not concerned with content encoding or caching.
 *
 * With the custom integration, the setup is more involved. In addition to the
 * proxy integration setup steps, you need to specify how the incoming request
 * data is mapped to the integration request and how the resulting integration
 * response data is mapped to the method response.
 */
class HttpIntegration extends integration_1.Integration {
    constructor(url, props = {}) {
        const proxy = props.proxy !== undefined ? props.proxy : true;
        const method = props.httpMethod || 'GET';
        super({
            type: proxy ? integration_1.IntegrationType.HTTP_PROXY : integration_1.IntegrationType.HTTP,
            integrationHttpMethod: method,
            uri: url,
            options: props.options,
        });
    }
}
exports.HttpIntegration = HttpIntegration;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaHR0cC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbImh0dHAudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7O0FBQUEsZ0RBQWtGO0FBcUJsRjs7Ozs7Ozs7Ozs7O0dBWUc7QUFDSCxNQUFhLGVBQWdCLFNBQVEseUJBQVc7SUFDNUMsWUFBWSxHQUFXLEVBQUUsUUFBOEIsRUFBRTtRQUNyRCxNQUFNLEtBQUssR0FBRyxLQUFLLENBQUMsS0FBSyxLQUFLLFNBQVMsQ0FBQyxDQUFDLENBQUMsS0FBSyxDQUFDLEtBQUssQ0FBQyxDQUFDLENBQUMsSUFBSSxDQUFDO1FBQzdELE1BQU0sTUFBTSxHQUFHLEtBQUssQ0FBQyxVQUFVLElBQUksS0FBSyxDQUFDO1FBQ3pDLEtBQUssQ0FBQztZQUNGLElBQUksRUFBRSxLQUFLLENBQUMsQ0FBQyxDQUFDLDZCQUFlLENBQUMsVUFBVSxDQUFDLENBQUMsQ0FBQyw2QkFBZSxDQUFDLElBQUk7WUFDL0QscUJBQXFCLEVBQUUsTUFBTTtZQUM3QixHQUFHLEVBQUUsR0FBRztZQUNSLE9BQU8sRUFBRSxLQUFLLENBQUMsT0FBTztTQUN6QixDQUFDLENBQUM7SUFDUCxDQUFDO0NBQ0o7QUFYRCwwQ0FXQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IEludGVncmF0aW9uLCBJbnRlZ3JhdGlvbk9wdGlvbnMsIEludGVncmF0aW9uVHlwZSB9IGZyb20gJy4uL2ludGVncmF0aW9uJztcbmV4cG9ydCBpbnRlcmZhY2UgSHR0cEludGVncmF0aW9uUHJvcHMge1xuICAgIC8qKlxuICAgICAqIERldGVybWluZXMgd2hldGhlciB0byB1c2UgcHJveHkgaW50ZWdyYXRpb24gb3IgY3VzdG9tIGludGVncmF0aW9uLlxuICAgICAqXG4gICAgICogQGRlZmF1bHQgdHJ1ZVxuICAgICAqL1xuICAgIHJlYWRvbmx5IHByb3h5PzogYm9vbGVhbjtcbiAgICAvKipcbiAgICAgKiBIVFRQIG1ldGhvZCB0byB1c2Ugd2hlbiBpbnZva2luZyB0aGUgYmFja2VuZCBVUkwuXG4gICAgICogQGRlZmF1bHQgR0VUXG4gICAgICovXG4gICAgcmVhZG9ubHkgaHR0cE1ldGhvZD86IHN0cmluZztcbiAgICAvKipcbiAgICAgKiBJbnRlZ3JhdGlvbiBvcHRpb25zLCBzdWNoIGFzIHJlcXVlc3QvcmVzb3Buc2UgbWFwcGluZywgY29udGVudCBoYW5kbGluZyxcbiAgICAgKiBldGMuXG4gICAgICpcbiAgICAgKiBAZGVmYXVsdCBkZWZhdWx0cyBiYXNlZCBvbiBgSW50ZWdyYXRpb25PcHRpb25zYCBkZWZhdWx0c1xuICAgICAqL1xuICAgIHJlYWRvbmx5IG9wdGlvbnM/OiBJbnRlZ3JhdGlvbk9wdGlvbnM7XG59XG4vKipcbiAqIFlvdSBjYW4gaW50ZWdyYXRlIGFuIEFQSSBtZXRob2Qgd2l0aCBhbiBIVFRQIGVuZHBvaW50IHVzaW5nIHRoZSBIVFRQIHByb3h5XG4gKiBpbnRlZ3JhdGlvbiBvciB0aGUgSFRUUCBjdXN0b20gaW50ZWdyYXRpb24sLlxuICpcbiAqIFdpdGggdGhlIHByb3h5IGludGVncmF0aW9uLCB0aGUgc2V0dXAgaXMgc2ltcGxlLiBZb3Ugb25seSBuZWVkIHRvIHNldCB0aGVcbiAqIEhUVFAgbWV0aG9kIGFuZCB0aGUgSFRUUCBlbmRwb2ludCBVUkksIGFjY29yZGluZyB0byB0aGUgYmFja2VuZCByZXF1aXJlbWVudHMsXG4gKiBpZiB5b3UgYXJlIG5vdCBjb25jZXJuZWQgd2l0aCBjb250ZW50IGVuY29kaW5nIG9yIGNhY2hpbmcuXG4gKlxuICogV2l0aCB0aGUgY3VzdG9tIGludGVncmF0aW9uLCB0aGUgc2V0dXAgaXMgbW9yZSBpbnZvbHZlZC4gSW4gYWRkaXRpb24gdG8gdGhlXG4gKiBwcm94eSBpbnRlZ3JhdGlvbiBzZXR1cCBzdGVwcywgeW91IG5lZWQgdG8gc3BlY2lmeSBob3cgdGhlIGluY29taW5nIHJlcXVlc3RcbiAqIGRhdGEgaXMgbWFwcGVkIHRvIHRoZSBpbnRlZ3JhdGlvbiByZXF1ZXN0IGFuZCBob3cgdGhlIHJlc3VsdGluZyBpbnRlZ3JhdGlvblxuICogcmVzcG9uc2UgZGF0YSBpcyBtYXBwZWQgdG8gdGhlIG1ldGhvZCByZXNwb25zZS5cbiAqL1xuZXhwb3J0IGNsYXNzIEh0dHBJbnRlZ3JhdGlvbiBleHRlbmRzIEludGVncmF0aW9uIHtcbiAgICBjb25zdHJ1Y3Rvcih1cmw6IHN0cmluZywgcHJvcHM6IEh0dHBJbnRlZ3JhdGlvblByb3BzID0ge30pIHtcbiAgICAgICAgY29uc3QgcHJveHkgPSBwcm9wcy5wcm94eSAhPT0gdW5kZWZpbmVkID8gcHJvcHMucHJveHkgOiB0cnVlO1xuICAgICAgICBjb25zdCBtZXRob2QgPSBwcm9wcy5odHRwTWV0aG9kIHx8ICdHRVQnO1xuICAgICAgICBzdXBlcih7XG4gICAgICAgICAgICB0eXBlOiBwcm94eSA/IEludGVncmF0aW9uVHlwZS5IVFRQX1BST1hZIDogSW50ZWdyYXRpb25UeXBlLkhUVFAsXG4gICAgICAgICAgICBpbnRlZ3JhdGlvbkh0dHBNZXRob2Q6IG1ldGhvZCxcbiAgICAgICAgICAgIHVyaTogdXJsLFxuICAgICAgICAgICAgb3B0aW9uczogcHJvcHMub3B0aW9ucyxcbiAgICAgICAgfSk7XG4gICAgfVxufVxuIl19