# coding: utf-8

"""
    Yahoo!広告 ディスプレイ広告 API リファレンス / Yahoo! Ads Display Ads API Reference

    <div lang=\"ja\">Yahoo!広告 ディスプレイ広告 APIのWebサービスについて説明します。<br> 「Try it out」のご利用には、事前にアプリケーションの登録が必要です。また、アプリケーションのリダイレクトURIの1つに<br> https://yahoojp-marketing.github.io/ads-display-api-documents/oauth2-redirect.htmlを登録してください。 </div> <div lang=\"en\">Display Ads API Web Services supported in Yahoo! Ads API.<br> When you use \"Try it out\", you need to register your application in advance.<br> As one of redirect URI for application, you need to set \"https://yahoojp-marketing.github.io/ads-display-api-documents/oauth2-redirect.html\". </div>   # noqa: E501

    The version of the OpenAPI document: v1
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from yahoo_ads_display.configuration import Configuration


class ReportDefinition(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'account_id': 'int',
        'complete_time': 'str',
        'date_range': 'ReportDefinitionServiceDateRange',
        'date_range_type': 'ReportDefinitionServiceDateRangeType',
        'download_encode': 'ReportDefinitionServiceDownloadEncode',
        'download_format': 'ReportDefinitionServiceDownloadFormat',
        'fields': 'list[str]',
        'filters': 'list[ReportDefinitionServiceFilter]',
        'frequency_range': 'ReportDefinitionServiceFrequencyRange',
        'job_status': 'ReportDefinitionServiceJobStatus',
        'lang': 'ReportDefinitionServiceLang',
        'report_job_error_detail': 'str',
        'report_job_id': 'int',
        'report_name': 'str',
        'request_time': 'str',
        'sort_fields': 'list[ReportDefinitionServiceReportSortField]',
        'zip': 'ReportDefinitionServiceZip'
    }

    attribute_map = {
        'account_id': 'accountId',
        'complete_time': 'completeTime',
        'date_range': 'dateRange',
        'date_range_type': 'dateRangeType',
        'download_encode': 'downloadEncode',
        'download_format': 'downloadFormat',
        'fields': 'fields',
        'filters': 'filters',
        'frequency_range': 'frequencyRange',
        'job_status': 'jobStatus',
        'lang': 'lang',
        'report_job_error_detail': 'reportJobErrorDetail',
        'report_job_id': 'reportJobId',
        'report_name': 'reportName',
        'request_time': 'requestTime',
        'sort_fields': 'sortFields',
        'zip': 'zip'
    }

    def __init__(self, account_id=None, complete_time=None, date_range=None, date_range_type=None, download_encode=None, download_format=None, fields=None, filters=None, frequency_range=None, job_status=None, lang=None, report_job_error_detail=None, report_job_id=None, report_name=None, request_time=None, sort_fields=None, zip=None, local_vars_configuration=None):  # noqa: E501
        """ReportDefinition - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._account_id = None
        self._complete_time = None
        self._date_range = None
        self._date_range_type = None
        self._download_encode = None
        self._download_format = None
        self._fields = None
        self._filters = None
        self._frequency_range = None
        self._job_status = None
        self._lang = None
        self._report_job_error_detail = None
        self._report_job_id = None
        self._report_name = None
        self._request_time = None
        self._sort_fields = None
        self._zip = None
        self.discriminator = None

        self.account_id = account_id
        self.complete_time = complete_time
        self.date_range = date_range
        self.date_range_type = date_range_type
        self.download_encode = download_encode
        self.download_format = download_format
        self.fields = fields
        self.filters = filters
        self.frequency_range = frequency_range
        self.job_status = job_status
        self.lang = lang
        self.report_job_error_detail = report_job_error_detail
        self.report_job_id = report_job_id
        self.report_name = report_name
        self.request_time = request_time
        self.sort_fields = sort_fields
        self.zip = zip

    @property
    def account_id(self):
        """Gets the account_id of this ReportDefinition.  # noqa: E501

        <div lang=\"ja\"> アカウントIDです。<br> このフィールドは、レスポンスの際に返却されますが、リクエストの際には無視されます。 </div> <div lang=\"en\"> Account ID. <br> Although this field will be returned in the response, it will be ignored on input. </div>   # noqa: E501

        :return: The account_id of this ReportDefinition.  # noqa: E501
        :rtype: int
        """
        return self._account_id

    @account_id.setter
    def account_id(self, account_id):
        """Sets the account_id of this ReportDefinition.

        <div lang=\"ja\"> アカウントIDです。<br> このフィールドは、レスポンスの際に返却されますが、リクエストの際には無視されます。 </div> <div lang=\"en\"> Account ID. <br> Although this field will be returned in the response, it will be ignored on input. </div>   # noqa: E501

        :param account_id: The account_id of this ReportDefinition.  # noqa: E501
        :type: int
        """

        self._account_id = account_id

    @property
    def complete_time(self):
        """Gets the complete_time of this ReportDefinition.  # noqa: E501

        <div lang=\"ja\"> ジョブ完了日時です。<br> このフィールドは、レスポンスの際に返却されますが、リクエストの際には無視されます。 </div> <div lang=\"en\"> The date and time of Job completion. <br> Although this field will be returned in the response, it will be ignored on input. </div>   # noqa: E501

        :return: The complete_time of this ReportDefinition.  # noqa: E501
        :rtype: str
        """
        return self._complete_time

    @complete_time.setter
    def complete_time(self, complete_time):
        """Sets the complete_time of this ReportDefinition.

        <div lang=\"ja\"> ジョブ完了日時です。<br> このフィールドは、レスポンスの際に返却されますが、リクエストの際には無視されます。 </div> <div lang=\"en\"> The date and time of Job completion. <br> Although this field will be returned in the response, it will be ignored on input. </div>   # noqa: E501

        :param complete_time: The complete_time of this ReportDefinition.  # noqa: E501
        :type: str
        """

        self._complete_time = complete_time

    @property
    def date_range(self):
        """Gets the date_range of this ReportDefinition.  # noqa: E501


        :return: The date_range of this ReportDefinition.  # noqa: E501
        :rtype: ReportDefinitionServiceDateRange
        """
        return self._date_range

    @date_range.setter
    def date_range(self, date_range):
        """Sets the date_range of this ReportDefinition.


        :param date_range: The date_range of this ReportDefinition.  # noqa: E501
        :type: ReportDefinitionServiceDateRange
        """

        self._date_range = date_range

    @property
    def date_range_type(self):
        """Gets the date_range_type of this ReportDefinition.  # noqa: E501


        :return: The date_range_type of this ReportDefinition.  # noqa: E501
        :rtype: ReportDefinitionServiceDateRangeType
        """
        return self._date_range_type

    @date_range_type.setter
    def date_range_type(self, date_range_type):
        """Sets the date_range_type of this ReportDefinition.


        :param date_range_type: The date_range_type of this ReportDefinition.  # noqa: E501
        :type: ReportDefinitionServiceDateRangeType
        """

        self._date_range_type = date_range_type

    @property
    def download_encode(self):
        """Gets the download_encode of this ReportDefinition.  # noqa: E501


        :return: The download_encode of this ReportDefinition.  # noqa: E501
        :rtype: ReportDefinitionServiceDownloadEncode
        """
        return self._download_encode

    @download_encode.setter
    def download_encode(self, download_encode):
        """Sets the download_encode of this ReportDefinition.


        :param download_encode: The download_encode of this ReportDefinition.  # noqa: E501
        :type: ReportDefinitionServiceDownloadEncode
        """

        self._download_encode = download_encode

    @property
    def download_format(self):
        """Gets the download_format of this ReportDefinition.  # noqa: E501


        :return: The download_format of this ReportDefinition.  # noqa: E501
        :rtype: ReportDefinitionServiceDownloadFormat
        """
        return self._download_format

    @download_format.setter
    def download_format(self, download_format):
        """Sets the download_format of this ReportDefinition.


        :param download_format: The download_format of this ReportDefinition.  # noqa: E501
        :type: ReportDefinitionServiceDownloadFormat
        """

        self._download_format = download_format

    @property
    def fields(self):
        """Gets the fields of this ReportDefinition.  # noqa: E501

        <div lang=\"ja\"> 表示項目です。<br> このフィールドは、ADD時に必須となり、REMOVE時に無視されます。<br> 指定可能な値は、ReportDefinitionServiceのgetReportFieldsで取得されるfieldNameをご確認ください。 </div> <div lang=\"en\"> Select the fields. <br> This field is required in ADD operation, and will be ignored in REMOVE operation.<br> * Available values can be referred to fieldName field of fields object obtained by getReportFields operation of ReportDefinitionService. </div>   # noqa: E501

        :return: The fields of this ReportDefinition.  # noqa: E501
        :rtype: list[str]
        """
        return self._fields

    @fields.setter
    def fields(self, fields):
        """Sets the fields of this ReportDefinition.

        <div lang=\"ja\"> 表示項目です。<br> このフィールドは、ADD時に必須となり、REMOVE時に無視されます。<br> 指定可能な値は、ReportDefinitionServiceのgetReportFieldsで取得されるfieldNameをご確認ください。 </div> <div lang=\"en\"> Select the fields. <br> This field is required in ADD operation, and will be ignored in REMOVE operation.<br> * Available values can be referred to fieldName field of fields object obtained by getReportFields operation of ReportDefinitionService. </div>   # noqa: E501

        :param fields: The fields of this ReportDefinition.  # noqa: E501
        :type: list[str]
        """

        self._fields = fields

    @property
    def filters(self):
        """Gets the filters of this ReportDefinition.  # noqa: E501


        :return: The filters of this ReportDefinition.  # noqa: E501
        :rtype: list[ReportDefinitionServiceFilter]
        """
        return self._filters

    @filters.setter
    def filters(self, filters):
        """Sets the filters of this ReportDefinition.


        :param filters: The filters of this ReportDefinition.  # noqa: E501
        :type: list[ReportDefinitionServiceFilter]
        """

        self._filters = filters

    @property
    def frequency_range(self):
        """Gets the frequency_range of this ReportDefinition.  # noqa: E501


        :return: The frequency_range of this ReportDefinition.  # noqa: E501
        :rtype: ReportDefinitionServiceFrequencyRange
        """
        return self._frequency_range

    @frequency_range.setter
    def frequency_range(self, frequency_range):
        """Sets the frequency_range of this ReportDefinition.


        :param frequency_range: The frequency_range of this ReportDefinition.  # noqa: E501
        :type: ReportDefinitionServiceFrequencyRange
        """

        self._frequency_range = frequency_range

    @property
    def job_status(self):
        """Gets the job_status of this ReportDefinition.  # noqa: E501


        :return: The job_status of this ReportDefinition.  # noqa: E501
        :rtype: ReportDefinitionServiceJobStatus
        """
        return self._job_status

    @job_status.setter
    def job_status(self, job_status):
        """Sets the job_status of this ReportDefinition.


        :param job_status: The job_status of this ReportDefinition.  # noqa: E501
        :type: ReportDefinitionServiceJobStatus
        """

        self._job_status = job_status

    @property
    def lang(self):
        """Gets the lang of this ReportDefinition.  # noqa: E501


        :return: The lang of this ReportDefinition.  # noqa: E501
        :rtype: ReportDefinitionServiceLang
        """
        return self._lang

    @lang.setter
    def lang(self, lang):
        """Sets the lang of this ReportDefinition.


        :param lang: The lang of this ReportDefinition.  # noqa: E501
        :type: ReportDefinitionServiceLang
        """

        self._lang = lang

    @property
    def report_job_error_detail(self):
        """Gets the report_job_error_detail of this ReportDefinition.  # noqa: E501

        <div lang=\"ja\"> ジョブエラー詳細です。<br> このフィールドは、レスポンスの際に返却されますが、リクエストの際には無視されます。 </div> <div lang=\"en\"> Job Error Detail. <br> Although this field will be returned in the response, it will be ignored on input. </div>   # noqa: E501

        :return: The report_job_error_detail of this ReportDefinition.  # noqa: E501
        :rtype: str
        """
        return self._report_job_error_detail

    @report_job_error_detail.setter
    def report_job_error_detail(self, report_job_error_detail):
        """Sets the report_job_error_detail of this ReportDefinition.

        <div lang=\"ja\"> ジョブエラー詳細です。<br> このフィールドは、レスポンスの際に返却されますが、リクエストの際には無視されます。 </div> <div lang=\"en\"> Job Error Detail. <br> Although this field will be returned in the response, it will be ignored on input. </div>   # noqa: E501

        :param report_job_error_detail: The report_job_error_detail of this ReportDefinition.  # noqa: E501
        :type: str
        """

        self._report_job_error_detail = report_job_error_detail

    @property
    def report_job_id(self):
        """Gets the report_job_id of this ReportDefinition.  # noqa: E501

        <div lang=\"ja\"> レポートジョブIDです。<br> このフィールドは、REMOVE時に必須となり、ADD時に無視されます。 </div> <div lang=\"en\"> Report Job Id. <br> This field is required in REMOVE operation, and will be ignored in ADD operation. </div>   # noqa: E501

        :return: The report_job_id of this ReportDefinition.  # noqa: E501
        :rtype: int
        """
        return self._report_job_id

    @report_job_id.setter
    def report_job_id(self, report_job_id):
        """Sets the report_job_id of this ReportDefinition.

        <div lang=\"ja\"> レポートジョブIDです。<br> このフィールドは、REMOVE時に必須となり、ADD時に無視されます。 </div> <div lang=\"en\"> Report Job Id. <br> This field is required in REMOVE operation, and will be ignored in ADD operation. </div>   # noqa: E501

        :param report_job_id: The report_job_id of this ReportDefinition.  # noqa: E501
        :type: int
        """

        self._report_job_id = report_job_id

    @property
    def report_name(self):
        """Gets the report_name of this ReportDefinition.  # noqa: E501

        <div lang=\"ja\"> レポート名です。<br> このフィールドは、ADD時に省略可能となり、REMOVE時に無視されます。 </div> <div lang=\"en\"> Report name. <br> This field is optional in ADD operation, and will be ignored in REMOVE operation. </div>   # noqa: E501

        :return: The report_name of this ReportDefinition.  # noqa: E501
        :rtype: str
        """
        return self._report_name

    @report_name.setter
    def report_name(self, report_name):
        """Sets the report_name of this ReportDefinition.

        <div lang=\"ja\"> レポート名です。<br> このフィールドは、ADD時に省略可能となり、REMOVE時に無視されます。 </div> <div lang=\"en\"> Report name. <br> This field is optional in ADD operation, and will be ignored in REMOVE operation. </div>   # noqa: E501

        :param report_name: The report_name of this ReportDefinition.  # noqa: E501
        :type: str
        """

        self._report_name = report_name

    @property
    def request_time(self):
        """Gets the request_time of this ReportDefinition.  # noqa: E501

        <div lang=\"ja\"> ジョブ依頼日時です。<br> このフィールドは、レスポンスの際に返却されますが、リクエストの際には無視されます。 </div> <div lang=\"en\"> The date and time of Job request. <br> Although this field will be returned in the response, it will be ignored on input. </div>   # noqa: E501

        :return: The request_time of this ReportDefinition.  # noqa: E501
        :rtype: str
        """
        return self._request_time

    @request_time.setter
    def request_time(self, request_time):
        """Sets the request_time of this ReportDefinition.

        <div lang=\"ja\"> ジョブ依頼日時です。<br> このフィールドは、レスポンスの際に返却されますが、リクエストの際には無視されます。 </div> <div lang=\"en\"> The date and time of Job request. <br> Although this field will be returned in the response, it will be ignored on input. </div>   # noqa: E501

        :param request_time: The request_time of this ReportDefinition.  # noqa: E501
        :type: str
        """

        self._request_time = request_time

    @property
    def sort_fields(self):
        """Gets the sort_fields of this ReportDefinition.  # noqa: E501


        :return: The sort_fields of this ReportDefinition.  # noqa: E501
        :rtype: list[ReportDefinitionServiceReportSortField]
        """
        return self._sort_fields

    @sort_fields.setter
    def sort_fields(self, sort_fields):
        """Sets the sort_fields of this ReportDefinition.


        :param sort_fields: The sort_fields of this ReportDefinition.  # noqa: E501
        :type: list[ReportDefinitionServiceReportSortField]
        """

        self._sort_fields = sort_fields

    @property
    def zip(self):
        """Gets the zip of this ReportDefinition.  # noqa: E501


        :return: The zip of this ReportDefinition.  # noqa: E501
        :rtype: ReportDefinitionServiceZip
        """
        return self._zip

    @zip.setter
    def zip(self, zip):
        """Sets the zip of this ReportDefinition.


        :param zip: The zip of this ReportDefinition.  # noqa: E501
        :type: ReportDefinitionServiceZip
        """

        self._zip = zip

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ReportDefinition):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, ReportDefinition):
            return True

        return self.to_dict() != other.to_dict()
