# coding: utf-8

"""
    Yahoo!広告 ディスプレイ広告 API リファレンス / Yahoo! Ads Display Ads API Reference

    <div lang=\"ja\">Yahoo!広告 ディスプレイ広告 APIのWebサービスについて説明します。<br> 「Try it out」のご利用には、事前にアプリケーションの登録が必要です。また、アプリケーションのリダイレクトURIの1つに<br> https://yahoojp-marketing.github.io/ads-display-api-documents/oauth2-redirect.htmlを登録してください。 </div> <div lang=\"en\">Display Ads API Web Services supported in Yahoo! Ads API.<br> When you use \"Try it out\", you need to register your application in advance.<br> As one of redirect URI for application, you need to set \"https://yahoojp-marketing.github.io/ads-display-api-documents/oauth2-redirect.html\". </div>   # noqa: E501

    The version of the OpenAPI document: v1
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from yahoo_ads_display.configuration import Configuration


class PlacementUrlList(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'account_id': 'int',
        'description': 'str',
        'unknown_domain_flg': 'PlacementUrlListServiceUnknownDomainFlg',
        'url_list_id': 'int',
        'url_list_name': 'str',
        'urls': 'list[PlacementUrlListServiceUrlList]'
    }

    attribute_map = {
        'account_id': 'accountId',
        'description': 'description',
        'unknown_domain_flg': 'unknownDomainFlg',
        'url_list_id': 'urlListId',
        'url_list_name': 'urlListName',
        'urls': 'urls'
    }

    def __init__(self, account_id=None, description=None, unknown_domain_flg=None, url_list_id=None, url_list_name=None, urls=None, local_vars_configuration=None):  # noqa: E501
        """PlacementUrlList - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._account_id = None
        self._description = None
        self._unknown_domain_flg = None
        self._url_list_id = None
        self._url_list_name = None
        self._urls = None
        self.discriminator = None

        self.account_id = account_id
        self.description = description
        self.unknown_domain_flg = unknown_domain_flg
        self.url_list_id = url_list_id
        self.url_list_name = url_list_name
        self.urls = urls

    @property
    def account_id(self):
        """Gets the account_id of this PlacementUrlList.  # noqa: E501

        <div lang=\"ja\"> アカウントIDです。<br> このフィールドは、リクエストの場合は必須です。 </div> <div lang=\"en\"> Account ID.<br> This field is required in requests. </div>   # noqa: E501

        :return: The account_id of this PlacementUrlList.  # noqa: E501
        :rtype: int
        """
        return self._account_id

    @account_id.setter
    def account_id(self, account_id):
        """Sets the account_id of this PlacementUrlList.

        <div lang=\"ja\"> アカウントIDです。<br> このフィールドは、リクエストの場合は必須です。 </div> <div lang=\"en\"> Account ID.<br> This field is required in requests. </div>   # noqa: E501

        :param account_id: The account_id of this PlacementUrlList.  # noqa: E501
        :type: int
        """
        if self.local_vars_configuration.client_side_validation and account_id is None:  # noqa: E501
            raise ValueError("Invalid value for `account_id`, must not be `None`")  # noqa: E501

        self._account_id = account_id

    @property
    def description(self):
        """Gets the description of this PlacementUrlList.  # noqa: E501

        <div lang=\"ja\"> urlリストの説明です。<br> このフィールドは、ADDおよびSET時に省略可能となります。 </div> <div lang=\"en\"> Url List Description.<br> This field is optional in ADD and SET operation. </div>   # noqa: E501

        :return: The description of this PlacementUrlList.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this PlacementUrlList.

        <div lang=\"ja\"> urlリストの説明です。<br> このフィールドは、ADDおよびSET時に省略可能となります。 </div> <div lang=\"en\"> Url List Description.<br> This field is optional in ADD and SET operation. </div>   # noqa: E501

        :param description: The description of this PlacementUrlList.  # noqa: E501
        :type: str
        """

        self._description = description

    @property
    def unknown_domain_flg(self):
        """Gets the unknown_domain_flg of this PlacementUrlList.  # noqa: E501


        :return: The unknown_domain_flg of this PlacementUrlList.  # noqa: E501
        :rtype: PlacementUrlListServiceUnknownDomainFlg
        """
        return self._unknown_domain_flg

    @unknown_domain_flg.setter
    def unknown_domain_flg(self, unknown_domain_flg):
        """Sets the unknown_domain_flg of this PlacementUrlList.


        :param unknown_domain_flg: The unknown_domain_flg of this PlacementUrlList.  # noqa: E501
        :type: PlacementUrlListServiceUnknownDomainFlg
        """

        self._unknown_domain_flg = unknown_domain_flg

    @property
    def url_list_id(self):
        """Gets the url_list_id of this PlacementUrlList.  # noqa: E501

        <div lang=\"ja\"> urlリストIDです。<br> このフィールドは、SETおよびREMOVE時に必須となります。 </div> <div lang=\"en\"> Url List ID. <br> This field is required in SET and REMOVE operation. </div>   # noqa: E501

        :return: The url_list_id of this PlacementUrlList.  # noqa: E501
        :rtype: int
        """
        return self._url_list_id

    @url_list_id.setter
    def url_list_id(self, url_list_id):
        """Sets the url_list_id of this PlacementUrlList.

        <div lang=\"ja\"> urlリストIDです。<br> このフィールドは、SETおよびREMOVE時に必須となります。 </div> <div lang=\"en\"> Url List ID. <br> This field is required in SET and REMOVE operation. </div>   # noqa: E501

        :param url_list_id: The url_list_id of this PlacementUrlList.  # noqa: E501
        :type: int
        """

        self._url_list_id = url_list_id

    @property
    def url_list_name(self):
        """Gets the url_list_name of this PlacementUrlList.  # noqa: E501

        <div lang=\"ja\"> urlリスト名です。<br> このフィールドは、ADD時に必須となり、SET時に省略可能となります。 </div> <div lang=\"en\"> Url List Name. <br> This field is required in ADD operation, and is optional in SET operation. </div>   # noqa: E501

        :return: The url_list_name of this PlacementUrlList.  # noqa: E501
        :rtype: str
        """
        return self._url_list_name

    @url_list_name.setter
    def url_list_name(self, url_list_name):
        """Sets the url_list_name of this PlacementUrlList.

        <div lang=\"ja\"> urlリスト名です。<br> このフィールドは、ADD時に必須となり、SET時に省略可能となります。 </div> <div lang=\"en\"> Url List Name. <br> This field is required in ADD operation, and is optional in SET operation. </div>   # noqa: E501

        :param url_list_name: The url_list_name of this PlacementUrlList.  # noqa: E501
        :type: str
        """

        self._url_list_name = url_list_name

    @property
    def urls(self):
        """Gets the urls of this PlacementUrlList.  # noqa: E501


        :return: The urls of this PlacementUrlList.  # noqa: E501
        :rtype: list[PlacementUrlListServiceUrlList]
        """
        return self._urls

    @urls.setter
    def urls(self, urls):
        """Sets the urls of this PlacementUrlList.


        :param urls: The urls of this PlacementUrlList.  # noqa: E501
        :type: list[PlacementUrlListServiceUrlList]
        """

        self._urls = urls

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, PlacementUrlList):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, PlacementUrlList):
            return True

        return self.to_dict() != other.to_dict()
