# coding: utf-8

"""
    Yahoo!広告 ディスプレイ広告 API リファレンス / Yahoo! Ads Display Ads API Reference

    <div lang=\"ja\">Yahoo!広告 ディスプレイ広告 APIのWebサービスについて説明します。<br> 「Try it out」のご利用には、事前にアプリケーションの登録が必要です。また、アプリケーションのリダイレクトURIの1つに<br> https://yahoojp-marketing.github.io/ads-display-api-documents/oauth2-redirect.htmlを登録してください。 </div> <div lang=\"en\">Display Ads API Web Services supported in Yahoo! Ads API.<br> When you use \"Try it out\", you need to register your application in advance.<br> As one of redirect URI for application, you need to set \"https://yahoojp-marketing.github.io/ads-display-api-documents/oauth2-redirect.html\". </div>   # noqa: E501

    The version of the OpenAPI document: v1
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from yahoo_ads_display.configuration import Configuration


class MediaServiceRecord(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'account_id': 'int',
        'approval_status': 'MediaServiceApprovalStatus',
        'campaign_banner_flg': 'MediaServiceCampaignBannerFlg',
        'creation_time': 'str',
        'disapproval_reason_codes': 'list[str]',
        'logo_flg': 'MediaServiceLogoFlg',
        'image_media': 'MediaServiceImageMedia',
        'media_id': 'int',
        'media_name': 'str',
        'media_title': 'str',
        'thumbnail_flg': 'MediaServiceThumbnailFlg',
        'user_status': 'MediaServiceUserStatus'
    }

    attribute_map = {
        'account_id': 'accountId',
        'approval_status': 'approvalStatus',
        'campaign_banner_flg': 'campaignBannerFlg',
        'creation_time': 'creationTime',
        'disapproval_reason_codes': 'disapprovalReasonCodes',
        'logo_flg': 'logoFlg',
        'image_media': 'imageMedia',
        'media_id': 'mediaId',
        'media_name': 'mediaName',
        'media_title': 'mediaTitle',
        'thumbnail_flg': 'thumbnailFlg',
        'user_status': 'userStatus'
    }

    def __init__(self, account_id=None, approval_status=None, campaign_banner_flg=None, creation_time=None, disapproval_reason_codes=None, logo_flg=None, image_media=None, media_id=None, media_name=None, media_title=None, thumbnail_flg=None, user_status=None, local_vars_configuration=None):  # noqa: E501
        """MediaServiceRecord - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._account_id = None
        self._approval_status = None
        self._campaign_banner_flg = None
        self._creation_time = None
        self._disapproval_reason_codes = None
        self._logo_flg = None
        self._image_media = None
        self._media_id = None
        self._media_name = None
        self._media_title = None
        self._thumbnail_flg = None
        self._user_status = None
        self.discriminator = None

        self.account_id = account_id
        self.approval_status = approval_status
        self.campaign_banner_flg = campaign_banner_flg
        self.creation_time = creation_time
        self.disapproval_reason_codes = disapproval_reason_codes
        self.logo_flg = logo_flg
        self.image_media = image_media
        self.media_id = media_id
        self.media_name = media_name
        self.media_title = media_title
        self.thumbnail_flg = thumbnail_flg
        self.user_status = user_status

    @property
    def account_id(self):
        """Gets the account_id of this MediaServiceRecord.  # noqa: E501

        <div lang=\"ja\">アカウントIDです。<br> このフィールドは、リクエストの場合は必須です。 </div> <div lang=\"en\">Account ID.<br> This field is required in requests. </div>   # noqa: E501

        :return: The account_id of this MediaServiceRecord.  # noqa: E501
        :rtype: int
        """
        return self._account_id

    @account_id.setter
    def account_id(self, account_id):
        """Sets the account_id of this MediaServiceRecord.

        <div lang=\"ja\">アカウントIDです。<br> このフィールドは、リクエストの場合は必須です。 </div> <div lang=\"en\">Account ID.<br> This field is required in requests. </div>   # noqa: E501

        :param account_id: The account_id of this MediaServiceRecord.  # noqa: E501
        :type: int
        """

        self._account_id = account_id

    @property
    def approval_status(self):
        """Gets the approval_status of this MediaServiceRecord.  # noqa: E501


        :return: The approval_status of this MediaServiceRecord.  # noqa: E501
        :rtype: MediaServiceApprovalStatus
        """
        return self._approval_status

    @approval_status.setter
    def approval_status(self, approval_status):
        """Sets the approval_status of this MediaServiceRecord.


        :param approval_status: The approval_status of this MediaServiceRecord.  # noqa: E501
        :type: MediaServiceApprovalStatus
        """

        self._approval_status = approval_status

    @property
    def campaign_banner_flg(self):
        """Gets the campaign_banner_flg of this MediaServiceRecord.  # noqa: E501


        :return: The campaign_banner_flg of this MediaServiceRecord.  # noqa: E501
        :rtype: MediaServiceCampaignBannerFlg
        """
        return self._campaign_banner_flg

    @campaign_banner_flg.setter
    def campaign_banner_flg(self, campaign_banner_flg):
        """Sets the campaign_banner_flg of this MediaServiceRecord.


        :param campaign_banner_flg: The campaign_banner_flg of this MediaServiceRecord.  # noqa: E501
        :type: MediaServiceCampaignBannerFlg
        """

        self._campaign_banner_flg = campaign_banner_flg

    @property
    def creation_time(self):
        """Gets the creation_time of this MediaServiceRecord.  # noqa: E501

        <div lang=\"ja\">入稿日時です。</div> <div lang=\"en\">Date and time of creation.</div>   # noqa: E501

        :return: The creation_time of this MediaServiceRecord.  # noqa: E501
        :rtype: str
        """
        return self._creation_time

    @creation_time.setter
    def creation_time(self, creation_time):
        """Sets the creation_time of this MediaServiceRecord.

        <div lang=\"ja\">入稿日時です。</div> <div lang=\"en\">Date and time of creation.</div>   # noqa: E501

        :param creation_time: The creation_time of this MediaServiceRecord.  # noqa: E501
        :type: str
        """

        self._creation_time = creation_time

    @property
    def disapproval_reason_codes(self):
        """Gets the disapproval_reason_codes of this MediaServiceRecord.  # noqa: E501

        <div lang=\"ja\">掲載拒否の理由です。</div> <div lang=\"en\">Reason code why it&#39;s disapproved on the review.</div>   # noqa: E501

        :return: The disapproval_reason_codes of this MediaServiceRecord.  # noqa: E501
        :rtype: list[str]
        """
        return self._disapproval_reason_codes

    @disapproval_reason_codes.setter
    def disapproval_reason_codes(self, disapproval_reason_codes):
        """Sets the disapproval_reason_codes of this MediaServiceRecord.

        <div lang=\"ja\">掲載拒否の理由です。</div> <div lang=\"en\">Reason code why it&#39;s disapproved on the review.</div>   # noqa: E501

        :param disapproval_reason_codes: The disapproval_reason_codes of this MediaServiceRecord.  # noqa: E501
        :type: list[str]
        """

        self._disapproval_reason_codes = disapproval_reason_codes

    @property
    def logo_flg(self):
        """Gets the logo_flg of this MediaServiceRecord.  # noqa: E501


        :return: The logo_flg of this MediaServiceRecord.  # noqa: E501
        :rtype: MediaServiceLogoFlg
        """
        return self._logo_flg

    @logo_flg.setter
    def logo_flg(self, logo_flg):
        """Sets the logo_flg of this MediaServiceRecord.


        :param logo_flg: The logo_flg of this MediaServiceRecord.  # noqa: E501
        :type: MediaServiceLogoFlg
        """

        self._logo_flg = logo_flg

    @property
    def image_media(self):
        """Gets the image_media of this MediaServiceRecord.  # noqa: E501


        :return: The image_media of this MediaServiceRecord.  # noqa: E501
        :rtype: MediaServiceImageMedia
        """
        return self._image_media

    @image_media.setter
    def image_media(self, image_media):
        """Sets the image_media of this MediaServiceRecord.


        :param image_media: The image_media of this MediaServiceRecord.  # noqa: E501
        :type: MediaServiceImageMedia
        """

        self._image_media = image_media

    @property
    def media_id(self):
        """Gets the media_id of this MediaServiceRecord.  # noqa: E501

        <div lang=\"ja\">画像IDです。<br> このフィールドは、SETおよびREMOVE時に必須となります。 </div> <div lang=\"en\">Media ID (image ID). <br> This field is required in SET and REMOVE operation. </div>   # noqa: E501

        :return: The media_id of this MediaServiceRecord.  # noqa: E501
        :rtype: int
        """
        return self._media_id

    @media_id.setter
    def media_id(self, media_id):
        """Sets the media_id of this MediaServiceRecord.

        <div lang=\"ja\">画像IDです。<br> このフィールドは、SETおよびREMOVE時に必須となります。 </div> <div lang=\"en\">Media ID (image ID). <br> This field is required in SET and REMOVE operation. </div>   # noqa: E501

        :param media_id: The media_id of this MediaServiceRecord.  # noqa: E501
        :type: int
        """

        self._media_id = media_id

    @property
    def media_name(self):
        """Gets the media_name of this MediaServiceRecord.  # noqa: E501

        <div lang=\"ja\"> 実ファイル名です。<br> このフィールドは、ADD時に必須となります。 </div> <div lang=\"en\">File name. <br> This field is required in ADD operation. </div>   # noqa: E501

        :return: The media_name of this MediaServiceRecord.  # noqa: E501
        :rtype: str
        """
        return self._media_name

    @media_name.setter
    def media_name(self, media_name):
        """Sets the media_name of this MediaServiceRecord.

        <div lang=\"ja\"> 実ファイル名です。<br> このフィールドは、ADD時に必須となります。 </div> <div lang=\"en\">File name. <br> This field is required in ADD operation. </div>   # noqa: E501

        :param media_name: The media_name of this MediaServiceRecord.  # noqa: E501
        :type: str
        """

        self._media_name = media_name

    @property
    def media_title(self):
        """Gets the media_title of this MediaServiceRecord.  # noqa: E501

        <div lang=\"ja\">画像名です。<br> このフィールドは、ADD時に必須となり、SET時に省略可能となります。 </div> <div lang=\"en\">Image name. <br> This field is required in ADD operation, and is optional in SET operation. </div>   # noqa: E501

        :return: The media_title of this MediaServiceRecord.  # noqa: E501
        :rtype: str
        """
        return self._media_title

    @media_title.setter
    def media_title(self, media_title):
        """Sets the media_title of this MediaServiceRecord.

        <div lang=\"ja\">画像名です。<br> このフィールドは、ADD時に必須となり、SET時に省略可能となります。 </div> <div lang=\"en\">Image name. <br> This field is required in ADD operation, and is optional in SET operation. </div>   # noqa: E501

        :param media_title: The media_title of this MediaServiceRecord.  # noqa: E501
        :type: str
        """

        self._media_title = media_title

    @property
    def thumbnail_flg(self):
        """Gets the thumbnail_flg of this MediaServiceRecord.  # noqa: E501


        :return: The thumbnail_flg of this MediaServiceRecord.  # noqa: E501
        :rtype: MediaServiceThumbnailFlg
        """
        return self._thumbnail_flg

    @thumbnail_flg.setter
    def thumbnail_flg(self, thumbnail_flg):
        """Sets the thumbnail_flg of this MediaServiceRecord.


        :param thumbnail_flg: The thumbnail_flg of this MediaServiceRecord.  # noqa: E501
        :type: MediaServiceThumbnailFlg
        """

        self._thumbnail_flg = thumbnail_flg

    @property
    def user_status(self):
        """Gets the user_status of this MediaServiceRecord.  # noqa: E501


        :return: The user_status of this MediaServiceRecord.  # noqa: E501
        :rtype: MediaServiceUserStatus
        """
        return self._user_status

    @user_status.setter
    def user_status(self, user_status):
        """Sets the user_status of this MediaServiceRecord.


        :param user_status: The user_status of this MediaServiceRecord.  # noqa: E501
        :type: MediaServiceUserStatus
        """

        self._user_status = user_status

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, MediaServiceRecord):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, MediaServiceRecord):
            return True

        return self.to_dict() != other.to_dict()
