# coding: utf-8

"""
    Yahoo!広告 ディスプレイ広告 API リファレンス / Yahoo! Ads Display Ads API Reference

    <div lang=\"ja\">Yahoo!広告 ディスプレイ広告 APIのWebサービスについて説明します。<br> 「Try it out」のご利用には、事前にアプリケーションの登録が必要です。また、アプリケーションのリダイレクトURIの1つに<br> https://yahoojp-marketing.github.io/ads-display-api-documents/oauth2-redirect.htmlを登録してください。 </div> <div lang=\"en\">Display Ads API Web Services supported in Yahoo! Ads API.<br> When you use \"Try it out\", you need to register your application in advance.<br> As one of redirect URI for application, you need to set \"https://yahoojp-marketing.github.io/ads-display-api-documents/oauth2-redirect.html\". </div>   # noqa: E501

    The version of the OpenAPI document: v1
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from yahoo_ads_display.configuration import Configuration


class FeedSet(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'account_id': 'int',
        'condition_sets': 'list[FeedSetServiceConditionSet]',
        'feed_id': 'int',
        'feed_set_id': 'int',
        'feed_set_name': 'str',
        'is_default_set': 'bool',
        'item_count': 'int'
    }

    attribute_map = {
        'account_id': 'accountId',
        'condition_sets': 'conditionSets',
        'feed_id': 'feedId',
        'feed_set_id': 'feedSetId',
        'feed_set_name': 'feedSetName',
        'is_default_set': 'isDefaultSet',
        'item_count': 'itemCount'
    }

    def __init__(self, account_id=None, condition_sets=None, feed_id=None, feed_set_id=None, feed_set_name=None, is_default_set=None, item_count=None, local_vars_configuration=None):  # noqa: E501
        """FeedSet - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._account_id = None
        self._condition_sets = None
        self._feed_id = None
        self._feed_set_id = None
        self._feed_set_name = None
        self._is_default_set = None
        self._item_count = None
        self.discriminator = None

        self.account_id = account_id
        self.condition_sets = condition_sets
        self.feed_id = feed_id
        self.feed_set_id = feed_set_id
        self.feed_set_name = feed_set_name
        self.is_default_set = is_default_set
        self.item_count = item_count

    @property
    def account_id(self):
        """Gets the account_id of this FeedSet.  # noqa: E501

        <div lang=\"ja\"> アカウントIDです。<br> このフィールドは、レスポンスの際に返却されますが、リクエストの際には無視されます。 </div> <div lang=\"en\"> Account ID.<br> Although this field will be returned in the response, it will be ignored on input. </div>   # noqa: E501

        :return: The account_id of this FeedSet.  # noqa: E501
        :rtype: int
        """
        return self._account_id

    @account_id.setter
    def account_id(self, account_id):
        """Sets the account_id of this FeedSet.

        <div lang=\"ja\"> アカウントIDです。<br> このフィールドは、レスポンスの際に返却されますが、リクエストの際には無視されます。 </div> <div lang=\"en\"> Account ID.<br> Although this field will be returned in the response, it will be ignored on input. </div>   # noqa: E501

        :param account_id: The account_id of this FeedSet.  # noqa: E501
        :type: int
        """

        self._account_id = account_id

    @property
    def condition_sets(self):
        """Gets the condition_sets of this FeedSet.  # noqa: E501


        :return: The condition_sets of this FeedSet.  # noqa: E501
        :rtype: list[FeedSetServiceConditionSet]
        """
        return self._condition_sets

    @condition_sets.setter
    def condition_sets(self, condition_sets):
        """Sets the condition_sets of this FeedSet.


        :param condition_sets: The condition_sets of this FeedSet.  # noqa: E501
        :type: list[FeedSetServiceConditionSet]
        """

        self._condition_sets = condition_sets

    @property
    def feed_id(self):
        """Gets the feed_id of this FeedSet.  # noqa: E501

        <div lang=\"ja\"> Feedを識別するIDです。<br> このフィールドは、リクエストの場合は必須です。 </div> <div lang=\"en\"> Feed ID.<br> This field is required in requests. </div>   # noqa: E501

        :return: The feed_id of this FeedSet.  # noqa: E501
        :rtype: int
        """
        return self._feed_id

    @feed_id.setter
    def feed_id(self, feed_id):
        """Sets the feed_id of this FeedSet.

        <div lang=\"ja\"> Feedを識別するIDです。<br> このフィールドは、リクエストの場合は必須です。 </div> <div lang=\"en\"> Feed ID.<br> This field is required in requests. </div>   # noqa: E501

        :param feed_id: The feed_id of this FeedSet.  # noqa: E501
        :type: int
        """

        self._feed_id = feed_id

    @property
    def feed_set_id(self):
        """Gets the feed_set_id of this FeedSet.  # noqa: E501

        <div lang=\"ja\"> 商品セットIDです。<br> REMOVE時、このフィールドは必須です。 </div> <div lang=\"en\"> Item Set ID.<br> This field is required in REMOVE operation. </div>   # noqa: E501

        :return: The feed_set_id of this FeedSet.  # noqa: E501
        :rtype: int
        """
        return self._feed_set_id

    @feed_set_id.setter
    def feed_set_id(self, feed_set_id):
        """Sets the feed_set_id of this FeedSet.

        <div lang=\"ja\"> 商品セットIDです。<br> REMOVE時、このフィールドは必須です。 </div> <div lang=\"en\"> Item Set ID.<br> This field is required in REMOVE operation. </div>   # noqa: E501

        :param feed_set_id: The feed_set_id of this FeedSet.  # noqa: E501
        :type: int
        """

        self._feed_set_id = feed_set_id

    @property
    def feed_set_name(self):
        """Gets the feed_set_name of this FeedSet.  # noqa: E501

        <div lang=\"ja\"> 商品セット名です。<br> ADD時、このフィールドは必須です。 </div> <div lang=\"en\"> Item Set name.<br> This field is required in ADD operation. </div>   # noqa: E501

        :return: The feed_set_name of this FeedSet.  # noqa: E501
        :rtype: str
        """
        return self._feed_set_name

    @feed_set_name.setter
    def feed_set_name(self, feed_set_name):
        """Sets the feed_set_name of this FeedSet.

        <div lang=\"ja\"> 商品セット名です。<br> ADD時、このフィールドは必須です。 </div> <div lang=\"en\"> Item Set name.<br> This field is required in ADD operation. </div>   # noqa: E501

        :param feed_set_name: The feed_set_name of this FeedSet.  # noqa: E501
        :type: str
        """

        self._feed_set_name = feed_set_name

    @property
    def is_default_set(self):
        """Gets the is_default_set of this FeedSet.  # noqa: E501

        <div lang=\"ja\"> デフォルトセット判定です。<br> このフィールドは、レスポンスの際に返却されますが、リクエストの際には無視されます。 </div> <div lang=\"en\"> Default setting of Item Set or not.<br> Although this field will be returned in the response, it will be ignored on input. </div>   # noqa: E501

        :return: The is_default_set of this FeedSet.  # noqa: E501
        :rtype: bool
        """
        return self._is_default_set

    @is_default_set.setter
    def is_default_set(self, is_default_set):
        """Sets the is_default_set of this FeedSet.

        <div lang=\"ja\"> デフォルトセット判定です。<br> このフィールドは、レスポンスの際に返却されますが、リクエストの際には無視されます。 </div> <div lang=\"en\"> Default setting of Item Set or not.<br> Although this field will be returned in the response, it will be ignored on input. </div>   # noqa: E501

        :param is_default_set: The is_default_set of this FeedSet.  # noqa: E501
        :type: bool
        """

        self._is_default_set = is_default_set

    @property
    def item_count(self):
        """Gets the item_count of this FeedSet.  # noqa: E501

        <div lang=\"ja\"> 商品セットの条件に含まれるアイテム数です。<br> このフィールドは、レスポンスの際に返却されますが、リクエストの際には無視されます。 </div> <div lang=\"en\"> Number of items included in Item Set conditions.<br> Although this field will be returned in the response, it will be ignored on input. </div>   # noqa: E501

        :return: The item_count of this FeedSet.  # noqa: E501
        :rtype: int
        """
        return self._item_count

    @item_count.setter
    def item_count(self, item_count):
        """Sets the item_count of this FeedSet.

        <div lang=\"ja\"> 商品セットの条件に含まれるアイテム数です。<br> このフィールドは、レスポンスの際に返却されますが、リクエストの際には無視されます。 </div> <div lang=\"en\"> Number of items included in Item Set conditions.<br> Although this field will be returned in the response, it will be ignored on input. </div>   # noqa: E501

        :param item_count: The item_count of this FeedSet.  # noqa: E501
        :type: int
        """

        self._item_count = item_count

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, FeedSet):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, FeedSet):
            return True

        return self.to_dict() != other.to_dict()
