# coding: utf-8

"""
    Yahoo!広告 ディスプレイ広告 API リファレンス / Yahoo! Ads Display Ads API Reference

    <div lang=\"ja\">Yahoo!広告 ディスプレイ広告 APIのWebサービスについて説明します。<br> 「Try it out」のご利用には、事前にアプリケーションの登録が必要です。また、アプリケーションのリダイレクトURIの1つに<br> https://yahoojp-marketing.github.io/ads-display-api-documents/oauth2-redirect.htmlを登録してください。 </div> <div lang=\"en\">Display Ads API Web Services supported in Yahoo! Ads API.<br> When you use \"Try it out\", you need to register your application in advance.<br> As one of redirect URI for application, you need to set \"https://yahoojp-marketing.github.io/ads-display-api-documents/oauth2-redirect.html\". </div>   # noqa: E501

    The version of the OpenAPI document: v1
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from yahoo_ads_display.configuration import Configuration


class Campaign(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'account_id': 'int',
        'ad_product_type': 'str',
        'app_id': 'str',
        'app_name': 'str',
        'bidding_strategy': 'CampaignServiceBiddingStrategy',
        'budget': 'CampaignServiceBudget',
        'campaign_bidding_strategy': 'CampaignServiceCampaignBiddingStrategy',
        'campaign_goal': 'str',
        'campaign_id': 'int',
        'campaign_name': 'str',
        'conversion_optimizer': 'CampaignServiceConversionOptimizer',
        'device_os_type': 'CampaignServiceDeviceOsType',
        'end_date': 'str',
        'feed_id': 'int',
        'frequency_cap': 'CampaignServiceFrequencyCap',
        'labels': 'list[CampaignServiceLabel]',
        'serving_status': 'CampaignServiceServingStatus',
        'start_date': 'str',
        'type': 'CampaignServiceType',
        'user_status': 'CampaignServiceUserStatus',
        'viewable_frequency_cap': 'CampaignServiceViewableFrequencyCap'
    }

    attribute_map = {
        'account_id': 'accountId',
        'ad_product_type': 'adProductType',
        'app_id': 'appId',
        'app_name': 'appName',
        'bidding_strategy': 'biddingStrategy',
        'budget': 'budget',
        'campaign_bidding_strategy': 'campaignBiddingStrategy',
        'campaign_goal': 'campaignGoal',
        'campaign_id': 'campaignId',
        'campaign_name': 'campaignName',
        'conversion_optimizer': 'conversionOptimizer',
        'device_os_type': 'deviceOsType',
        'end_date': 'endDate',
        'feed_id': 'feedId',
        'frequency_cap': 'frequencyCap',
        'labels': 'labels',
        'serving_status': 'servingStatus',
        'start_date': 'startDate',
        'type': 'type',
        'user_status': 'userStatus',
        'viewable_frequency_cap': 'viewableFrequencyCap'
    }

    def __init__(self, account_id=None, ad_product_type=None, app_id=None, app_name=None, bidding_strategy=None, budget=None, campaign_bidding_strategy=None, campaign_goal=None, campaign_id=None, campaign_name=None, conversion_optimizer=None, device_os_type=None, end_date=None, feed_id=None, frequency_cap=None, labels=None, serving_status=None, start_date=None, type=None, user_status=None, viewable_frequency_cap=None, local_vars_configuration=None):  # noqa: E501
        """Campaign - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._account_id = None
        self._ad_product_type = None
        self._app_id = None
        self._app_name = None
        self._bidding_strategy = None
        self._budget = None
        self._campaign_bidding_strategy = None
        self._campaign_goal = None
        self._campaign_id = None
        self._campaign_name = None
        self._conversion_optimizer = None
        self._device_os_type = None
        self._end_date = None
        self._feed_id = None
        self._frequency_cap = None
        self._labels = None
        self._serving_status = None
        self._start_date = None
        self._type = None
        self._user_status = None
        self._viewable_frequency_cap = None
        self.discriminator = None

        self.account_id = account_id
        self.ad_product_type = ad_product_type
        self.app_id = app_id
        self.app_name = app_name
        self.bidding_strategy = bidding_strategy
        self.budget = budget
        self.campaign_bidding_strategy = campaign_bidding_strategy
        self.campaign_goal = campaign_goal
        self.campaign_id = campaign_id
        self.campaign_name = campaign_name
        self.conversion_optimizer = conversion_optimizer
        self.device_os_type = device_os_type
        self.end_date = end_date
        self.feed_id = feed_id
        self.frequency_cap = frequency_cap
        self.labels = labels
        self.serving_status = serving_status
        self.start_date = start_date
        self.type = type
        self.user_status = user_status
        self.viewable_frequency_cap = viewable_frequency_cap

    @property
    def account_id(self):
        """Gets the account_id of this Campaign.  # noqa: E501

        <div lang=\"ja\"> アカウントIDです。<br> このフィールドは、リクエストの場合は必須です。 </div> <div lang=\"en\"> Account ID. <br> This field is required in requests. </div>   # noqa: E501

        :return: The account_id of this Campaign.  # noqa: E501
        :rtype: int
        """
        return self._account_id

    @account_id.setter
    def account_id(self, account_id):
        """Sets the account_id of this Campaign.

        <div lang=\"ja\"> アカウントIDです。<br> このフィールドは、リクエストの場合は必須です。 </div> <div lang=\"en\"> Account ID. <br> This field is required in requests. </div>   # noqa: E501

        :param account_id: The account_id of this Campaign.  # noqa: E501
        :type: int
        """

        self._account_id = account_id

    @property
    def ad_product_type(self):
        """Gets the ad_product_type of this Campaign.  # noqa: E501

        <div lang=\"ja\"> 配信方法です。<br> ADD時、このフィールドは目的なしの場合は必須となり、目的ありの場合は設定不可となります。<br> REMOVE時、このフィールドは無視されます。<br> ※指定可能な値は、AccountAdProductServiceのGET操作で取得されるAdProductをご確認ください。 </div> <div lang=\"en\"> Ad product information.<br> In ADD operation, this field is required for campaigns with no campaign goal, and this field cannot be set for campaigns with campaign goal. <br> In REMOVE operation, this field will be ignored.<br> * Available values can be referred to adProductType field of AdProduct object obtained by GET operation of AccountAdProductService. </div>   # noqa: E501

        :return: The ad_product_type of this Campaign.  # noqa: E501
        :rtype: str
        """
        return self._ad_product_type

    @ad_product_type.setter
    def ad_product_type(self, ad_product_type):
        """Sets the ad_product_type of this Campaign.

        <div lang=\"ja\"> 配信方法です。<br> ADD時、このフィールドは目的なしの場合は必須となり、目的ありの場合は設定不可となります。<br> REMOVE時、このフィールドは無視されます。<br> ※指定可能な値は、AccountAdProductServiceのGET操作で取得されるAdProductをご確認ください。 </div> <div lang=\"en\"> Ad product information.<br> In ADD operation, this field is required for campaigns with no campaign goal, and this field cannot be set for campaigns with campaign goal. <br> In REMOVE operation, this field will be ignored.<br> * Available values can be referred to adProductType field of AdProduct object obtained by GET operation of AccountAdProductService. </div>   # noqa: E501

        :param ad_product_type: The ad_product_type of this Campaign.  # noqa: E501
        :type: str
        """

        self._ad_product_type = ad_product_type

    @property
    def app_id(self):
        """Gets the app_id of this Campaign.  # noqa: E501

        <div lang=\"ja\"> iOS:アプリIDです。<br> Android:パッケージ名です。<br> このフィールドは、ADD時に省略可能となり、SETおよびREMOVE時は無視されます。<br> ※campaignTypeがAPPの場合、ADD時に必須となります。 </div> <div lang=\"en\"> iOS: APP ID.<br> Android: Package name. <br> This field is optional in ADD operation, and will be ignored in SET and REMOVE operation.<br> *If campaignType is APP, this field is required in ADD operation. </div>   # noqa: E501

        :return: The app_id of this Campaign.  # noqa: E501
        :rtype: str
        """
        return self._app_id

    @app_id.setter
    def app_id(self, app_id):
        """Sets the app_id of this Campaign.

        <div lang=\"ja\"> iOS:アプリIDです。<br> Android:パッケージ名です。<br> このフィールドは、ADD時に省略可能となり、SETおよびREMOVE時は無視されます。<br> ※campaignTypeがAPPの場合、ADD時に必須となります。 </div> <div lang=\"en\"> iOS: APP ID.<br> Android: Package name. <br> This field is optional in ADD operation, and will be ignored in SET and REMOVE operation.<br> *If campaignType is APP, this field is required in ADD operation. </div>   # noqa: E501

        :param app_id: The app_id of this Campaign.  # noqa: E501
        :type: str
        """

        self._app_id = app_id

    @property
    def app_name(self):
        """Gets the app_name of this Campaign.  # noqa: E501

        <div lang=\"ja\"> アプリの名称です。<br> このフィールドは、ADD時に省略可能となり、SETおよびREMOVE時は無視されます。<br> ※campaignTypeがAPPの場合、ADD時に必須となります。 </div> <div lang=\"en\"> App Name. <br> This field is optional in ADD operation, and will be ignored in SET and REMOVE operation.<br> *If campaignType is APP, this field is required in ADD operation. </div>   # noqa: E501

        :return: The app_name of this Campaign.  # noqa: E501
        :rtype: str
        """
        return self._app_name

    @app_name.setter
    def app_name(self, app_name):
        """Sets the app_name of this Campaign.

        <div lang=\"ja\"> アプリの名称です。<br> このフィールドは、ADD時に省略可能となり、SETおよびREMOVE時は無視されます。<br> ※campaignTypeがAPPの場合、ADD時に必須となります。 </div> <div lang=\"en\"> App Name. <br> This field is optional in ADD operation, and will be ignored in SET and REMOVE operation.<br> *If campaignType is APP, this field is required in ADD operation. </div>   # noqa: E501

        :param app_name: The app_name of this Campaign.  # noqa: E501
        :type: str
        """

        self._app_name = app_name

    @property
    def bidding_strategy(self):
        """Gets the bidding_strategy of this Campaign.  # noqa: E501


        :return: The bidding_strategy of this Campaign.  # noqa: E501
        :rtype: CampaignServiceBiddingStrategy
        """
        return self._bidding_strategy

    @bidding_strategy.setter
    def bidding_strategy(self, bidding_strategy):
        """Sets the bidding_strategy of this Campaign.


        :param bidding_strategy: The bidding_strategy of this Campaign.  # noqa: E501
        :type: CampaignServiceBiddingStrategy
        """

        self._bidding_strategy = bidding_strategy

    @property
    def budget(self):
        """Gets the budget of this Campaign.  # noqa: E501


        :return: The budget of this Campaign.  # noqa: E501
        :rtype: CampaignServiceBudget
        """
        return self._budget

    @budget.setter
    def budget(self, budget):
        """Sets the budget of this Campaign.


        :param budget: The budget of this Campaign.  # noqa: E501
        :type: CampaignServiceBudget
        """

        self._budget = budget

    @property
    def campaign_bidding_strategy(self):
        """Gets the campaign_bidding_strategy of this Campaign.  # noqa: E501


        :return: The campaign_bidding_strategy of this Campaign.  # noqa: E501
        :rtype: CampaignServiceCampaignBiddingStrategy
        """
        return self._campaign_bidding_strategy

    @campaign_bidding_strategy.setter
    def campaign_bidding_strategy(self, campaign_bidding_strategy):
        """Sets the campaign_bidding_strategy of this Campaign.


        :param campaign_bidding_strategy: The campaign_bidding_strategy of this Campaign.  # noqa: E501
        :type: CampaignServiceCampaignBiddingStrategy
        """

        self._campaign_bidding_strategy = campaign_bidding_strategy

    @property
    def campaign_goal(self):
        """Gets the campaign_goal of this Campaign.  # noqa: E501

        <div lang=\"ja\"> キャンペーン目的です。<br> ADD時、このフィールドは目的なしの場合は設定不可となり、目的ありの場合は必須となります。<br> SETおよびREMOVE時、このフィールドは無視されます。<br> ※指定可能な値は、AccountServiceのGET操作で得られるAccountのaccountAuthoritiesフィールドをご確認ください。<br> </div> <div lang=\"en\"> Campaign goal.<br> In ADD operation, this field cannot be set for campaigns with no campaign goal, and will be required for campaigns with campaign goal.<br> In SET and REMOVE operation, this field will be ignored.<br> * Available values can be referred to accountAuthorities field of Account object obtained by GET operation of AccountService.<br> </div>   # noqa: E501

        :return: The campaign_goal of this Campaign.  # noqa: E501
        :rtype: str
        """
        return self._campaign_goal

    @campaign_goal.setter
    def campaign_goal(self, campaign_goal):
        """Sets the campaign_goal of this Campaign.

        <div lang=\"ja\"> キャンペーン目的です。<br> ADD時、このフィールドは目的なしの場合は設定不可となり、目的ありの場合は必須となります。<br> SETおよびREMOVE時、このフィールドは無視されます。<br> ※指定可能な値は、AccountServiceのGET操作で得られるAccountのaccountAuthoritiesフィールドをご確認ください。<br> </div> <div lang=\"en\"> Campaign goal.<br> In ADD operation, this field cannot be set for campaigns with no campaign goal, and will be required for campaigns with campaign goal.<br> In SET and REMOVE operation, this field will be ignored.<br> * Available values can be referred to accountAuthorities field of Account object obtained by GET operation of AccountService.<br> </div>   # noqa: E501

        :param campaign_goal: The campaign_goal of this Campaign.  # noqa: E501
        :type: str
        """

        self._campaign_goal = campaign_goal

    @property
    def campaign_id(self):
        """Gets the campaign_id of this Campaign.  # noqa: E501

        <div lang=\"ja\"> キャンペーンIDです。<br> このフィールドはSETおよびREMOVE時に必須となり、ADD時に無視されます。 </div> <div lang=\"en\"> Campaign ID.<br> This field is required in SET and REMOVE operation, and will be ignored in ADD operation. </div>   # noqa: E501

        :return: The campaign_id of this Campaign.  # noqa: E501
        :rtype: int
        """
        return self._campaign_id

    @campaign_id.setter
    def campaign_id(self, campaign_id):
        """Sets the campaign_id of this Campaign.

        <div lang=\"ja\"> キャンペーンIDです。<br> このフィールドはSETおよびREMOVE時に必須となり、ADD時に無視されます。 </div> <div lang=\"en\"> Campaign ID.<br> This field is required in SET and REMOVE operation, and will be ignored in ADD operation. </div>   # noqa: E501

        :param campaign_id: The campaign_id of this Campaign.  # noqa: E501
        :type: int
        """

        self._campaign_id = campaign_id

    @property
    def campaign_name(self):
        """Gets the campaign_name of this Campaign.  # noqa: E501

        <div lang=\"ja\"> キャンペーン名です。<br> このフィールドは、ADD時は必須、SET時は省略可能となり、REMOVE時は無視されます。 </div> <div lang=\"en\"> Campaign Name.<br> This field is required in ADD operation, is optional in SET operation, and will be ignored in REMOVE operation. </div>   # noqa: E501

        :return: The campaign_name of this Campaign.  # noqa: E501
        :rtype: str
        """
        return self._campaign_name

    @campaign_name.setter
    def campaign_name(self, campaign_name):
        """Sets the campaign_name of this Campaign.

        <div lang=\"ja\"> キャンペーン名です。<br> このフィールドは、ADD時は必須、SET時は省略可能となり、REMOVE時は無視されます。 </div> <div lang=\"en\"> Campaign Name.<br> This field is required in ADD operation, is optional in SET operation, and will be ignored in REMOVE operation. </div>   # noqa: E501

        :param campaign_name: The campaign_name of this Campaign.  # noqa: E501
        :type: str
        """

        self._campaign_name = campaign_name

    @property
    def conversion_optimizer(self):
        """Gets the conversion_optimizer of this Campaign.  # noqa: E501


        :return: The conversion_optimizer of this Campaign.  # noqa: E501
        :rtype: CampaignServiceConversionOptimizer
        """
        return self._conversion_optimizer

    @conversion_optimizer.setter
    def conversion_optimizer(self, conversion_optimizer):
        """Sets the conversion_optimizer of this Campaign.


        :param conversion_optimizer: The conversion_optimizer of this Campaign.  # noqa: E501
        :type: CampaignServiceConversionOptimizer
        """

        self._conversion_optimizer = conversion_optimizer

    @property
    def device_os_type(self):
        """Gets the device_os_type of this Campaign.  # noqa: E501


        :return: The device_os_type of this Campaign.  # noqa: E501
        :rtype: CampaignServiceDeviceOsType
        """
        return self._device_os_type

    @device_os_type.setter
    def device_os_type(self, device_os_type):
        """Sets the device_os_type of this Campaign.


        :param device_os_type: The device_os_type of this Campaign.  # noqa: E501
        :type: CampaignServiceDeviceOsType
        """

        self._device_os_type = device_os_type

    @property
    def end_date(self):
        """Gets the end_date of this Campaign.  # noqa: E501

        <div lang=\"ja\"> 終了日です。<br> このフィールドは、ADDおよびSET時に省略可能となり、REMOVE時に無視されます。 </div> <div lang=\"en\"> End date.<br> This field is optional in ADD and SET operation, and will be ignored in REMOVE operation. </div>   # noqa: E501

        :return: The end_date of this Campaign.  # noqa: E501
        :rtype: str
        """
        return self._end_date

    @end_date.setter
    def end_date(self, end_date):
        """Sets the end_date of this Campaign.

        <div lang=\"ja\"> 終了日です。<br> このフィールドは、ADDおよびSET時に省略可能となり、REMOVE時に無視されます。 </div> <div lang=\"en\"> End date.<br> This field is optional in ADD and SET operation, and will be ignored in REMOVE operation. </div>   # noqa: E501

        :param end_date: The end_date of this Campaign.  # noqa: E501
        :type: str
        """

        self._end_date = end_date

    @property
    def feed_id(self):
        """Gets the feed_id of this Campaign.  # noqa: E501

        <div lang=\"ja\"> フィードIDです。<br> このフィールドは、ADD時に省略可能となり、SETおよびREMOVE時に無視されます。<br> ※動的ディスプレイ広告の場合、ADD時に必須となります。 </div> <div lang=\"en\"> Feed ID.<br> This field is optional in ADD operation, and will be ignored in SET and REMOVE operation. <br> *If adType is Dynamic Ads for Display, this field is required in ADD operation. </div>   # noqa: E501

        :return: The feed_id of this Campaign.  # noqa: E501
        :rtype: int
        """
        return self._feed_id

    @feed_id.setter
    def feed_id(self, feed_id):
        """Sets the feed_id of this Campaign.

        <div lang=\"ja\"> フィードIDです。<br> このフィールドは、ADD時に省略可能となり、SETおよびREMOVE時に無視されます。<br> ※動的ディスプレイ広告の場合、ADD時に必須となります。 </div> <div lang=\"en\"> Feed ID.<br> This field is optional in ADD operation, and will be ignored in SET and REMOVE operation. <br> *If adType is Dynamic Ads for Display, this field is required in ADD operation. </div>   # noqa: E501

        :param feed_id: The feed_id of this Campaign.  # noqa: E501
        :type: int
        """

        self._feed_id = feed_id

    @property
    def frequency_cap(self):
        """Gets the frequency_cap of this Campaign.  # noqa: E501


        :return: The frequency_cap of this Campaign.  # noqa: E501
        :rtype: CampaignServiceFrequencyCap
        """
        return self._frequency_cap

    @frequency_cap.setter
    def frequency_cap(self, frequency_cap):
        """Sets the frequency_cap of this Campaign.


        :param frequency_cap: The frequency_cap of this Campaign.  # noqa: E501
        :type: CampaignServiceFrequencyCap
        """

        self._frequency_cap = frequency_cap

    @property
    def labels(self):
        """Gets the labels of this Campaign.  # noqa: E501


        :return: The labels of this Campaign.  # noqa: E501
        :rtype: list[CampaignServiceLabel]
        """
        return self._labels

    @labels.setter
    def labels(self, labels):
        """Sets the labels of this Campaign.


        :param labels: The labels of this Campaign.  # noqa: E501
        :type: list[CampaignServiceLabel]
        """

        self._labels = labels

    @property
    def serving_status(self):
        """Gets the serving_status of this Campaign.  # noqa: E501


        :return: The serving_status of this Campaign.  # noqa: E501
        :rtype: CampaignServiceServingStatus
        """
        return self._serving_status

    @serving_status.setter
    def serving_status(self, serving_status):
        """Sets the serving_status of this Campaign.


        :param serving_status: The serving_status of this Campaign.  # noqa: E501
        :type: CampaignServiceServingStatus
        """

        self._serving_status = serving_status

    @property
    def start_date(self):
        """Gets the start_date of this Campaign.  # noqa: E501

        <div lang=\"ja\"> 開始日です。<br> このフィールドは、ADDおよびSET時に省略可能となり、REMOVE時に無視されます。 </div> <div lang=\"en\"> Start date.<br> This field is optional in ADD and SET operation, and will be ignored in REMOVE operation. </div>   # noqa: E501

        :return: The start_date of this Campaign.  # noqa: E501
        :rtype: str
        """
        return self._start_date

    @start_date.setter
    def start_date(self, start_date):
        """Sets the start_date of this Campaign.

        <div lang=\"ja\"> 開始日です。<br> このフィールドは、ADDおよびSET時に省略可能となり、REMOVE時に無視されます。 </div> <div lang=\"en\"> Start date.<br> This field is optional in ADD and SET operation, and will be ignored in REMOVE operation. </div>   # noqa: E501

        :param start_date: The start_date of this Campaign.  # noqa: E501
        :type: str
        """

        self._start_date = start_date

    @property
    def type(self):
        """Gets the type of this Campaign.  # noqa: E501


        :return: The type of this Campaign.  # noqa: E501
        :rtype: CampaignServiceType
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this Campaign.


        :param type: The type of this Campaign.  # noqa: E501
        :type: CampaignServiceType
        """

        self._type = type

    @property
    def user_status(self):
        """Gets the user_status of this Campaign.  # noqa: E501


        :return: The user_status of this Campaign.  # noqa: E501
        :rtype: CampaignServiceUserStatus
        """
        return self._user_status

    @user_status.setter
    def user_status(self, user_status):
        """Sets the user_status of this Campaign.


        :param user_status: The user_status of this Campaign.  # noqa: E501
        :type: CampaignServiceUserStatus
        """

        self._user_status = user_status

    @property
    def viewable_frequency_cap(self):
        """Gets the viewable_frequency_cap of this Campaign.  # noqa: E501


        :return: The viewable_frequency_cap of this Campaign.  # noqa: E501
        :rtype: CampaignServiceViewableFrequencyCap
        """
        return self._viewable_frequency_cap

    @viewable_frequency_cap.setter
    def viewable_frequency_cap(self, viewable_frequency_cap):
        """Sets the viewable_frequency_cap of this Campaign.


        :param viewable_frequency_cap: The viewable_frequency_cap of this Campaign.  # noqa: E501
        :type: CampaignServiceViewableFrequencyCap
        """

        self._viewable_frequency_cap = viewable_frequency_cap

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Campaign):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, Campaign):
            return True

        return self.to_dict() != other.to_dict()
