# coding: utf-8

"""
    Yahoo!広告 ディスプレイ広告 API リファレンス / Yahoo! Ads Display Ads API Reference

    <div lang=\"ja\">Yahoo!広告 ディスプレイ広告 APIのWebサービスについて説明します。<br> 「Try it out」のご利用には、事前にアプリケーションの登録が必要です。また、アプリケーションのリダイレクトURIの1つに<br> https://yahoojp-marketing.github.io/ads-display-api-documents/oauth2-redirect.htmlを登録してください。 </div> <div lang=\"en\">Display Ads API Web Services supported in Yahoo! Ads API.<br> When you use \"Try it out\", you need to register your application in advance.<br> As one of redirect URI for application, you need to set \"https://yahoojp-marketing.github.io/ads-display-api-documents/oauth2-redirect.html\". </div>   # noqa: E501

    The version of the OpenAPI document: v1
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from yahoo_ads_display.configuration import Configuration


class AdGroup(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'account_id': 'int',
        'ad_group_bidding_strategy': 'AdGroupServiceBiddingStrategy',
        'ad_group_id': 'int',
        'ad_group_name': 'str',
        'bid': 'AdGroupServiceBid',
        'campaign_id': 'int',
        'campaign_name': 'str',
        'conversion_optimizer': 'AdGroupServiceConversionOptimizer',
        'device': 'list[AdGroupServiceDeviceType]',
        'device_app': 'list[AdGroupServiceDeviceAppType]',
        'device_os': 'list[AdGroupServiceDeviceOsType]',
        'device_os_version': 'str',
        'dynamic_image_extensions': 'AdGroupServiceDynamicImageExtensions',
        'feed_set_id': 'int',
        'is_remove_feed_set_id': 'bool',
        'labels': 'list[AdGroupServiceLabel]',
        'smart_device_carriers': 'list[AdGroupServiceSmartDeviceCarrier]',
        'user_status': 'AdGroupServiceUserStatus'
    }

    attribute_map = {
        'account_id': 'accountId',
        'ad_group_bidding_strategy': 'adGroupBiddingStrategy',
        'ad_group_id': 'adGroupId',
        'ad_group_name': 'adGroupName',
        'bid': 'bid',
        'campaign_id': 'campaignId',
        'campaign_name': 'campaignName',
        'conversion_optimizer': 'conversionOptimizer',
        'device': 'device',
        'device_app': 'deviceApp',
        'device_os': 'deviceOs',
        'device_os_version': 'deviceOsVersion',
        'dynamic_image_extensions': 'dynamicImageExtensions',
        'feed_set_id': 'feedSetId',
        'is_remove_feed_set_id': 'isRemoveFeedSetId',
        'labels': 'labels',
        'smart_device_carriers': 'smartDeviceCarriers',
        'user_status': 'userStatus'
    }

    def __init__(self, account_id=None, ad_group_bidding_strategy=None, ad_group_id=None, ad_group_name=None, bid=None, campaign_id=None, campaign_name=None, conversion_optimizer=None, device=None, device_app=None, device_os=None, device_os_version=None, dynamic_image_extensions=None, feed_set_id=None, is_remove_feed_set_id=None, labels=None, smart_device_carriers=None, user_status=None, local_vars_configuration=None):  # noqa: E501
        """AdGroup - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._account_id = None
        self._ad_group_bidding_strategy = None
        self._ad_group_id = None
        self._ad_group_name = None
        self._bid = None
        self._campaign_id = None
        self._campaign_name = None
        self._conversion_optimizer = None
        self._device = None
        self._device_app = None
        self._device_os = None
        self._device_os_version = None
        self._dynamic_image_extensions = None
        self._feed_set_id = None
        self._is_remove_feed_set_id = None
        self._labels = None
        self._smart_device_carriers = None
        self._user_status = None
        self.discriminator = None

        self.account_id = account_id
        self.ad_group_bidding_strategy = ad_group_bidding_strategy
        self.ad_group_id = ad_group_id
        self.ad_group_name = ad_group_name
        self.bid = bid
        self.campaign_id = campaign_id
        self.campaign_name = campaign_name
        self.conversion_optimizer = conversion_optimizer
        self.device = device
        self.device_app = device_app
        self.device_os = device_os
        self.device_os_version = device_os_version
        self.dynamic_image_extensions = dynamic_image_extensions
        self.feed_set_id = feed_set_id
        self.is_remove_feed_set_id = is_remove_feed_set_id
        self.labels = labels
        self.smart_device_carriers = smart_device_carriers
        self.user_status = user_status

    @property
    def account_id(self):
        """Gets the account_id of this AdGroup.  # noqa: E501

        <div lang=\"ja\"> アカウントIDです。<br> このフィールドは、リクエストの場合は必須です。 </div> <div lang=\"en\"> Account ID.<br> This field is required in requests. </div>   # noqa: E501

        :return: The account_id of this AdGroup.  # noqa: E501
        :rtype: int
        """
        return self._account_id

    @account_id.setter
    def account_id(self, account_id):
        """Sets the account_id of this AdGroup.

        <div lang=\"ja\"> アカウントIDです。<br> このフィールドは、リクエストの場合は必須です。 </div> <div lang=\"en\"> Account ID.<br> This field is required in requests. </div>   # noqa: E501

        :param account_id: The account_id of this AdGroup.  # noqa: E501
        :type: int
        """

        self._account_id = account_id

    @property
    def ad_group_bidding_strategy(self):
        """Gets the ad_group_bidding_strategy of this AdGroup.  # noqa: E501


        :return: The ad_group_bidding_strategy of this AdGroup.  # noqa: E501
        :rtype: AdGroupServiceBiddingStrategy
        """
        return self._ad_group_bidding_strategy

    @ad_group_bidding_strategy.setter
    def ad_group_bidding_strategy(self, ad_group_bidding_strategy):
        """Sets the ad_group_bidding_strategy of this AdGroup.


        :param ad_group_bidding_strategy: The ad_group_bidding_strategy of this AdGroup.  # noqa: E501
        :type: AdGroupServiceBiddingStrategy
        """

        self._ad_group_bidding_strategy = ad_group_bidding_strategy

    @property
    def ad_group_id(self):
        """Gets the ad_group_id of this AdGroup.  # noqa: E501

        <div lang=\"ja\"> 広告グループIDです。<br> このフィールドは、ADD時は無視され、SETおよびREMOVE時は必須となります。 </div> <div lang=\"en\"> Ad group ID.<br> This field will be ignored in ADD operation, and will be required in SET and REMOVE operation. </div>   # noqa: E501

        :return: The ad_group_id of this AdGroup.  # noqa: E501
        :rtype: int
        """
        return self._ad_group_id

    @ad_group_id.setter
    def ad_group_id(self, ad_group_id):
        """Sets the ad_group_id of this AdGroup.

        <div lang=\"ja\"> 広告グループIDです。<br> このフィールドは、ADD時は無視され、SETおよびREMOVE時は必須となります。 </div> <div lang=\"en\"> Ad group ID.<br> This field will be ignored in ADD operation, and will be required in SET and REMOVE operation. </div>   # noqa: E501

        :param ad_group_id: The ad_group_id of this AdGroup.  # noqa: E501
        :type: int
        """

        self._ad_group_id = ad_group_id

    @property
    def ad_group_name(self):
        """Gets the ad_group_name of this AdGroup.  # noqa: E501

        <div lang=\"ja\"> 広告グループ名です。<br> このフィールドは、ADD時は必須となり、SET時は省略可能となります。 </div> <div lang=\"en\"> Ad group name.<br> This field is required in ADD operation, and will be optional in SET operation. </div>   # noqa: E501

        :return: The ad_group_name of this AdGroup.  # noqa: E501
        :rtype: str
        """
        return self._ad_group_name

    @ad_group_name.setter
    def ad_group_name(self, ad_group_name):
        """Sets the ad_group_name of this AdGroup.

        <div lang=\"ja\"> 広告グループ名です。<br> このフィールドは、ADD時は必須となり、SET時は省略可能となります。 </div> <div lang=\"en\"> Ad group name.<br> This field is required in ADD operation, and will be optional in SET operation. </div>   # noqa: E501

        :param ad_group_name: The ad_group_name of this AdGroup.  # noqa: E501
        :type: str
        """

        self._ad_group_name = ad_group_name

    @property
    def bid(self):
        """Gets the bid of this AdGroup.  # noqa: E501


        :return: The bid of this AdGroup.  # noqa: E501
        :rtype: AdGroupServiceBid
        """
        return self._bid

    @bid.setter
    def bid(self, bid):
        """Sets the bid of this AdGroup.


        :param bid: The bid of this AdGroup.  # noqa: E501
        :type: AdGroupServiceBid
        """

        self._bid = bid

    @property
    def campaign_id(self):
        """Gets the campaign_id of this AdGroup.  # noqa: E501

        <div lang=\"ja\"> キャンペーンIDです。<br> このフィールドは、リクエストの場合は必須です。 </div> <div lang=\"en\"> Campaign ID.<br> This field is required in requests. </div>   # noqa: E501

        :return: The campaign_id of this AdGroup.  # noqa: E501
        :rtype: int
        """
        return self._campaign_id

    @campaign_id.setter
    def campaign_id(self, campaign_id):
        """Sets the campaign_id of this AdGroup.

        <div lang=\"ja\"> キャンペーンIDです。<br> このフィールドは、リクエストの場合は必須です。 </div> <div lang=\"en\"> Campaign ID.<br> This field is required in requests. </div>   # noqa: E501

        :param campaign_id: The campaign_id of this AdGroup.  # noqa: E501
        :type: int
        """

        self._campaign_id = campaign_id

    @property
    def campaign_name(self):
        """Gets the campaign_name of this AdGroup.  # noqa: E501

        <div lang=\"ja\"> キャンペーン名です。<br> このフィールドは、レスポンスの際に返却されますが、リクエストの際には無視されます。 </div> <div lang=\"en\"> Campaign name.<br> Although this field will be returned in the response, it will be ignored on input. </div>   # noqa: E501

        :return: The campaign_name of this AdGroup.  # noqa: E501
        :rtype: str
        """
        return self._campaign_name

    @campaign_name.setter
    def campaign_name(self, campaign_name):
        """Sets the campaign_name of this AdGroup.

        <div lang=\"ja\"> キャンペーン名です。<br> このフィールドは、レスポンスの際に返却されますが、リクエストの際には無視されます。 </div> <div lang=\"en\"> Campaign name.<br> Although this field will be returned in the response, it will be ignored on input. </div>   # noqa: E501

        :param campaign_name: The campaign_name of this AdGroup.  # noqa: E501
        :type: str
        """

        self._campaign_name = campaign_name

    @property
    def conversion_optimizer(self):
        """Gets the conversion_optimizer of this AdGroup.  # noqa: E501


        :return: The conversion_optimizer of this AdGroup.  # noqa: E501
        :rtype: AdGroupServiceConversionOptimizer
        """
        return self._conversion_optimizer

    @conversion_optimizer.setter
    def conversion_optimizer(self, conversion_optimizer):
        """Sets the conversion_optimizer of this AdGroup.


        :param conversion_optimizer: The conversion_optimizer of this AdGroup.  # noqa: E501
        :type: AdGroupServiceConversionOptimizer
        """

        self._conversion_optimizer = conversion_optimizer

    @property
    def device(self):
        """Gets the device of this AdGroup.  # noqa: E501


        :return: The device of this AdGroup.  # noqa: E501
        :rtype: list[AdGroupServiceDeviceType]
        """
        return self._device

    @device.setter
    def device(self, device):
        """Sets the device of this AdGroup.


        :param device: The device of this AdGroup.  # noqa: E501
        :type: list[AdGroupServiceDeviceType]
        """

        self._device = device

    @property
    def device_app(self):
        """Gets the device_app of this AdGroup.  # noqa: E501


        :return: The device_app of this AdGroup.  # noqa: E501
        :rtype: list[AdGroupServiceDeviceAppType]
        """
        return self._device_app

    @device_app.setter
    def device_app(self, device_app):
        """Sets the device_app of this AdGroup.


        :param device_app: The device_app of this AdGroup.  # noqa: E501
        :type: list[AdGroupServiceDeviceAppType]
        """

        self._device_app = device_app

    @property
    def device_os(self):
        """Gets the device_os of this AdGroup.  # noqa: E501


        :return: The device_os of this AdGroup.  # noqa: E501
        :rtype: list[AdGroupServiceDeviceOsType]
        """
        return self._device_os

    @device_os.setter
    def device_os(self, device_os):
        """Sets the device_os of this AdGroup.


        :param device_os: The device_os of this AdGroup.  # noqa: E501
        :type: list[AdGroupServiceDeviceOsType]
        """

        self._device_os = device_os

    @property
    def device_os_version(self):
        """Gets the device_os_version of this AdGroup.  # noqa: E501

        <div lang=\"ja\"> OSバージョンです。<br> ADDおよびSET時、このフィールドは省略可能となります。<br> ※設定を解除する場合は、NONEを設定してください。 </div> <div lang=\"en\"> OS version.<br> ∗To cancel the setting, specify &#34;NONE&#34;.<br> This field is optional in ADD and SET operation. </div>   # noqa: E501

        :return: The device_os_version of this AdGroup.  # noqa: E501
        :rtype: str
        """
        return self._device_os_version

    @device_os_version.setter
    def device_os_version(self, device_os_version):
        """Sets the device_os_version of this AdGroup.

        <div lang=\"ja\"> OSバージョンです。<br> ADDおよびSET時、このフィールドは省略可能となります。<br> ※設定を解除する場合は、NONEを設定してください。 </div> <div lang=\"en\"> OS version.<br> ∗To cancel the setting, specify &#34;NONE&#34;.<br> This field is optional in ADD and SET operation. </div>   # noqa: E501

        :param device_os_version: The device_os_version of this AdGroup.  # noqa: E501
        :type: str
        """

        self._device_os_version = device_os_version

    @property
    def dynamic_image_extensions(self):
        """Gets the dynamic_image_extensions of this AdGroup.  # noqa: E501


        :return: The dynamic_image_extensions of this AdGroup.  # noqa: E501
        :rtype: AdGroupServiceDynamicImageExtensions
        """
        return self._dynamic_image_extensions

    @dynamic_image_extensions.setter
    def dynamic_image_extensions(self, dynamic_image_extensions):
        """Sets the dynamic_image_extensions of this AdGroup.


        :param dynamic_image_extensions: The dynamic_image_extensions of this AdGroup.  # noqa: E501
        :type: AdGroupServiceDynamicImageExtensions
        """

        self._dynamic_image_extensions = dynamic_image_extensions

    @property
    def feed_set_id(self):
        """Gets the feed_set_id of this AdGroup.  # noqa: E501

        <div lang=\"ja\"> 商品セットIDです。<br> ADDおよびSET時、このフィールドは省略可能となります。<br> *ADD時に未指定の場合、デフォルトセットを自動で関連付けます。 </div> <div lang=\"en\"> Feed set ID.<br> This field is optional in ADD and SET operation.<br> * If feedSetId is not specified in ADD operation, the default set is associated automatically. </div>   # noqa: E501

        :return: The feed_set_id of this AdGroup.  # noqa: E501
        :rtype: int
        """
        return self._feed_set_id

    @feed_set_id.setter
    def feed_set_id(self, feed_set_id):
        """Sets the feed_set_id of this AdGroup.

        <div lang=\"ja\"> 商品セットIDです。<br> ADDおよびSET時、このフィールドは省略可能となります。<br> *ADD時に未指定の場合、デフォルトセットを自動で関連付けます。 </div> <div lang=\"en\"> Feed set ID.<br> This field is optional in ADD and SET operation.<br> * If feedSetId is not specified in ADD operation, the default set is associated automatically. </div>   # noqa: E501

        :param feed_set_id: The feed_set_id of this AdGroup.  # noqa: E501
        :type: int
        """

        self._feed_set_id = feed_set_id

    @property
    def is_remove_feed_set_id(self):
        """Gets the is_remove_feed_set_id of this AdGroup.  # noqa: E501

        <div lang=\"ja\"> 商品セットとの関連付けを削除します。<br> このフィールドは、リクエストの際には無視されます。<br> *商品セットの関連付けが必須となったため、この機能は廃止しました。 </div> <div lang=\"en\"> Remove association with feed set. (Stop delivery)<br> This field will be ignored on input.<br> * Association with feed set changed to required, so this feature was abolished. </div>   # noqa: E501

        :return: The is_remove_feed_set_id of this AdGroup.  # noqa: E501
        :rtype: bool
        """
        return self._is_remove_feed_set_id

    @is_remove_feed_set_id.setter
    def is_remove_feed_set_id(self, is_remove_feed_set_id):
        """Sets the is_remove_feed_set_id of this AdGroup.

        <div lang=\"ja\"> 商品セットとの関連付けを削除します。<br> このフィールドは、リクエストの際には無視されます。<br> *商品セットの関連付けが必須となったため、この機能は廃止しました。 </div> <div lang=\"en\"> Remove association with feed set. (Stop delivery)<br> This field will be ignored on input.<br> * Association with feed set changed to required, so this feature was abolished. </div>   # noqa: E501

        :param is_remove_feed_set_id: The is_remove_feed_set_id of this AdGroup.  # noqa: E501
        :type: bool
        """

        self._is_remove_feed_set_id = is_remove_feed_set_id

    @property
    def labels(self):
        """Gets the labels of this AdGroup.  # noqa: E501


        :return: The labels of this AdGroup.  # noqa: E501
        :rtype: list[AdGroupServiceLabel]
        """
        return self._labels

    @labels.setter
    def labels(self, labels):
        """Sets the labels of this AdGroup.


        :param labels: The labels of this AdGroup.  # noqa: E501
        :type: list[AdGroupServiceLabel]
        """

        self._labels = labels

    @property
    def smart_device_carriers(self):
        """Gets the smart_device_carriers of this AdGroup.  # noqa: E501


        :return: The smart_device_carriers of this AdGroup.  # noqa: E501
        :rtype: list[AdGroupServiceSmartDeviceCarrier]
        """
        return self._smart_device_carriers

    @smart_device_carriers.setter
    def smart_device_carriers(self, smart_device_carriers):
        """Sets the smart_device_carriers of this AdGroup.


        :param smart_device_carriers: The smart_device_carriers of this AdGroup.  # noqa: E501
        :type: list[AdGroupServiceSmartDeviceCarrier]
        """

        self._smart_device_carriers = smart_device_carriers

    @property
    def user_status(self):
        """Gets the user_status of this AdGroup.  # noqa: E501


        :return: The user_status of this AdGroup.  # noqa: E501
        :rtype: AdGroupServiceUserStatus
        """
        return self._user_status

    @user_status.setter
    def user_status(self, user_status):
        """Sets the user_status of this AdGroup.


        :param user_status: The user_status of this AdGroup.  # noqa: E501
        :type: AdGroupServiceUserStatus
        """

        self._user_status = user_status

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, AdGroup):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, AdGroup):
            return True

        return self.to_dict() != other.to_dict()
