# coding: utf-8

"""
    Yahoo!広告 ディスプレイ広告 API リファレンス / Yahoo! Ads Display Ads API Reference

    <div lang=\"ja\">Yahoo!広告 ディスプレイ広告 APIのWebサービスについて説明します。<br> 「Try it out」のご利用には、事前にアプリケーションの登録が必要です。また、アプリケーションのリダイレクトURIの1つに<br> https://yahoojp-marketing.github.io/ads-display-api-documents/oauth2-redirect.htmlを登録してください。 </div> <div lang=\"en\">Display Ads API Web Services supported in Yahoo! Ads API.<br> When you use \"Try it out\", you need to register your application in advance.<br> As one of redirect URI for application, you need to set \"https://yahoojp-marketing.github.io/ads-display-api-documents/oauth2-redirect.html\". </div>   # noqa: E501

    The version of the OpenAPI document: v1
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from yahoo_ads_display.configuration import Configuration


class Account(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'account_authorities': 'list[str]',
        'account_id': 'int',
        'account_name': 'str',
        'account_status': 'AccountServiceStatus',
        'account_type': 'AccountServiceType',
        'auth_type': 'AccountServiceAuthType',
        'auto_tagging_enabled': 'AccountServiceAutoTaggingEnabled',
        'budget': 'AccountServiceBudget',
        'delivery_status': 'AccountServiceDeliveryStatus',
        'is_test_account': 'AccountServiceIsTestAccount'
    }

    attribute_map = {
        'account_authorities': 'accountAuthorities',
        'account_id': 'accountId',
        'account_name': 'accountName',
        'account_status': 'accountStatus',
        'account_type': 'accountType',
        'auth_type': 'authType',
        'auto_tagging_enabled': 'autoTaggingEnabled',
        'budget': 'budget',
        'delivery_status': 'deliveryStatus',
        'is_test_account': 'isTestAccount'
    }

    def __init__(self, account_authorities=None, account_id=None, account_name=None, account_status=None, account_type=None, auth_type=None, auto_tagging_enabled=None, budget=None, delivery_status=None, is_test_account=None, local_vars_configuration=None):  # noqa: E501
        """Account - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._account_authorities = None
        self._account_id = None
        self._account_name = None
        self._account_status = None
        self._account_type = None
        self._auth_type = None
        self._auto_tagging_enabled = None
        self._budget = None
        self._delivery_status = None
        self._is_test_account = None
        self.discriminator = None

        self.account_authorities = account_authorities
        self.account_id = account_id
        self.account_name = account_name
        self.account_status = account_status
        self.account_type = account_type
        self.auth_type = auth_type
        self.auto_tagging_enabled = auto_tagging_enabled
        self.budget = budget
        self.delivery_status = delivery_status
        self.is_test_account = is_test_account

    @property
    def account_authorities(self):
        """Gets the account_authorities of this Account.  # noqa: E501

        <div lang=\"ja\">アカウント権限です。</div> <div lang=\"en\">Account authority.</div>   # noqa: E501

        :return: The account_authorities of this Account.  # noqa: E501
        :rtype: list[str]
        """
        return self._account_authorities

    @account_authorities.setter
    def account_authorities(self, account_authorities):
        """Sets the account_authorities of this Account.

        <div lang=\"ja\">アカウント権限です。</div> <div lang=\"en\">Account authority.</div>   # noqa: E501

        :param account_authorities: The account_authorities of this Account.  # noqa: E501
        :type: list[str]
        """

        self._account_authorities = account_authorities

    @property
    def account_id(self):
        """Gets the account_id of this Account.  # noqa: E501

        <div lang=\"ja\"> アカウントIDです。<br> SET時、このフィールドは必須となります。 </div> <div lang=\"en\"> Account ID.<br> This field is required in SET operation. </div>   # noqa: E501

        :return: The account_id of this Account.  # noqa: E501
        :rtype: int
        """
        return self._account_id

    @account_id.setter
    def account_id(self, account_id):
        """Sets the account_id of this Account.

        <div lang=\"ja\"> アカウントIDです。<br> SET時、このフィールドは必須となります。 </div> <div lang=\"en\"> Account ID.<br> This field is required in SET operation. </div>   # noqa: E501

        :param account_id: The account_id of this Account.  # noqa: E501
        :type: int
        """

        self._account_id = account_id

    @property
    def account_name(self):
        """Gets the account_name of this Account.  # noqa: E501

        <div lang=\"ja\"> アカウント名です。<br> SET時、このフィールドは省略可能となります。 </div> <div lang=\"en\"> Account name.<br> This field is optional in SET operation. </div>   # noqa: E501

        :return: The account_name of this Account.  # noqa: E501
        :rtype: str
        """
        return self._account_name

    @account_name.setter
    def account_name(self, account_name):
        """Sets the account_name of this Account.

        <div lang=\"ja\"> アカウント名です。<br> SET時、このフィールドは省略可能となります。 </div> <div lang=\"en\"> Account name.<br> This field is optional in SET operation. </div>   # noqa: E501

        :param account_name: The account_name of this Account.  # noqa: E501
        :type: str
        """

        self._account_name = account_name

    @property
    def account_status(self):
        """Gets the account_status of this Account.  # noqa: E501


        :return: The account_status of this Account.  # noqa: E501
        :rtype: AccountServiceStatus
        """
        return self._account_status

    @account_status.setter
    def account_status(self, account_status):
        """Sets the account_status of this Account.


        :param account_status: The account_status of this Account.  # noqa: E501
        :type: AccountServiceStatus
        """

        self._account_status = account_status

    @property
    def account_type(self):
        """Gets the account_type of this Account.  # noqa: E501


        :return: The account_type of this Account.  # noqa: E501
        :rtype: AccountServiceType
        """
        return self._account_type

    @account_type.setter
    def account_type(self, account_type):
        """Sets the account_type of this Account.


        :param account_type: The account_type of this Account.  # noqa: E501
        :type: AccountServiceType
        """

        self._account_type = account_type

    @property
    def auth_type(self):
        """Gets the auth_type of this Account.  # noqa: E501


        :return: The auth_type of this Account.  # noqa: E501
        :rtype: AccountServiceAuthType
        """
        return self._auth_type

    @auth_type.setter
    def auth_type(self, auth_type):
        """Sets the auth_type of this Account.


        :param auth_type: The auth_type of this Account.  # noqa: E501
        :type: AccountServiceAuthType
        """

        self._auth_type = auth_type

    @property
    def auto_tagging_enabled(self):
        """Gets the auto_tagging_enabled of this Account.  # noqa: E501


        :return: The auto_tagging_enabled of this Account.  # noqa: E501
        :rtype: AccountServiceAutoTaggingEnabled
        """
        return self._auto_tagging_enabled

    @auto_tagging_enabled.setter
    def auto_tagging_enabled(self, auto_tagging_enabled):
        """Sets the auto_tagging_enabled of this Account.


        :param auto_tagging_enabled: The auto_tagging_enabled of this Account.  # noqa: E501
        :type: AccountServiceAutoTaggingEnabled
        """

        self._auto_tagging_enabled = auto_tagging_enabled

    @property
    def budget(self):
        """Gets the budget of this Account.  # noqa: E501


        :return: The budget of this Account.  # noqa: E501
        :rtype: AccountServiceBudget
        """
        return self._budget

    @budget.setter
    def budget(self, budget):
        """Sets the budget of this Account.


        :param budget: The budget of this Account.  # noqa: E501
        :type: AccountServiceBudget
        """

        self._budget = budget

    @property
    def delivery_status(self):
        """Gets the delivery_status of this Account.  # noqa: E501


        :return: The delivery_status of this Account.  # noqa: E501
        :rtype: AccountServiceDeliveryStatus
        """
        return self._delivery_status

    @delivery_status.setter
    def delivery_status(self, delivery_status):
        """Sets the delivery_status of this Account.


        :param delivery_status: The delivery_status of this Account.  # noqa: E501
        :type: AccountServiceDeliveryStatus
        """

        self._delivery_status = delivery_status

    @property
    def is_test_account(self):
        """Gets the is_test_account of this Account.  # noqa: E501


        :return: The is_test_account of this Account.  # noqa: E501
        :rtype: AccountServiceIsTestAccount
        """
        return self._is_test_account

    @is_test_account.setter
    def is_test_account(self, is_test_account):
        """Sets the is_test_account of this Account.


        :param is_test_account: The is_test_account of this Account.  # noqa: E501
        :type: AccountServiceIsTestAccount
        """

        self._is_test_account = is_test_account

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Account):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, Account):
            return True

        return self.to_dict() != other.to_dict()
