# coding: utf-8

"""
    Yahoo!広告 ディスプレイ広告 API リファレンス / Yahoo! Ads Display Ads API Reference

    <div lang=\"ja\">Yahoo!広告 ディスプレイ広告 APIのWebサービスについて説明します。<br> 「Try it out」のご利用には、事前にアプリケーションの登録が必要です。また、アプリケーションのリダイレクトURIの1つに<br> https://yahoojp-marketing.github.io/ads-display-api-documents/oauth2-redirect.htmlを登録してください。 </div> <div lang=\"en\">Display Ads API Web Services supported in Yahoo! Ads API.<br> When you use \"Try it out\", you need to register your application in advance.<br> As one of redirect URI for application, you need to set \"https://yahoojp-marketing.github.io/ads-display-api-documents/oauth2-redirect.html\". </div>   # noqa: E501

    The version of the OpenAPI document: v1
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from yahoo_ads_display.api_client import ApiClient
from yahoo_ads_display.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class VideoServiceApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def video_service_download_post(self, **kwargs):  # noqa: E501
        """video_service_download_post  # noqa: E501

        <div lang=\"ja\">入稿済の動画をダウンロードします。</div> <div lang=\"en\">Downloads the added video.</div>   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.video_service_download_post(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param VideoServiceDownloadSelector video_service_download_selector:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.video_service_download_post_with_http_info(**kwargs)  # noqa: E501

    def video_service_download_post_with_http_info(self, **kwargs):  # noqa: E501
        """video_service_download_post  # noqa: E501

        <div lang=\"ja\">入稿済の動画をダウンロードします。</div> <div lang=\"en\">Downloads the added video.</div>   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.video_service_download_post_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param VideoServiceDownloadSelector video_service_download_selector:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(file, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'video_service_download_selector'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method video_service_download_post" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'video_service_download_selector' in local_var_params:
            body_params = local_var_params['video_service_download_selector']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/octet-stream'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oAuth']  # noqa: E501

        return self.api_client.call_api(
            '/VideoService/download', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='file',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def video_service_get_post(self, **kwargs):  # noqa: E501
        """video_service_get_post  # noqa: E501

        <div lang=\"ja\">入稿済の動画の情報を取得します。</div> <div lang=\"en\">Retrieves the added video information.</div>   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.video_service_get_post(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param VideoServiceSelector video_service_selector:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: VideoServiceGetResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.video_service_get_post_with_http_info(**kwargs)  # noqa: E501

    def video_service_get_post_with_http_info(self, **kwargs):  # noqa: E501
        """video_service_get_post  # noqa: E501

        <div lang=\"ja\">入稿済の動画の情報を取得します。</div> <div lang=\"en\">Retrieves the added video information.</div>   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.video_service_get_post_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param VideoServiceSelector video_service_selector:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(VideoServiceGetResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'video_service_selector'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method video_service_get_post" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'video_service_selector' in local_var_params:
            body_params = local_var_params['video_service_selector']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oAuth']  # noqa: E501

        return self.api_client.call_api(
            '/VideoService/get', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='VideoServiceGetResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def video_service_remove_post(self, **kwargs):  # noqa: E501
        """video_service_remove_post  # noqa: E501

        <div lang=\"ja\">入稿済みの動画を削除します。</div> <div lang=\"en\">Removes the added videos.</div>   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.video_service_remove_post(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param VideoServiceOperation video_service_operation:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: VideoServiceMutateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.video_service_remove_post_with_http_info(**kwargs)  # noqa: E501

    def video_service_remove_post_with_http_info(self, **kwargs):  # noqa: E501
        """video_service_remove_post  # noqa: E501

        <div lang=\"ja\">入稿済みの動画を削除します。</div> <div lang=\"en\">Removes the added videos.</div>   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.video_service_remove_post_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param VideoServiceOperation video_service_operation:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(VideoServiceMutateResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'video_service_operation'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method video_service_remove_post" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'video_service_operation' in local_var_params:
            body_params = local_var_params['video_service_operation']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oAuth']  # noqa: E501

        return self.api_client.call_api(
            '/VideoService/remove', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='VideoServiceMutateResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def video_service_set_post(self, **kwargs):  # noqa: E501
        """video_service_set_post  # noqa: E501

        <div lang=\"ja\">入稿済の動画の情報（動画名、配信状況）を変更します。</div> <div lang=\"en\">Updates information (Video Name and Display Status) of added videos.</div>   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.video_service_set_post(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param VideoServiceOperation video_service_operation:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: VideoServiceMutateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.video_service_set_post_with_http_info(**kwargs)  # noqa: E501

    def video_service_set_post_with_http_info(self, **kwargs):  # noqa: E501
        """video_service_set_post  # noqa: E501

        <div lang=\"ja\">入稿済の動画の情報（動画名、配信状況）を変更します。</div> <div lang=\"en\">Updates information (Video Name and Display Status) of added videos.</div>   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.video_service_set_post_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param VideoServiceOperation video_service_operation:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(VideoServiceMutateResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'video_service_operation'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method video_service_set_post" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'video_service_operation' in local_var_params:
            body_params = local_var_params['video_service_operation']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oAuth']  # noqa: E501

        return self.api_client.call_api(
            '/VideoService/set', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='VideoServiceMutateResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def video_service_upload_post(self, account_id, video_name, video_title, user_status, **kwargs):  # noqa: E501
        """video_service_upload_post  # noqa: E501

        <div lang=\"ja\">動画ファイルのアップロード処理を実施します。</div> <div lang=\"en\">Upload process of video files can be operated.</div>   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.video_service_upload_post(account_id, video_name, video_title, user_status, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int account_id: <div lang=\"ja\">アカウントIDです。</div> <div lang=\"en\">Account ID.</div>  (required)
        :param str video_name: <div lang=\"ja\">動画のファイル名です。</div> <div lang=\"en\">Video file name.</div>  (required)
        :param str video_title: <div lang=\"ja\">動画名です。</div> <div lang=\"en\">Video name.</div>  (required)
        :param VideoServiceUserStatus user_status: <div lang=\"ja\">ユーザーにより広告配信の有無を調整できる設定です。</div> <div lang=\"en\">Ad delivery status that can be set by an user is served.</div>  (required)
        :param file file:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: VideoServiceUploadResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.video_service_upload_post_with_http_info(account_id, video_name, video_title, user_status, **kwargs)  # noqa: E501

    def video_service_upload_post_with_http_info(self, account_id, video_name, video_title, user_status, **kwargs):  # noqa: E501
        """video_service_upload_post  # noqa: E501

        <div lang=\"ja\">動画ファイルのアップロード処理を実施します。</div> <div lang=\"en\">Upload process of video files can be operated.</div>   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.video_service_upload_post_with_http_info(account_id, video_name, video_title, user_status, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int account_id: <div lang=\"ja\">アカウントIDです。</div> <div lang=\"en\">Account ID.</div>  (required)
        :param str video_name: <div lang=\"ja\">動画のファイル名です。</div> <div lang=\"en\">Video file name.</div>  (required)
        :param str video_title: <div lang=\"ja\">動画名です。</div> <div lang=\"en\">Video name.</div>  (required)
        :param VideoServiceUserStatus user_status: <div lang=\"ja\">ユーザーにより広告配信の有無を調整できる設定です。</div> <div lang=\"en\">Ad delivery status that can be set by an user is served.</div>  (required)
        :param file file:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(VideoServiceUploadResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'account_id',
            'video_name',
            'video_title',
            'user_status',
            'file'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method video_service_upload_post" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'account_id' is set
        if self.api_client.client_side_validation and ('account_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['account_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `account_id` when calling `video_service_upload_post`")  # noqa: E501
        # verify the required parameter 'video_name' is set
        if self.api_client.client_side_validation and ('video_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['video_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `video_name` when calling `video_service_upload_post`")  # noqa: E501
        # verify the required parameter 'video_title' is set
        if self.api_client.client_side_validation and ('video_title' not in local_var_params or  # noqa: E501
                                                        local_var_params['video_title'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `video_title` when calling `video_service_upload_post`")  # noqa: E501
        # verify the required parameter 'user_status' is set
        if self.api_client.client_side_validation and ('user_status' not in local_var_params or  # noqa: E501
                                                        local_var_params['user_status'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `user_status` when calling `video_service_upload_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'account_id' in local_var_params and local_var_params['account_id'] is not None:  # noqa: E501
            query_params.append(('accountId', local_var_params['account_id']))  # noqa: E501
        if 'video_name' in local_var_params and local_var_params['video_name'] is not None:  # noqa: E501
            query_params.append(('videoName', local_var_params['video_name']))  # noqa: E501
        if 'video_title' in local_var_params and local_var_params['video_title'] is not None:  # noqa: E501
            query_params.append(('videoTitle', local_var_params['video_title']))  # noqa: E501
        if 'user_status' in local_var_params and local_var_params['user_status'] is not None:  # noqa: E501
            query_params.append(('userStatus', local_var_params['user_status']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'file' in local_var_params:
            local_var_files['file'] = local_var_params['file']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oAuth']  # noqa: E501

        return self.api_client.call_api(
            '/VideoService/upload', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='VideoServiceUploadResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
