# coding: utf-8

"""
    Yahoo!広告 ディスプレイ広告 API リファレンス / Yahoo! Ads Display Ads API Reference

    <div lang=\"ja\">Yahoo!広告 ディスプレイ広告 APIのWebサービスについて説明します。<br> 「Try it out」のご利用には、事前にアプリケーションの登録が必要です。また、アプリケーションのリダイレクトURIの1つに<br> https://yahoojp-marketing.github.io/ads-display-api-documents/oauth2-redirect.htmlを登録してください。 </div> <div lang=\"en\">Display Ads API Web Services supported in Yahoo! Ads API.<br> When you use \"Try it out\", you need to register your application in advance.<br> As one of redirect URI for application, you need to set \"https://yahoojp-marketing.github.io/ads-display-api-documents/oauth2-redirect.html\". </div>   # noqa: E501

    The version of the OpenAPI document: v1
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from yahoo_ads_display.api_client import ApiClient
from yahoo_ads_display.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class FeedDataServiceApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def feed_data_service_download_error_file_post(self, **kwargs):  # noqa: E501
        """feed_data_service_download_error_file_post  # noqa: E501

        <div lang=\"ja\">商品情報のエラーファイルダウンロード処理を実施します。</div> <div lang=\"en\">Downloads error file.</div>   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.feed_data_service_download_error_file_post(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param FeedDataServiceDownloadErrorFileSelector feed_data_service_download_error_file_selector:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.feed_data_service_download_error_file_post_with_http_info(**kwargs)  # noqa: E501

    def feed_data_service_download_error_file_post_with_http_info(self, **kwargs):  # noqa: E501
        """feed_data_service_download_error_file_post  # noqa: E501

        <div lang=\"ja\">商品情報のエラーファイルダウンロード処理を実施します。</div> <div lang=\"en\">Downloads error file.</div>   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.feed_data_service_download_error_file_post_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param FeedDataServiceDownloadErrorFileSelector feed_data_service_download_error_file_selector:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(file, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'feed_data_service_download_error_file_selector'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method feed_data_service_download_error_file_post" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'feed_data_service_download_error_file_selector' in local_var_params:
            body_params = local_var_params['feed_data_service_download_error_file_selector']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/octet-stream'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oAuth']  # noqa: E501

        return self.api_client.call_api(
            '/FeedDataService/downloadErrorFile', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='file',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def feed_data_service_get_post(self, **kwargs):  # noqa: E501
        """feed_data_service_get_post  # noqa: E501

        <div lang=\"ja\">アップロードした商品情報の処理状況を照会します。</div> <div lang=\"en\">Returns status of uploaded item list.</div>   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.feed_data_service_get_post(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param FeedDataServiceSelector feed_data_service_selector:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: FeedDataServiceGetResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.feed_data_service_get_post_with_http_info(**kwargs)  # noqa: E501

    def feed_data_service_get_post_with_http_info(self, **kwargs):  # noqa: E501
        """feed_data_service_get_post  # noqa: E501

        <div lang=\"ja\">アップロードした商品情報の処理状況を照会します。</div> <div lang=\"en\">Returns status of uploaded item list.</div>   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.feed_data_service_get_post_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param FeedDataServiceSelector feed_data_service_selector:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(FeedDataServiceGetResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'feed_data_service_selector'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method feed_data_service_get_post" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'feed_data_service_selector' in local_var_params:
            body_params = local_var_params['feed_data_service_selector']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oAuth']  # noqa: E501

        return self.api_client.call_api(
            '/FeedDataService/get', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='FeedDataServiceGetResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def feed_data_service_upload_post(self, account_id, feed_id, upload_type, is_debug, **kwargs):  # noqa: E501
        """feed_data_service_upload_post  # noqa: E501

        <div lang=\"ja\">商品情報のアップロード処理を実施します。</div> <div lang=\"en\">Executes upload item list.</div>   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.feed_data_service_upload_post(account_id, feed_id, upload_type, is_debug, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int account_id: <div lang=\"ja\">アカウントIDです。</div> <div lang=\"en\">Account ID.</div>  (required)
        :param int feed_id: <div lang=\"ja\">フィードIDです。</div> <div lang=\"en\">Feed ID.</div>  (required)
        :param FeedDataServiceItemListUploadType upload_type: <div lang=\"ja\">商品リストファイルアップロード時の取り込み種別です。</div> <div lang=\"en\">FeedDataServiceItemListUploadType object displays upload type of item list.</div>  (required)
        :param bool is_debug: <div lang=\"ja\">trueはデバッグモードでの実行を意味します。</div> <div lang=\"en\">true means to run in debug mode.</div>  (required)
        :param file file:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: FeedDataServiceUploadResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.feed_data_service_upload_post_with_http_info(account_id, feed_id, upload_type, is_debug, **kwargs)  # noqa: E501

    def feed_data_service_upload_post_with_http_info(self, account_id, feed_id, upload_type, is_debug, **kwargs):  # noqa: E501
        """feed_data_service_upload_post  # noqa: E501

        <div lang=\"ja\">商品情報のアップロード処理を実施します。</div> <div lang=\"en\">Executes upload item list.</div>   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.feed_data_service_upload_post_with_http_info(account_id, feed_id, upload_type, is_debug, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int account_id: <div lang=\"ja\">アカウントIDです。</div> <div lang=\"en\">Account ID.</div>  (required)
        :param int feed_id: <div lang=\"ja\">フィードIDです。</div> <div lang=\"en\">Feed ID.</div>  (required)
        :param FeedDataServiceItemListUploadType upload_type: <div lang=\"ja\">商品リストファイルアップロード時の取り込み種別です。</div> <div lang=\"en\">FeedDataServiceItemListUploadType object displays upload type of item list.</div>  (required)
        :param bool is_debug: <div lang=\"ja\">trueはデバッグモードでの実行を意味します。</div> <div lang=\"en\">true means to run in debug mode.</div>  (required)
        :param file file:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(FeedDataServiceUploadResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'account_id',
            'feed_id',
            'upload_type',
            'is_debug',
            'file'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method feed_data_service_upload_post" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'account_id' is set
        if self.api_client.client_side_validation and ('account_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['account_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `account_id` when calling `feed_data_service_upload_post`")  # noqa: E501
        # verify the required parameter 'feed_id' is set
        if self.api_client.client_side_validation and ('feed_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['feed_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `feed_id` when calling `feed_data_service_upload_post`")  # noqa: E501
        # verify the required parameter 'upload_type' is set
        if self.api_client.client_side_validation and ('upload_type' not in local_var_params or  # noqa: E501
                                                        local_var_params['upload_type'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `upload_type` when calling `feed_data_service_upload_post`")  # noqa: E501
        # verify the required parameter 'is_debug' is set
        if self.api_client.client_side_validation and ('is_debug' not in local_var_params or  # noqa: E501
                                                        local_var_params['is_debug'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `is_debug` when calling `feed_data_service_upload_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'account_id' in local_var_params and local_var_params['account_id'] is not None:  # noqa: E501
            query_params.append(('accountId', local_var_params['account_id']))  # noqa: E501
        if 'feed_id' in local_var_params and local_var_params['feed_id'] is not None:  # noqa: E501
            query_params.append(('feedId', local_var_params['feed_id']))  # noqa: E501
        if 'upload_type' in local_var_params and local_var_params['upload_type'] is not None:  # noqa: E501
            query_params.append(('uploadType', local_var_params['upload_type']))  # noqa: E501
        if 'is_debug' in local_var_params and local_var_params['is_debug'] is not None:  # noqa: E501
            query_params.append(('isDebug', local_var_params['is_debug']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'file' in local_var_params:
            local_var_files['file'] = local_var_params['file']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oAuth']  # noqa: E501

        return self.api_client.call_api(
            '/FeedDataService/upload', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='FeedDataServiceUploadResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
