# yahoo-ads-display
<div lang=\"ja\">Yahoo!広告 ディスプレイ広告 APIのWebサービスについて説明します。<br>
「Try it out」のご利用には、事前にアプリケーションの登録が必要です。また、アプリケーションのリダイレクトURIの1つに<br>
https://yahoojp-marketing.github.io/ads-display-api-documents/oauth2-redirect.htmlを登録してください。
</div>
<div lang=\"en\">Display Ads API Web Services supported in Yahoo! Ads API.<br>
When you use \"Try it out\", you need to register your application in advance.<br>
As one of redirect URI for application, you need to set \"https://yahoojp-marketing.github.io/ads-display-api-documents/oauth2-redirect.html\".
</div>


This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: v1
- Package version: 1.0.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import yahoo_ads_display
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import yahoo_ads_display
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function

import time
import yahoo_ads_display
from yahoo_ads_display.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://ads-display.yahooapis.jp/api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = yahoo_ads_display.Configuration(
    host = "https://ads-display.yahooapis.jp/api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure OAuth2 access token for authorization: oAuth
configuration = yahoo_ads_display.Configuration(
    host = "https://ads-display.yahooapis.jp/api/v1"
)
configuration.access_token = 'YOUR_ACCESS_TOKEN'


# Enter a context with an instance of the API client
with yahoo_ads_display.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = yahoo_ads_display.AccountAdProductServiceApi(api_client)
    account_ad_product_service_selector = yahoo_ads_display.AccountAdProductServiceSelector() # AccountAdProductServiceSelector |  (optional)

    try:
        api_response = api_instance.account_ad_product_service_get_post(account_ad_product_service_selector=account_ad_product_service_selector)
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling AccountAdProductServiceApi->account_ad_product_service_get_post: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *https://ads-display.yahooapis.jp/api/v1*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AccountAdProductServiceApi* | [**account_ad_product_service_get_post**](docs/AccountAdProductServiceApi.md#account_ad_product_service_get_post) | **POST** /AccountAdProductService/get |
*AccountServiceApi* | [**account_service_get_post**](docs/AccountServiceApi.md#account_service_get_post) | **POST** /AccountService/get |
*AccountServiceApi* | [**account_service_set_post**](docs/AccountServiceApi.md#account_service_set_post) | **POST** /AccountService/set |
*AdGroupAdLabelServiceApi* | [**ad_group_ad_label_service_add_post**](docs/AdGroupAdLabelServiceApi.md#ad_group_ad_label_service_add_post) | **POST** /AdGroupAdLabelService/add |
*AdGroupAdLabelServiceApi* | [**ad_group_ad_label_service_remove_post**](docs/AdGroupAdLabelServiceApi.md#ad_group_ad_label_service_remove_post) | **POST** /AdGroupAdLabelService/remove |
*AdGroupAdServiceApi* | [**ad_group_ad_service_add_post**](docs/AdGroupAdServiceApi.md#ad_group_ad_service_add_post) | **POST** /AdGroupAdService/add |
*AdGroupAdServiceApi* | [**ad_group_ad_service_get_post**](docs/AdGroupAdServiceApi.md#ad_group_ad_service_get_post) | **POST** /AdGroupAdService/get |
*AdGroupAdServiceApi* | [**ad_group_ad_service_remove_post**](docs/AdGroupAdServiceApi.md#ad_group_ad_service_remove_post) | **POST** /AdGroupAdService/remove |
*AdGroupAdServiceApi* | [**ad_group_ad_service_set_post**](docs/AdGroupAdServiceApi.md#ad_group_ad_service_set_post) | **POST** /AdGroupAdService/set |
*AdGroupLabelServiceApi* | [**ad_group_label_service_add_post**](docs/AdGroupLabelServiceApi.md#ad_group_label_service_add_post) | **POST** /AdGroupLabelService/add |
*AdGroupLabelServiceApi* | [**ad_group_label_service_remove_post**](docs/AdGroupLabelServiceApi.md#ad_group_label_service_remove_post) | **POST** /AdGroupLabelService/remove |
*AdGroupServiceApi* | [**ad_group_service_add_post**](docs/AdGroupServiceApi.md#ad_group_service_add_post) | **POST** /AdGroupService/add |
*AdGroupServiceApi* | [**ad_group_service_get_post**](docs/AdGroupServiceApi.md#ad_group_service_get_post) | **POST** /AdGroupService/get |
*AdGroupServiceApi* | [**ad_group_service_remove_post**](docs/AdGroupServiceApi.md#ad_group_service_remove_post) | **POST** /AdGroupService/remove |
*AdGroupServiceApi* | [**ad_group_service_set_post**](docs/AdGroupServiceApi.md#ad_group_service_set_post) | **POST** /AdGroupService/set |
*AdGroupTargetServiceApi* | [**ad_group_target_service_add_post**](docs/AdGroupTargetServiceApi.md#ad_group_target_service_add_post) | **POST** /AdGroupTargetService/add |
*AdGroupTargetServiceApi* | [**ad_group_target_service_get_post**](docs/AdGroupTargetServiceApi.md#ad_group_target_service_get_post) | **POST** /AdGroupTargetService/get |
*AdGroupTargetServiceApi* | [**ad_group_target_service_remove_post**](docs/AdGroupTargetServiceApi.md#ad_group_target_service_remove_post) | **POST** /AdGroupTargetService/remove |
*AdGroupTargetServiceApi* | [**ad_group_target_service_replace_post**](docs/AdGroupTargetServiceApi.md#ad_group_target_service_replace_post) | **POST** /AdGroupTargetService/replace |
*AdGroupTargetServiceApi* | [**ad_group_target_service_set_post**](docs/AdGroupTargetServiceApi.md#ad_group_target_service_set_post) | **POST** /AdGroupTargetService/set |
*AuditLogServiceApi* | [**audit_log_service_add_post**](docs/AuditLogServiceApi.md#audit_log_service_add_post) | **POST** /AuditLogService/add |
*AuditLogServiceApi* | [**audit_log_service_download_post**](docs/AuditLogServiceApi.md#audit_log_service_download_post) | **POST** /AuditLogService/download |
*AuditLogServiceApi* | [**audit_log_service_get_post**](docs/AuditLogServiceApi.md#audit_log_service_get_post) | **POST** /AuditLogService/get |
*BalanceServiceApi* | [**balance_service_get_post**](docs/BalanceServiceApi.md#balance_service_get_post) | **POST** /BalanceService/get |
*CampaignLabelServiceApi* | [**campaign_label_service_add_post**](docs/CampaignLabelServiceApi.md#campaign_label_service_add_post) | **POST** /CampaignLabelService/add |
*CampaignLabelServiceApi* | [**campaign_label_service_remove_post**](docs/CampaignLabelServiceApi.md#campaign_label_service_remove_post) | **POST** /CampaignLabelService/remove |
*CampaignMigrationServiceApi* | [**campaign_migration_service_download_error_file_post**](docs/CampaignMigrationServiceApi.md#campaign_migration_service_download_error_file_post) | **POST** /CampaignMigrationService/downloadErrorFile |
*CampaignMigrationServiceApi* | [**campaign_migration_service_download_original_file_post**](docs/CampaignMigrationServiceApi.md#campaign_migration_service_download_original_file_post) | **POST** /CampaignMigrationService/downloadOriginalFile |
*CampaignMigrationServiceApi* | [**campaign_migration_service_download_post**](docs/CampaignMigrationServiceApi.md#campaign_migration_service_download_post) | **POST** /CampaignMigrationService/download |
*CampaignMigrationServiceApi* | [**campaign_migration_service_get_post**](docs/CampaignMigrationServiceApi.md#campaign_migration_service_get_post) | **POST** /CampaignMigrationService/get |
*CampaignMigrationServiceApi* | [**campaign_migration_service_upload_post**](docs/CampaignMigrationServiceApi.md#campaign_migration_service_upload_post) | **POST** /CampaignMigrationService/upload |
*CampaignServiceApi* | [**campaign_service_add_post**](docs/CampaignServiceApi.md#campaign_service_add_post) | **POST** /CampaignService/add |
*CampaignServiceApi* | [**campaign_service_get_post**](docs/CampaignServiceApi.md#campaign_service_get_post) | **POST** /CampaignService/get |
*CampaignServiceApi* | [**campaign_service_remove_post**](docs/CampaignServiceApi.md#campaign_service_remove_post) | **POST** /CampaignService/remove |
*CampaignServiceApi* | [**campaign_service_set_post**](docs/CampaignServiceApi.md#campaign_service_set_post) | **POST** /CampaignService/set |
*ConversionTrackerServiceApi* | [**conversion_tracker_service_add_post**](docs/ConversionTrackerServiceApi.md#conversion_tracker_service_add_post) | **POST** /ConversionTrackerService/add |
*ConversionTrackerServiceApi* | [**conversion_tracker_service_get_post**](docs/ConversionTrackerServiceApi.md#conversion_tracker_service_get_post) | **POST** /ConversionTrackerService/get |
*ConversionTrackerServiceApi* | [**conversion_tracker_service_set_post**](docs/ConversionTrackerServiceApi.md#conversion_tracker_service_set_post) | **POST** /ConversionTrackerService/set |
*DictionaryServiceApi* | [**dictionary_service_get_audience_category_post**](docs/DictionaryServiceApi.md#dictionary_service_get_audience_category_post) | **POST** /DictionaryService/getAudienceCategory |
*DictionaryServiceApi* | [**dictionary_service_get_disapproval_reason_post**](docs/DictionaryServiceApi.md#dictionary_service_get_disapproval_reason_post) | **POST** /DictionaryService/getDisapprovalReason |
*DictionaryServiceApi* | [**dictionary_service_get_feed_item_google_product_category_post**](docs/DictionaryServiceApi.md#dictionary_service_get_feed_item_google_product_category_post) | **POST** /DictionaryService/getFeedItemGoogleProductCategory |
*DictionaryServiceApi* | [**dictionary_service_get_geographic_location_post**](docs/DictionaryServiceApi.md#dictionary_service_get_geographic_location_post) | **POST** /DictionaryService/getGeographicLocation |
*DictionaryServiceApi* | [**dictionary_service_get_interest_category_post**](docs/DictionaryServiceApi.md#dictionary_service_get_interest_category_post) | **POST** /DictionaryService/getInterestCategory |
*DictionaryServiceApi* | [**dictionary_service_get_media_ad_format_get**](docs/DictionaryServiceApi.md#dictionary_service_get_media_ad_format_get) | **GET** /DictionaryService/getMediaAdFormat |
*DictionaryServiceApi* | [**dictionary_service_get_os_version_post**](docs/DictionaryServiceApi.md#dictionary_service_get_os_version_post) | **POST** /DictionaryService/getOsVersion |
*DictionaryServiceApi* | [**dictionary_service_get_site_category_post**](docs/DictionaryServiceApi.md#dictionary_service_get_site_category_post) | **POST** /DictionaryService/getSiteCategory |
*DictionaryServiceApi* | [**dictionary_service_get_third_party_tracking_domain_get**](docs/DictionaryServiceApi.md#dictionary_service_get_third_party_tracking_domain_get) | **GET** /DictionaryService/getThirdPartyTrackingDomain |
*FeedDataServiceApi* | [**feed_data_service_download_error_file_post**](docs/FeedDataServiceApi.md#feed_data_service_download_error_file_post) | **POST** /FeedDataService/downloadErrorFile |
*FeedDataServiceApi* | [**feed_data_service_get_post**](docs/FeedDataServiceApi.md#feed_data_service_get_post) | **POST** /FeedDataService/get |
*FeedDataServiceApi* | [**feed_data_service_upload_post**](docs/FeedDataServiceApi.md#feed_data_service_upload_post) | **POST** /FeedDataService/upload |
*FeedFtpRequestServiceApi* | [**feed_ftp_request_service_add_post**](docs/FeedFtpRequestServiceApi.md#feed_ftp_request_service_add_post) | **POST** /FeedFtpRequestService/add |
*FeedFtpServiceApi* | [**feed_ftp_service_add_post**](docs/FeedFtpServiceApi.md#feed_ftp_service_add_post) | **POST** /FeedFtpService/add |
*FeedFtpServiceApi* | [**feed_ftp_service_get_post**](docs/FeedFtpServiceApi.md#feed_ftp_service_get_post) | **POST** /FeedFtpService/get |
*FeedFtpServiceApi* | [**feed_ftp_service_set_post**](docs/FeedFtpServiceApi.md#feed_ftp_service_set_post) | **POST** /FeedFtpService/set |
*FeedItemServiceApi* | [**feed_item_service_set_post**](docs/FeedItemServiceApi.md#feed_item_service_set_post) | **POST** /FeedItemService/set |
*FeedServiceApi* | [**feed_service_add_post**](docs/FeedServiceApi.md#feed_service_add_post) | **POST** /FeedService/add |
*FeedServiceApi* | [**feed_service_download_dis_approval_reason_list_post**](docs/FeedServiceApi.md#feed_service_download_dis_approval_reason_list_post) | **POST** /FeedService/downloadDisApprovalReasonList |
*FeedServiceApi* | [**feed_service_get_post**](docs/FeedServiceApi.md#feed_service_get_post) | **POST** /FeedService/get |
*FeedServiceApi* | [**feed_service_remove_post**](docs/FeedServiceApi.md#feed_service_remove_post) | **POST** /FeedService/remove |
*FeedServiceApi* | [**feed_service_set_post**](docs/FeedServiceApi.md#feed_service_set_post) | **POST** /FeedService/set |
*FeedSetServiceApi* | [**feed_set_service_add_post**](docs/FeedSetServiceApi.md#feed_set_service_add_post) | **POST** /FeedSetService/add |
*FeedSetServiceApi* | [**feed_set_service_get_post**](docs/FeedSetServiceApi.md#feed_set_service_get_post) | **POST** /FeedSetService/get |
*FeedSetServiceApi* | [**feed_set_service_remove_post**](docs/FeedSetServiceApi.md#feed_set_service_remove_post) | **POST** /FeedSetService/remove |
*LabelServiceApi* | [**label_service_add_post**](docs/LabelServiceApi.md#label_service_add_post) | **POST** /LabelService/add |
*LabelServiceApi* | [**label_service_get_post**](docs/LabelServiceApi.md#label_service_get_post) | **POST** /LabelService/get |
*LabelServiceApi* | [**label_service_remove_post**](docs/LabelServiceApi.md#label_service_remove_post) | **POST** /LabelService/remove |
*LabelServiceApi* | [**label_service_set_post**](docs/LabelServiceApi.md#label_service_set_post) | **POST** /LabelService/set |
*MediaServiceApi* | [**media_service_add_post**](docs/MediaServiceApi.md#media_service_add_post) | **POST** /MediaService/add |
*MediaServiceApi* | [**media_service_download_post**](docs/MediaServiceApi.md#media_service_download_post) | **POST** /MediaService/download |
*MediaServiceApi* | [**media_service_get_post**](docs/MediaServiceApi.md#media_service_get_post) | **POST** /MediaService/get |
*MediaServiceApi* | [**media_service_remove_post**](docs/MediaServiceApi.md#media_service_remove_post) | **POST** /MediaService/remove |
*MediaServiceApi* | [**media_service_set_post**](docs/MediaServiceApi.md#media_service_set_post) | **POST** /MediaService/set |
*PlacementUrlIdeaServiceApi* | [**placement_url_idea_service_get_post**](docs/PlacementUrlIdeaServiceApi.md#placement_url_idea_service_get_post) | **POST** /PlacementUrlIdeaService/get |
*PlacementUrlListServiceApi* | [**placement_url_list_service_add_post**](docs/PlacementUrlListServiceApi.md#placement_url_list_service_add_post) | **POST** /PlacementUrlListService/add |
*PlacementUrlListServiceApi* | [**placement_url_list_service_get_post**](docs/PlacementUrlListServiceApi.md#placement_url_list_service_get_post) | **POST** /PlacementUrlListService/get |
*PlacementUrlListServiceApi* | [**placement_url_list_service_remove_post**](docs/PlacementUrlListServiceApi.md#placement_url_list_service_remove_post) | **POST** /PlacementUrlListService/remove |
*PlacementUrlListServiceApi* | [**placement_url_list_service_set_post**](docs/PlacementUrlListServiceApi.md#placement_url_list_service_set_post) | **POST** /PlacementUrlListService/set |
*ReportDefinitionServiceApi* | [**report_definition_service_add_post**](docs/ReportDefinitionServiceApi.md#report_definition_service_add_post) | **POST** /ReportDefinitionService/add |
*ReportDefinitionServiceApi* | [**report_definition_service_download_post**](docs/ReportDefinitionServiceApi.md#report_definition_service_download_post) | **POST** /ReportDefinitionService/download |
*ReportDefinitionServiceApi* | [**report_definition_service_get_post**](docs/ReportDefinitionServiceApi.md#report_definition_service_get_post) | **POST** /ReportDefinitionService/get |
*ReportDefinitionServiceApi* | [**report_definition_service_get_report_fields_post**](docs/ReportDefinitionServiceApi.md#report_definition_service_get_report_fields_post) | **POST** /ReportDefinitionService/getReportFields |
*ReportDefinitionServiceApi* | [**report_definition_service_remove_post**](docs/ReportDefinitionServiceApi.md#report_definition_service_remove_post) | **POST** /ReportDefinitionService/remove |
*RetargetingListServiceApi* | [**retargeting_list_service_add_post**](docs/RetargetingListServiceApi.md#retargeting_list_service_add_post) | **POST** /RetargetingListService/add |
*RetargetingListServiceApi* | [**retargeting_list_service_get_post**](docs/RetargetingListServiceApi.md#retargeting_list_service_get_post) | **POST** /RetargetingListService/get |
*RetargetingListServiceApi* | [**retargeting_list_service_remove_post**](docs/RetargetingListServiceApi.md#retargeting_list_service_remove_post) | **POST** /RetargetingListService/remove |
*RetargetingListServiceApi* | [**retargeting_list_service_set_post**](docs/RetargetingListServiceApi.md#retargeting_list_service_set_post) | **POST** /RetargetingListService/set |
*RetargetingTagServiceApi* | [**retargeting_tag_service_add_post**](docs/RetargetingTagServiceApi.md#retargeting_tag_service_add_post) | **POST** /RetargetingTagService/add |
*RetargetingTagServiceApi* | [**retargeting_tag_service_get_post**](docs/RetargetingTagServiceApi.md#retargeting_tag_service_get_post) | **POST** /RetargetingTagService/get |
*SearchKeywordIdeaServiceApi* | [**search_keyword_idea_service_get_post**](docs/SearchKeywordIdeaServiceApi.md#search_keyword_idea_service_get_post) | **POST** /SearchKeywordIdeaService/get |
*SearchKeywordListServiceApi* | [**search_keyword_list_service_add_post**](docs/SearchKeywordListServiceApi.md#search_keyword_list_service_add_post) | **POST** /SearchKeywordListService/add |
*SearchKeywordListServiceApi* | [**search_keyword_list_service_get_post**](docs/SearchKeywordListServiceApi.md#search_keyword_list_service_get_post) | **POST** /SearchKeywordListService/get |
*SearchKeywordListServiceApi* | [**search_keyword_list_service_remove_post**](docs/SearchKeywordListServiceApi.md#search_keyword_list_service_remove_post) | **POST** /SearchKeywordListService/remove |
*SearchKeywordListServiceApi* | [**search_keyword_list_service_set_post**](docs/SearchKeywordListServiceApi.md#search_keyword_list_service_set_post) | **POST** /SearchKeywordListService/set |
*StatsServiceApi* | [**stats_service_get_post**](docs/StatsServiceApi.md#stats_service_get_post) | **POST** /StatsService/get |
*VideoServiceApi* | [**video_service_download_post**](docs/VideoServiceApi.md#video_service_download_post) | **POST** /VideoService/download |
*VideoServiceApi* | [**video_service_get_post**](docs/VideoServiceApi.md#video_service_get_post) | **POST** /VideoService/get |
*VideoServiceApi* | [**video_service_remove_post**](docs/VideoServiceApi.md#video_service_remove_post) | **POST** /VideoService/remove |
*VideoServiceApi* | [**video_service_set_post**](docs/VideoServiceApi.md#video_service_set_post) | **POST** /VideoService/set |
*VideoServiceApi* | [**video_service_upload_post**](docs/VideoServiceApi.md#video_service_upload_post) | **POST** /VideoService/upload |


## Documentation For Models

 - [Account](docs/Account.md)
 - [AccountAdProduct](docs/AccountAdProduct.md)
 - [AccountAdProductServiceAdProduct](docs/AccountAdProductServiceAdProduct.md)
 - [AccountAdProductServiceGetResponse](docs/AccountAdProductServiceGetResponse.md)
 - [AccountAdProductServicePage](docs/AccountAdProductServicePage.md)
 - [AccountAdProductServiceSelector](docs/AccountAdProductServiceSelector.md)
 - [AccountAdProductServiceValue](docs/AccountAdProductServiceValue.md)
 - [AccountServiceAuthType](docs/AccountServiceAuthType.md)
 - [AccountServiceAutoTaggingEnabled](docs/AccountServiceAutoTaggingEnabled.md)
 - [AccountServiceBudget](docs/AccountServiceBudget.md)
 - [AccountServiceDeliveryStatus](docs/AccountServiceDeliveryStatus.md)
 - [AccountServiceGetResponse](docs/AccountServiceGetResponse.md)
 - [AccountServiceIncludeTestAccount](docs/AccountServiceIncludeTestAccount.md)
 - [AccountServiceIsTestAccount](docs/AccountServiceIsTestAccount.md)
 - [AccountServiceLimitChargeType](docs/AccountServiceLimitChargeType.md)
 - [AccountServiceMutateResponse](docs/AccountServiceMutateResponse.md)
 - [AccountServiceOperation](docs/AccountServiceOperation.md)
 - [AccountServicePage](docs/AccountServicePage.md)
 - [AccountServiceReturnValue](docs/AccountServiceReturnValue.md)
 - [AccountServiceSelector](docs/AccountServiceSelector.md)
 - [AccountServiceStatus](docs/AccountServiceStatus.md)
 - [AccountServiceType](docs/AccountServiceType.md)
 - [AccountServiceValue](docs/AccountServiceValue.md)
 - [AdGroup](docs/AdGroup.md)
 - [AdGroupAd](docs/AdGroupAd.md)
 - [AdGroupAdLabel](docs/AdGroupAdLabel.md)
 - [AdGroupAdLabelServiceMutateResponse](docs/AdGroupAdLabelServiceMutateResponse.md)
 - [AdGroupAdLabelServiceOperation](docs/AdGroupAdLabelServiceOperation.md)
 - [AdGroupAdLabelServiceReturnValue](docs/AdGroupAdLabelServiceReturnValue.md)
 - [AdGroupAdLabelServiceValue](docs/AdGroupAdLabelServiceValue.md)
 - [AdGroupAdServiceAd](docs/AdGroupAdServiceAd.md)
 - [AdGroupAdServiceAdStyle](docs/AdGroupAdServiceAdStyle.md)
 - [AdGroupAdServiceAdType](docs/AdGroupAdServiceAdType.md)
 - [AdGroupAdServiceApprovalStatus](docs/AdGroupAdServiceApprovalStatus.md)
 - [AdGroupAdServiceBannerImageAd](docs/AdGroupAdServiceBannerImageAd.md)
 - [AdGroupAdServiceBannerVideoAd](docs/AdGroupAdServiceBannerVideoAd.md)
 - [AdGroupAdServiceBid](docs/AdGroupAdServiceBid.md)
 - [AdGroupAdServiceBiddingStrategyType](docs/AdGroupAdServiceBiddingStrategyType.md)
 - [AdGroupAdServiceButtonText](docs/AdGroupAdServiceButtonText.md)
 - [AdGroupAdServiceCampaignGoalFilterType](docs/AdGroupAdServiceCampaignGoalFilterType.md)
 - [AdGroupAdServiceCarrierName](docs/AdGroupAdServiceCarrierName.md)
 - [AdGroupAdServiceDynamicAd](docs/AdGroupAdServiceDynamicAd.md)
 - [AdGroupAdServiceGetResponse](docs/AdGroupAdServiceGetResponse.md)
 - [AdGroupAdServiceIsRemoveFlg](docs/AdGroupAdServiceIsRemoveFlg.md)
 - [AdGroupAdServiceLabel](docs/AdGroupAdServiceLabel.md)
 - [AdGroupAdServiceManualCPCAdGroupAdBid](docs/AdGroupAdServiceManualCPCAdGroupAdBid.md)
 - [AdGroupAdServiceManualCPVAdGroupAdBid](docs/AdGroupAdServiceManualCPVAdGroupAdBid.md)
 - [AdGroupAdServiceMobileAd](docs/AdGroupAdServiceMobileAd.md)
 - [AdGroupAdServiceMutateResponse](docs/AdGroupAdServiceMutateResponse.md)
 - [AdGroupAdServiceOperation](docs/AdGroupAdServiceOperation.md)
 - [AdGroupAdServicePage](docs/AdGroupAdServicePage.md)
 - [AdGroupAdServicePosAd](docs/AdGroupAdServicePosAd.md)
 - [AdGroupAdServiceResponsiveImageAd](docs/AdGroupAdServiceResponsiveImageAd.md)
 - [AdGroupAdServiceResponsiveVideoAd](docs/AdGroupAdServiceResponsiveVideoAd.md)
 - [AdGroupAdServiceReturnValue](docs/AdGroupAdServiceReturnValue.md)
 - [AdGroupAdServiceSelector](docs/AdGroupAdServiceSelector.md)
 - [AdGroupAdServiceStaticFrameAd](docs/AdGroupAdServiceStaticFrameAd.md)
 - [AdGroupAdServiceTextAd](docs/AdGroupAdServiceTextAd.md)
 - [AdGroupAdServiceUserStatus](docs/AdGroupAdServiceUserStatus.md)
 - [AdGroupAdServiceValue](docs/AdGroupAdServiceValue.md)
 - [AdGroupLabel](docs/AdGroupLabel.md)
 - [AdGroupLabelServiceMutateResponse](docs/AdGroupLabelServiceMutateResponse.md)
 - [AdGroupLabelServiceOperation](docs/AdGroupLabelServiceOperation.md)
 - [AdGroupLabelServiceReturnValue](docs/AdGroupLabelServiceReturnValue.md)
 - [AdGroupLabelServiceValue](docs/AdGroupLabelServiceValue.md)
 - [AdGroupServiceAutoConversionOptimizer](docs/AdGroupServiceAutoConversionOptimizer.md)
 - [AdGroupServiceBid](docs/AdGroupServiceBid.md)
 - [AdGroupServiceBiddingStrategy](docs/AdGroupServiceBiddingStrategy.md)
 - [AdGroupServiceCampaignBiddingStrategyType](docs/AdGroupServiceCampaignBiddingStrategyType.md)
 - [AdGroupServiceCampaignGoalFilterType](docs/AdGroupServiceCampaignGoalFilterType.md)
 - [AdGroupServiceConversionOptimizer](docs/AdGroupServiceConversionOptimizer.md)
 - [AdGroupServiceDeviceAppType](docs/AdGroupServiceDeviceAppType.md)
 - [AdGroupServiceDeviceOsType](docs/AdGroupServiceDeviceOsType.md)
 - [AdGroupServiceDeviceType](docs/AdGroupServiceDeviceType.md)
 - [AdGroupServiceDynamicImageExtensions](docs/AdGroupServiceDynamicImageExtensions.md)
 - [AdGroupServiceEligibilityFlg](docs/AdGroupServiceEligibilityFlg.md)
 - [AdGroupServiceGetResponse](docs/AdGroupServiceGetResponse.md)
 - [AdGroupServiceLabel](docs/AdGroupServiceLabel.md)
 - [AdGroupServiceManualCPCBid](docs/AdGroupServiceManualCPCBid.md)
 - [AdGroupServiceManualCPVBid](docs/AdGroupServiceManualCPVBid.md)
 - [AdGroupServiceManualConversionOptimizer](docs/AdGroupServiceManualConversionOptimizer.md)
 - [AdGroupServiceMutateResponse](docs/AdGroupServiceMutateResponse.md)
 - [AdGroupServiceNoneConversionOptimizer](docs/AdGroupServiceNoneConversionOptimizer.md)
 - [AdGroupServiceOperation](docs/AdGroupServiceOperation.md)
 - [AdGroupServiceOptimizerType](docs/AdGroupServiceOptimizerType.md)
 - [AdGroupServicePage](docs/AdGroupServicePage.md)
 - [AdGroupServiceReturnValue](docs/AdGroupServiceReturnValue.md)
 - [AdGroupServiceSelector](docs/AdGroupServiceSelector.md)
 - [AdGroupServiceSmartDeviceCarrier](docs/AdGroupServiceSmartDeviceCarrier.md)
 - [AdGroupServiceType](docs/AdGroupServiceType.md)
 - [AdGroupServiceUserStatus](docs/AdGroupServiceUserStatus.md)
 - [AdGroupServiceValue](docs/AdGroupServiceValue.md)
 - [AdGroupTarget](docs/AdGroupTarget.md)
 - [AdGroupTargetReturnValue](docs/AdGroupTargetReturnValue.md)
 - [AdGroupTargetServiceAdScheduleTarget](docs/AdGroupTargetServiceAdScheduleTarget.md)
 - [AdGroupTargetServiceAge](docs/AdGroupTargetServiceAge.md)
 - [AdGroupTargetServiceAgeTarget](docs/AdGroupTargetServiceAgeTarget.md)
 - [AdGroupTargetServiceAppTarget](docs/AdGroupTargetServiceAppTarget.md)
 - [AdGroupTargetServiceAudienceCategoryTarget](docs/AdGroupTargetServiceAudienceCategoryTarget.md)
 - [AdGroupTargetServiceCarrierTarget](docs/AdGroupTargetServiceCarrierTarget.md)
 - [AdGroupTargetServiceCarrierType](docs/AdGroupTargetServiceCarrierType.md)
 - [AdGroupTargetServiceDayOfWeek](docs/AdGroupTargetServiceDayOfWeek.md)
 - [AdGroupTargetServiceDeviceAppType](docs/AdGroupTargetServiceDeviceAppType.md)
 - [AdGroupTargetServiceDeviceOsType](docs/AdGroupTargetServiceDeviceOsType.md)
 - [AdGroupTargetServiceDeviceTarget](docs/AdGroupTargetServiceDeviceTarget.md)
 - [AdGroupTargetServiceDeviceType](docs/AdGroupTargetServiceDeviceType.md)
 - [AdGroupTargetServiceEstimateFlg](docs/AdGroupTargetServiceEstimateFlg.md)
 - [AdGroupTargetServiceGender](docs/AdGroupTargetServiceGender.md)
 - [AdGroupTargetServiceGenderTarget](docs/AdGroupTargetServiceGenderTarget.md)
 - [AdGroupTargetServiceGeoTarget](docs/AdGroupTargetServiceGeoTarget.md)
 - [AdGroupTargetServiceGetResponse](docs/AdGroupTargetServiceGetResponse.md)
 - [AdGroupTargetServiceInterestCategoryTarget](docs/AdGroupTargetServiceInterestCategoryTarget.md)
 - [AdGroupTargetServiceMutateResponse](docs/AdGroupTargetServiceMutateResponse.md)
 - [AdGroupTargetServiceOperation](docs/AdGroupTargetServiceOperation.md)
 - [AdGroupTargetServiceOsTarget](docs/AdGroupTargetServiceOsTarget.md)
 - [AdGroupTargetServiceOsVersionTarget](docs/AdGroupTargetServiceOsVersionTarget.md)
 - [AdGroupTargetServicePage](docs/AdGroupTargetServicePage.md)
 - [AdGroupTargetServicePlacementTarget](docs/AdGroupTargetServicePlacementTarget.md)
 - [AdGroupTargetServicePlacementUrlListType](docs/AdGroupTargetServicePlacementUrlListType.md)
 - [AdGroupTargetServiceSearchTarget](docs/AdGroupTargetServiceSearchTarget.md)
 - [AdGroupTargetServiceSelector](docs/AdGroupTargetServiceSelector.md)
 - [AdGroupTargetServiceSiteCategoryTarget](docs/AdGroupTargetServiceSiteCategoryTarget.md)
 - [AdGroupTargetServiceSiteRetargetingTarget](docs/AdGroupTargetServiceSiteRetargetingTarget.md)
 - [AdGroupTargetServiceTarget](docs/AdGroupTargetServiceTarget.md)
 - [AdGroupTargetServiceTargetListDeliverType](docs/AdGroupTargetServiceTargetListDeliverType.md)
 - [AdGroupTargetServiceTargetType](docs/AdGroupTargetServiceTargetType.md)
 - [AdGroupTargetServiceValue](docs/AdGroupTargetServiceValue.md)
 - [AuditLogServiceDateRange](docs/AuditLogServiceDateRange.md)
 - [AuditLogServiceDownloadSelector](docs/AuditLogServiceDownloadSelector.md)
 - [AuditLogServiceGetResponse](docs/AuditLogServiceGetResponse.md)
 - [AuditLogServiceJob](docs/AuditLogServiceJob.md)
 - [AuditLogServiceJobStatus](docs/AuditLogServiceJobStatus.md)
 - [AuditLogServiceLang](docs/AuditLogServiceLang.md)
 - [AuditLogServiceMutateResponse](docs/AuditLogServiceMutateResponse.md)
 - [AuditLogServiceOperation](docs/AuditLogServiceOperation.md)
 - [AuditLogServicePage](docs/AuditLogServicePage.md)
 - [AuditLogServiceReturnValue](docs/AuditLogServiceReturnValue.md)
 - [AuditLogServiceSelector](docs/AuditLogServiceSelector.md)
 - [AuditLogServiceUpdateSource](docs/AuditLogServiceUpdateSource.md)
 - [AuditLogServiceValue](docs/AuditLogServiceValue.md)
 - [Balance](docs/Balance.md)
 - [BalanceServiceGetResponse](docs/BalanceServiceGetResponse.md)
 - [BalanceServicePage](docs/BalanceServicePage.md)
 - [BalanceServiceSelector](docs/BalanceServiceSelector.md)
 - [BalanceServiceValue](docs/BalanceServiceValue.md)
 - [Campaign](docs/Campaign.md)
 - [CampaignLabel](docs/CampaignLabel.md)
 - [CampaignLabelServiceMutateResponse](docs/CampaignLabelServiceMutateResponse.md)
 - [CampaignLabelServiceOperation](docs/CampaignLabelServiceOperation.md)
 - [CampaignLabelServiceReturnValue](docs/CampaignLabelServiceReturnValue.md)
 - [CampaignLabelServiceValue](docs/CampaignLabelServiceValue.md)
 - [CampaignMigrationServiceDownloadFileSelector](docs/CampaignMigrationServiceDownloadFileSelector.md)
 - [CampaignMigrationServiceDownloadSelector](docs/CampaignMigrationServiceDownloadSelector.md)
 - [CampaignMigrationServiceGetResponse](docs/CampaignMigrationServiceGetResponse.md)
 - [CampaignMigrationServiceJob](docs/CampaignMigrationServiceJob.md)
 - [CampaignMigrationServiceJobStatus](docs/CampaignMigrationServiceJobStatus.md)
 - [CampaignMigrationServiceJobValue](docs/CampaignMigrationServiceJobValue.md)
 - [CampaignMigrationServiceLang](docs/CampaignMigrationServiceLang.md)
 - [CampaignMigrationServicePage](docs/CampaignMigrationServicePage.md)
 - [CampaignMigrationServiceScope](docs/CampaignMigrationServiceScope.md)
 - [CampaignMigrationServiceSelector](docs/CampaignMigrationServiceSelector.md)
 - [CampaignMigrationServiceUploadResponse](docs/CampaignMigrationServiceUploadResponse.md)
 - [CampaignMigrationServiceUploadReturnValue](docs/CampaignMigrationServiceUploadReturnValue.md)
 - [CampaignServiceAutoCampaignConversionOptimizer](docs/CampaignServiceAutoCampaignConversionOptimizer.md)
 - [CampaignServiceBiddingStrategy](docs/CampaignServiceBiddingStrategy.md)
 - [CampaignServiceBiddingStrategyType](docs/CampaignServiceBiddingStrategyType.md)
 - [CampaignServiceBudget](docs/CampaignServiceBudget.md)
 - [CampaignServiceBudgetDeliveryMethod](docs/CampaignServiceBudgetDeliveryMethod.md)
 - [CampaignServiceCampaignBiddingStrategy](docs/CampaignServiceCampaignBiddingStrategy.md)
 - [CampaignServiceCampaignBiddingStrategyType](docs/CampaignServiceCampaignBiddingStrategyType.md)
 - [CampaignServiceConversionOptimizer](docs/CampaignServiceConversionOptimizer.md)
 - [CampaignServiceConversionOptimizerEligibilityFlg](docs/CampaignServiceConversionOptimizerEligibilityFlg.md)
 - [CampaignServiceConversionOptimizerTrainingStatus](docs/CampaignServiceConversionOptimizerTrainingStatus.md)
 - [CampaignServiceConversionOptimizerType](docs/CampaignServiceConversionOptimizerType.md)
 - [CampaignServiceDeviceOsType](docs/CampaignServiceDeviceOsType.md)
 - [CampaignServiceFrequencyCap](docs/CampaignServiceFrequencyCap.md)
 - [CampaignServiceFrequencyLevel](docs/CampaignServiceFrequencyLevel.md)
 - [CampaignServiceFrequencyTimeUnit](docs/CampaignServiceFrequencyTimeUnit.md)
 - [CampaignServiceGetResponse](docs/CampaignServiceGetResponse.md)
 - [CampaignServiceGoalFilterType](docs/CampaignServiceGoalFilterType.md)
 - [CampaignServiceLabel](docs/CampaignServiceLabel.md)
 - [CampaignServiceManualCampaignConversionOptimizer](docs/CampaignServiceManualCampaignConversionOptimizer.md)
 - [CampaignServiceMutateResponse](docs/CampaignServiceMutateResponse.md)
 - [CampaignServiceOperation](docs/CampaignServiceOperation.md)
 - [CampaignServicePage](docs/CampaignServicePage.md)
 - [CampaignServiceReturnValue](docs/CampaignServiceReturnValue.md)
 - [CampaignServiceSelector](docs/CampaignServiceSelector.md)
 - [CampaignServiceServingStatus](docs/CampaignServiceServingStatus.md)
 - [CampaignServiceType](docs/CampaignServiceType.md)
 - [CampaignServiceUserStatus](docs/CampaignServiceUserStatus.md)
 - [CampaignServiceValue](docs/CampaignServiceValue.md)
 - [CampaignServiceViewableFrequencyCap](docs/CampaignServiceViewableFrequencyCap.md)
 - [ConversionTracker](docs/ConversionTracker.md)
 - [ConversionTrackerServiceAppConversion](docs/ConversionTrackerServiceAppConversion.md)
 - [ConversionTrackerServiceAppConversionPlatform](docs/ConversionTrackerServiceAppConversionPlatform.md)
 - [ConversionTrackerServiceAppConversionType](docs/ConversionTrackerServiceAppConversionType.md)
 - [ConversionTrackerServiceCategory](docs/ConversionTrackerServiceCategory.md)
 - [ConversionTrackerServiceCountingType](docs/ConversionTrackerServiceCountingType.md)
 - [ConversionTrackerServiceExcludeFromBidding](docs/ConversionTrackerServiceExcludeFromBidding.md)
 - [ConversionTrackerServiceGetResponse](docs/ConversionTrackerServiceGetResponse.md)
 - [ConversionTrackerServiceMutateResponse](docs/ConversionTrackerServiceMutateResponse.md)
 - [ConversionTrackerServiceOperation](docs/ConversionTrackerServiceOperation.md)
 - [ConversionTrackerServicePage](docs/ConversionTrackerServicePage.md)
 - [ConversionTrackerServicePeriod](docs/ConversionTrackerServicePeriod.md)
 - [ConversionTrackerServicePeriodDatetime](docs/ConversionTrackerServicePeriodDatetime.md)
 - [ConversionTrackerServiceReturnValue](docs/ConversionTrackerServiceReturnValue.md)
 - [ConversionTrackerServiceSelector](docs/ConversionTrackerServiceSelector.md)
 - [ConversionTrackerServiceStatsPeriod](docs/ConversionTrackerServiceStatsPeriod.md)
 - [ConversionTrackerServiceStatsPeriodCustomDate](docs/ConversionTrackerServiceStatsPeriodCustomDate.md)
 - [ConversionTrackerServiceStatus](docs/ConversionTrackerServiceStatus.md)
 - [ConversionTrackerServiceType](docs/ConversionTrackerServiceType.md)
 - [ConversionTrackerServiceValue](docs/ConversionTrackerServiceValue.md)
 - [ConversionTrackerServiceWebConversion](docs/ConversionTrackerServiceWebConversion.md)
 - [ConversionTrackerServiceWebConversionSnippet](docs/ConversionTrackerServiceWebConversionSnippet.md)
 - [ConversionTrackerServiceWebConversionSnippetType](docs/ConversionTrackerServiceWebConversionSnippetType.md)
 - [DictionaryServiceAudienceCategory](docs/DictionaryServiceAudienceCategory.md)
 - [DictionaryServiceAudienceCategoryPage](docs/DictionaryServiceAudienceCategoryPage.md)
 - [DictionaryServiceAudienceCategoryValue](docs/DictionaryServiceAudienceCategoryValue.md)
 - [DictionaryServiceCategory](docs/DictionaryServiceCategory.md)
 - [DictionaryServiceCategoryChild](docs/DictionaryServiceCategoryChild.md)
 - [DictionaryServiceCategoryPage](docs/DictionaryServiceCategoryPage.md)
 - [DictionaryServiceCategorySelector](docs/DictionaryServiceCategorySelector.md)
 - [DictionaryServiceCategoryValue](docs/DictionaryServiceCategoryValue.md)
 - [DictionaryServiceDeviceOsType](docs/DictionaryServiceDeviceOsType.md)
 - [DictionaryServiceDisapprovalReason](docs/DictionaryServiceDisapprovalReason.md)
 - [DictionaryServiceDisapprovalReasonPage](docs/DictionaryServiceDisapprovalReasonPage.md)
 - [DictionaryServiceDisapprovalReasonSelector](docs/DictionaryServiceDisapprovalReasonSelector.md)
 - [DictionaryServiceDisapprovalReasonValue](docs/DictionaryServiceDisapprovalReasonValue.md)
 - [DictionaryServiceFeedItemGoogleProductCategory](docs/DictionaryServiceFeedItemGoogleProductCategory.md)
 - [DictionaryServiceFeedItemGoogleProductCategoryPage](docs/DictionaryServiceFeedItemGoogleProductCategoryPage.md)
 - [DictionaryServiceFeedItemGoogleProductCategorySelector](docs/DictionaryServiceFeedItemGoogleProductCategorySelector.md)
 - [DictionaryServiceFeedItemGoogleProductCategoryValue](docs/DictionaryServiceFeedItemGoogleProductCategoryValue.md)
 - [DictionaryServiceGeographicLocation](docs/DictionaryServiceGeographicLocation.md)
 - [DictionaryServiceGeographicLocationPage](docs/DictionaryServiceGeographicLocationPage.md)
 - [DictionaryServiceGeographicLocationSelector](docs/DictionaryServiceGeographicLocationSelector.md)
 - [DictionaryServiceGeographicLocationType](docs/DictionaryServiceGeographicLocationType.md)
 - [DictionaryServiceGeographicLocationValue](docs/DictionaryServiceGeographicLocationValue.md)
 - [DictionaryServiceGetAudienceCategoryResponse](docs/DictionaryServiceGetAudienceCategoryResponse.md)
 - [DictionaryServiceGetDisapprovalReasonResponse](docs/DictionaryServiceGetDisapprovalReasonResponse.md)
 - [DictionaryServiceGetFeedItemGoogleProductCategoryResponse](docs/DictionaryServiceGetFeedItemGoogleProductCategoryResponse.md)
 - [DictionaryServiceGetGeographicLocationResponse](docs/DictionaryServiceGetGeographicLocationResponse.md)
 - [DictionaryServiceGetInterestCategoryResponse](docs/DictionaryServiceGetInterestCategoryResponse.md)
 - [DictionaryServiceGetMediaAdFormatResponse](docs/DictionaryServiceGetMediaAdFormatResponse.md)
 - [DictionaryServiceGetOsVersionResponse](docs/DictionaryServiceGetOsVersionResponse.md)
 - [DictionaryServiceGetSiteCategoryResponse](docs/DictionaryServiceGetSiteCategoryResponse.md)
 - [DictionaryServiceGetThirdPartyTrackingDomainResponse](docs/DictionaryServiceGetThirdPartyTrackingDomainResponse.md)
 - [DictionaryServiceLang](docs/DictionaryServiceLang.md)
 - [DictionaryServiceMediaAdFormat](docs/DictionaryServiceMediaAdFormat.md)
 - [DictionaryServiceMediaAdFormatPage](docs/DictionaryServiceMediaAdFormatPage.md)
 - [DictionaryServiceMediaAdFormatValue](docs/DictionaryServiceMediaAdFormatValue.md)
 - [DictionaryServiceOsVersion](docs/DictionaryServiceOsVersion.md)
 - [DictionaryServiceOsVersionPage](docs/DictionaryServiceOsVersionPage.md)
 - [DictionaryServiceOsVersionSelector](docs/DictionaryServiceOsVersionSelector.md)
 - [DictionaryServiceOsVersionValue](docs/DictionaryServiceOsVersionValue.md)
 - [DictionaryServiceThirdPartyTrackingDomain](docs/DictionaryServiceThirdPartyTrackingDomain.md)
 - [DictionaryServiceThirdPartyTrackingDomainPage](docs/DictionaryServiceThirdPartyTrackingDomainPage.md)
 - [DictionaryServiceThirdPartyTrackingDomainValue](docs/DictionaryServiceThirdPartyTrackingDomainValue.md)
 - [Error](docs/Error.md)
 - [ErrorDetail](docs/ErrorDetail.md)
 - [Feed](docs/Feed.md)
 - [FeedDataServiceDownloadErrorFileSelector](docs/FeedDataServiceDownloadErrorFileSelector.md)
 - [FeedDataServiceFileUploadDateRange](docs/FeedDataServiceFileUploadDateRange.md)
 - [FeedDataServiceFileUploadSrc](docs/FeedDataServiceFileUploadSrc.md)
 - [FeedDataServiceFileUploadStatus](docs/FeedDataServiceFileUploadStatus.md)
 - [FeedDataServiceGetResponse](docs/FeedDataServiceGetResponse.md)
 - [FeedDataServiceItemListUploadType](docs/FeedDataServiceItemListUploadType.md)
 - [FeedDataServicePage](docs/FeedDataServicePage.md)
 - [FeedDataServiceRecord](docs/FeedDataServiceRecord.md)
 - [FeedDataServiceSelector](docs/FeedDataServiceSelector.md)
 - [FeedDataServiceUploadResponse](docs/FeedDataServiceUploadResponse.md)
 - [FeedDataServiceUploadReturnValue](docs/FeedDataServiceUploadReturnValue.md)
 - [FeedDataServiceValue](docs/FeedDataServiceValue.md)
 - [FeedFtp](docs/FeedFtp.md)
 - [FeedFtpRequest](docs/FeedFtpRequest.md)
 - [FeedFtpRequestServiceMutateResponse](docs/FeedFtpRequestServiceMutateResponse.md)
 - [FeedFtpRequestServiceOperation](docs/FeedFtpRequestServiceOperation.md)
 - [FeedFtpRequestServiceReturnValue](docs/FeedFtpRequestServiceReturnValue.md)
 - [FeedFtpRequestServiceValue](docs/FeedFtpRequestServiceValue.md)
 - [FeedFtpServiceActiveStatus](docs/FeedFtpServiceActiveStatus.md)
 - [FeedFtpServiceGetResponse](docs/FeedFtpServiceGetResponse.md)
 - [FeedFtpServiceItemListUploadType](docs/FeedFtpServiceItemListUploadType.md)
 - [FeedFtpServiceMutateResponse](docs/FeedFtpServiceMutateResponse.md)
 - [FeedFtpServiceOperation](docs/FeedFtpServiceOperation.md)
 - [FeedFtpServicePage](docs/FeedFtpServicePage.md)
 - [FeedFtpServiceReturnValue](docs/FeedFtpServiceReturnValue.md)
 - [FeedFtpServiceSchedule](docs/FeedFtpServiceSchedule.md)
 - [FeedFtpServiceScheduleDaily](docs/FeedFtpServiceScheduleDaily.md)
 - [FeedFtpServiceScheduleHourly](docs/FeedFtpServiceScheduleHourly.md)
 - [FeedFtpServiceScheduleType](docs/FeedFtpServiceScheduleType.md)
 - [FeedFtpServiceScheduleWeek](docs/FeedFtpServiceScheduleWeek.md)
 - [FeedFtpServiceScheduleWeekly](docs/FeedFtpServiceScheduleWeekly.md)
 - [FeedFtpServiceSelector](docs/FeedFtpServiceSelector.md)
 - [FeedFtpServiceValue](docs/FeedFtpServiceValue.md)
 - [FeedItem](docs/FeedItem.md)
 - [FeedItemServiceAvailability](docs/FeedItemServiceAvailability.md)
 - [FeedItemServiceIsRemoveFlg](docs/FeedItemServiceIsRemoveFlg.md)
 - [FeedItemServiceMutateResponse](docs/FeedItemServiceMutateResponse.md)
 - [FeedItemServiceOperation](docs/FeedItemServiceOperation.md)
 - [FeedItemServiceReturnValue](docs/FeedItemServiceReturnValue.md)
 - [FeedItemServiceValue](docs/FeedItemServiceValue.md)
 - [FeedServiceControlType](docs/FeedServiceControlType.md)
 - [FeedServiceDownloadDisApprovalReasonListSelector](docs/FeedServiceDownloadDisApprovalReasonListSelector.md)
 - [FeedServiceGetResponse](docs/FeedServiceGetResponse.md)
 - [FeedServiceMutateResponse](docs/FeedServiceMutateResponse.md)
 - [FeedServiceOperation](docs/FeedServiceOperation.md)
 - [FeedServicePage](docs/FeedServicePage.md)
 - [FeedServiceReturnValue](docs/FeedServiceReturnValue.md)
 - [FeedServiceSelector](docs/FeedServiceSelector.md)
 - [FeedServiceSourceType](docs/FeedServiceSourceType.md)
 - [FeedServiceUploadLimit](docs/FeedServiceUploadLimit.md)
 - [FeedServiceValue](docs/FeedServiceValue.md)
 - [FeedSet](docs/FeedSet.md)
 - [FeedSetServiceCompareOperator](docs/FeedSetServiceCompareOperator.md)
 - [FeedSetServiceCondition](docs/FeedSetServiceCondition.md)
 - [FeedSetServiceConditionSet](docs/FeedSetServiceConditionSet.md)
 - [FeedSetServiceConditionType](docs/FeedSetServiceConditionType.md)
 - [FeedSetServiceGetResponse](docs/FeedSetServiceGetResponse.md)
 - [FeedSetServiceMutateResponse](docs/FeedSetServiceMutateResponse.md)
 - [FeedSetServiceOperation](docs/FeedSetServiceOperation.md)
 - [FeedSetServicePage](docs/FeedSetServicePage.md)
 - [FeedSetServiceReturnValue](docs/FeedSetServiceReturnValue.md)
 - [FeedSetServiceSelector](docs/FeedSetServiceSelector.md)
 - [FeedSetServiceValue](docs/FeedSetServiceValue.md)
 - [InlineObject](docs/InlineObject.md)
 - [InlineObject1](docs/InlineObject1.md)
 - [InlineObject2](docs/InlineObject2.md)
 - [Label](docs/Label.md)
 - [LabelServiceGetResponse](docs/LabelServiceGetResponse.md)
 - [LabelServiceMutateResponse](docs/LabelServiceMutateResponse.md)
 - [LabelServiceOperation](docs/LabelServiceOperation.md)
 - [LabelServicePage](docs/LabelServicePage.md)
 - [LabelServiceReturnValue](docs/LabelServiceReturnValue.md)
 - [LabelServiceSelector](docs/LabelServiceSelector.md)
 - [LabelServiceValue](docs/LabelServiceValue.md)
 - [MediaServiceApprovalStatus](docs/MediaServiceApprovalStatus.md)
 - [MediaServiceCampaignBannerFlg](docs/MediaServiceCampaignBannerFlg.md)
 - [MediaServiceDownloadSelector](docs/MediaServiceDownloadSelector.md)
 - [MediaServiceFileType](docs/MediaServiceFileType.md)
 - [MediaServiceGetResponse](docs/MediaServiceGetResponse.md)
 - [MediaServiceImageMedia](docs/MediaServiceImageMedia.md)
 - [MediaServiceLogoFlg](docs/MediaServiceLogoFlg.md)
 - [MediaServiceMutateResponse](docs/MediaServiceMutateResponse.md)
 - [MediaServiceOperation](docs/MediaServiceOperation.md)
 - [MediaServicePage](docs/MediaServicePage.md)
 - [MediaServiceRecord](docs/MediaServiceRecord.md)
 - [MediaServiceReturnValue](docs/MediaServiceReturnValue.md)
 - [MediaServiceSelector](docs/MediaServiceSelector.md)
 - [MediaServiceThumbnailFlg](docs/MediaServiceThumbnailFlg.md)
 - [MediaServiceType](docs/MediaServiceType.md)
 - [MediaServiceUserStatus](docs/MediaServiceUserStatus.md)
 - [MediaServiceValue](docs/MediaServiceValue.md)
 - [PlacementUrlIdea](docs/PlacementUrlIdea.md)
 - [PlacementUrlIdeaServiceAdFormat](docs/PlacementUrlIdeaServiceAdFormat.md)
 - [PlacementUrlIdeaServiceAdFormatConditions](docs/PlacementUrlIdeaServiceAdFormatConditions.md)
 - [PlacementUrlIdeaServiceGetResponse](docs/PlacementUrlIdeaServiceGetResponse.md)
 - [PlacementUrlIdeaServicePage](docs/PlacementUrlIdeaServicePage.md)
 - [PlacementUrlIdeaServiceSelector](docs/PlacementUrlIdeaServiceSelector.md)
 - [PlacementUrlIdeaServiceValue](docs/PlacementUrlIdeaServiceValue.md)
 - [PlacementUrlList](docs/PlacementUrlList.md)
 - [PlacementUrlListServiceGetResponse](docs/PlacementUrlListServiceGetResponse.md)
 - [PlacementUrlListServiceMutateResponse](docs/PlacementUrlListServiceMutateResponse.md)
 - [PlacementUrlListServiceOperation](docs/PlacementUrlListServiceOperation.md)
 - [PlacementUrlListServicePage](docs/PlacementUrlListServicePage.md)
 - [PlacementUrlListServiceReturnValue](docs/PlacementUrlListServiceReturnValue.md)
 - [PlacementUrlListServiceSelector](docs/PlacementUrlListServiceSelector.md)
 - [PlacementUrlListServiceUnknownDomainFlg](docs/PlacementUrlListServiceUnknownDomainFlg.md)
 - [PlacementUrlListServiceUrlActiveFlg](docs/PlacementUrlListServiceUrlActiveFlg.md)
 - [PlacementUrlListServiceUrlList](docs/PlacementUrlListServiceUrlList.md)
 - [PlacementUrlListServiceValue](docs/PlacementUrlListServiceValue.md)
 - [ReportDefinition](docs/ReportDefinition.md)
 - [ReportDefinitionServiceDateRange](docs/ReportDefinitionServiceDateRange.md)
 - [ReportDefinitionServiceDateRangeType](docs/ReportDefinitionServiceDateRangeType.md)
 - [ReportDefinitionServiceDownloadEncode](docs/ReportDefinitionServiceDownloadEncode.md)
 - [ReportDefinitionServiceDownloadFormat](docs/ReportDefinitionServiceDownloadFormat.md)
 - [ReportDefinitionServiceDownloadSelector](docs/ReportDefinitionServiceDownloadSelector.md)
 - [ReportDefinitionServiceFieldAttribute](docs/ReportDefinitionServiceFieldAttribute.md)
 - [ReportDefinitionServiceFieldValue](docs/ReportDefinitionServiceFieldValue.md)
 - [ReportDefinitionServiceFilter](docs/ReportDefinitionServiceFilter.md)
 - [ReportDefinitionServiceFilterOperator](docs/ReportDefinitionServiceFilterOperator.md)
 - [ReportDefinitionServiceFrequencyRange](docs/ReportDefinitionServiceFrequencyRange.md)
 - [ReportDefinitionServiceGetReportFields](docs/ReportDefinitionServiceGetReportFields.md)
 - [ReportDefinitionServiceGetReportFieldsResponse](docs/ReportDefinitionServiceGetReportFieldsResponse.md)
 - [ReportDefinitionServiceGetResponse](docs/ReportDefinitionServiceGetResponse.md)
 - [ReportDefinitionServiceJobStatus](docs/ReportDefinitionServiceJobStatus.md)
 - [ReportDefinitionServiceLang](docs/ReportDefinitionServiceLang.md)
 - [ReportDefinitionServiceMutateResponse](docs/ReportDefinitionServiceMutateResponse.md)
 - [ReportDefinitionServiceOperation](docs/ReportDefinitionServiceOperation.md)
 - [ReportDefinitionServicePage](docs/ReportDefinitionServicePage.md)
 - [ReportDefinitionServiceReportSortField](docs/ReportDefinitionServiceReportSortField.md)
 - [ReportDefinitionServiceReportSortType](docs/ReportDefinitionServiceReportSortType.md)
 - [ReportDefinitionServiceReturnValue](docs/ReportDefinitionServiceReturnValue.md)
 - [ReportDefinitionServiceSelector](docs/ReportDefinitionServiceSelector.md)
 - [ReportDefinitionServiceType](docs/ReportDefinitionServiceType.md)
 - [ReportDefinitionServiceValue](docs/ReportDefinitionServiceValue.md)
 - [ReportDefinitionServiceZip](docs/ReportDefinitionServiceZip.md)
 - [RetargetingList](docs/RetargetingList.md)
 - [RetargetingListServiceCombination](docs/RetargetingListServiceCombination.md)
 - [RetargetingListServiceCombinationTargetList](docs/RetargetingListServiceCombinationTargetList.md)
 - [RetargetingListServiceCompareOperator](docs/RetargetingListServiceCompareOperator.md)
 - [RetargetingListServiceCustomAudienceTargetList](docs/RetargetingListServiceCustomAudienceTargetList.md)
 - [RetargetingListServiceDeliveryStatus](docs/RetargetingListServiceDeliveryStatus.md)
 - [RetargetingListServiceGetResponse](docs/RetargetingListServiceGetResponse.md)
 - [RetargetingListServiceIsOpen](docs/RetargetingListServiceIsOpen.md)
 - [RetargetingListServiceIsPreset](docs/RetargetingListServiceIsPreset.md)
 - [RetargetingListServiceLogicalOperator](docs/RetargetingListServiceLogicalOperator.md)
 - [RetargetingListServiceMutateResponse](docs/RetargetingListServiceMutateResponse.md)
 - [RetargetingListServiceOperation](docs/RetargetingListServiceOperation.md)
 - [RetargetingListServicePage](docs/RetargetingListServicePage.md)
 - [RetargetingListServiceReturnValue](docs/RetargetingListServiceReturnValue.md)
 - [RetargetingListServiceRule](docs/RetargetingListServiceRule.md)
 - [RetargetingListServiceRuleCondition](docs/RetargetingListServiceRuleCondition.md)
 - [RetargetingListServiceRuleTargetList](docs/RetargetingListServiceRuleTargetList.md)
 - [RetargetingListServiceRuleType](docs/RetargetingListServiceRuleType.md)
 - [RetargetingListServiceSelector](docs/RetargetingListServiceSelector.md)
 - [RetargetingListServiceSimilarityTargetList](docs/RetargetingListServiceSimilarityTargetList.md)
 - [RetargetingListServiceTargetList](docs/RetargetingListServiceTargetList.md)
 - [RetargetingListServiceTargetListData](docs/RetargetingListServiceTargetListData.md)
 - [RetargetingListServiceTargetListSize](docs/RetargetingListServiceTargetListSize.md)
 - [RetargetingListServiceTargetListSizeReaches](docs/RetargetingListServiceTargetListSizeReaches.md)
 - [RetargetingListServiceTargetListType](docs/RetargetingListServiceTargetListType.md)
 - [RetargetingListServiceValue](docs/RetargetingListServiceValue.md)
 - [RetargetingTag](docs/RetargetingTag.md)
 - [RetargetingTagServiceApprovalStatus](docs/RetargetingTagServiceApprovalStatus.md)
 - [RetargetingTagServiceGetResponse](docs/RetargetingTagServiceGetResponse.md)
 - [RetargetingTagServiceMutateResponse](docs/RetargetingTagServiceMutateResponse.md)
 - [RetargetingTagServiceOperation](docs/RetargetingTagServiceOperation.md)
 - [RetargetingTagServicePage](docs/RetargetingTagServicePage.md)
 - [RetargetingTagServiceReturnValue](docs/RetargetingTagServiceReturnValue.md)
 - [RetargetingTagServiceSelector](docs/RetargetingTagServiceSelector.md)
 - [RetargetingTagServiceValue](docs/RetargetingTagServiceValue.md)
 - [SearchKeywordIdea](docs/SearchKeywordIdea.md)
 - [SearchKeywordIdeaServiceGetResponse](docs/SearchKeywordIdeaServiceGetResponse.md)
 - [SearchKeywordIdeaServiceKeywordFrequency](docs/SearchKeywordIdeaServiceKeywordFrequency.md)
 - [SearchKeywordIdeaServiceKeywordRecency](docs/SearchKeywordIdeaServiceKeywordRecency.md)
 - [SearchKeywordIdeaServiceMatchType](docs/SearchKeywordIdeaServiceMatchType.md)
 - [SearchKeywordIdeaServicePage](docs/SearchKeywordIdeaServicePage.md)
 - [SearchKeywordIdeaServiceSelector](docs/SearchKeywordIdeaServiceSelector.md)
 - [SearchKeywordIdeaServiceSortField](docs/SearchKeywordIdeaServiceSortField.md)
 - [SearchKeywordIdeaServiceSortType](docs/SearchKeywordIdeaServiceSortType.md)
 - [SearchKeywordIdeaServiceValue](docs/SearchKeywordIdeaServiceValue.md)
 - [SearchKeywordList](docs/SearchKeywordList.md)
 - [SearchKeywordListServiceDeliveryStatus](docs/SearchKeywordListServiceDeliveryStatus.md)
 - [SearchKeywordListServiceGetResponse](docs/SearchKeywordListServiceGetResponse.md)
 - [SearchKeywordListServiceKeywordFrequency](docs/SearchKeywordListServiceKeywordFrequency.md)
 - [SearchKeywordListServiceKeywordRecency](docs/SearchKeywordListServiceKeywordRecency.md)
 - [SearchKeywordListServiceMutateResponse](docs/SearchKeywordListServiceMutateResponse.md)
 - [SearchKeywordListServiceOperation](docs/SearchKeywordListServiceOperation.md)
 - [SearchKeywordListServicePage](docs/SearchKeywordListServicePage.md)
 - [SearchKeywordListServiceReturnValue](docs/SearchKeywordListServiceReturnValue.md)
 - [SearchKeywordListServiceSearchKeyword](docs/SearchKeywordListServiceSearchKeyword.md)
 - [SearchKeywordListServiceSelector](docs/SearchKeywordListServiceSelector.md)
 - [SearchKeywordListServiceValue](docs/SearchKeywordListServiceValue.md)
 - [Stats](docs/Stats.md)
 - [StatsServiceAdGroupStatsValue](docs/StatsServiceAdGroupStatsValue.md)
 - [StatsServiceAdScheduleTarget](docs/StatsServiceAdScheduleTarget.md)
 - [StatsServiceAdStatsValue](docs/StatsServiceAdStatsValue.md)
 - [StatsServiceAge](docs/StatsServiceAge.md)
 - [StatsServiceAgeTarget](docs/StatsServiceAgeTarget.md)
 - [StatsServiceAppTarget](docs/StatsServiceAppTarget.md)
 - [StatsServiceAudienceCategoryTarget](docs/StatsServiceAudienceCategoryTarget.md)
 - [StatsServiceCampaignStatsValue](docs/StatsServiceCampaignStatsValue.md)
 - [StatsServiceCarrierTarget](docs/StatsServiceCarrierTarget.md)
 - [StatsServiceCarrierType](docs/StatsServiceCarrierType.md)
 - [StatsServiceDayOfWeek](docs/StatsServiceDayOfWeek.md)
 - [StatsServiceDeviceAppType](docs/StatsServiceDeviceAppType.md)
 - [StatsServiceDeviceOsType](docs/StatsServiceDeviceOsType.md)
 - [StatsServiceDeviceTarget](docs/StatsServiceDeviceTarget.md)
 - [StatsServiceDeviceType](docs/StatsServiceDeviceType.md)
 - [StatsServiceEstimateFlg](docs/StatsServiceEstimateFlg.md)
 - [StatsServiceGender](docs/StatsServiceGender.md)
 - [StatsServiceGenderTarget](docs/StatsServiceGenderTarget.md)
 - [StatsServiceGeoTarget](docs/StatsServiceGeoTarget.md)
 - [StatsServiceGetResponse](docs/StatsServiceGetResponse.md)
 - [StatsServiceImageStatsValue](docs/StatsServiceImageStatsValue.md)
 - [StatsServiceInterestCategoryTarget](docs/StatsServiceInterestCategoryTarget.md)
 - [StatsServiceOsTarget](docs/StatsServiceOsTarget.md)
 - [StatsServiceOsVersionTarget](docs/StatsServiceOsVersionTarget.md)
 - [StatsServicePage](docs/StatsServicePage.md)
 - [StatsServicePeriod](docs/StatsServicePeriod.md)
 - [StatsServicePeriodCustomDate](docs/StatsServicePeriodCustomDate.md)
 - [StatsServicePeriodDatetime](docs/StatsServicePeriodDatetime.md)
 - [StatsServicePlacementTarget](docs/StatsServicePlacementTarget.md)
 - [StatsServicePlacementUrlListType](docs/StatsServicePlacementUrlListType.md)
 - [StatsServiceSearchTarget](docs/StatsServiceSearchTarget.md)
 - [StatsServiceSelector](docs/StatsServiceSelector.md)
 - [StatsServiceSiteCategoryTarget](docs/StatsServiceSiteCategoryTarget.md)
 - [StatsServiceSiteRetargetingTarget](docs/StatsServiceSiteRetargetingTarget.md)
 - [StatsServiceStatsPeriod](docs/StatsServiceStatsPeriod.md)
 - [StatsServiceTarget](docs/StatsServiceTarget.md)
 - [StatsServiceTargetListDeliverType](docs/StatsServiceTargetListDeliverType.md)
 - [StatsServiceTargetSetting](docs/StatsServiceTargetSetting.md)
 - [StatsServiceTargetStatsValue](docs/StatsServiceTargetStatsValue.md)
 - [StatsServiceTargetType](docs/StatsServiceTargetType.md)
 - [StatsServiceType](docs/StatsServiceType.md)
 - [StatsServiceValue](docs/StatsServiceValue.md)
 - [StatsServiceVideoStatsValue](docs/StatsServiceVideoStatsValue.md)
 - [Video](docs/Video.md)
 - [VideoServiceApprovalStatus](docs/VideoServiceApprovalStatus.md)
 - [VideoServiceDownloadSelector](docs/VideoServiceDownloadSelector.md)
 - [VideoServiceFileType](docs/VideoServiceFileType.md)
 - [VideoServiceGetResponse](docs/VideoServiceGetResponse.md)
 - [VideoServiceMutateResponse](docs/VideoServiceMutateResponse.md)
 - [VideoServiceOperation](docs/VideoServiceOperation.md)
 - [VideoServicePage](docs/VideoServicePage.md)
 - [VideoServiceProcessStatus](docs/VideoServiceProcessStatus.md)
 - [VideoServiceQualityType](docs/VideoServiceQualityType.md)
 - [VideoServiceReturnValue](docs/VideoServiceReturnValue.md)
 - [VideoServiceSelector](docs/VideoServiceSelector.md)
 - [VideoServiceSetting](docs/VideoServiceSetting.md)
 - [VideoServiceUploadData](docs/VideoServiceUploadData.md)
 - [VideoServiceUploadResponse](docs/VideoServiceUploadResponse.md)
 - [VideoServiceUploadReturnValue](docs/VideoServiceUploadReturnValue.md)
 - [VideoServiceUploadValue](docs/VideoServiceUploadValue.md)
 - [VideoServiceUserStatus](docs/VideoServiceUserStatus.md)
 - [VideoServiceValue](docs/VideoServiceValue.md)


## Documentation For Authorization


## oAuth

- **Type**: OAuth
- **Flow**: accessCode
- **Authorization URL**: https://biz-oauth.yahoo.co.jp/oauth/v1/authorize
- **Scopes**:
 - **yahooads**: アプリケーションを経由したYahoo!広告の各機能の操作/Operation by each function of Yahoo! Ads via applications.


## Author




