from typing import overload, Any, Callable, TypeVar, Union
from .ffi import (
    CData,
    CharCData,
    ClientCData,
    DisplayCData,
    EventLoopCData,
    ListenerCData,
    NullCData,
    QueueCData,
    ResourceCData,
)

WAYLAND_VERSION_MAJOR: int
WAYLAND_VERSION_MINOR: int
WAYLAND_VERSION_MICRO: int

# Event loop functionality
def wl_event_loop_create() -> EventLoopCData: ...
def wl_event_loop_destroy(event_loop: EventLoopCData) -> None: ...

# Display functionality
def wl_display_create() -> DisplayCData: ...
def wl_display_destroy(display: DisplayCData) -> None: ...
def wl_display_destroy_clients(display: DisplayCData) -> None: ...
def wl_display_flush_clients(display: DisplayCData) -> None: ...
def wl_display_get_event_loop(display: DisplayCData) -> EventLoopCData: ...
def wl_display_add_socket(display: DisplayCData, name: bytes) -> int: ...
def wl_display_add_socket_auto(display: DisplayCData) -> CharCData: ...
def wl_display_terminate(display: DisplayCData) -> None: ...
def wl_display_run(display: DisplayCData) -> None: ...
def wl_display_get_serial(display: DisplayCData) -> int: ...
def wl_display_next_serial(display: DisplayCData) -> int: ...
def wl_display_init_shm(display: DisplayCData) -> int: ...
def wl_display_add_shm_format(display: DisplayCData, format: int) -> int: ...
def wl_event_queue_destroy(queue: QueueCData) -> None: ...
def wl_display_connect(name: Union[bytes, NullCData]) -> DisplayCData: ...
def wl_display_connect_to_fd(fd: int) -> DisplayCData: ...
def wl_display_disconnect(display: DisplayCData) -> None: ...
def wl_display_get_fd(display: DisplayCData) -> int: ...
def wl_display_dispatch(display: DisplayCData) -> int: ...
def wl_display_dispatch_pending(display: DisplayCData) -> int: ...
def wl_display_dispatch_queue(display: DisplayCData, queue: QueueCData) -> int: ...
def wl_display_dispatch_queue_pending(
    display: DisplayCData, queue: QueueCData
) -> int: ...
def wl_display_roundtrip(display: DisplayCData) -> int: ...
def wl_display_roundtrip_queue(display: DisplayCData, queue: QueueCData) -> int: ...
def wl_display_get_error(display: DisplayCData) -> int: ...
def wl_display_read_events(display: DisplayCData) -> int: ...
def wl_display_prepare_read(display: DisplayCData) -> int: ...
def wl_display_prepare_read_queue(display: DisplayCData, queue: QueueCData) -> int: ...
def wl_display_flush(display: DisplayCData) -> int: ...
def wl_display_create_queue(display: DisplayCData) -> QueueCData: ...

# Client functionality
def wl_client_create(display: DisplayCData, fd: int) -> ClientCData: ...
def wl_client_destroy(client: ClientCData) -> None: ...
def wl_client_flush(client: ClientCData) -> None: ...
def wl_client_add_destroy_listener(
    client: ClientCData, listener: ListenerCData
) -> None: ...
def wl_client_get_object(client: ClientCData, id: int) -> ResourceCData: ...
def wl_client_get_credentials(
    client: ClientCData, pid: CData, uid: CData, gid: CData
) -> None: ...

# Resource functionality
def wl_resource_get_user_data(resource: ResourceCData) -> CData: ...

WL_EVENT_READABLE: int
WL_EVENT_WRITABLE: int
WL_EVENT_HANGUP: int
WL_EVENT_ERROR: int
