from typing import overload, Any, Callable, TypeVar, Union

class CData:
    def __getitem__(self, idx: int): ...
    # required for wl_list_for_each
    @property
    def next(self) -> CData: ...

class CDataArray:
    def __setitem__(self, idx: int, elem: CData) -> None: ...

# built-in cdata types
class NullCData(CData): ...
class CharCData(CData): ...

# custom cdata types
class ClientCData(CData): ...
class DisplayCData(CData): ...
class EventLoopCData(CData): ...
class ListenerCData(CData): ...
class QueueCData(CData): ...
class ResourceCData(CData): ...

_FuncType = Callable[..., Any]
_F = TypeVar("_F", bound=_FuncType)
_CDataT = TypeVar("_CDataT", bound=CData)

NULL: NullCData

@overload
def new(cdecl: str) -> CData: ...
@overload
def new(cdecl: str, init: Any) -> CDataArray: ...
def gc(
    cdata: _CDataT, destructor: Callable[[_CDataT], None], size: int = 0
) -> _CDataT: ...
def string(cdata: CharCData) -> str: ...
def release(cdata: CData) -> None: ...
def def_extern() -> Callable[[_F], _F]: ...
def from_handle(cdata: CData) -> Any: ...
