import { Repository } from 'aws-cdk-lib/aws-codecommit';
import { ApiDestination } from 'aws-cdk-lib/aws-events';
import { Construct } from 'constructs';
import { ResolvedApplicationProps } from '../applicationProps';
import { Topic } from 'aws-cdk-lib/aws-sns';
export interface FeatureBranchBuildsProps extends Pick<ResolvedApplicationProps, 'projectName' | 'repository' | 'commands' | 'codeBuild'> {
    codeCommitRepository: Repository;
    repositoryApiDestination: ApiDestination;
}
export declare class FeatureBranchBuilds extends Construct {
    readonly failuresTopic: Topic;
    constructor(scope: Construct, id: string, props: FeatureBranchBuildsProps);
    private createDeployProject;
    private createDeployNotifications;
    private createStatusEvent;
    private createBuildFailuresTopic;
    private createDestroyProject;
    private createProjectTriggerOptions;
    private grantAssumeCDKRoles;
}
