"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CustomNodejsFunction = void 0;
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_lambda_1 = require("aws-cdk-lib/aws-lambda");
const aws_logs_1 = require("aws-cdk-lib/aws-logs");
class CustomNodejsFunction extends aws_lambda_1.Function {
    constructor(scope, id, props) {
        super(scope, id, {
            runtime: aws_lambda_1.Runtime.NODEJS_18_X,
            handler: 'index.handler',
            logRetention: aws_logs_1.RetentionDays.ONE_MONTH,
            ...props,
        });
        if (!CustomNodejsFunction.powertoolsLayer) {
            CustomNodejsFunction.powertoolsLayer = aws_lambda_1.LayerVersion.fromLayerVersionArn(this, 'PowertoolsLayer', `arn:aws:lambda:${aws_cdk_lib_1.Stack.of(this).region}:094274105915:layer:AWSLambdaPowertoolsTypeScript:7`);
        }
        this.addLayers(CustomNodejsFunction.powertoolsLayer);
        this.addEnvironment('POWERTOOLS_SERVICE_NAME', aws_cdk_lib_1.Stack.of(this).stackName);
    }
}
exports.CustomNodejsFunction = CustomNodejsFunction;
//# sourceMappingURL=data:application/json;base64,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