"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CDKApplication = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const ciStack_1 = require("./ciStack");
const environment_1 = require("./util/environment");
class CDKApplication extends aws_cdk_lib_1.App {
    constructor(props) {
        super(props);
        const ci = this.node.tryGetContext('ci');
        const env = this.node.tryGetContext('env');
        if (ci && ci.toLowerCase() === 'true') {
            const environment = environment_1.getEnvironmentConfig(this, 'ci');
            new ciStack_1.CIStack(this, 'CI', {
                env: environment,
                ...props,
            });
        }
        else if (env) {
            props.stacks.create(this, env);
        }
        else {
            throw new Error('Either "env" or "ci" context value must be provided');
        }
    }
}
exports.CDKApplication = CDKApplication;
_a = JSII_RTTI_SYMBOL_1;
CDKApplication[_a] = { fqn: "opinionated-ci-pipeline.CDKApplication", version: "1.0.0-beta.0" };
//# sourceMappingURL=data:application/json;base64,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