"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.defaultProps = void 0;
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_codebuild_1 = require("aws-cdk-lib/aws-codebuild");
exports.defaultProps = {
    repository: {
        defaultBranch: 'main',
    },
    commands: {
        install: ['npm install --location=global aws-cdk@2'],
        synthPipeline: ['cdk synth -c ci=true'],
        deployEnvironment: ['cdk deploy -c env=${ENV_NAME} --all'],
        destroyEnvironment: ['yes | cdk destroy -c env=${ENV_NAME} --all'],
    },
    codeBuild: {
        timeout: aws_cdk_lib_1.Duration.minutes(30),
        buildEnvironment: {
            computeType: aws_codebuild_1.ComputeType.MEDIUM,
            buildImage: aws_codebuild_1.LinuxBuildImage.STANDARD_6_0,
        },
    },
    slackNotifications: {
        mainPipelineFailures: true,
    },
}; // "satisfies PartialDeep<CIStackProps>" would be great here if jsii supported TypeScript 4.9 (PartialDeep from type-fest lib)
//# sourceMappingURL=data:application/json;base64,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